/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circustools.ast.ActionAnn;
import net.sourceforge.czt.circustools.ast.ActionSignature;
import net.sourceforge.czt.circustools.ast.BasicProcessSignature;
import net.sourceforge.czt.circustools.ast.ProcessAnn;
import net.sourceforge.czt.circustools.ast.ProcessSignature;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.typecheck.circus.ErrorAnn;
import net.sourceforge.czt.typecheck.circus.ErrorMessage;
import net.sourceforge.czt.typecheck.circus.TypeCheckUtils;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.typecheck.circus.impl.ChannelInfo;
import net.sourceforge.czt.typecheck.circus.impl.Factory;
import net.sourceforge.czt.typecheck.circus.impl.ProcessInfo;
import net.sourceforge.czt.typecheck.circus.util.GlobalDefs;
import net.sourceforge.czt.typecheck.circus.util.LocalTypeEnv;
import net.sourceforge.czt.typecheck.circus.util.UnificationEnv;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.GenParamType;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Checker
extends net.sourceforge.czt.typecheck.z.Checker {
    protected TypeChecker typeChecker_;

    public Checker(TypeChecker typeChecker) {
        super(typeChecker);
        this.typeChecker_ = typeChecker;
    }

    @Override
    protected Factory factory() {
        return this.typeChecker_.circusFactory_;
    }

    protected Checker actionChecker() {
        return this.typeChecker_.actionChecker_;
    }

    protected Checker commandChecker() {
        return this.typeChecker_.commandChecker_;
    }

    protected Checker communicChecker() {
        return this.typeChecker_.communicChecker_;
    }

    protected Checker processChecker() {
        return this.typeChecker_.processChecker_;
    }

    protected Checker channelDeclChecker() {
        return this.typeChecker_.channelDeclChecker_;
    }

    protected DeclName currentProcess() {
        return this.typeChecker_.currentProcess_;
    }

    protected void setCurrentProcess(DeclName name) {
        this.typeChecker_.currentProcess_ = name;
    }

    protected DeclName currentAction() {
        return this.typeChecker_.currentAction_;
    }

    protected void setCurrentAction(DeclName name) {
        this.typeChecker_.currentAction_ = name;
    }

    protected DeclName stateName() {
        return this.typeChecker_.stateName_;
    }

    protected void setStateName(DeclName name) {
        this.typeChecker_.stateName_ = name;
    }

    protected List<RefName> statesAux() {
        return this.typeChecker_.statesAux_;
    }

    protected void setStatesAux(List<RefName> names) {
        this.typeChecker_.statesAux_ = names;
    }

    protected void setCurrentGenParams(List params) {
        this.typeChecker_.currentGenParams_ = params;
    }

    protected List currentGenParams() {
        return this.typeChecker_.currentGenParams_;
    }

    protected void setOnTheFlyProcesses(List<ProcessPara> procs) {
        this.typeChecker_.onTheFlyProcesses_ = procs;
    }

    protected List onTheFlyProcesses() {
        return this.typeChecker_.onTheFlyProcesses_;
    }

    protected List<ChannelInfo> channels() {
        return this.typeChecker_.channels_;
    }

    protected List<DeclName> chansets() {
        return this.typeChecker_.chansets_;
    }

    protected List<ProcessInfo> processes() {
        return this.typeChecker_.processes_;
    }

    protected List<DeclName> muProcesses() {
        return this.typeChecker_.muProcesses_;
    }

    protected List<DeclName> muActions() {
        return this.typeChecker_.muActions_;
    }

    protected List<List<NameTypePair>> localVars4ActPostCheck() {
        return this.typeChecker_.localVars4ActPostCheck_;
    }

    protected List<List<NameTypePair>> localVars4ProcPostCheck() {
        return this.typeChecker_.localVars4ProcPostCheck_;
    }

    protected List<DeclName> actions4PostCheck() {
        return this.typeChecker_.actions4PostCheck_;
    }

    protected List<DeclName> processes4PostCheck() {
        return this.typeChecker_.processes4PostCheck_;
    }

    protected boolean isChannel(DeclName name) {
        boolean result = false;
        for (ChannelInfo channel : this.channels()) {
            DeclName decl = channel.getChannelType().getName();
            if (!GlobalDefs.compareDeclName(name, decl, false)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean isGenericChannel(DeclName name) {
        boolean result = false;
        for (ChannelInfo channel : this.channels()) {
            DeclName decl = channel.getChannelType().getName();
            if (!GlobalDefs.compareDeclName(name, decl, false) || !channel.isGeneric()) continue;
            result = true;
            break;
        }
        return result;
    }

    protected List<DeclName> getGenParamsChannel(DeclName name) {
        List<Object> result = new ArrayList<DeclName>();
        for (ChannelInfo channel : this.channels()) {
            DeclName decl = channel.getChannelType().getName();
            if (!GlobalDefs.compareDeclName(name, decl, false)) continue;
            result = channel.getParams();
            break;
        }
        return result;
    }

    protected boolean isProcess(DeclName name) {
        boolean result = false;
        for (ProcessInfo process : this.processes()) {
            DeclName decl = process.getProcessName();
            if (!GlobalDefs.compareDeclName(name, decl, false)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean isGenericProcess(DeclName name) {
        boolean result = false;
        for (ProcessInfo process : this.processes()) {
            DeclName decl = process.getProcessName();
            if (!GlobalDefs.compareDeclName(name, decl, false) || !process.isGeneric()) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean isChannelSet(DeclName name) {
        boolean result = false;
        for (DeclName chanset : this.chansets()) {
            if (!GlobalDefs.compareDeclName(chanset, name, false)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean addChannel(DeclName declName, Type type) {
        boolean result = true;
        for (ChannelInfo channel : this.channels()) {
            if (!GlobalDefs.compareDeclName(channel.getChannelType().getName(), declName, false)) continue;
            channel.getChannelType().setType(type);
            result = false;
        }
        if (result) {
            NameTypePair nameType = this.factory().createNameTypePair(declName, type);
            ChannelInfo insert = new ChannelInfo(nameType);
            this.channels().add(insert);
        }
        return result;
    }

    protected boolean addGenChannel(DeclName declName, Type type, List<DeclName> params) {
        boolean result = true;
        for (ChannelInfo channel : this.channels()) {
            if (!GlobalDefs.compareDeclName(channel.getChannelType().getName(), declName, false)) continue;
            channel.getChannelType().setType(type);
            result = false;
        }
        if (result) {
            NameTypePair nameType = this.factory().createNameTypePair(declName, type);
            ChannelInfo insert = new ChannelInfo(nameType, true, params);
            this.channels().add(insert);
        }
        return result;
    }

    protected boolean addChannelSet(DeclName declName) {
        boolean result = true;
        for (DeclName chanset : this.chansets()) {
            if (!GlobalDefs.compareDeclName(chanset, declName, false)) continue;
            result = false;
        }
        if (result) {
            this.chansets().add(declName);
        }
        return result;
    }

    protected boolean addProcess(DeclName declName) {
        boolean result = true;
        for (ProcessInfo process : this.processes()) {
            if (!GlobalDefs.compareDeclName(process.getProcessName(), declName, false)) continue;
            result = false;
        }
        if (result) {
            ProcessInfo insert = new ProcessInfo(declName, false, null);
            this.processes().add(insert);
        }
        return result;
    }

    protected boolean addGenProcess(DeclName declName, List<DeclName> params) {
        boolean result = true;
        for (ProcessInfo process : this.processes()) {
            if (!GlobalDefs.compareDeclName(process.getProcessName(), declName, false)) continue;
            result = false;
        }
        if (result) {
            ProcessInfo insert = new ProcessInfo(declName, true, params);
            this.processes().add(insert);
        }
        return result;
    }

    protected void addVars(List<NameTypePair> vars) {
        for (NameTypePair var : vars) {
            this.typeEnv().add(var);
            DeclName primedVar = this.factory().createDeclName(var.getName().getWord() + "'", null, null);
            this.typeEnv().add(primedVar, var.getType());
        }
    }

    protected ProcessInfo getProcessInfo(DeclName name) {
        ProcessInfo result = null;
        List<ProcessInfo> processes = this.processes();
        for (ProcessInfo proc : processes) {
            if (!GlobalDefs.compareDeclName(proc.getProcessName(), name, false)) continue;
            result = proc;
        }
        return result;
    }

    protected Type getChannelType(DeclName name) {
        Type result = null;
        for (ChannelInfo chan : this.channels()) {
            if (!GlobalDefs.compareDeclName(chan.getChannelType().getName(), name, false)) continue;
            result = chan.getChannelType().getType();
            break;
        }
        return result;
    }

    protected String getKindOfProcess(DeclName name) {
        String result = "";
        for (ProcessInfo process : this.processes()) {
            DeclName decl = process.getProcessName();
            if (!GlobalDefs.compareDeclName(decl, name, false)) continue;
            result = process.getKindOfProcess().name();
            break;
        }
        return result;
    }

    protected boolean isNewDef(DeclName name) {
        boolean result = true;
        RefName refName = this.factory().createRefName(name);
        Type typeLocal = this.typeEnv().getType(refName);
        if (!(typeLocal instanceof UnknownType)) {
            result = false;
        }
        return result;
    }

    protected List<NameTypePair> getUsedChannels(DeclName procName) {
        ArrayList<NameTypePair> result = new ArrayList<NameTypePair>();
        for (ProcessInfo proc : this.processes()) {
            if (!GlobalDefs.compareDeclName(proc.getProcessName(), procName, false)) continue;
            result.addAll(proc.getUsedChans());
            break;
        }
        return result;
    }

    protected List<DeclName> getGenParamsProcess(DeclName procName) {
        List<DeclName> result = new ArrayList<DeclName>();
        for (ProcessInfo proc : this.processes()) {
            if (!GlobalDefs.compareDeclName(proc.getProcessName(), procName, false)) continue;
            result = proc.getGenParams();
            break;
        }
        return result;
    }

    public void addMuProcess(DeclName name) {
        this.muProcesses().add(name);
    }

    public void addMuAction(DeclName name) {
        this.muActions().add(name);
    }

    public void addProcesses4PostCheck(DeclName name, List<NameTypePair> pairs) {
        this.processes4PostCheck().add(name);
        this.localVars4ProcPostCheck().add(pairs);
    }

    public void addAction4PostCheck(DeclName name, List<NameTypePair> pairs) {
        this.actions4PostCheck().add(name);
        this.localVars4ActPostCheck().add(pairs);
    }

    public void removeMuProcess(DeclName name) {
        for (DeclName nameMuProc : this.muProcesses()) {
            if (!GlobalDefs.compareDeclName(nameMuProc, name, false)) continue;
            this.muProcesses().remove(name);
            break;
        }
    }

    public void removeMuAction(DeclName name) {
        for (DeclName nameMuAct : this.muActions()) {
            if (!GlobalDefs.compareDeclName(nameMuAct, name, false)) continue;
            this.muActions().remove(name);
            break;
        }
    }

    public void removeAction4PostCheck(DeclName name) {
        for (DeclName act : this.actions4PostCheck()) {
            if (!GlobalDefs.compareDeclName(act, name, false)) continue;
            this.actions4PostCheck().remove(name);
            break;
        }
    }

    public boolean isMuProcess(DeclName name) {
        boolean result = false;
        for (DeclName nameMuProc : this.muProcesses()) {
            if (!GlobalDefs.compareDeclName(nameMuProc, name, false)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isMuAction(DeclName name) {
        boolean result = false;
        for (DeclName nameMuAct : this.muActions()) {
            if (!GlobalDefs.compareDeclName(nameMuAct, name, false)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isLovalVar(RefName name) {
        boolean result = true;
        DeclName declName = this.factory().createDeclName(name.getWord(), null, null);
        Type type = this.typeEnv().getType(name);
        if (!(type instanceof UnknownType)) {
            if (this.localCircTypeEnv().isAction(declName) || this.localCircTypeEnv().isNameSet(declName)) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public boolean isLocalVars(List<RefName> names) {
        RefName name;
        boolean result = true;
        Iterator<RefName> i$ = names.iterator();
        while (i$.hasNext() && (result = this.isLovalVar(name = i$.next()))) {
        }
        return result;
    }

    @Override
    protected List typecheck(TermA termA, SectionInfo sectInfo) {
        return TypeCheckUtils.typecheck((Term)termA, sectInfo, this.markup());
    }

    protected void error(TermA termA, ErrorMessage error, Object[] params) {
        ErrorAnn errorAnn = this.errorAnn(termA, error, params);
        this.error(termA, errorAnn);
    }

    @Override
    protected void error(TermA termA, net.sourceforge.czt.typecheck.z.ErrorMessage error, Object[] params) {
        ErrorAnn errorAnn = this.errorAnn(termA, error.toString(), params);
        this.error(termA, errorAnn);
    }

    protected ErrorAnn errorAnn(TermA termA, ErrorMessage error, Object[] params) {
        ErrorAnn errorAnn = new ErrorAnn(error.toString(), params, this.sectInfo(), this.sectName(), this.nearestLocAnn(termA), this.markup());
        return errorAnn;
    }

    @Override
    protected ErrorAnn errorAnn(TermA termA, String error, Object[] params) {
        ErrorAnn errorAnn = new ErrorAnn(error, params, this.sectInfo(), this.sectName(), this.nearestLocAnn(termA), this.markup());
        return errorAnn;
    }

    @Override
    protected UResult unify(Type2 typeA, Type2 typeB) {
        UnificationEnv unificationEnv = (UnificationEnv)this.unificationEnv();
        return unificationEnv.unify(typeA, typeB);
    }

    protected LocalTypeEnv localCircTypeEnv() {
        return this.typeChecker_.localCircTypeEnv_;
    }

    protected void addGlobalGenParamTypes(List<DeclName> declNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (DeclName declName : declNames) {
            GenParamType genParamType = this.factory().createGenParamType(declName);
            PowerType powerType = this.factory().createPowerType((Type2)genParamType);
            if (names.contains(declName.getWord())) {
                Object[] params = new Object[]{declName};
                this.error((TermA)declName, ErrorMessage.REDECLARED_GEN, params);
            } else {
                names.add(declName.getWord());
            }
            this.sectTypeEnv().add(declName, (Type)powerType);
        }
    }

    protected void addProcessAnn(CircusProcess term, ProcessSignature psig) {
        ProcessAnn pAnn = (ProcessAnn)term.getAnn(ProcessAnn.class);
        if (pAnn == null) {
            pAnn = this.factory().createProcessAnn(psig);
            term.getAnns().add((Object)pAnn);
        } else {
            pAnn.setProcessSignature(psig);
        }
    }

    protected void addActionAnn(CircusAction term, ActionSignature asig) {
        ActionAnn aAnn = (ActionAnn)term.getAnn(ActionAnn.class);
        if (aAnn == null) {
            aAnn = this.factory().createActionAnn(asig);
            term.getAnns().add((Object)aAnn);
        } else {
            aAnn.setActionSignature(asig);
        }
    }

    protected ProcessSignature cloneProcessSignature(ProcessSignature procSig) {
        ProcessSignature result = this.factory().createProcessSignature();
        if (procSig instanceof BasicProcessSignature) {
            BasicProcessSignature resultTemp = this.factory().createBasicProcessSignature();
            BasicProcessSignature signature = (BasicProcessSignature)procSig;
            if (signature.getActionsSignature() != null) {
                resultTemp.getActionsSignature().addAll((Collection)signature.getActionsSignature());
            }
            if (signature.getDeclNameSets() != null) {
                resultTemp.getDeclNameSets().addAll((Collection)signature.getDeclNameSets());
            }
            if (signature.getLocalZDeclsSignature() != null) {
                resultTemp.getLocalZDeclsSignature().addAll((Collection)signature.getLocalZDeclsSignature());
            }
            if (signature.getStateSignature() != null) {
                resultTemp.setStateSignature(signature.getStateSignature());
            }
            result = resultTemp;
        }
        if (procSig.getParamsOrIndexes() != null) {
            Signature sig = this.factory().createSignature((List)procSig.getParamsOrIndexes().getNameTypePair());
            result.setParamsOrIndexes(sig);
        }
        return result;
    }

    protected ActionSignature cloneActionSignature(ActionSignature actionSig) {
        ActionSignature result = this.factory().createActionSignature();
        if (actionSig.getLocalVarsSignature() != null) {
            result.setLocalVarsSignature(actionSig.getLocalVarsSignature());
        }
        if (actionSig.getParams() != null) {
            result.setParams(actionSig.getParams());
        }
        return result;
    }

    protected List<NameTypePair> checkDecls(List<NameTypePair> list, List<NameTypePair> news, TermA term, ErrorMessage error, List paramsError) {
        for (NameTypePair newDec : news) {
            boolean put = true;
            for (NameTypePair oldDec : list) {
                Type2 typeOldDec;
                if (!GlobalDefs.compareDeclName(newDec.getName(), oldDec.getName(), false)) continue;
                Type2 typeNewDec = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(newDec.getType());
                if (this.unify(typeNewDec, typeOldDec = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(oldDec.getType())) != net.sourceforge.czt.typecheck.z.util.GlobalDefs.SUCC) {
                    paramsError.add(oldDec.getName().getWord());
                    paramsError.add(typeOldDec);
                    paramsError.add(typeNewDec);
                    Object[] params = paramsError.toArray();
                    this.error(term, error, params);
                }
                put = false;
                break;
            }
            if (!put) continue;
            list.add(newDec);
        }
        return list;
    }

    protected ProcessSignature joinProcessSignature(ProcessSignature procSigL, ProcessSignature procSigR) {
        ArrayList<NameTypePair> resultPairs;
        ListTerm pairs;
        ArrayList<NameTypePair> resultPairs2;
        ListTerm pairs2;
        ProcessSignature result = this.factory().createProcessSignature();
        BasicProcessSignature resultTemp = this.factory().createBasicProcessSignature();
        if (procSigL instanceof BasicProcessSignature) {
            BasicProcessSignature sigL = (BasicProcessSignature)procSigL;
            if (sigL.getActionsSignature() != null) {
                resultTemp.getActionsSignature().addAll((Collection)sigL.getActionsSignature());
            }
            if (sigL.getDeclNameSets() != null) {
                resultTemp.getDeclNameSets().addAll((Collection)sigL.getDeclNameSets());
            }
            if (sigL.getLocalZDeclsSignature() != null) {
                resultTemp.getLocalZDeclsSignature().addAll((Collection)sigL.getLocalZDeclsSignature());
            }
            if (sigL.getStateSignature() != null) {
                if (resultTemp.getStateSignature() != null) {
                    pairs2 = sigL.getStateSignature().getNameTypePair();
                    resultPairs2 = new ArrayList<NameTypePair>();
                    resultPairs2.addAll((Collection<NameTypePair>)resultTemp.getStateSignature().getNameTypePair());
                    for (NameTypePair pair : pairs2) {
                        if (resultPairs2.contains(pair)) continue;
                        resultPairs2.add(pair);
                    }
                    resultTemp.setStateSignature(this.factory().createSignature(resultPairs2));
                } else {
                    resultTemp.setStateSignature(sigL.getStateSignature());
                }
            }
            result = resultTemp;
        }
        if (procSigR instanceof BasicProcessSignature) {
            BasicProcessSignature sigR = (BasicProcessSignature)procSigR;
            if (sigR.getActionsSignature() != null) {
                resultTemp.getActionsSignature().addAll((Collection)sigR.getActionsSignature());
            }
            if (sigR.getDeclNameSets() != null) {
                resultTemp.getDeclNameSets().addAll((Collection)sigR.getDeclNameSets());
            }
            if (sigR.getLocalZDeclsSignature() != null) {
                resultTemp.getLocalZDeclsSignature().addAll((Collection)sigR.getLocalZDeclsSignature());
            }
            if (sigR.getStateSignature() != null) {
                if (resultTemp.getStateSignature() != null) {
                    pairs2 = sigR.getStateSignature().getNameTypePair();
                    resultPairs2 = new ArrayList();
                    resultPairs2.addAll((Collection<NameTypePair>)resultTemp.getStateSignature().getNameTypePair());
                    for (NameTypePair pair : pairs2) {
                        if (resultPairs2.contains(pair)) continue;
                        resultPairs2.add(pair);
                    }
                    resultTemp.setStateSignature(this.factory().createSignature(resultPairs2));
                } else {
                    resultTemp.setStateSignature(sigR.getStateSignature());
                }
            }
            result = resultTemp;
        }
        if (procSigL.getParamsOrIndexes() != null) {
            if (result.getParamsOrIndexes() != null) {
                pairs = procSigL.getParamsOrIndexes().getNameTypePair();
                resultPairs = new ArrayList<NameTypePair>();
                resultPairs.addAll((Collection<NameTypePair>)result.getParamsOrIndexes().getNameTypePair());
                for (NameTypePair pair : pairs) {
                    if (resultPairs.contains(pair)) continue;
                    resultPairs.add(pair);
                }
                result.setParamsOrIndexes(this.factory().createSignature(resultPairs));
            } else {
                result.setParamsOrIndexes(procSigL.getParamsOrIndexes());
            }
        }
        if (procSigR.getParamsOrIndexes() != null) {
            if (result.getParamsOrIndexes() != null) {
                pairs = procSigR.getParamsOrIndexes().getNameTypePair();
                resultPairs = new ArrayList();
                resultPairs.addAll((Collection<NameTypePair>)result.getParamsOrIndexes().getNameTypePair());
                for (NameTypePair pair : pairs) {
                    if (resultPairs.contains(pair)) continue;
                    resultPairs.add(pair);
                }
                result.setParamsOrIndexes(this.factory().createSignature(resultPairs));
            } else {
                result.setParamsOrIndexes(procSigR.getParamsOrIndexes());
            }
        }
        return result;
    }

    protected ActionSignature joinActionSignature(ActionSignature actionSigL, ActionSignature actionSigR) {
        ArrayList<NameTypePair> resultPairs;
        ListTerm pairs;
        ActionSignature result = this.factory().createActionSignature();
        if (actionSigL.getLocalVarsSignature() != null) {
            result.setLocalVarsSignature(actionSigL.getLocalVarsSignature());
        }
        if (actionSigR.getLocalVarsSignature() != null) {
            if (result.getLocalVarsSignature() != null) {
                pairs = actionSigR.getLocalVarsSignature().getNameTypePair();
                resultPairs = new ArrayList<NameTypePair>();
                resultPairs.addAll((Collection<NameTypePair>)result.getLocalVarsSignature().getNameTypePair());
                for (NameTypePair pair : pairs) {
                    if (resultPairs.contains(pair)) continue;
                    resultPairs.add(pair);
                }
                result.setLocalVarsSignature(this.factory().createSignature(resultPairs));
            } else {
                result.setLocalVarsSignature(actionSigR.getLocalVarsSignature());
            }
        }
        if (actionSigL.getParams() != null) {
            result.setParams(actionSigL.getParams());
        }
        if (actionSigR.getParams() != null) {
            if (result.getParams() != null) {
                pairs = actionSigR.getParams().getNameTypePair();
                resultPairs = new ArrayList();
                resultPairs.addAll((Collection<NameTypePair>)result.getParams().getNameTypePair());
                for (NameTypePair pair : pairs) {
                    if (resultPairs.contains(pair)) continue;
                    resultPairs.add(pair);
                }
                result.setParams(this.factory().createSignature(resultPairs));
            } else {
                result.setParams(actionSigR.getParams());
            }
        }
        return result;
    }
}

