/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.Action1;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.ActionIte;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.AlphabetisedParallelAction;
import net.sourceforge.czt.circus.ast.AlphabetisedParallelActionIte;
import net.sourceforge.czt.circus.ast.BasicAction;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusCommand;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.InterleaveAction;
import net.sourceforge.czt.circus.ast.InterleaveActionIte;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.ParallelAction;
import net.sourceforge.czt.circus.ast.ParallelActionIte;
import net.sourceforge.czt.circus.ast.ParamAction;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.ast.SubstitutionAction;
import net.sourceforge.czt.circus.visitor.Action1Visitor;
import net.sourceforge.czt.circus.visitor.Action2Visitor;
import net.sourceforge.czt.circus.visitor.ActionIteVisitor;
import net.sourceforge.czt.circus.visitor.AlphabetisedParallelActionIteVisitor;
import net.sourceforge.czt.circus.visitor.AlphabetisedParallelActionVisitor;
import net.sourceforge.czt.circus.visitor.BasicActionVisitor;
import net.sourceforge.czt.circus.visitor.CallActionVisitor;
import net.sourceforge.czt.circus.visitor.CircusActionVisitor;
import net.sourceforge.czt.circus.visitor.CircusCommandVisitor;
import net.sourceforge.czt.circus.visitor.GuardedActionVisitor;
import net.sourceforge.czt.circus.visitor.HideActionVisitor;
import net.sourceforge.czt.circus.visitor.InterleaveActionIteVisitor;
import net.sourceforge.czt.circus.visitor.InterleaveActionVisitor;
import net.sourceforge.czt.circus.visitor.MuActionVisitor;
import net.sourceforge.czt.circus.visitor.ParallelActionIteVisitor;
import net.sourceforge.czt.circus.visitor.ParallelActionVisitor;
import net.sourceforge.czt.circus.visitor.ParamActionVisitor;
import net.sourceforge.czt.circus.visitor.PrefixingActionVisitor;
import net.sourceforge.czt.circus.visitor.SchExprActionVisitor;
import net.sourceforge.czt.circus.visitor.SubstitutionActionVisitor;
import net.sourceforge.czt.circustools.ast.ActionSignature;
import net.sourceforge.czt.circustools.ast.ActionType;
import net.sourceforge.czt.circustools.ast.ChanSetType;
import net.sourceforge.czt.circustools.ast.NameSetType;
import net.sourceforge.czt.typecheck.circus.Checker;
import net.sourceforge.czt.typecheck.circus.ErrorMessage;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.typecheck.circus.impl.ActionInfo;
import net.sourceforge.czt.typecheck.circus.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.DeclChecker;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.VarDecl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionChecker
extends Checker
implements CircusActionVisitor,
Action1Visitor,
Action2Visitor,
SchExprActionVisitor,
BasicActionVisitor,
CallActionVisitor,
MuActionVisitor,
PrefixingActionVisitor,
SubstitutionActionVisitor,
GuardedActionVisitor,
HideActionVisitor,
ActionIteVisitor,
ParamActionVisitor,
AlphabetisedParallelActionIteVisitor,
InterleaveActionIteVisitor,
ParallelActionIteVisitor,
InterleaveActionVisitor,
ParallelActionVisitor,
AlphabetisedParallelActionVisitor,
CircusCommandVisitor {
    protected DeclChecker zDeclChecker_;

    public ActionChecker(TypeChecker typeChecker) {
        super(typeChecker);
        this.zDeclChecker_ = new DeclChecker(typeChecker);
    }

    public Object visitCircusAction(CircusAction term) {
        return this.factory().createActionSignature();
    }

    public Object visitAction1(Action1 term) {
        ActionSignature actionSignature = (ActionSignature)term.getCircusAction().accept((Visitor)this.actionChecker());
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitAction2(Action2 term) {
        ActionSignature actionSigL = (ActionSignature)term.getLeftAction().accept((Visitor)this.actionChecker());
        ActionSignature actionSigR = (ActionSignature)term.getRightAction().accept((Visitor)this.actionChecker());
        ActionSignature result = this.joinActionSignature(actionSigL, actionSigR);
        this.addActionAnn((CircusAction)term, result);
        return result;
    }

    public Object visitSchExprAction(SchExprAction term) {
        ActionSignature actionSignature = this.factory().createActionSignature();
        Type typeExpr = (Type)term.getExpr().accept((Visitor)this.exprChecker());
        SchemaType schType = (SchemaType)((PowerType)typeExpr).getType();
        Signature vars = schType.getSignature();
        actionSignature.setLocalVarsSignature(vars);
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitBasicAction(BasicAction term) {
        ActionSignature actionSignature = this.factory().createActionSignature();
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitCallAction(CallAction term) {
        ActionSignature actionSignature = this.factory().createActionSignature();
        RefName actionRef = term.getRefName();
        DeclName actionDecl = this.factory().createDeclName(actionRef);
        if (actionDecl.getWord().startsWith("$$implicitAction_")) {
            List<ActionPara> implicitActions = this.localCircTypeEnv().getOnTheFlyActions();
            for (ActionPara implicitAction : implicitActions) {
                if (!GlobalDefs.compareDeclName(actionDecl, implicitAction.getDeclName(), false)) continue;
                Signature implicitActionSig = (Signature)implicitAction.accept((Visitor)this.paraChecker());
            }
        }
        if (this.isMuAction(actionDecl)) {
            if (!term.getExpr().isEmpty()) {
                Object[] params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionDecl.getWord()};
                this.error((TermA)term, ErrorMessage.MU_ACTION_CALL_ERROR, params);
            }
        } else {
            Object[] params;
            Type typeRefName = this.typeEnv().getType(actionRef);
            if (!(typeRefName instanceof UnknownType)) {
                if (!this.localCircTypeEnv().isAction(actionDecl)) {
                    params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionDecl.getWord()};
                    this.error((TermA)term, ErrorMessage.IS_NOT_ACTION_NAME, params);
                } else {
                    if (typeRefName instanceof ActionType) {
                        ActionType actionType = (ActionType)typeRefName;
                        actionSignature = actionType.getActionSignature();
                    } else {
                        SchemaType schType = (SchemaType)((PowerType)typeRefName).getType();
                        Signature vars = schType.getSignature();
                        actionSignature.setActionName(actionDecl);
                        actionSignature.setLocalVarsSignature(vars);
                    }
                    params = null;
                    if (actionSignature.getParams() != null) {
                        params = actionSignature.getParams().getNameTypePair();
                    }
                    this.checkCallAction(term, (List<NameTypePair>)params);
                }
            } else if (!GlobalDefs.compareDeclName(actionDecl, this.currentAction(), false)) {
                if (!net.sourceforge.czt.typecheck.z.util.GlobalDefs.containsObject(this.paraErrors(), term)) {
                    this.paraErrors().add(term);
                    ListTerm pairs = this.typeEnv().getTypeEnvAnn().getNameTypePair();
                    this.addAction4PostCheck(this.currentAction(), (List<NameTypePair>)pairs);
                }
            } else {
                params = this.localCircTypeEnv().getActionInfo(actionDecl).getParams();
                this.checkCallAction(term, (List<NameTypePair>)params);
            }
        }
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitMuAction(MuAction term) {
        DeclName name = term.getDeclName();
        CircusAction action = term.getCircusAction();
        this.addMuAction(name);
        ActionSignature signature = (ActionSignature)action.accept((Visitor)this.actionChecker());
        this.removeMuAction(name);
        this.addActionAnn((CircusAction)term, signature);
        return signature;
    }

    public Object visitPrefixingAction(PrefixingAction term) {
        CircusAction action = term.getCircusAction();
        RefName chanName = term.getCommunication().getChanName();
        DeclName declName = this.factory().createDeclName(chanName.getWord(), null, null);
        term.getCommunication().getChanName().setDecl(declName);
        List inputVars = (List)term.getCommunication().accept((Visitor)this.communicChecker());
        this.typeEnv().enterScope();
        this.addVars(inputVars);
        ActionSignature actionSignature = (ActionSignature)action.accept((Visitor)this.actionChecker());
        this.typeEnv().exitScope();
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitSubstitutionAction(SubstitutionAction term) {
        ActionSignature actionSignature = (ActionSignature)term.getCircusAction().accept((Visitor)this.actionChecker());
        ListTerm oldNames = term.getOldNames();
        ListTerm newNames = term.getNewNames();
        if (oldNames.size() == newNames.size()) {
            int i = 0;
            for (RefName oldName : oldNames) {
                Object[] params;
                Object[] params2;
                RefName newName = (RefName)newNames.get(0);
                if (!this.isLovalVar(oldName)) {
                    params2 = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), oldName.getWord()};
                    this.error((TermA)term, ErrorMessage.IS_NOT_LOCAL_VAR_NAME_IN_SUBST_ACTION, params2);
                    break;
                }
                if (!this.isLovalVar(newName)) {
                    params2 = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), newName.getWord()};
                    this.error((TermA)term, ErrorMessage.IS_NOT_LOCAL_VAR_NAME_IN_SUBST_ACTION, params2);
                    break;
                }
                Type2 expectedU = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(this.typeEnv().getType(oldName));
                Type2 foundU = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(this.typeEnv().getType(newName));
                if (foundU instanceof UnknownType) {
                    params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionSignature.getActionName().getWord(), newName.getWord()};
                    this.error((TermA)term, ErrorMessage.RENAME_ACTION_UNDECLARED_VAR, params);
                } else if (expectedU instanceof UnknownType) {
                    params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionSignature.getActionName().getWord(), oldName.getWord()};
                    this.error((TermA)term, ErrorMessage.RENAME_ACTION_UNDECLARED_VAR, params);
                } else if (this.unify(foundU, expectedU) != net.sourceforge.czt.typecheck.z.util.GlobalDefs.SUCC) {
                    params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionSignature.getActionName().getWord(), expectedU, foundU, i + 1};
                    this.error((TermA)term, ErrorMessage.ACTION_RENAME_NOT_UNIFY, params);
                    break;
                }
                ++i;
            }
        } else {
            Object[] params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionSignature.getActionName().getWord(), oldNames.size(), newNames.size()};
            this.error((TermA)term, ErrorMessage.ACTION_RENAME_DIFF_NUMBER_VARS, params);
        }
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitGuardedAction(GuardedAction term) {
        term.getPred().accept((Visitor)this.predChecker());
        ActionSignature signature = (ActionSignature)term.getCircusAction().accept((Visitor)this.actionChecker());
        this.addActionAnn((CircusAction)term, signature);
        return signature;
    }

    public Object visitHideAction(HideAction term) {
        ChanSetType typeCS = (ChanSetType)term.getChannelSet().accept((Visitor)this.exprChecker());
        this.localCircTypeEnv().addUsedChans((List<NameTypePair>)typeCS.getChannels().getNameTypePair());
        ActionSignature signature = (ActionSignature)term.getCircusAction().accept((Visitor)this.actionChecker());
        this.addActionAnn((CircusAction)term, signature);
        return signature;
    }

    public Object visitActionIte(ActionIte term) {
        ListTerm decs = term.getDecl();
        CircusAction action = term.getCircusAction();
        List<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        ArrayList<String> paramsError = new ArrayList<String>();
        paramsError.add(this.currentAction().getWord());
        paramsError.add(this.currentProcess().getWord());
        for (Decl d : decs) {
            if (!(d instanceof VarDecl)) {
                throw new UnsupportedOperationException("Iterated actions accept only VarDecl!");
            }
            VarDecl dec = (VarDecl)d;
            boolean declOK = this.isFinity(dec.getExpr());
            List pairs = (List)dec.accept((Visitor)this.declChecker());
            allPairs = this.checkDecls(allPairs, pairs, (TermA)term, ErrorMessage.REDECLARED_VAR_IN_ACTION_ITE, paramsError);
            if (declOK) continue;
            Object[] params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord()};
            this.error((TermA)term, ErrorMessage.INFINITY_VALUES_IN_ACTION_ITE, params);
            break;
        }
        this.typeEnv().enterScope();
        this.typeEnv().add(allPairs);
        ActionSignature actionSig = (ActionSignature)action.accept((Visitor)this.actionChecker());
        ActionSignature actionSignature = this.cloneActionSignature(actionSig);
        Signature sig = this.factory().createSignature(allPairs);
        actionSignature.setLocalVarsSignature(sig);
        this.typeEnv().exitScope();
        return actionSignature;
    }

    public Object visitParamAction(ParamAction term) {
        ListTerm decls = term.getDecl();
        CircusAction action = term.getCircusAction();
        List<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        ArrayList<String> paramsError = new ArrayList<String>();
        paramsError.add(this.currentAction().getWord());
        paramsError.add(this.currentProcess().getWord());
        for (Decl d : decls) {
            if (!(d instanceof VarDecl)) {
                throw new UnsupportedOperationException("Parameterised actions accept only VarDecl!");
            }
            VarDecl decl = (VarDecl)d;
            List pairs = (List)decl.accept((Visitor)this.declChecker());
            allPairs = this.checkDecls(allPairs, pairs, (TermA)term, ErrorMessage.REDECLARED_PARAM_IN_ACTION, paramsError);
        }
        ActionInfo actionInfo = this.localCircTypeEnv().getActionInfo(this.currentAction());
        actionInfo.setIsParam(true);
        actionInfo.setParams(allPairs);
        this.typeEnv().enterScope();
        this.typeEnv().add(allPairs);
        ActionSignature actionSig = (ActionSignature)action.accept((Visitor)this.actionChecker());
        ActionSignature actionSignature = this.cloneActionSignature(actionSig);
        Signature varsSig = this.factory().createSignature(allPairs);
        actionSignature.setParams(varsSig);
        this.typeEnv().exitScope();
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitAlphabetisedParallelActionIte(AlphabetisedParallelActionIte term) {
        ChanSetType typeCS = (ChanSetType)term.getChannelSet().accept((Visitor)this.exprChecker());
        this.localCircTypeEnv().addUsedChans((List<NameTypePair>)typeCS.getChannels().getNameTypePair());
        NameSetType typeNS = (NameSetType)term.getNameSet().accept((Visitor)this.exprChecker());
        ActionSignature actionSignature = (ActionSignature)this.visitActionIte((ActionIte)term);
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitInterleaveActionIte(InterleaveActionIte term) {
        NameSetType typeNS = (NameSetType)term.getNameSet().accept((Visitor)this.exprChecker());
        ActionSignature actionSignature = (ActionSignature)this.visitActionIte((ActionIte)term);
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitParallelActionIte(ParallelActionIte term) {
        ChanSetType typeCS = (ChanSetType)term.getChannelSet().accept((Visitor)this.exprChecker());
        this.localCircTypeEnv().addUsedChans((List<NameTypePair>)typeCS.getChannels().getNameTypePair());
        NameSetType typeNS = (NameSetType)term.getNameSet().accept((Visitor)this.exprChecker());
        ActionSignature actionSignature = (ActionSignature)this.visitActionIte((ActionIte)term);
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitInterleaveAction(InterleaveAction term) {
        NameSetType typeNSL = (NameSetType)term.getLeftNameSet().accept((Visitor)this.exprChecker());
        NameSetType typeNSR = (NameSetType)term.getRightNameSet().accept((Visitor)this.exprChecker());
        ActionSignature actionSignature = (ActionSignature)this.visitAction2((Action2)term);
        return actionSignature;
    }

    public Object visitParallelAction(ParallelAction term) {
        ChanSetType typeCS = (ChanSetType)term.getChannelSet().accept((Visitor)this.exprChecker());
        this.localCircTypeEnv().addUsedChans((List<NameTypePair>)typeCS.getChannels().getNameTypePair());
        term.getLeftNameSet().accept((Visitor)this.exprChecker());
        term.getRightNameSet().accept((Visitor)this.exprChecker());
        ActionSignature actionSignature = (ActionSignature)this.visitAction2((Action2)term);
        return actionSignature;
    }

    public Object visitAlphabetisedParallelAction(AlphabetisedParallelAction term) {
        ArrayList<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        ChanSetType typeCSL = (ChanSetType)term.getLeftAlpha().accept((Visitor)this.exprChecker());
        ChanSetType typeCSR = (ChanSetType)term.getRightAlpha().accept((Visitor)this.exprChecker());
        allPairs.addAll((Collection<NameTypePair>)typeCSL.getChannels().getNameTypePair());
        allPairs.addAll((Collection<NameTypePair>)typeCSR.getChannels().getNameTypePair());
        this.localCircTypeEnv().addUsedChans(allPairs);
        term.getLeftNameSet().accept((Visitor)this.exprChecker());
        term.getRightNameSet().accept((Visitor)this.exprChecker());
        ActionSignature actionSignature = (ActionSignature)this.visitAction2((Action2)term);
        return actionSignature;
    }

    public Object visitCircusCommand(CircusCommand term) {
        return term.accept((Visitor)this.commandChecker());
    }

    private boolean checkCall(DeclName actionName, List decs, List types) {
        boolean result = true;
        int i = 0;
        if (decs.size() == types.size()) {
            for (NameTypePair pair : decs) {
                Type2 expectedU = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType(pair.getType());
                Type2 foundU = net.sourceforge.czt.typecheck.z.util.GlobalDefs.unwrapType((Type)types.get(i));
                if (foundU instanceof UnknownType) {
                    Object[] params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionName.getWord(), i + 1};
                    this.error((TermA)actionName, ErrorMessage.PARAM_ACTION_CALL_UNDECLARED_VAR, params);
                    result = false;
                    break;
                }
                if (this.unify(foundU, expectedU) != net.sourceforge.czt.typecheck.z.util.GlobalDefs.SUCC) {
                    Object[] params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionName.getWord(), expectedU, foundU, i + 1};
                    this.error((TermA)actionName, ErrorMessage.PARAM_ACTION_CALL_NOT_UNIFY, params);
                    result = false;
                    break;
                }
                ++i;
            }
        } else {
            Object[] params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), decs.size(), types.size(), actionName.getWord()};
            this.error((TermA)actionName, ErrorMessage.ACTION_CALL_DIFF_NUMBER_EXPRS, params);
            result = false;
        }
        return result;
    }

    private void checkCallAction(CallAction term, List<NameTypePair> params) {
        DeclName actionDecl = this.factory().createDeclName(term.getRefName());
        switch (term.getCallType()) {
            case Param: {
                if (!this.localCircTypeEnv().isParamAction(actionDecl)) {
                    Object[] paramsError = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionDecl.getWord()};
                    this.error((TermA)term, ErrorMessage.IS_NOT_PARAM_ACTION_IN_ACTION_CALL, paramsError);
                    break;
                }
                ArrayList<Type> typeExprs = new ArrayList<Type>();
                ListTerm exprs = null;
                exprs = term.getExpr();
                for (Expr expr : exprs) {
                    Type type = (Type)expr.accept((Visitor)this.exprChecker());
                    typeExprs.add(type);
                }
                this.checkCall(actionDecl, params, typeExprs);
                break;
            }
            case Normal: {
                if (!this.localCircTypeEnv().isParamAction(actionDecl)) break;
                Object[] paramsError = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionDecl.getWord()};
                this.error((TermA)term, ErrorMessage.PARAM_ACTION_CALL_WITHOUT_EXPRS, paramsError);
            }
        }
    }
}

