/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public abstract class ReflectiveVisitor {
    private String getClassName() {
        return "ReflectiveVisitor";
    }

    private Logger getLogger() {
        return Logger.getLogger("net.sourceforge.czt.util." + this.getClassName());
    }

    public Object dispatch(Object o) {
        if (o == null) {
            return null;
        }
        try {
            Method method = this.getMethod(o.getClass());
            return method.invoke((Object)this, o);
        }
        catch (InvocationTargetException e) {
            this.getLogger().finer("Caught InvocationTargetException");
            Throwable throwable = e.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            this.getLogger().finer("Caught IllegalAccessException");
            Throwable throwable = e.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            e.printStackTrace();
        }
        return null;
    }

    protected Method getMethod(Class c) {
        String methodName = "getMethod";
        this.getLogger().entering(this.getClassName(), "getMethod", c);
        Method m = null;
        for (Class newc = c; m == null && newc != Object.class; newc = newc.getSuperclass()) {
            String method = newc.getName();
            method = "visit" + method.substring(method.lastIndexOf(46) + 1);
            this.getLogger().finer("Try " + newc.toString());
            try {
                m = this.getClass().getMethod(method, newc);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().finer("Caught NoSuchMethodException");
            }
            if (m != null) continue;
            m = this.tryInterfaces(newc);
        }
        if (m == null) {
            try {
                m = this.getClass().getMethod("visitObject", Object.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getLogger().exiting(this.getClassName(), "getMethod", m);
        return m;
    }

    protected Method tryInterfaces(Class c) {
        String methodName = "tryInterfaces";
        this.getLogger().entering(this.getClassName(), "tryInterfaces", c);
        String methodPrefix = "visit";
        Method m = null;
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String method = interfaces[i].getName();
            method = methodPrefix + method.substring(method.lastIndexOf(46) + 1);
            this.getLogger().finer("Try " + method.toString());
            try {
                m = this.getClass().getMethod(method, interfaces[i]);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getLogger().finer("Caught NoSuchMethodException");
                continue;
            }
            catch (SecurityException securityException) {
                this.getLogger().finer("Caught SecurityException");
            }
        }
        this.getLogger().exiting(this.getClassName(), "tryInterfaces", m);
        return m;
    }
}

