/*
 * Decompiled with CFR 0.152.
 */
package jcircus.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;
import jcircus.JCircus;
import jcircus.exceptions.FailParsingException;
import jcircus.exceptions.FailTranslationException;
import jcircus.exceptions.FailTypeCheckingException;
import jcircus.exceptions.JCircusException;
import jcircus.gui.ChooseMainDialog;
import jcircus.gui.ParametersDialog;
import jcircus.util.ProcInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCircusFrame
extends JFrame
implements ActionListener {
    private static final String NEWLINE = "\n";
    private JCircus jCircus = new JCircus(this);
    private JLabel lblInputSpec;
    private JTextField txfInputSpec;
    private JButton btnChooseInput;
    private JLabel lblProjName;
    private JTextField txfProjName;
    private JLabel lblOutputPath;
    private JTextField txfOutputPath;
    private JButton btnChooseOutput;
    private JLabel lblOutputDir;
    private JTextField txfOutputDir;
    private JButton btnTranslate;
    private JLabel lblLog;
    private JTextArea txaLog;
    private boolean canceled = false;

    public JCircus getJCircus() {
        return this.jCircus;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public JCircusFrame() {
        this.setTitle("JCircus");
        this.setDefaultCloseOperation(3);
        JPanel contentPane = new JPanel();
        contentPane.setOpaque(true);
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane(contentPane);
        GridBagLayout gridBagLayout = new GridBagLayout();
        contentPane.setLayout(gridBagLayout);
        this.lblInputSpec = new JLabel("Input specification:");
        this.txfInputSpec = new JTextField();
        this.txfInputSpec.setPreferredSize(new Dimension(400, 22));
        this.btnChooseInput = new JButton("...");
        this.btnChooseInput.setPreferredSize(new Dimension(30, 22));
        this.btnChooseInput.addActionListener(this);
        this.lblProjName = new JLabel("Project name:");
        this.txfProjName = new JTextField();
        this.txfProjName.setPreferredSize(new Dimension(400, 22));
        this.txfProjName.getDocument().addDocumentListener(new TextFieldsDocumentListener());
        this.lblOutputPath = new JLabel("Project path:");
        this.txfOutputPath = new JTextField();
        this.txfOutputPath.setPreferredSize(new Dimension(400, 22));
        this.txfOutputPath.getDocument().addDocumentListener(new TextFieldsDocumentListener());
        this.btnChooseOutput = new JButton("...");
        this.btnChooseOutput.setPreferredSize(new Dimension(30, 22));
        this.btnChooseOutput.addActionListener(this);
        this.lblOutputDir = new JLabel("Project folders will be created in:");
        this.txfOutputDir = new JTextField();
        this.txfOutputDir.setPreferredSize(new Dimension(400, 22));
        this.txfOutputDir.setEditable(false);
        this.btnTranslate = new JButton("Translate");
        this.btnTranslate.setPreferredSize(new Dimension(100, 25));
        this.btnTranslate.addActionListener(this);
        this.lblLog = new JLabel("Log:");
        this.txaLog = new JTextArea(5, 20);
        this.txaLog.setMargin(new Insets(5, 5, 5, 5));
        this.txaLog.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(this.txaLog);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 0;
        c.weightx = 0.0;
        contentPane.add((Component)this.lblInputSpec, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        c.weightx = 1.0;
        contentPane.add((Component)this.txfInputSpec, c);
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        c.weightx = 0.0;
        contentPane.add((Component)this.btnChooseInput, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 0;
        c.weightx = 0.0;
        contentPane.add((Component)this.lblProjName, c);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        c.weightx = 1.0;
        contentPane.add((Component)this.txfProjName, c);
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 0;
        c.weightx = 0.0;
        contentPane.add((Component)this.lblOutputPath, c);
        c.gridx = 1;
        c.gridy = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        c.weightx = 1.0;
        contentPane.add((Component)this.txfOutputPath, c);
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 2;
        c.weightx = 0.0;
        contentPane.add((Component)this.btnChooseOutput, c);
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(10, 0, 0, 0);
        contentPane.add((Component)this.lblOutputDir, c);
        c.gridy = -1;
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(2, 0, 0, 0);
        contentPane.add((Component)this.txfOutputDir, c);
        c.fill = 0;
        c.gridwidth = 0;
        c.anchor = 10;
        c.insets = new Insets(10, 0, 0, 0);
        contentPane.add((Component)this.btnTranslate, c);
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(2, 0, 0, 0);
        contentPane.add((Component)this.lblLog, c);
        c.fill = 2;
        c.gridwidth = 0;
        c.insets = new Insets(2, 0, 0, 0);
        contentPane.add((Component)logScrollPane, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnChooseInput) {
            this.btnChooseInputActionPerformed();
        } else if (e.getSource() == this.btnChooseOutput) {
            this.btnChooseOutputActionPerformed();
        } else if (e.getSource() == this.btnTranslate) {
            this.btnTranslateActionPerformed();
        }
    }

    private void btnChooseInputActionPerformed() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setCurrentDirectory(new File("./examples"));
        fc.setCurrentDirectory(new File("."));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String path = file.getAbsolutePath();
            this.txfInputSpec.setText(path);
        }
    }

    private void btnChooseOutputActionPerformed() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setCurrentDirectory(new File("./output"));
        fc.setCurrentDirectory(new File("."));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String path = file.getAbsolutePath();
            this.txfOutputPath.setText(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnTranslateActionPerformed() {
        this.txaLog.setDocument(new PlainDocument());
        this.jCircus = new JCircus(this);
        String path = this.txfInputSpec.getText();
        if (path == null || path.equals("")) {
            JOptionPane.showMessageDialog(this, "Enter the input file.");
            return;
        }
        String projectName = this.txfProjName.getText();
        if (projectName == null || projectName.equals("")) {
            JOptionPane.showMessageDialog(this, "Enter the project name.");
            return;
        }
        String projectDir = this.txfOutputPath.getText();
        if (projectDir == null || projectDir.equals("")) {
            JOptionPane.showMessageDialog(this, "Enter the output dir.");
            return;
        }
        try {
            this.jCircus.jCircusMain(path, projectName, projectDir);
        }
        catch (FailParsingException fpe) {
            List errors = fpe.getErrors();
            this.txaLog.append(errors.size() + " parsing error(s)!" + NEWLINE);
            this.txaLog.setCaretPosition(this.txaLog.getDocument().getLength());
            for (Object e : errors) {
                this.txaLog.append(e.toString() + NEWLINE);
                this.txaLog.setCaretPosition(this.txaLog.getDocument().getLength());
            }
        }
        catch (FailTypeCheckingException ftce) {
            List typeErrors = ftce.getErrors();
            this.txaLog.append(typeErrors.size() + " type error(s)!" + NEWLINE);
            this.txaLog.setCaretPosition(this.txaLog.getDocument().getLength());
            for (Object e : typeErrors) {
                this.txaLog.append(e.toString() + NEWLINE);
                this.txaLog.setCaretPosition(this.txaLog.getDocument().getLength());
            }
        }
        catch (FailTranslationException fte) {
            List reqErrors = fte.getErrors();
            this.txaLog.append("Input file does not meet the requirements for translation.\n");
            this.txaLog.append(reqErrors.size() + " error(s)!" + NEWLINE);
            this.txaLog.setCaretPosition(this.txaLog.getDocument().getLength());
            for (Object e : reqErrors) {
                this.txaLog.append(e.toString() + NEWLINE);
                this.txaLog.setCaretPosition(this.txaLog.getDocument().getLength());
            }
        }
        catch (JCircusException e) {
            JOptionPane.showMessageDialog(this, "Unexpected error. See log for details.", "Error", 0);
            try {
                PrintStream printStream = new PrintStream("/log.txt");
                e.printStackTrace(printStream);
                printStream.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Can't create log.", "Error", 0);
                ioe.printStackTrace();
            }
            finally {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unexpected error. See log for details.", "Error", 0);
            try {
                PrintStream printStream = new PrintStream("/log.txt");
                printStream.print(e.toString());
                printStream.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Can't create log.", "Error", 0);
                ioe.printStackTrace();
            }
            finally {
                e.printStackTrace();
            }
        }
    }

    public void reportParsingOK() {
        this.txaLog.append("No parsing errors!\n");
    }

    public void reportTypeCheckingOK() {
        this.txaLog.append("No type checking errors!\n");
    }

    public void reportTranslationOK(String projectDir, String projectName) {
        this.txaLog.append("Translation was successful! Files for project '" + projectName + "' were created at " + this.getOutputDir(projectDir, projectName) + ".");
    }

    private void changeOutputDir() {
        String outputPath = this.txfOutputPath.getText();
        String projectName = this.txfProjName.getText();
        String projectDir = this.getOutputDir(outputPath, projectName);
        this.txfOutputDir.setText(projectDir);
    }

    private String getOutputDir(String outputPath, String projectName) {
        return outputPath + "\\" + projectName + "\\" + "src";
    }

    public boolean promptForMainProcesses(List<ProcInfo> procInfoList) {
        ChooseMainDialog chooseMainDialog = new ChooseMainDialog(this, procInfoList);
        chooseMainDialog.pack();
        chooseMainDialog.setVisible(true);
        if (this.canceled) {
            JOptionPane.showMessageDialog(this, "Translation canceled by the user.");
            return false;
        }
        return true;
    }

    public boolean promptForParameters(ProcInfo procInfo) {
        ParametersDialog ParametersFrame = new ParametersDialog(this, procInfo);
        ParametersFrame.pack();
        ParametersFrame.setVisible(true);
        if (this.canceled) {
            JOptionPane.showMessageDialog(this, "Translation canceled by the user.");
            return false;
        }
        return true;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JCircusFrame jCircusFrame = new JCircusFrame();
        jCircusFrame.pack();
        jCircusFrame.setVisible(true);
    }

    public void setUpForTesting() {
        this.txfInputSpec.setText("D:\\Angela\\Research\\Java\\JCircus\\src\\examples\\T_MS.tex");
        this.txfProjName.setText("MS_");
        this.txfOutputPath.setText("D:\\Angela\\Research\\Java\\Translator");
        this.changeOutputDir();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JCircusFrame.createAndShowGUI();
            }
        });
    }

    public class TextFieldsDocumentListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            JCircusFrame.this.changeOutputDir();
        }

        public void removeUpdate(DocumentEvent e) {
            JCircusFrame.this.changeOutputDir();
        }

        public void changedUpdate(DocumentEvent e) {
            JCircusFrame.this.changeOutputDir();
        }
    }
}

