/*
 * Decompiled with CFR 0.152.
 */
package jcircus.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jcircus.gui.JCircusFrame;
import jcircus.util.ProcInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseMainDialog
extends JDialog
implements ActionListener {
    private JCheckBox[] checkBoxes;
    private JButton btnOk;
    private JButton btnCancel;
    private List<ProcInfo> procList;

    public ChooseMainDialog(JCircusFrame jCircusFrame, List<ProcInfo> procList) {
        super(jCircusFrame, "Choose main processes", true);
        int i;
        this.procList = procList;
        this.setDefaultCloseOperation(0);
        JPanel contentPane = new JPanel();
        contentPane.setOpaque(true);
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane(contentPane);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        String[] text = new String[]{"Mark the processes for which you", "want a class Main to be created:"};
        this.checkBoxes = new JCheckBox[procList.size()];
        for (i = 0; i < text.length; ++i) {
            this.getContentPane().add(new JLabel(text[i]));
        }
        for (i = 0; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i] = new JCheckBox(procList.get(i).getProcessName());
            this.getContentPane().add(this.checkBoxes[i]);
        }
        JPanel pnlButtons = new JPanel();
        this.btnOk = new JButton("OK");
        this.btnOk.setSize(20, 10);
        this.btnOk.addActionListener(this);
        pnlButtons.add(this.btnOk);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setSize(20, 10);
        this.btnCancel.addActionListener(this);
        pnlButtons.add(this.btnCancel);
        this.getContentPane().add(pnlButtons);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            this.btnOkPressed();
        } else if (e.getSource() == this.btnCancel) {
            this.btnCancelPressed();
        }
    }

    private void btnOkPressed() {
        int n = 0;
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            if (this.checkBoxes[i].isSelected()) {
                this.procList.get(i).setCreateMain(true);
                ++n;
                continue;
            }
            this.procList.get(i).setCreateMain(false);
        }
        if (n == 0) {
            JOptionPane.showMessageDialog(this, "No class Main will be created.");
        }
        ((JCircusFrame)this.getOwner()).setCanceled(false);
        this.setVisible(false);
        this.dispose();
    }

    private void btnCancelPressed() {
        ((JCircusFrame)this.getOwner()).setCanceled(true);
        this.setVisible(false);
        this.dispose();
    }
}

