/*
 * Decompiled with CFR 0.152.
 */
package jcircus.environment;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jcircus.exceptions.NoNameTypeAnnotationException;
import jcircus.util.CircusType;
import jcircus.util.NameType;
import jcircus.util.Util;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.util.Factory;

public class NameTypeEnv {
    private Hashtable hashtable_ = new Hashtable();
    private Factory factory_ = new Factory();

    public void put(DeclName declName, CircusType circusType) throws NoNameTypeAnnotationException {
        if (declName.getAnn(NameType.class) == null) {
            throw new NoNameTypeAnnotationException(declName.toString());
        }
        this.hashtable_.put(declName, circusType);
    }

    public CircusType getCircusType(String string) {
        CircusType circusType = null;
        DeclName n = this.factory_.createDeclName(string);
        Enumeration keys = this.hashtable_.keys();
        while (keys.hasMoreElements()) {
            DeclName t = (DeclName)keys.nextElement();
            if (!t.equals(n)) continue;
            circusType = (CircusType)((Object)this.hashtable_.get(t));
            break;
        }
        return circusType;
    }

    public NameType getNameType(String string) {
        NameType nameType = null;
        Enumeration keys = this.hashtable_.keys();
        while (keys.hasMoreElements()) {
            DeclName t = (DeclName)keys.nextElement();
            if (!t.toString().equals(string)) continue;
            nameType = (NameType)((Object)t.getAnn(NameType.class));
            break;
        }
        return nameType;
    }

    public void remove(String channelName) {
        this.hashtable_.remove(channelName);
    }

    public NameTypeEnv substitute(List newChannels, List oldChannels) {
        NameTypeEnv r = new NameTypeEnv();
        r.putAll(this);
        for (int i = 0; i < oldChannels.size(); ++i) {
            Name oldChannelName = (Name)oldChannels.get(i);
            Name newChannelName = (Name)newChannels.get(i);
            if (!r.containsKey(oldChannelName.toString())) continue;
            NameType nameType = r.getNameType(oldChannelName.toString());
            CircusType circusType = r.getCircusType(oldChannelName.toString());
            r.remove(oldChannelName.toString());
            DeclName declName = this.factory_.createDeclName(newChannelName.toString());
            Util.addNameTypeAnn((TermA)declName, nameType);
            r.put(declName, circusType);
        }
        return r;
    }

    public void putAll(NameTypeEnv typeEnvironment) {
        Iterator iterator = typeEnvironment.iteratorKeys();
        while (iterator.hasNext()) {
            DeclName declName = (DeclName)iterator.next();
            CircusType circusType = typeEnvironment.getCircusType(declName.toString());
            this.put(declName, circusType);
        }
    }

    public boolean containsKey(String declName) {
        boolean r = false;
        Enumeration keys = this.hashtable_.keys();
        while (keys.hasMoreElements()) {
            DeclName t = (DeclName)keys.nextElement();
            if (!t.toString().equals(declName)) continue;
            r = true;
        }
        return r;
    }

    public Enumeration keys() {
        return this.hashtable_.keys();
    }

    public Iterator iteratorKeys() {
        return this.hashtable_.keySet().iterator();
    }

    public void print() {
        Enumeration en = this.hashtable_.keys();
        System.out.println("-------------");
        while (en.hasMoreElements()) {
            DeclName declName = (DeclName)en.nextElement();
            CircusType type = (CircusType)((Object)this.hashtable_.get(declName));
            System.out.println("DeclName: " + declName + ", CircusType: " + (Object)((Object)type));
        }
        System.out.println("-------------");
    }
}

