/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.java_cup;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import net.sourceforge.czt.java_cup.emit;
import net.sourceforge.czt.java_cup.internal_error;
import net.sourceforge.czt.java_cup.lalr_item;
import net.sourceforge.czt.java_cup.lalr_item_set;
import net.sourceforge.czt.java_cup.lalr_transition;
import net.sourceforge.czt.java_cup.lexer;
import net.sourceforge.czt.java_cup.nonassoc_action;
import net.sourceforge.czt.java_cup.parse_action;
import net.sourceforge.czt.java_cup.parse_action_row;
import net.sourceforge.czt.java_cup.parse_action_table;
import net.sourceforge.czt.java_cup.parse_reduce_row;
import net.sourceforge.czt.java_cup.parse_reduce_table;
import net.sourceforge.czt.java_cup.production;
import net.sourceforge.czt.java_cup.production_part;
import net.sourceforge.czt.java_cup.reduce_action;
import net.sourceforge.czt.java_cup.shift_action;
import net.sourceforge.czt.java_cup.symbol;
import net.sourceforge.czt.java_cup.symbol_part;
import net.sourceforge.czt.java_cup.symbol_set;
import net.sourceforge.czt.java_cup.terminal;
import net.sourceforge.czt.java_cup.terminal_set;

public class lalr_state {
    protected static Hashtable _all = new Hashtable();
    protected static Hashtable _all_kernels = new Hashtable();
    protected static int next_index = 0;
    protected lalr_item_set _items;
    protected lalr_transition _transitions = null;
    protected int _index;

    public lalr_state(lalr_item_set itms) throws internal_error {
        if (itms == null) {
            throw new internal_error("Attempt to construct an LALR state from a null item set");
        }
        if (lalr_state.find_state(itms) != null) {
            throw new internal_error("Attempt to construct a duplicate LALR state");
        }
        this._index = next_index++;
        this._items = itms;
        _all.put(this._items, this);
    }

    public static Enumeration all() {
        return _all.elements();
    }

    public static int number() {
        return _all.size();
    }

    public static lalr_state find_state(lalr_item_set itms) {
        if (itms == null) {
            return null;
        }
        return (lalr_state)_all.get(itms);
    }

    public lalr_item_set items() {
        return this._items;
    }

    public lalr_transition transitions() {
        return this._transitions;
    }

    public int index() {
        return this._index;
    }

    protected static void dump_state(lalr_state st) throws internal_error {
        if (st == null) {
            System.out.println("NULL lalr_state");
            return;
        }
        System.out.println("lalr_state [" + st.index() + "] {");
        lalr_item_set itms = st.items();
        Enumeration e = itms.all();
        while (e.hasMoreElements()) {
            lalr_item itm = (lalr_item)e.nextElement();
            System.out.print("  [");
            System.out.print(itm.the_production().lhs().the_symbol().name());
            System.out.print(" ::= ");
            for (int i = 0; i < itm.the_production().rhs_length(); ++i) {
                production_part part;
                if (i == itm.dot_pos()) {
                    System.out.print("(*) ");
                }
                if ((part = itm.the_production().rhs(i)).is_action()) {
                    System.out.print("{action} ");
                    continue;
                }
                System.out.print(((symbol_part)part).the_symbol().name() + " ");
            }
            if (itm.dot_at_end()) {
                System.out.print("(*) ");
            }
            System.out.println("]");
        }
        System.out.println("}");
    }

    protected static void propagate_all_lookaheads() throws internal_error {
        Enumeration st = lalr_state.all();
        while (st.hasMoreElements()) {
            ((lalr_state)st.nextElement()).propagate_lookaheads();
        }
    }

    public void add_transition(symbol on_sym, lalr_state to_st) throws internal_error {
        lalr_transition trans;
        this._transitions = trans = new lalr_transition(on_sym, to_st, this._transitions);
    }

    public static lalr_state build_machine(production start_prod) throws internal_error {
        Stack<lalr_state> work_stack = new Stack<lalr_state>();
        if (start_prod == null) {
            throw new internal_error("Attempt to build viable prefix recognizer using a null production");
        }
        lalr_item_set start_items = new lalr_item_set();
        lalr_item itm = new lalr_item(start_prod);
        itm.lookahead().add(terminal.EOF);
        start_items.add(itm);
        lalr_item_set kernel = new lalr_item_set(start_items);
        start_items.compute_closure();
        lalr_state start_state = new lalr_state(start_items);
        work_stack.push(start_state);
        _all_kernels.put(kernel, start_state);
        while (!work_stack.empty()) {
            symbol sym2;
            lalr_state st = (lalr_state)work_stack.pop();
            symbol_set outgoing = new symbol_set();
            Enumeration i = st.items().all();
            while (i.hasMoreElements()) {
                itm = (lalr_item)i.nextElement();
                sym2 = itm.symbol_after_dot();
                if (sym2 == null) continue;
                outgoing.add(sym2);
            }
            Enumeration s = outgoing.all();
            while (s.hasMoreElements()) {
                sym2 = (symbol)s.nextElement();
                lalr_item_set linked_items = new lalr_item_set();
                lalr_item_set new_items = new lalr_item_set();
                i = st.items().all();
                while (i.hasMoreElements()) {
                    itm = (lalr_item)i.nextElement();
                    symbol sym22 = itm.symbol_after_dot();
                    if (!sym2.equals(sym22)) continue;
                    new_items.add(itm.shift());
                    linked_items.add(itm);
                }
                kernel = new lalr_item_set(new_items);
                lalr_state new_st = (lalr_state)_all_kernels.get(kernel);
                if (new_st == null) {
                    new_items.compute_closure();
                    new_st = new lalr_state(new_items);
                    work_stack.push(new_st);
                    _all_kernels.put(kernel, new_st);
                } else {
                    Enumeration fix = linked_items.all();
                    while (fix.hasMoreElements()) {
                        lalr_item fix_itm = (lalr_item)fix.nextElement();
                        for (int l = 0; l < fix_itm.propagate_items().size(); ++l) {
                            lalr_item new_itm = (lalr_item)fix_itm.propagate_items().elementAt(l);
                            lalr_item existing = new_st.items().find(new_itm);
                            if (existing == null) continue;
                            fix_itm.propagate_items().setElementAt(existing, l);
                        }
                    }
                }
                st.add_transition(sym2, new_st);
            }
        }
        lalr_state.propagate_all_lookaheads();
        return start_state;
    }

    protected void propagate_lookaheads() throws internal_error {
        Enumeration itm = this.items().all();
        while (itm.hasMoreElements()) {
            ((lalr_item)itm.nextElement()).propagate_lookaheads(null);
        }
    }

    public void build_table_entries(parse_action_table act_table, parse_reduce_table reduce_table) throws internal_error {
        parse_action act;
        terminal_set conflict_set = new terminal_set();
        parse_action_row our_act_row = act_table.under_state[this.index()];
        parse_reduce_row our_red_row = reduce_table.under_state[this.index()];
        Enumeration i = this.items().all();
        while (i.hasMoreElements()) {
            lalr_item itm = (lalr_item)i.nextElement();
            if (!itm.dot_at_end()) continue;
            act = new reduce_action(itm.the_production());
            for (int t = 0; t < terminal.number(); ++t) {
                if (!itm.lookahead().contains(t)) continue;
                if (our_act_row.under_term[t].kind() == 0) {
                    our_act_row.under_term[t] = act;
                    continue;
                }
                terminal term = terminal.find(t);
                parse_action other_act = our_act_row.under_term[t];
                if (other_act.kind() != 1 && other_act.kind() != 3) {
                    if (itm.the_production().index() < ((reduce_action)other_act).reduce_with().index()) {
                        our_act_row.under_term[t] = act;
                    }
                } else if (this.fix_with_precedence(itm.the_production(), t, our_act_row, act)) {
                    term = null;
                }
                if (term == null) continue;
                conflict_set.add(term);
            }
        }
        for (lalr_transition trans = this.transitions(); trans != null; trans = trans.next()) {
            symbol sym2 = trans.on_symbol();
            if (!sym2.is_non_term()) {
                act = new shift_action(trans.to_state());
                if (our_act_row.under_term[sym2.index()].kind() == 0) {
                    our_act_row.under_term[sym2.index()] = act;
                    continue;
                }
                production p = ((reduce_action)our_act_row.under_term[sym2.index()]).reduce_with();
                if (this.fix_with_precedence(p, sym2.index(), our_act_row, act)) continue;
                our_act_row.under_term[sym2.index()] = act;
                conflict_set.add(terminal.find(sym2.index()));
                continue;
            }
            our_red_row.under_non_term[sym2.index()] = trans.to_state();
        }
        if (!conflict_set.empty()) {
            this.report_conflicts(conflict_set);
        }
    }

    protected boolean fix_with_precedence(production p, int term_index, parse_action_row table_row, parse_action act) throws internal_error {
        terminal term = terminal.find(term_index);
        if (p.precedence_num() > -1) {
            if (p.precedence_num() > term.precedence_num()) {
                table_row.under_term[term_index] = this.insert_reduce(table_row.under_term[term_index], act);
                return true;
            }
            if (p.precedence_num() < term.precedence_num()) {
                table_row.under_term[term_index] = this.insert_shift(table_row.under_term[term_index], act);
                return true;
            }
            if (term.precedence_side() == 1) {
                table_row.under_term[term_index] = this.insert_shift(table_row.under_term[term_index], act);
                return true;
            }
            if (term.precedence_side() == 0) {
                table_row.under_term[term_index] = this.insert_reduce(table_row.under_term[term_index], act);
                return true;
            }
            if (term.precedence_side() == 2) {
                table_row.under_term[term_index] = new nonassoc_action();
                return true;
            }
            throw new internal_error("Unable to resolve conflict correctly");
        }
        if (term.precedence_num() > -1) {
            table_row.under_term[term_index] = this.insert_shift(table_row.under_term[term_index], act);
            return true;
        }
        return false;
    }

    protected parse_action insert_action(parse_action a1, parse_action a2, int act_type) throws internal_error {
        if (a1.kind() == act_type && a2.kind() == act_type) {
            throw new internal_error("Conflict resolution of bogus actions");
        }
        if (a1.kind() == act_type) {
            return a1;
        }
        if (a2.kind() == act_type) {
            return a2;
        }
        throw new internal_error("Conflict resolution of bogus actions");
    }

    protected parse_action insert_shift(parse_action a1, parse_action a2) throws internal_error {
        return this.insert_action(a1, a2, 1);
    }

    protected parse_action insert_reduce(parse_action a1, parse_action a2) throws internal_error {
        return this.insert_action(a1, a2, 2);
    }

    protected void report_conflicts(terminal_set conflict_set) throws internal_error {
        Enumeration itms = this.items().all();
        while (itms.hasMoreElements()) {
            lalr_item itm = (lalr_item)itms.nextElement();
            if (!itm.dot_at_end()) continue;
            boolean after_itm = false;
            Enumeration comps = this.items().all();
            while (comps.hasMoreElements()) {
                lalr_item compare = (lalr_item)comps.nextElement();
                if (itm == compare) {
                    after_itm = true;
                }
                if (itm == compare || !compare.dot_at_end() || !after_itm || !compare.lookahead().intersects(itm.lookahead())) continue;
                this.report_reduce_reduce(itm, compare);
            }
            for (int t = 0; t < terminal.number(); ++t) {
                if (!conflict_set.contains(t)) continue;
                this.report_shift_reduce(itm, t);
            }
        }
    }

    protected void report_reduce_reduce(lalr_item itm1, lalr_item itm2) throws internal_error {
        boolean comma_flag = false;
        System.err.println("*** Reduce/Reduce conflict found in state #" + this.index());
        System.err.print("  between ");
        System.err.println(itm1.to_simple_string());
        System.err.print("  and     ");
        System.err.println(itm2.to_simple_string());
        System.err.print("  under symbols: {");
        for (int t = 0; t < terminal.number(); ++t) {
            if (!itm1.lookahead().contains(t) || !itm2.lookahead().contains(t)) continue;
            if (comma_flag) {
                System.err.print(", ");
            } else {
                comma_flag = true;
            }
            System.err.print(terminal.find(t).name());
        }
        System.err.println("}");
        System.err.print("  Resolved in favor of ");
        if (itm1.the_production().index() < itm2.the_production().index()) {
            System.err.println("the first production.\n");
        } else {
            System.err.println("the second production.\n");
        }
        ++emit.num_conflicts;
        ++lexer.warning_count;
    }

    protected void report_shift_reduce(lalr_item red_itm, int conflict_sym) throws internal_error {
        System.err.println("*** Shift/Reduce conflict found in state #" + this.index());
        System.err.print("  between ");
        System.err.println(red_itm.to_simple_string());
        Enumeration itms = this.items().all();
        while (itms.hasMoreElements()) {
            symbol shift_sym;
            lalr_item itm = (lalr_item)itms.nextElement();
            if (itm == red_itm || itm.dot_at_end() || (shift_sym = itm.symbol_after_dot()).is_non_term() || shift_sym.index() != conflict_sym) continue;
            System.err.println("  and     " + itm.to_simple_string());
        }
        System.err.println("  under symbol " + terminal.find(conflict_sym).name());
        System.err.println("  Resolved in favor of shifting.\n");
        ++emit.num_conflicts;
        ++lexer.warning_count;
    }

    public boolean equals(lalr_state other) {
        return other != null && this.items().equals(other.items());
    }

    public boolean equals(Object other) {
        if (!(other instanceof lalr_state)) {
            return false;
        }
        return this.equals((lalr_state)other);
    }

    public int hashCode() {
        return this.items().hashCode();
    }

    public String toString() {
        String result = "lalr_state [" + this.index() + "]: " + this._items + "\n";
        for (lalr_transition tr = this.transitions(); tr != null; tr = tr.next()) {
            result = result + tr;
            result = result + "\n";
        }
        return result;
    }
}

