/*
 * Decompiled with CFR 0.152.
 */
package jcsp.util;

import java.io.Serializable;
import jcsp.util.BufferSizeError;
import jcsp.util.ChannelDataStore;

public class InfiniteBuffer
implements ChannelDataStore,
Serializable {
    private static final int DEFAULT_SIZE = 8;
    private int initialSize;
    private Object[] buffer;
    private int counter = 0;
    private int firstIndex = 0;
    private int lastIndex = 0;

    public InfiniteBuffer() {
        this(8);
    }

    public InfiniteBuffer(int n) {
        if (n <= 0) {
            throw new BufferSizeError("\n*** Attempt to create a buffered channel with an initially negative or zero capacity");
        }
        this.initialSize = n;
        this.buffer = new Object[n + 1];
    }

    public Object get() {
        Object object = this.buffer[this.firstIndex];
        this.buffer[this.firstIndex] = null;
        this.firstIndex = (this.firstIndex + 1) % this.buffer.length;
        --this.counter;
        return object;
    }

    public void put(Object object) {
        if (this.counter == this.buffer.length) {
            Object[] objectArray = this.buffer;
            this.buffer = new Object[this.buffer.length * 2];
            System.arraycopy(objectArray, this.firstIndex, this.buffer, 0, objectArray.length - this.firstIndex);
            System.arraycopy(objectArray, 0, this.buffer, objectArray.length - this.firstIndex, this.firstIndex);
            this.firstIndex = 0;
            this.lastIndex = objectArray.length;
        }
        this.buffer[this.lastIndex] = object;
        this.lastIndex = (this.lastIndex + 1) % this.buffer.length;
        ++this.counter;
    }

    public int getState() {
        if (this.counter == 0) {
            return 0;
        }
        return 1;
    }

    public Object clone() {
        return new InfiniteBuffer(this.initialSize);
    }
}

