/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import java.util.Vector;
import jcsp.lang.Barrier;
import jcsp.lang.CSProcess;
import jcsp.lang.One2OneChannelInt;

public class Parallel
implements CSProcess {
    CSProcess[] processes;
    int nProcesses = 0;
    private ParThread[] parThreads;
    private int nThreads = 0;
    private Barrier barrier = new Barrier();
    private boolean priority;
    boolean processesChanged;
    static Vector allParThreads = new Vector();

    public static synchronized void destroy() {
        Vector vector = allParThreads;
        synchronized (vector) {
            int n = allParThreads.size();
            System.out.println("*** Parallel: stopping " + n + " processes ... ");
            int n2 = 0;
            while (n2 < n) {
                ((Thread)allParThreads.elementAt(n2)).stop();
                ++n2;
            }
            allParThreads.removeAllElements();
            System.out.println("*** Parallel: " + n + " processes stopped");
        }
    }

    public Parallel() {
        this(null, false);
    }

    Parallel(boolean bl) {
        this(null, bl);
    }

    public Parallel(CSProcess[] cSProcessArray) {
        this(cSProcessArray, false);
    }

    Parallel(CSProcess[] cSProcessArray, boolean bl) {
        if (cSProcessArray != null) {
            this.nProcesses = cSProcessArray.length;
            this.processes = new CSProcess[this.nProcesses];
            System.arraycopy(cSProcessArray, 0, this.processes, 0, this.nProcesses);
            this.parThreads = new ParThread[this.nProcesses];
        } else {
            this.nProcesses = 0;
            this.processes = new CSProcess[0];
            this.parThreads = new ParThread[0];
        }
        this.processesChanged = true;
        this.priority = bl;
    }

    public synchronized void addProcess(CSProcess cSProcess) {
        if (cSProcess != null) {
            int n = this.nProcesses + 1;
            if (n > this.processes.length) {
                CSProcess[] cSProcessArray = this.processes;
                this.processes = new CSProcess[2 * n];
                System.arraycopy(cSProcessArray, 0, this.processes, 0, this.nProcesses);
            }
            this.processes[this.nProcesses] = cSProcess;
            this.nProcesses = n;
            this.processesChanged = true;
        }
    }

    public synchronized void addProcess(CSProcess[] cSProcessArray) {
        if (this.processes != null) {
            int n = cSProcessArray.length;
            int n2 = this.nProcesses + n;
            if (n2 > this.processes.length) {
                CSProcess[] cSProcessArray2 = this.processes;
                this.processes = new CSProcess[2 * n2];
                System.arraycopy(cSProcessArray2, 0, this.processes, 0, this.nProcesses);
            }
            System.arraycopy(cSProcessArray, 0, this.processes, this.nProcesses, n);
            this.nProcesses = n2;
            this.processesChanged = true;
        }
    }

    public synchronized void removeProcess(CSProcess cSProcess) {
        int n = 0;
        while (n < this.nProcesses) {
            if (this.processes[n] == cSProcess) {
                if (n < this.nProcesses - 1) {
                    System.arraycopy(this.processes, n + 1, this.processes, n, this.nProcesses - (n + 1));
                }
                --this.nProcesses;
                this.processes[this.nProcesses] = null;
                this.processesChanged = true;
                return;
            }
            ++n;
        }
    }

    public synchronized void removeAllProcesses() {
        int n = 0;
        while (n < this.nProcesses) {
            this.processes[n] = null;
            ++n;
        }
        this.nProcesses = 0;
        this.processesChanged = true;
    }

    public synchronized void releaseAllThreads() {
        int n = 0;
        while (n < this.nThreads) {
            this.parThreads[n].kick.write(1);
            this.parThreads[n] = null;
            ++n;
        }
        this.nThreads = 0;
        this.processesChanged = true;
    }

    public synchronized int getNumberProcesses() {
        return this.nProcesses;
    }

    public void run() {
        if (this.nProcesses > 0) {
            CSProcess cSProcess;
            Object object;
            int n = 0;
            int n2 = 0;
            if (this.priority) {
                object = Thread.currentThread();
                n = ((Thread)object).getPriority();
                n2 = Math.min(n + this.nProcesses - 1, Math.min(10, ((Thread)object).getThreadGroup().getMaxPriority()));
            }
            object = this;
            synchronized (object) {
                cSProcess = this.processes[this.nProcesses - 1];
                if (this.processesChanged) {
                    this.barrier.reset(this.nProcesses);
                    if (this.nThreads < this.nProcesses - 1) {
                        if (this.parThreads.length < this.nProcesses - 1) {
                            ParThread[] parThreadArray = this.parThreads;
                            this.parThreads = new ParThread[this.processes.length];
                            System.arraycopy(parThreadArray, 0, this.parThreads, 0, this.nThreads);
                        }
                        int n3 = 0;
                        while (n3 < this.nThreads) {
                            this.parThreads[n3].reset(this.processes[n3], this.barrier);
                            if (this.priority) {
                                this.parThreads[n3].setPriority(Math.max(n, n2 - n3));
                            }
                            this.parThreads[n3].kick.write(0);
                            ++n3;
                        }
                        int n4 = this.nThreads;
                        while (n4 < this.nProcesses - 1) {
                            this.parThreads[n4] = new ParThread(this.processes[n4], this.barrier);
                            if (this.priority) {
                                this.parThreads[n4].setPriority(Math.max(n, n2 - n4));
                            }
                            this.parThreads[n4].start();
                            ++n4;
                        }
                        this.nThreads = this.nProcesses - 1;
                    } else {
                        int n5 = 0;
                        while (n5 < this.nProcesses - 1) {
                            this.parThreads[n5].reset(this.processes[n5], this.barrier);
                            if (this.priority) {
                                this.parThreads[n5].setPriority(Math.max(n, n2 - n5));
                            }
                            this.parThreads[n5].kick.write(0);
                            ++n5;
                        }
                    }
                    this.processesChanged = false;
                } else {
                    int n6 = 0;
                    while (n6 < this.nProcesses - 1) {
                        if (this.priority) {
                            this.parThreads[n6].setPriority(Math.max(n, n2 - n6));
                        }
                        this.parThreads[n6].kick.write(0);
                        ++n6;
                    }
                }
            }
            cSProcess.run();
            this.barrier.sync();
        }
    }

    private class ParThread
    extends Thread {
        private CSProcess process;
        private Barrier barrier;
        public static final int AGAIN = 0;
        public static final int TERMINATE = 1;
        public One2OneChannelInt kick = new One2OneChannelInt();

        ParThread(CSProcess cSProcess, Barrier barrier) {
            this.setDaemon(true);
            allParThreads.addElement(this);
            this.setProcess(cSProcess);
            this.barrier = barrier;
        }

        public void reset(CSProcess cSProcess, Barrier barrier) {
            this.setProcess(cSProcess);
            this.barrier = barrier;
        }

        private void setProcess(CSProcess cSProcess) {
            this.process = cSProcess;
            if (cSProcess != null) {
                this.setName(cSProcess.getClass().getName());
            } else {
                this.setName("none");
            }
        }

        public void kickkick() {
            this.kick.write(0);
        }

        public void run() {
            int n = 0;
            while (n == 0) {
                this.process.run();
                this.barrier.sync();
                n = this.kick.read();
            }
        }
    }
}

