/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import java.io.Serializable;
import jcsp.lang.Alternative;
import jcsp.lang.AltingChannelInt;
import jcsp.lang.ProcessInterruptedError;
import jcsp.util.ints.ChannelDataStoreInt;
import jcsp.util.ints.ZeroBufferInt;

public class One2OneChannelInt
extends AltingChannelInt
implements Serializable {
    private ChannelDataStoreInt data;
    private Alternative alt;

    public One2OneChannelInt() {
        this(null);
    }

    public One2OneChannelInt(ChannelDataStoreInt channelDataStoreInt) {
        this.data = channelDataStoreInt == null ? new ZeroBufferInt() : (ChannelDataStoreInt)channelDataStoreInt.clone();
    }

    public synchronized int read() {
        if (this.data.getState() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessInterruptedError("*** Thrown from One2OneChannelInt.read ()\n" + interruptedException.toString());
            }
        }
        int n = this.data.get();
        this.notify();
        return n;
    }

    public synchronized void write(int n) {
        this.data.put(n);
        if (this.alt != null) {
            this.alt.schedule();
        } else {
            this.notify();
        }
        if (this.data.getState() == 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new ProcessInterruptedError("*** Thrown from One2OneChannelInt.write (int)\n" + interruptedException.toString());
            }
        }
    }

    synchronized boolean enable(Alternative alternative) {
        if (this.data.getState() == 0) {
            this.alt = alternative;
            return false;
        }
        return true;
    }

    synchronized boolean disable() {
        this.alt = null;
        return this.data.getState() != 0;
    }

    public synchronized boolean pending() {
        return this.data.getState() != 0;
    }

    public static One2OneChannelInt[] create(int n) {
        return One2OneChannelInt.create(n, null);
    }

    public static One2OneChannelInt create(ChannelDataStoreInt channelDataStoreInt) {
        return new One2OneChannelInt(channelDataStoreInt);
    }

    public static One2OneChannelInt[] create(int n, ChannelDataStoreInt channelDataStoreInt) {
        One2OneChannelInt[] one2OneChannelIntArray = new One2OneChannelInt[n];
        int n2 = 0;
        while (n2 < n) {
            one2OneChannelIntArray[n2] = new One2OneChannelInt(channelDataStoreInt);
            ++n2;
        }
        return one2OneChannelIntArray;
    }
}

