/*
 * Decompiled with CFR 0.152.
 */
package jcsp.lang;

import java.io.Serializable;
import jcsp.lang.ProcessInterruptedError;

public class Bucket
implements Serializable {
    private int nHolding = 0;

    public synchronized void fallInto() {
        ++this.nHolding;
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            throw new ProcessInterruptedError("*** Thrown from Bucket.fallInto ()\n" + interruptedException.toString());
        }
    }

    public synchronized int flush() {
        this.notifyAll();
        int n = this.nHolding;
        this.nHolding = 0;
        return n;
    }

    public synchronized int holding() {
        return this.nHolding;
    }

    public static Bucket[] create(int n) {
        Bucket[] bucketArray = new Bucket[n];
        int n2 = 0;
        while (n2 < n) {
            bucketArray[n2] = new Bucket();
            ++n2;
        }
        return bucketArray;
    }
}

