/*
 * Decompiled with CFR 0.152.
 */
package jcsp.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Shape;
import jcsp.lang.TaggedProtocol;

public abstract class GraphicsCommand
extends TaggedProtocol {
    static final int NULL_TAG = 0;
    static final int TRANSLATE = 1;
    static final int SET_COLOR = 2;
    static final int SET_PAINT_MODE_TAG = 3;
    static final int SET_XOR_MODE = 4;
    static final int SET_FONT = 5;
    static final int CLIP_RECT = 6;
    static final int SET_CLIP = 7;
    static final int COPY_AREA = 8;
    static final int DRAW_LINE = 9;
    static final int FILL_RECT = 10;
    static final int DRAW_RECT = 11;
    static final int CLEAR_RECT = 12;
    static final int DRAW_ROUND_RECT = 13;
    static final int FILL_ROUND_RECT = 14;
    static final int DRAW_3D_RECT = 15;
    static final int FILL_3D_RECT = 16;
    static final int DRAW_OVAL = 17;
    static final int FILL_OVAL = 18;
    static final int DRAW_ARC = 19;
    static final int FILL_ARC = 20;
    static final int DRAW_POLYLINE = 21;
    static final int DRAW_POLYGON = 22;
    static final int FILL_POLYGON = 23;
    static final int DRAW_STRING = 24;
    static final int DRAW_CHARS = 25;
    static final int DRAW_BYTES = 26;
    static final int DRAW_IMAGE = 27;
    static final int GENERAL = 28;
    public static final GraphicsCommand NULL = new Null();
    public static final GraphicsCommand SET_PAINT_MODE = new SetPaintMode();

    GraphicsCommand(int n) {
        super(n);
    }

    public static final class General
    extends GraphicsCommand {
        final Graphic g;

        public General(Graphic graphic) {
            super(28);
            this.g = graphic;
        }
    }

    public static interface Graphic {
        public void doGraphic(Graphics var1, Component var2);
    }

    public static final class DrawImage
    extends GraphicsCommand {
        final int drawtag;
        final Image image;
        final int x;
        final int y;
        final int width;
        final int height;
        final Color bgcolor;
        final int dx1;
        final int dy1;
        final int dx2;
        final int dy2;
        final int sx1;
        final int sy1;
        final int sx2;
        final int sy2;

        public DrawImage(Image image, int n, int n2) {
            super(27);
            this.drawtag = 0;
            this.image = image;
            this.x = n;
            this.y = n2;
            this.width = 0;
            this.height = 0;
            this.bgcolor = null;
            this.dx1 = 0;
            this.dy1 = 0;
            this.dx2 = 0;
            this.dy2 = 0;
            this.sx1 = 0;
            this.sy1 = 0;
            this.sx2 = 0;
            this.sy2 = 0;
        }

        public DrawImage(Image image, int n, int n2, int n3, int n4) {
            super(27);
            this.drawtag = 1;
            this.image = image;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.bgcolor = null;
            this.dx1 = 0;
            this.dy1 = 0;
            this.dx2 = 0;
            this.dy2 = 0;
            this.sx1 = 0;
            this.sy1 = 0;
            this.sx2 = 0;
            this.sy2 = 0;
        }

        public DrawImage(Image image, int n, int n2, Color color) {
            super(27);
            this.drawtag = 2;
            this.image = image;
            this.x = n;
            this.y = n2;
            this.bgcolor = color;
            this.width = 0;
            this.height = 0;
            this.dx1 = 0;
            this.dy1 = 0;
            this.dx2 = 0;
            this.dy2 = 0;
            this.sx1 = 0;
            this.sy1 = 0;
            this.sx2 = 0;
            this.sy2 = 0;
        }

        public DrawImage(Image image, int n, int n2, int n3, int n4, Color color) {
            super(27);
            this.drawtag = 3;
            this.image = image;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.bgcolor = color;
            this.dx1 = 0;
            this.dy1 = 0;
            this.dx2 = 0;
            this.dy2 = 0;
            this.sx1 = 0;
            this.sy1 = 0;
            this.sx2 = 0;
            this.sy2 = 0;
        }

        public DrawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            super(27);
            this.drawtag = 4;
            this.image = image;
            this.dx1 = n;
            this.dy1 = n2;
            this.dx2 = n3;
            this.dy2 = n4;
            this.sx1 = n5;
            this.sy1 = n6;
            this.sx2 = n7;
            this.sy2 = n8;
            this.x = 0;
            this.y = 0;
            this.width = 0;
            this.height = 0;
            this.bgcolor = null;
        }

        public DrawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
            super(27);
            this.drawtag = 5;
            this.image = image;
            this.dx1 = n;
            this.dy1 = n2;
            this.dx2 = n3;
            this.dy2 = n4;
            this.sx1 = n5;
            this.sy1 = n6;
            this.sx2 = n7;
            this.sy2 = n8;
            this.bgcolor = color;
            this.x = 0;
            this.y = 0;
            this.width = 0;
            this.height = 0;
        }
    }

    public static final class DrawBytes
    extends GraphicsCommand {
        final byte[] data;
        final int offset;
        final int length;
        final int x;
        final int y;

        public DrawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
            super(26);
            this.data = byArray;
            this.offset = n;
            this.length = n2;
            this.x = n3;
            this.y = n4;
        }
    }

    public static final class DrawChars
    extends GraphicsCommand {
        final char[] data;
        final int offset;
        final int length;
        final int x;
        final int y;

        public DrawChars(char[] cArray, int n, int n2, int n3, int n4) {
            super(25);
            this.data = cArray;
            this.offset = n;
            this.length = n2;
            this.x = n3;
            this.y = n4;
        }
    }

    public static final class DrawString
    extends GraphicsCommand {
        final String string;
        final int x;
        final int y;

        public DrawString(String string, int n, int n2) {
            super(24);
            this.string = string;
            this.x = n;
            this.y = n2;
        }
    }

    public static final class FillPolygon
    extends GraphicsCommand {
        final int polytag;
        final int[] xPoints;
        final int[] yPoints;
        final int nPoints;
        final Polygon p;

        public FillPolygon(int[] nArray, int[] nArray2, int n) {
            super(23);
            this.polytag = 0;
            this.xPoints = nArray;
            this.yPoints = nArray2;
            this.nPoints = n;
            this.p = null;
        }

        public FillPolygon(Polygon polygon) {
            super(23);
            this.polytag = 1;
            this.p = polygon;
            this.xPoints = null;
            this.yPoints = null;
            this.nPoints = 0;
        }
    }

    public static final class DrawPolygon
    extends GraphicsCommand {
        final int polytag;
        final int[] xPoints;
        final int[] yPoints;
        final int nPoints;
        final Polygon p;

        public DrawPolygon(int[] nArray, int[] nArray2, int n) {
            super(22);
            this.polytag = 0;
            this.xPoints = nArray;
            this.yPoints = nArray2;
            this.nPoints = n;
            this.p = null;
        }

        public DrawPolygon(Polygon polygon) {
            super(22);
            this.polytag = 1;
            this.p = polygon;
            this.xPoints = null;
            this.yPoints = null;
            this.nPoints = 0;
        }
    }

    public static final class DrawPolyline
    extends GraphicsCommand {
        final int[] xPoints;
        final int[] yPoints;
        final int nPoints;

        public DrawPolyline(int[] nArray, int[] nArray2, int n) {
            super(21);
            this.xPoints = nArray;
            this.yPoints = nArray2;
            this.nPoints = n;
        }
    }

    public static final class FillArc
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;
        final int startAngle;
        final int arcAngle;

        public FillArc(int n, int n2, int n3, int n4, int n5, int n6) {
            super(20);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.startAngle = n5;
            this.arcAngle = n6;
        }
    }

    public static final class DrawArc
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;
        final int startAngle;
        final int arcAngle;

        public DrawArc(int n, int n2, int n3, int n4, int n5, int n6) {
            super(19);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.startAngle = n5;
            this.arcAngle = n6;
        }
    }

    public static final class FillOval
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;

        public FillOval(int n, int n2, int n3, int n4) {
            super(18);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }

    public static final class DrawOval
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;

        public DrawOval(int n, int n2, int n3, int n4) {
            super(17);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }

    public static final class Fill3DRect
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;
        final boolean raised;

        public Fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
            super(16);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.raised = bl;
        }
    }

    public static final class Draw3DRect
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;
        final boolean raised;

        public Draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
            super(15);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.raised = bl;
        }
    }

    public static final class FillRoundRect
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;
        final int arcWidth;
        final int arcHeight;

        public FillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
            super(14);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.arcWidth = n5;
            this.arcHeight = n6;
        }
    }

    public static final class DrawRoundRect
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;
        final int arcWidth;
        final int arcHeight;

        public DrawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
            super(13);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.arcWidth = n5;
            this.arcHeight = n6;
        }
    }

    public static final class ClearRect
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;

        public ClearRect(int n, int n2, int n3, int n4) {
            super(12);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }

    public static final class DrawRect
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;

        public DrawRect(int n, int n2, int n3, int n4) {
            super(11);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }

    public static final class FillRect
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;

        public FillRect(int n, int n2, int n3, int n4) {
            super(10);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }

    public static final class DrawLine
    extends GraphicsCommand {
        final int x1;
        final int y1;
        final int x2;
        final int y2;

        public DrawLine(int n, int n2, int n3, int n4) {
            super(9);
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
        }
    }

    public static final class CopyArea
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;
        final int dx;
        final int dy;

        public CopyArea(int n, int n2, int n3, int n4, int n5, int n6) {
            super(8);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.dx = n5;
            this.dy = n6;
        }
    }

    public static final class SetClip
    extends GraphicsCommand {
        final int cliptag;
        final int x;
        final int y;
        final int width;
        final int height;
        final Shape s;

        public SetClip(int n, int n2, int n3, int n4) {
            super(7);
            this.cliptag = 0;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.s = null;
        }

        public SetClip(Shape shape) {
            super(7);
            this.cliptag = 1;
            this.s = shape;
            this.x = 0;
            this.y = 0;
            this.width = 0;
            this.height = 0;
        }
    }

    public static final class ClipRect
    extends GraphicsCommand {
        final int x;
        final int y;
        final int width;
        final int height;

        public ClipRect(int n, int n2, int n3, int n4) {
            super(6);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }
    }

    public static final class SetFont
    extends GraphicsCommand {
        final Font f;

        public SetFont(Font font) {
            super(5);
            this.f = font;
        }
    }

    public static final class SetXORMode
    extends GraphicsCommand {
        final Color c;

        public SetXORMode(Color color) {
            super(4);
            this.c = color;
        }
    }

    private static final class SetPaintMode
    extends GraphicsCommand {
        public SetPaintMode() {
            super(3);
        }
    }

    public static final class SetColor
    extends GraphicsCommand {
        final Color c;

        public SetColor(Color color) {
            super(2);
            this.c = color;
        }
    }

    public static final class Translate
    extends GraphicsCommand {
        final int x;
        final int y;

        public Translate(int n, int n2) {
            super(1);
            this.x = n;
            this.y = n2;
        }
    }

    private static final class Null
    extends GraphicsCommand {
        public Null() {
            super(0);
        }
    }
}

