/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.session;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.parser.util.DefinitionTable;
import net.sourceforge.czt.parser.util.DefinitionTableService;
import net.sourceforge.czt.parser.util.JokerTable;
import net.sourceforge.czt.parser.util.JokerTableCommand;
import net.sourceforge.czt.parser.util.LatexMarkupFunction;
import net.sourceforge.czt.parser.util.OpTable;
import net.sourceforge.czt.parser.util.OpTableVisitor;
import net.sourceforge.czt.parser.z.ParseUtils;
import net.sourceforge.czt.session.Command;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.FileSource;
import net.sourceforge.czt.session.Key;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.session.Source;
import net.sourceforge.czt.session.UrlSource;
import net.sourceforge.czt.util.CztLogger;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.ZSect;

public class SectionManager
implements Cloneable,
SectionInfo {
    private Map<Key, Object> content_ = new HashMap<Key, Object>();
    private Map<Class, Command> commands_ = new HashMap<Class, Command>();
    private Properties properties_ = new Properties();

    public SectionManager() {
        this.setupDefaultCommands();
    }

    public Object clone() {
        SectionManager result = new SectionManager();
        this.copyMap(this.content_, result.content_);
        this.copyMap(this.commands_, result.commands_);
        this.copyMap(this.properties_, result.properties_);
        return result;
    }

    private void copyMap(Map from, Map to) {
        to.clear();
        for (Map.Entry entry : from.entrySet()) {
            to.put(entry.getKey(), entry.getValue());
        }
    }

    public String getProperty(String key) {
        return this.properties_.getProperty(key);
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public Object setProperty(String key, String value) {
        return this.properties_.setProperty(key, value);
    }

    private void setupDefaultCommands() {
        this.commands_.put(Source.class, new SourceLocator());
        this.commands_.put(Spec.class, ParseUtils.getCommand());
        this.commands_.put(ZSect.class, ParseUtils.getCommand());
        this.commands_.put(OpTable.class, new OpTableCommand());
        this.commands_.put(DefinitionTable.class, new DefinitionTableService());
        this.commands_.put(LatexMarkupFunction.class, ParseUtils.getCommand());
        this.commands_.put(JokerTable.class, new JokerTableCommand());
    }

    public void putCommand(Class infoType, Command command) {
        this.commands_.put(infoType, command);
    }

    public Command getCommand(Class infoType) {
        return this.commands_.get(infoType);
    }

    public boolean isCached(Key key) {
        return this.content_.get(key) != null;
    }

    public Object get(Key key) throws CommandException {
        CztLogger.getLogger(this.getClass()).finer("Entering method get " + key);
        Class infoType = key.getType();
        String name = key.getName();
        Object result = this.content_.get(key);
        if (result == null) {
            Command command = this.commands_.get(infoType);
            if (command == null) {
                throw new CommandException("No command available to compute " + key);
            }
            CztLogger.getLogger(this.getClass()).finer("Try command ...");
            command.compute(name, this);
            result = this.content_.get(new Key(name, infoType));
            if (result == null) {
                String message = "Key " + key + " not computed by " + command;
                throw new CommandException(message);
            }
        }
        String message = "Leaving method get and returning " + result;
        CztLogger.getLogger(this.getClass()).finer(message);
        return result;
    }

    public void put(Key key, Object value) {
        String message;
        assert (key != null);
        assert (value != null);
        if (!key.getType().isInstance(value)) {
            message = "SectionManager ERROR: " + value + " is not an instance of " + key.getType();
            CztLogger.getLogger(this.getClass()).warning(message);
        }
        assert (key.getType().isInstance(value));
        if (this.content_.containsKey(key)) {
            message = "Attempt to add duplicate key: " + key;
            CztLogger.getLogger(this.getClass()).warning(message);
        }
        this.content_.put(key, value);
        CztLogger.getLogger(this.getClass()).finer("put " + key);
    }

    public void put(Key key, Object value, Set dependencies) {
        this.put(key, value);
    }

    public void reset() {
        CztLogger.getLogger(this.getClass()).finer("reset");
        this.content_.clear();
    }

    public String toString() {
        return "SectionManager contains " + this.content_.toString();
    }

    class OpTableCommand
    implements Command {
        OpTableCommand() {
        }

        public boolean compute(String name, SectionManager manager) throws CommandException {
            Key key = new Key(name, OpTable.class);
            if (!manager.isCached(key)) {
                ZSect zSect = (ZSect)manager.get(new Key(name, ZSect.class));
                if (!manager.isCached(key)) {
                    OpTableVisitor visitor = new OpTableVisitor(manager);
                    OpTable opTable = (OpTable)visitor.run((Term)zSect);
                    manager.put(key, opTable);
                }
            }
            return true;
        }
    }

    class LatexMarkupFunctionCommand
    implements Command {
        LatexMarkupFunctionCommand() {
        }

        public boolean compute(String name, SectionManager manager) throws CommandException {
            Key key = new Key(name, LatexMarkupFunction.class);
            if (!manager.isCached(key)) {
                ZSect zsect = (ZSect)manager.get(new Key(name, ZSect.class));
                if (!manager.isCached(key) && zsect != null) {
                    manager.put(key, new LatexMarkupFunction(name));
                }
            }
            return true;
        }
    }

    class SourceLocator
    implements Command {
        SourceLocator() {
        }

        public boolean compute(String name, SectionManager manager) {
            URL url = this.getClass().getResource("/lib/" + name + ".tex");
            if (url != null) {
                manager.put(new Key(name, Source.class), new UrlSource(url));
                return true;
            }
            File file = new File(name);
            if (file.exists()) {
                manager.put(new Key(name, Source.class), new FileSource(file));
                return true;
            }
            return false;
        }
    }
}

