/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.czt.java_cup.runtime.Scanner;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.parser.util.LatexMarkupFunction;
import net.sourceforge.czt.parser.util.LatexMarkupFunctionVisitor;
import net.sourceforge.czt.parser.util.MarkupException;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.Key;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.util.CztLogger;
import net.sourceforge.czt.z.ast.Directive;
import net.sourceforge.czt.z.ast.DirectiveType;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.impl.ZFactoryImpl;
import net.sourceforge.czt.z.util.ZChar;

public class LatexMarkupParser
implements Scanner {
    private static ZFactory factory_ = new ZFactoryImpl();
    private LatexScanner scanner_;
    private SectionInfo sectInfo_;
    private LatexMarkupFunction markupFunction_ = null;
    private Map markupFunctions_ = new HashMap();
    private boolean sectHead_ = false;
    private String sectName_ = null;
    private String parents_ = null;
    private Symbol symbol_ = null;
    private String source_ = null;

    public LatexMarkupParser(LatexScanner scanner, SectionInfo sectInfo) {
        this.scanner_ = scanner;
        this.sectInfo_ = sectInfo;
    }

    public String getSource() {
        return this.source_;
    }

    public void setSource(String source) {
        this.source_ = source;
    }

    private void addMarkupFunction(String parent) throws MarkupException {
        LatexMarkupFunction markupFunction;
        if (this.markupFunction_ == null) {
            this.markupFunction_ = new LatexMarkupFunction(this.sectName_);
            this.markupFunctions_.put(this.sectName_, this.markupFunction_);
            this.scanner_.setMarkupFunction(this.markupFunction_);
        }
        if ((markupFunction = (LatexMarkupFunction)this.markupFunctions_.get(parent)) == null) {
            try {
                markupFunction = (LatexMarkupFunction)this.sectInfo_.get(new Key(parent, LatexMarkupFunction.class));
            }
            catch (CommandException exception) {
                String message = "Cannot get LatexMarkupFunction for " + parent + "; try to continue anyway";
                CztLogger.getLogger(LatexMarkupFunctionVisitor.class).warning(message);
            }
        }
        if (markupFunction != null) {
            this.markupFunction_.add(markupFunction);
        }
    }

    public Symbol next_token() throws Exception {
        boolean isStartOfAnonymousSpec;
        Symbol token = this.scanner_.next_token();
        boolean bl = isStartOfAnonymousSpec = this.sectName_ == null && (token.sym == 3 || token.sym == 4 || token.sym == 31 || token.sym == 32 || token.sym == 33 || token.sym == 2);
        if (isStartOfAnonymousSpec) {
            this.sectName_ = "Specification";
            this.parents_ = "standard_toolkit";
            this.addMarkupFunction("prelude");
            this.addMarkupFunction(this.parents_);
        }
        if (token.sym == 0) {
            this.updateLatexMarkupFunction();
        }
        if (this.sectHead_) {
            if (token.sym == 6) {
                this.sectName_ = this.sectName_.trim();
                this.markupFunction_ = new LatexMarkupFunction(this.sectName_);
                this.markupFunctions_.put(this.sectName_, this.markupFunction_);
                this.scanner_.setMarkupFunction(this.markupFunction_);
                if (!this.sectName_.equals("prelude")) {
                    this.addMarkupFunction("prelude");
                }
                if (this.parents_ != null) {
                    String[] parents = this.parents_.split(",");
                    for (int i = 0; i < parents.length; ++i) {
                        String parent = parents[i].trim();
                        if (parent == null || parent.equals("")) continue;
                        this.addMarkupFunction(parent);
                    }
                }
                this.sectHead_ = false;
            } else if (token.sym == 7) {
                this.sectName_ = "";
            } else if (token.sym == 8) {
                this.parents_ = "";
            } else if (this.parents_ != null) {
                this.parents_ = this.parents_ + token.value;
            } else if (this.sectName_ != null) {
                this.sectName_ = this.sectName_ + token.value;
            } else {
                System.err.println("Unexpected token '" + token.value + "' within a section header.");
            }
        } else if (token.sym == 5) {
            this.updateLatexMarkupFunction();
            this.sectHead_ = true;
            this.parents_ = null;
            this.sectName_ = null;
        } else {
            if (token.sym == 3) {
                Directive directive = LatexMarkupParser.parseCharMarkupDirective((String)token.value, token.left);
                if (directive != null) {
                    this.markupFunction_.add(directive);
                }
                return this.next_token();
            }
            if (token.sym == 4) {
                this.parseWordMarkup(DirectiveType.NONE, token.left);
            } else if (token.sym == 31) {
                this.parseWordMarkup(DirectiveType.IN, token.left);
            } else if (token.sym == 32) {
                this.parseWordMarkup(DirectiveType.PRE, token.left);
            } else if (token.sym == 33) {
                this.parseWordMarkup(DirectiveType.POST, token.left);
            }
        }
        this.check(this.symbol_, token);
        if (token != null && token.value != null) {
            this.symbol_ = token;
        }
        return token;
    }

    private void updateLatexMarkupFunction() {
        if (this.markupFunction_ != null) {
            Key key = new Key(this.markupFunction_.getSection(), LatexMarkupFunction.class);
            this.sectInfo_.put(key, this.markupFunction_, null);
        }
    }

    private void check(Symbol t1, Symbol t2) {
        String message = "WARNING: Possible missing hard space at line " + t2.left + " column " + t2.right + " in " + this.source_;
        if (t1 != null && t2 != null && t1.sym == 2 && t2.sym == 2) {
            String s1 = (String)t1.value;
            String s2 = (String)t2.value;
            if (s1 != null && s1.length() > 0 && s2 != null && s2.length() > 0) {
                boolean cond;
                ZChar[] zchars1 = ZChar.toZChars((String)s1);
                ZChar[] zchars2 = ZChar.toZChars((String)s2);
                ZChar c1 = zchars1[zchars1.length - 1];
                ZChar c2 = zchars2[0];
                boolean c1IsLetterOrDigit = ZChar.isDigit((ZChar)c1) || ZChar.isLetter((ZChar)c1);
                boolean c2IsLetterOrDigit = ZChar.isDigit((ZChar)c2) || ZChar.isLetter((ZChar)c2);
                boolean c1IsDeltaOrXi = ZChar.DELTA.equals((Object)c1) || ZChar.XI.equals((Object)c1);
                boolean bl = cond = c1IsLetterOrDigit && c2IsLetterOrDigit && !c1IsDeltaOrXi;
                if (cond) {
                    System.err.println(message);
                }
            }
        }
    }

    private void parseWordMarkup(DirectiveType type, int line) throws Exception {
        String name = this.parseName();
        String latex = this.parseUnicode();
        Directive directive = factory_.createDirective(name, latex, type);
        directive.getAnns().add((Object)factory_.createLocAnn(null, new Integer(line), null));
        this.markupFunction_.add(directive);
    }

    private String parseName() throws Exception {
        Symbol token = this.scanner_.next_token();
        if (token.sym == 34) {
            return (String)token.value;
        }
        System.err.println("Error while parsing markup directive.");
        return null;
    }

    private String parseUnicode() throws Exception {
        String result = "";
        Symbol token = this.scanner_.next_token();
        while (token.sym != 35 && token.sym != 0) {
            result = result + token.value;
            token = this.scanner_.next_token();
        }
        return result;
    }

    public static Directive parseCharMarkupDirective(String directive, int line) {
        String[] splitted = directive.split("[ \t]+");
        int expectedLength = 3;
        if (splitted.length == 3) {
            DirectiveType type = DirectiveType.NONE;
            String name = splitted[1];
            if ("%%Zprechar".equals(splitted[0])) {
                type = DirectiveType.PRE;
            } else if ("%%Zpostchar".equals(splitted[0])) {
                type = DirectiveType.POST;
            } else if ("%%Zinchar".equals(splitted[0])) {
                type = DirectiveType.IN;
            }
            if (splitted[2].startsWith("U+")) {
                int beginString = 2;
                int endString = 6;
                String hexValue = splitted[2].substring(2, 6);
                int hexBase = 16;
                int decimal = Integer.parseInt(hexValue, 16);
                char[] chars = Character.toChars(decimal);
                String unicode = new String(chars);
                Directive d = factory_.createDirective(name, unicode, type);
                d.getAnns().add((Object)factory_.createLocAnn(null, new Integer(line), null));
                return d;
            }
            if (splitted[2].startsWith("U-")) {
                int beginString = 2;
                int endString = 10;
                String hexValue = splitted[2].substring(2, 10);
                int hexBase = 16;
                int decimal = Integer.parseInt(hexValue, 16);
                char[] chars = Character.toChars(decimal);
                String unicode = new String(chars);
                Directive d = factory_.createDirective(name, unicode, type);
                d.getAnns().add((Object)factory_.createLocAnn(null, new Integer(line), null));
                return d;
            }
            System.err.println("WARNING: Cannot parse " + directive);
            return null;
        }
        System.err.println("WARNING: Cannot parse " + directive);
        return null;
    }

    public static interface LatexScanner
    extends Scanner {
        public void setMarkupFunction(LatexMarkupFunction var1);
    }
}

