/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.ArrayList;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.visitor.ListTermVisitor;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.parser.util.AbstractVisitor;
import net.sourceforge.czt.parser.util.JokerTable;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Parent;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.visitor.ParaVisitor;
import net.sourceforge.czt.z.visitor.ZSectVisitor;
import net.sourceforge.czt.zpatt.ast.Jokers;
import net.sourceforge.czt.zpatt.visitor.JokersVisitor;

public class JokerTableVisitor
extends AbstractVisitor
implements TermVisitor,
ListTermVisitor,
JokersVisitor,
ParaVisitor,
ZSectVisitor {
    private JokerTable table_;

    public JokerTableVisitor(SectionInfo sectInfo) {
        super(sectInfo);
    }

    public Class getInfoType() {
        return JokerTable.class;
    }

    public Object run(Term term) throws CommandException {
        super.run(term);
        return this.getJokerTable();
    }

    protected JokerTable getJokerTable() {
        return this.table_;
    }

    public Object visitTerm(Term term) {
        String message = "JokerTables can only be build for ZSects; was tried for " + term.getClass();
        throw new UnsupportedOperationException(message);
    }

    public Object visitListTerm(ListTerm listTerm) {
        for (Object o : listTerm) {
            if (!(o instanceof Term)) continue;
            Term t = (Term)o;
            this.visit(t);
        }
        return null;
    }

    public Object visitJokers(Jokers jokers) {
        try {
            this.table_.add(jokers);
        }
        catch (JokerTable.JokerException e) {
            throw new CztException((Throwable)e);
        }
        return null;
    }

    public Object visitPara(Para para) {
        return null;
    }

    public Object visitZSect(ZSect zSect) {
        String name = zSect.getName();
        ArrayList<JokerTable> parentTables = new ArrayList<JokerTable>();
        for (Parent parent : zSect.getParent()) {
            JokerTable parentTable = (JokerTable)this.get(parent.getWord(), JokerTable.class);
            if (parentTable == null) continue;
            parentTables.add(parentTable);
        }
        try {
            this.table_ = new JokerTable(name, parentTables);
        }
        catch (JokerTable.JokerException e) {
            throw new CztException((Throwable)e);
        }
        this.visit((Term)zSect.getPara());
        return null;
    }

    protected void visit(Term term) {
        term.accept((Visitor)this);
    }
}

