/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.czt.java_cup.runtime.Scanner;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.util.CztException;

public final class DebugUtils {
    private DebugUtils() {
    }

    public static Map getFieldMap(Class aClass) {
        HashMap<Object, String> result = new HashMap<Object, String>();
        Field[] fields = aClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            try {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                result.put(field.get(null), field.getName());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new CztException((Throwable)e);
            }
        }
        return result;
    }

    public static void scan(Scanner scanner, Class cupSymbolTable) throws Exception {
        Map symbols = DebugUtils.getFieldMap(cupSymbolTable);
        Symbol symbol = null;
        while (true) {
            symbol = scanner.next_token();
            if (symbol.sym == 0) break;
            String symbolName = (String)symbols.get(new Integer(symbol.sym));
            String result = "Token " + symbolName;
            result = result + " at line " + symbol.left + " column " + symbol.right;
            if (symbol.value != null) {
                String value = symbol.value.toString();
                result = result + " with value '";
                int maxLength = 20;
                result = value.length() <= 20 ? result + value + "'" : result + value.substring(0, 20) + "...'";
            }
            System.out.println(result);
        }
    }
}

