/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.oz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.oz.jaxb.JaxbValidator;
import net.sourceforge.czt.parser.oz.AstTree;
import net.sourceforge.czt.parser.oz.JTreeVisitor;
import net.sourceforge.czt.parser.oz.ParseUtils;
import net.sourceforge.czt.parser.oz.TermModel;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Spec;

public class Main
extends JPanel
implements ActionListener {
    private static final int WIDTH = 700;
    private static final int HEIGHT = 600;
    private Spec spec_ = null;

    public Main() {
        super(new BorderLayout());
    }

    public TermModel getAst(String file) {
        try {
            Term o = ParseUtils.parseLatexFile(file, new SectionManager());
            if (o instanceof Spec) {
                Spec newSpec = (Spec)o;
                JaxbValidator validator = new JaxbValidator();
                validator.validate((Term)newSpec);
                if (this.spec_ == null) {
                    this.spec_ = newSpec;
                } else {
                    this.spec_.getSect().addAll((Collection)newSpec.getSect());
                }
                JTreeVisitor visitor = new JTreeVisitor();
                return (TermModel)this.spec_.accept((Visitor)visitor);
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private void openAndAdd(String file) {
        AstTree tree = new AstTree(this.getAst(file));
        JScrollPane scrollPane = new JScrollPane(tree);
        scrollPane.setPreferredSize(new Dimension(700, 600));
        this.add((Component)scrollPane, "Center");
    }

    private static void createAndShowGUI(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("Ast");
        frame.setDefaultCloseOperation(3);
        Main newContentPane = new Main();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        for (int i = 0; i < args.length; ++i) {
            newContentPane.openAndAdd(args[i]);
        }
        frame.pack();
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.createAndShowGUI(args);
            }
        });
    }
}

