/*
 * Decompiled with CFR 0.152.
 */
package circparser.util;

import circparser.exception.CircusParserException;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.util.Factory;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefName;

public class CircusParserUtil {
    private static Factory fCF = new Factory();

    public static Pred pred(TermA t) throws CircusParserException {
        Pred result = null;
        if (t != null) {
            if (t instanceof Pred) {
                result = (Pred)t;
            } else if (t instanceof Expr) {
                result = fCF.createExprPred((Expr)t);
                LocAnn locAnn = (LocAnn)t.getAnn(LocAnn.class);
                if (locAnn != null) {
                    result.getAnns().add((Object)locAnn);
                }
            } else {
                throw new CircusParserException("Cannot convert term (class: " + t.getClass() + " into a predicate");
            }
        }
        return result;
    }

    public static Expr expr(TermA t) throws CircusParserException {
        Expr result = null;
        if (t != null) {
            if (t instanceof Expr) {
                result = (Expr)t;
            } else if (t instanceof ExprPred) {
                result = ((ExprPred)t).getExpr();
            } else {
                if (t instanceof Pred) {
                    throw new CircusParserException("Expression expected but a predicate has been found, class: " + t.getClass() + ", t = " + t.toString());
                }
                throw new CircusParserException("Expression term expected, " + t.getClass() + " received instead");
            }
        }
        return result;
    }

    public static DeclName createDeclName(String str) {
        return fCF.createDeclName(str.toString());
    }

    public static RefName createRefName(String str) {
        return fCF.createRefName(CircusParserUtil.createDeclName(str));
    }
}

