/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.z.util;

public class ZChar {
    private final int ASCII = 256;
    private int codePoint_;
    public static ZChar DELTA = new ZChar(916);
    public static ZChar XI = new ZChar(926);
    public static ZChar THETA = new ZChar(952);
    public static ZChar LAMBDA = new ZChar(955);
    public static ZChar MU = new ZChar(956);
    public static ZChar ARITHMOS = new ZChar(120120);
    public static ZChar NAT = new ZChar(8469);
    public static ZChar POWER = new ZChar(8473);
    public static ZChar PRIME = new ZChar(8242);
    public static ZChar OUTSTROKE = new ZChar(33);
    public static ZChar INSTROKE = new ZChar(63);
    public static ZChar NE = new ZChar(8599);
    public static ZChar SW = new ZChar(8601);
    public static ZChar SE = new ZChar(8600);
    public static ZChar NW = new ZChar(8598);
    public static ZChar LL = new ZChar(95);
    public static ZChar LPAREN = new ZChar(40);
    public static ZChar RPAREN = new ZChar(41);
    public static ZChar LSQUARE = new ZChar(91);
    public static ZChar RSQUARE = new ZChar(93);
    public static ZChar LBRACE = new ZChar(123);
    public static ZChar RBRACE = new ZChar(125);
    public static ZChar LBIND = new ZChar(10633);
    public static ZChar RBIND = new ZChar(10634);
    public static ZChar LDATA = new ZChar(10218);
    public static ZChar RDATA = new ZChar(10219);
    public static ZChar ZEDCHAR = new ZChar(9472);
    public static ZChar AXCHAR = new ZChar(9591);
    public static ZChar SCHCHAR = new ZChar(9484);
    public static ZChar GENCHAR = new ZChar(9552);
    public static ZChar ENDCHAR = new ZChar(8233);
    public static ZChar NLCHAR = new ZChar(8232);
    public static ZChar SPACE = new ZChar(32);
    public static ZChar VL = new ZChar(124);
    public static ZChar AMP = new ZChar(38);
    public static ZChar VDASH = new ZChar(8866);
    public static ZChar AND = new ZChar(8743);
    public static ZChar OR = new ZChar(8744);
    public static ZChar IMP = new ZChar(8658);
    public static ZChar IFF = new ZChar(8660);
    public static ZChar NOT = new ZChar(172);
    public static ZChar ALL = new ZChar(8704);
    public static ZChar EXI = new ZChar(8707);
    public static ZChar CROSS = new ZChar(215);
    public static ZChar SOLIDUS = new ZChar(47);
    public static ZChar EQUALS = new ZChar(61);
    public static ZChar MEM = new ZChar(8712);
    public static ZChar COLON = new ZChar(58);
    public static ZChar SEMICOLON = new ZChar(59);
    public static ZChar COMMA = new ZChar(44);
    public static ZChar DOT = new ZChar(46);
    public static ZChar SPOT = new ZChar(10625);
    public static ZChar ZHIDE = new ZChar(10745);
    public static ZChar ZPROJ = new ZChar(10785);
    public static ZChar ZCOMP = new ZChar(10783);
    public static ZChar ZPIPE = new ZChar(10784);
    public static ZChar PLUS = new ZChar(43);
    public static ZChar TYPECOLON = new ZChar(10626);
    public static ZChar REL = new ZChar(8596);
    public static ZChar FUN = new ZChar(8594);
    public static ZChar NEQ = new ZChar(8800);
    public static ZChar NOTMEM = new ZChar(8713);
    public static ZChar EMPTYSET = new ZChar(8709);
    public static ZChar SUBSETEQ = new ZChar(8838);
    public static ZChar SUBSET = new ZChar(8834);
    public static ZChar CUP = new ZChar(8746);
    public static ZChar CAP = new ZChar(8745);
    public static ZChar SETMINUS = new ZChar(92);
    public static ZChar SYMDIFF = new ZChar(8854);
    public static ZChar BIGCUP = new ZChar(8899);
    public static ZChar BIGCAP = new ZChar(8898);
    public static ZChar FINSET = new ZChar(120125);
    public static ZChar MAPSTO = new ZChar(8614);
    public static ZChar COMP = new ZChar(10814);
    public static ZChar CIRC = new ZChar(8728);
    public static ZChar DRES = new ZChar(9665);
    public static ZChar RRES = new ZChar(9655);
    public static ZChar NDRES = new ZChar(10852);
    public static ZChar NRRES = new ZChar(10853);
    public static ZChar TILDE = new ZChar(8764);
    public static ZChar LIMG = new ZChar(10631);
    public static ZChar RIMG = new ZChar(10632);
    public static ZChar OPLUS = new ZChar(8853);
    public static ZChar PFUN = new ZChar(8696);
    public static ZChar PINJ = new ZChar(10516);
    public static ZChar INJ = new ZChar(8611);
    public static ZChar PSURJ = new ZChar(10496);
    public static ZChar SURJ = new ZChar(8608);
    public static ZChar BIJ = new ZChar(10518);
    public static ZChar FFUN = new ZChar(8699);
    public static ZChar FINJ = new ZChar(10517);
    public static ZChar NUM = new ZChar(8484);
    public static ZChar NEG = new ZChar(45);
    public static ZChar MINUS = new ZChar(8722);
    public static ZChar LEQ = new ZChar(8804);
    public static ZChar LESS = new ZChar(60);
    public static ZChar GEQ = new ZChar(8805);
    public static ZChar GREATER = new ZChar(62);
    public static ZChar MULT = new ZChar(42);
    public static ZChar NUMBER = new ZChar(35);
    public static ZChar LANGLE = new ZChar(10216);
    public static ZChar RANGLE = new ZChar(10217);
    public static ZChar CAT = new ZChar(8256);
    public static ZChar EXTRACT = new ZChar(8639);
    public static ZChar FILTER = new ZChar(8638);

    public ZChar(char c) {
        if (Character.isHighSurrogate(c)) {
            throw new IllegalArgumentException();
        }
        this.codePoint_ = c;
    }

    public ZChar(int codePoint) {
        if (!Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException();
        }
        this.codePoint_ = codePoint;
    }

    private ZChar(char high, char low) {
        if (!Character.isSurrogatePair(high, low)) {
            throw new IllegalArgumentException();
        }
        char[] chars = new char[]{high, low};
        this.codePoint_ = Character.codePointAt(chars, 0);
    }

    public ZChar(char[] chars) {
        this.codePoint_ = Character.codePointAt(chars, 0);
    }

    public int codePoint() {
        return this.codePoint_;
    }

    public int charCount() {
        return Character.charCount(this.codePoint_);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().equals(obj.getClass())) {
            ZChar zchar = (ZChar)obj;
            return this.codePoint_ == zchar.codePoint_;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(Character.toChars(this.codePoint_));
    }

    public static ZChar[] toZChars(String string) {
        int numZChars = string.codePointCount(0, string.length());
        ZChar[] result = new ZChar[numZChars];
        int index = 0;
        for (int i = 0; i < numZChars; ++i) {
            int codePoint = string.codePointAt(index);
            result[i] = new ZChar(codePoint);
            index += result[i].charCount();
        }
        return result;
    }

    public boolean isAsciiChar() {
        return this.codePoint_ < 256;
    }

    public static boolean isAlpha(ZChar zchar) {
        return ZChar.isLetter(zchar) || ZChar.isDigit(zchar);
    }

    public static boolean isDigit(ZChar zchar) {
        return Character.isDigit(zchar.codePoint());
    }

    public static boolean isLetter(ZChar zchar) {
        return Character.isLetter(zchar.codePoint());
    }

    public static boolean isStroke(ZChar zchar) {
        return zchar.equals(INSTROKE) || zchar.equals(OUTSTROKE) || zchar.equals(PRIME);
    }

    public static boolean isWordGlue(ZChar zchar) {
        boolean isSE = zchar.equals(SE);
        boolean isSW = zchar.equals(SW);
        boolean isNE = zchar.equals(NE);
        boolean isNW = zchar.equals(NW);
        boolean isLL = zchar.equals(LL);
        return isSE || isSW || isNE || isNW || isLL;
    }
}

