/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.base.visitor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.util.Visitor;

public final class VisitorUtils {
    private VisitorUtils() {
    }

    private static String getClassName() {
        return "VisitorUtils";
    }

    private static Logger getLogger() {
        return Logger.getLogger("net.sourceforge.czt.base.util." + VisitorUtils.getClassName());
    }

    public static void visitList(Visitor visitor, List list) {
        Object[] arguments = new Object[]{visitor, list};
        VisitorUtils.getLogger().entering(VisitorUtils.getClassName(), "visitList", arguments);
        for (Object object : list) {
            if (!(object instanceof Term)) continue;
            ((Term)object).accept(visitor);
        }
    }

    public static List getVisitList(Visitor visitor, List list) {
        Object[] arguments = new Object[]{visitor, list};
        VisitorUtils.getLogger().entering(VisitorUtils.getClassName(), "getVisitList", arguments);
        boolean changed = false;
        Vector<Object> newList = new Vector<Object>(list.size());
        for (Object oldObject : list) {
            if (oldObject == null) {
                throw new NullPointerException();
            }
            if (oldObject instanceof Term) {
                Object newObject = ((Term)oldObject).accept(visitor);
                if (oldObject != newObject) {
                    changed = true;
                }
                if (newObject == null) {
                    throw new NullPointerException();
                }
                newList.add(newObject);
                continue;
            }
            newList.add(oldObject);
        }
        if (changed) {
            VisitorUtils.getLogger().fine("List has changed.");
            VisitorUtils.getLogger().exiting(VisitorUtils.getClassName(), "getVisitList", list);
            return newList;
        }
        VisitorUtils.getLogger().exiting(VisitorUtils.getClassName(), "getVisitList", newList);
        return list;
    }

    public static void visitArray(Visitor visitor, Object[] array) {
        Object[] arguments = new Object[]{visitor, array};
        VisitorUtils.getLogger().entering(VisitorUtils.getClassName(), "visitArray", arguments);
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            if (!(object instanceof Term)) continue;
            ((Term)object).accept(visitor);
        }
    }

    public static Object visitTerm(Visitor visitor, Term term, boolean share) {
        Object[] arguments = new Object[]{visitor, term, share};
        VisitorUtils.getLogger().entering(VisitorUtils.getClassName(), "visitTerm", arguments);
        boolean changed = false;
        Object[] args = term.getChildren();
        for (int i = 0; i < args.length; ++i) {
            Object object;
            if (!(args[i] instanceof Term) || (object = ((Term)args[i]).accept(visitor)) == args[i]) continue;
            args[i] = object;
            changed = true;
        }
        if (!changed && share) {
            VisitorUtils.getLogger().exiting(VisitorUtils.getClassName(), "visitTerm", term);
            return term;
        }
        VisitorUtils.getLogger().fine("Term has changed.");
        Term newTerm = term.create(args);
        VisitorUtils.getLogger().exiting(VisitorUtils.getClassName(), "visitTerm", newTerm);
        return newTerm;
    }

    public static void visitTerm(Visitor visitor, Term term) {
        Object[] arguments = new Object[]{visitor, term};
        VisitorUtils.getLogger().entering(VisitorUtils.getClassName(), "visitTerm", arguments);
        Object[] args = term.getChildren();
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Term)) continue;
            ((Term)args[i]).accept(visitor);
        }
    }

    public static void checkVisitorRules(Visitor visitor) {
        Class<?> visitorClass = visitor.getClass();
        Method[] methods = visitorClass.getDeclaredMethods();
        Class<?>[] interfaces = visitorClass.getInterfaces();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!methodName.startsWith("visit")) continue;
            String interfaceName = methodName.substring(5) + "Visitor";
            boolean found = false;
            for (int j = 0; j < interfaces.length && !found; ++j) {
                found = interfaces[j].getName().endsWith(interfaceName);
            }
            if (found) continue;
            System.err.println("Warning: class " + visitorClass.getName() + " should implement interface " + interfaceName + ".");
        }
    }
}

