/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.typecheck.z.impl.Factory;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.TypeAnn;
import net.sourceforge.czt.z.ast.TypeEnvAnn;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.impl.ZFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeEnv {
    protected Factory factory_;
    protected Stack<List<NameTypePair>> typeInfo_;
    protected Stack<List<DeclName>> parameters_;

    public TypeEnv() {
        this((ZFactory)new ZFactoryImpl());
    }

    public TypeEnv(ZFactory zFactory) {
        this.factory_ = new Factory(zFactory);
        this.typeInfo_ = new Stack();
        this.parameters_ = new Stack();
    }

    public void enterScope() {
        ArrayList info = new ArrayList();
        this.typeInfo_.push(info);
        ArrayList parameters = new ArrayList();
        this.parameters_.push(parameters);
    }

    public void exitScope() {
        this.typeInfo_.pop();
        this.parameters_.pop();
    }

    public TypeEnvAnn getTypeEnvAnn() {
        List<NameTypePair> pairs = this.getNameTypePairs();
        return this.factory_.createTypeEnvAnn(pairs);
    }

    public void addParameters(List<DeclName> parameters) {
        this.parameters_.peek().addAll(parameters);
    }

    public List<DeclName> getParameters() {
        ArrayList<DeclName> result = new ArrayList<DeclName>();
        result.addAll((Collection)this.parameters_.peek());
        return result;
    }

    public void add(DeclName declName, Type type) {
        NameTypePair pair = this.factory_.createNameTypePair(declName, type);
        this.add(pair);
    }

    public void override(DeclName declName, Type type) {
        for (NameTypePair pair : this.typeInfo_.peek()) {
            if (!GlobalDefs.namesEqual((Name)declName, (Name)pair.getName())) continue;
            pair.setType(type);
            return;
        }
        this.add(declName, type);
    }

    public void add(NameTypePair pair) {
        this.typeInfo_.peek().add(pair);
    }

    public void add(List<NameTypePair> pairs) {
        for (NameTypePair pair : pairs) {
            this.add(pair);
        }
    }

    public Type getType(RefName name) {
        UnknownType result = this.factory_.createUnknownType();
        NameTypePair pair = this.getPair((Name)name);
        if (pair != null) {
            result = pair.getType();
            name.setDecl(pair.getName());
        }
        return result;
    }

    public List<NameTypePair> getNameTypePair() {
        return this.typeInfo_.peek();
    }

    public Type getTypeFromAnns(TermA termA) {
        UnknownType result = this.factory_.createUnknownType();
        ListTerm anns = termA.getAnns();
        for (Object next : anns) {
            if (!(next instanceof TypeAnn)) continue;
            result = ((TypeAnn)next).getType();
            break;
        }
        return result;
    }

    protected List<NameTypePair> getNameTypePairs() {
        ArrayList<NameTypePair> result = new ArrayList<NameTypePair>();
        for (List list : this.typeInfo_) {
            for (NameTypePair pair : list) {
                NameTypePair existing = this.findNameTypePair(pair.getName(), result);
                if (existing != null) continue;
                result.add(pair);
            }
        }
        return result;
    }

    protected NameTypePair findNameTypePair(DeclName declName, List<NameTypePair> pairs) {
        NameTypePair result = null;
        for (NameTypePair pair : pairs) {
            if (!pair.getName().equals(declName)) continue;
            result = pair;
            break;
        }
        return result;
    }

    protected NameTypePair getPair(Name name) {
        NameTypePair result = null;
        for (List list : this.typeInfo_) {
            for (NameTypePair pair : list) {
                if (!pair.getName().getWord().equals(name.getWord()) || !pair.getName().getStroke().equals(name.getStroke())) continue;
                result = pair;
            }
        }
        return result;
    }
}

