/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.typecheck.z.impl.Factory;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.GenericType;
import net.sourceforge.czt.z.ast.Name;
import net.sourceforge.czt.z.ast.NameSectTypeTriple;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.SectTypeEnvAnn;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.impl.ZFactoryImpl;
import net.sourceforge.czt.z.util.ZString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectTypeEnv {
    public static final String PRELUDE = "prelude";
    public static final String[] TOOLKITS = new String[]{"prelude", "set_toolkit", "relation_toolkit", "function_toolkit", "sequence_toolkit", "number_toolkit", "standard_toolkit"};
    protected static Factory factory_;
    protected List<NameSectTypeTriple> typeInfo_;
    protected List<DeclName> declarations_;
    protected List<String> sectionDeclarations_;
    protected String section_ = null;
    protected boolean secondTime_ = false;
    protected Set<String> visibleSections_;
    protected Set<String> checkedSections_;
    protected Map<String, Set<String>> parents_;

    public SectTypeEnv() {
        this((ZFactory)new ZFactoryImpl());
    }

    public SectTypeEnv(ZFactory zFactory) {
        factory_ = new Factory(zFactory);
        this.typeInfo_ = new ArrayList<NameSectTypeTriple>();
        this.declarations_ = new ArrayList<DeclName>();
        this.sectionDeclarations_ = new ArrayList<String>();
        this.visibleSections_ = new HashSet<String>();
        this.checkedSections_ = new HashSet<String>();
        this.parents_ = new HashMap<String, Set<String>>();
    }

    public void setSection(String section) {
        if (!this.visibleSections_.contains(section)) {
            this.visibleSections_.add(section);
        }
        if (!this.checkedSections_.contains(section)) {
            this.checkedSections_.add(section);
        }
        this.section_ = section;
    }

    public void setSecondTime(boolean secondTime) {
        this.secondTime_ = secondTime;
    }

    public boolean getSecondTime() {
        return this.secondTime_;
    }

    public Factory getFactory() {
        return factory_;
    }

    public boolean isChecked(String section) {
        boolean result = this.checkedSections_.contains(section);
        if (this.secondTime_) {
            result = this.sectionDeclarations_.contains(section);
            this.sectionDeclarations_.add(section);
        }
        return result;
    }

    public String getSection() {
        return this.section_;
    }

    public Set<String> getVisibleSections() {
        return this.visibleSections_;
    }

    public void endSection() {
        this.visibleSections_.clear();
        this.section_ = null;
    }

    public void addParent(String parent) {
        this.visibleSections_.add(parent);
        Set<String> parents = this.parents_.get(this.section_);
        if (parents == null) {
            parents = new HashSet<String>();
        }
        parents.add(parent);
        this.parents_.put(this.section_, parents);
        this.visibleSections_.addAll(this.getTransitiveParents(parent));
    }

    public boolean add(NameSectTypeTriple triple) {
        boolean result = true;
        NameSectTypeTriple existing = this.getTriple((Name)triple.getName());
        if (existing == null) {
            this.typeInfo_.add(triple);
            result = true;
        } else {
            existing.setType(triple.getType());
        }
        if (this.secondTime_) {
            result = !this.declarations_.contains(triple.getName());
            this.declarations_.add(triple.getName());
        }
        return result;
    }

    public boolean add(NameTypePair nameTypePair) {
        return this.add(nameTypePair.getName(), nameTypePair.getType());
    }

    public boolean add(DeclName declName, Type type) {
        boolean result = true;
        for (NameSectTypeTriple triple : this.typeInfo_) {
            if (!triple.getName().equals(declName)) continue;
            triple.setType(type);
            result = false;
        }
        if (result) {
            NameSectTypeTriple insert = factory_.createNameSectTypeTriple(declName, this.section_, type);
            this.typeInfo_.add(insert);
        }
        if (this.secondTime_) {
            result = !this.declarations_.contains(declName);
            this.declarations_.add(declName);
        }
        return result;
    }

    public boolean update(RefName refName, Type type) {
        NameSectTypeTriple triple = this.getTriple((Name)refName);
        if (triple != null) {
            triple.setType(type);
        } else {
            DeclName declName = factory_.createDeclName(refName.getWord(), (List)refName.getStroke(), null);
            NameSectTypeTriple insert = factory_.createNameSectTypeTriple(declName, this.section_, type);
            this.typeInfo_.add(insert);
        }
        return true;
    }

    public List<NameSectTypeTriple> getNameSectTypeTriple() {
        ArrayList<NameSectTypeTriple> triples = new ArrayList<NameSectTypeTriple>();
        for (NameSectTypeTriple triple : this.typeInfo_) {
            if (!this.visibleSections_.contains(this.section_) && !triple.getSect().equals(PRELUDE)) continue;
            triples.add(triple);
        }
        return triples;
    }

    public SectTypeEnvAnn getSectTypeEnvAnn() {
        List<NameSectTypeTriple> triples = this.getNameSectTypeTriple();
        return factory_.createSectTypeEnvAnn(triples);
    }

    public Type getType(RefName name) {
        DeclName declName = factory_.createDeclName(name);
        UnknownType result = factory_.createUnknownType();
        NameSectTypeTriple triple = this.getTriple((Name)name);
        if (triple != null && this.visibleSections_.contains(triple.getSect())) {
            result = triple.getType();
            name.setDecl(triple.getName());
        }
        if (result instanceof UnknownType && (name.getWord().startsWith(ZString.DELTA) || name.getWord().startsWith(ZString.XI))) {
            int size = ZString.DELTA.length();
            String baseWord = name.getWord().substring(size);
            RefName baseName = factory_.createRefName(baseWord, (List)name.getStroke(), null);
            Type baseType = this.getType(baseName);
            if (this.isSchema(baseType)) {
                PowerType powerType = (PowerType)SectTypeEnv.unwrapType(baseType);
                SchemaType schemaType = (SchemaType)powerType.getType();
                Signature signature = schemaType.getSignature();
                ListTerm pairs = signature.getNameTypePair();
                ArrayList<NameTypePair> newPairs = new ArrayList<NameTypePair>((Collection<NameTypePair>)pairs);
                for (NameTypePair pair : pairs) {
                    DeclName primedName = factory_.createDeclName(pair.getName());
                    primedName.getStroke().add((Object)factory_.createNextStroke());
                    NameTypePair newPair = factory_.createNameTypePair(primedName, pair.getType());
                    newPairs.add(newPair);
                }
                Signature newSignature = factory_.createSignature(newPairs);
                SchemaType newSchemaType = factory_.createSchemaType(newSignature);
                PowerType newPowerType = factory_.createPowerType((Type2)newSchemaType);
                if (baseType instanceof GenericType) {
                    GenericType gType = (GenericType)baseType;
                    result = factory_.createGenericType((List)gType.getName(), (Type2)newPowerType, null);
                } else {
                    result = newPowerType;
                }
                this.add(declName, (Type)result);
            }
        }
        return result;
    }

    protected static Type2 unwrapType(Type type) {
        Type2 result = null;
        if (type instanceof GenericType) {
            GenericType genericType = (GenericType)type;
            result = genericType.getType();
        } else {
            result = (Type2)type;
        }
        return result;
    }

    protected boolean isSchema(Type type) {
        PowerType powerType;
        boolean result = false;
        Type2 type2 = SectTypeEnv.unwrapType(type);
        if (type2 instanceof PowerType && (powerType = (PowerType)type2).getType() instanceof SchemaType) {
            result = true;
        }
        return result;
    }

    public void dump() {
        System.err.println("typeinfo:");
        for (NameSectTypeTriple next : this.typeInfo_) {
            System.err.print("\t(" + next.getName());
            System.err.print(", (" + next.getSect());
            System.err.println(", (" + next.getType() + ")))");
        }
    }

    private NameSectTypeTriple getTriple(Name name) {
        NameSectTypeTriple result = null;
        for (NameSectTypeTriple next : this.typeInfo_) {
            if (!next.getName().getWord().equals(name.getWord()) || !next.getName().getStroke().equals(name.getStroke()) || !this.visibleSections_.contains(this.section_) && !next.getSect().equals(PRELUDE)) continue;
            result = next;
            break;
        }
        return result;
    }

    private Set<String> getTransitiveParents(String section) {
        HashSet<String> result = new HashSet<String>();
        Set<String> parents = this.parents_.get(section);
        if (parents != null) {
            result.addAll(parents);
            for (String parent : parents) {
                Set<String> transitiveParents = this.getTransitiveParents(parent);
                result.addAll(transitiveParents);
            }
        }
        return result;
    }
}

