/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.visitor.CallActionVisitor;
import net.sourceforge.czt.circus.visitor.CallProcessVisitor;
import net.sourceforge.czt.circustools.ast.ActionSignature;
import net.sourceforge.czt.circustools.ast.ActionType;
import net.sourceforge.czt.circustools.ast.ProcessSignature;
import net.sourceforge.czt.circustools.ast.ProcessType;
import net.sourceforge.czt.typecheck.circus.Checker;
import net.sourceforge.czt.typecheck.circus.ErrorAnn;
import net.sourceforge.czt.typecheck.circus.ErrorMessage;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostChecker
extends Checker
implements CallProcessVisitor,
CallActionVisitor {
    protected net.sourceforge.czt.typecheck.z.PostChecker zPostChecker;

    public PostChecker(TypeChecker typeChecker) {
        super(typeChecker);
        this.zPostChecker = new net.sourceforge.czt.typecheck.z.PostChecker(typeChecker);
    }

    @Override
    public Object visitTerm(Term term) {
        return term.accept((Visitor)this.zPostChecker);
    }

    public Object visitCallProcess(CallProcess term) {
        RefName procRef = term.getRefName();
        DeclName procDecl = this.factory().createDeclName(procRef);
        ErrorAnn errorAnn = null;
        DeclName currentProc = this.processes4PostCheck().remove(0);
        List<NameTypePair> localVars = this.localVars4ProcPostCheck().remove(0);
        this.typeEnv().enterScope();
        this.typeEnv().add(localVars);
        if (!this.isProcess(procDecl)) {
            Object[] params = new Object[]{currentProc.getWord(), procDecl.getWord()};
            errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_PROCESS_NAME, params);
        } else {
            ProcessType procType = (ProcessType)this.sectTypeEnv().getType(procRef);
            ProcessSignature procSignature = procType.getProcessSignature();
            this.setCurrentProcess(currentProc);
            ListTerm paramsOrIndexes = null;
            if (procSignature.getParamsOrIndexes() != null) {
                paramsOrIndexes = procSignature.getParamsOrIndexes().getNameTypePair();
            }
            errorAnn = this.checkCallProcess(term, (List<NameTypePair>)paramsOrIndexes, errorAnn);
        }
        this.typeEnv().exitScope();
        return errorAnn;
    }

    public Object visitCallAction(CallAction term) {
        ActionSignature actionSignature = this.factory().createActionSignature();
        RefName actionRef = term.getRefName();
        DeclName actionDecl = this.factory().createDeclName(actionRef);
        ErrorAnn errorAnn = null;
        DeclName currentAct = this.actions4PostCheck().remove(0);
        List<NameTypePair> localVars = this.localVars4ActPostCheck().remove(0);
        this.typeEnv().enterScope();
        this.typeEnv().add(localVars);
        if (!this.localCircTypeEnv().isAction(actionDecl)) {
            Object[] params = new Object[]{currentAct.getWord(), this.currentProcess().getWord(), actionDecl.getWord()};
            errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_ACTION_NAME, params);
        } else {
            ActionType actionType = this.localCircTypeEnv().getActionType(actionDecl);
            actionSignature = actionType.getActionSignature();
            this.setCurrentAction(currentAct);
            ListTerm params = null;
            if (actionSignature.getParams() != null) {
                params = actionSignature.getParams().getNameTypePair();
            }
            errorAnn = this.checkCallAction(term, (List<NameTypePair>)params, errorAnn);
        }
        this.typeEnv().exitScope();
        this.setCurrentAction(null);
        return errorAnn;
    }

    private ErrorAnn checkCallProc(DeclName procName, List decs, List types) {
        ErrorAnn errorAnn = null;
        int i = 0;
        if (decs.size() == types.size()) {
            for (NameTypePair pair : decs) {
                Type2 expectedU = GlobalDefs.unwrapType(pair.getType());
                Type2 foundU = GlobalDefs.unwrapType((Type)types.get(i));
                if (foundU instanceof UnknownType) {
                    Object[] params = new Object[]{this.currentProcess().getWord(), procName.getWord(), i + 1};
                    errorAnn = this.errorAnn((TermA)procName, ErrorMessage.PARAM_PROC_CALL_UNDECLARED_VAR, params);
                    break;
                }
                if (this.unify(foundU, expectedU) != GlobalDefs.SUCC) {
                    Object[] params = new Object[]{this.currentProcess().getWord(), expectedU, foundU, i, procName.getWord()};
                    errorAnn = this.errorAnn((TermA)procName, ErrorMessage.PARAM_PROC_CALL_NOT_UNIFY, params);
                    break;
                }
                ++i;
            }
        } else {
            Object[] params = new Object[]{this.currentProcess().getWord(), decs.size(), types.size(), procName.getWord()};
            errorAnn = this.errorAnn((TermA)procName, ErrorMessage.PROC_CALL_DIFF_NUMBER_EXPRS, params);
        }
        return errorAnn;
    }

    private ErrorAnn checkCallProcess(CallProcess term, List<NameTypePair> paramsOrIndexes, ErrorAnn errorAnn) {
        DeclName procDecl = this.factory().createDeclName(term.getRefName());
        String kindOfProcess = this.getKindOfProcess(procDecl);
        ArrayList<Type> typeExprs = new ArrayList<Type>();
        ListTerm exprs = null;
        switch (term.getCallType()) {
            case Param: {
                if (!kindOfProcess.equals("PARAM")) {
                    Object[] params = new Object[]{this.currentProcess().getWord(), procDecl.getWord()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_PARAM_PROCESS_IN_PROC_CALL, params);
                    break;
                }
                exprs = term.getExpr();
                for (Expr expr : exprs) {
                    Type type = (Type)expr.accept((Visitor)this.exprChecker());
                    typeExprs.add(type);
                }
                errorAnn = this.checkCallProc(procDecl, paramsOrIndexes, typeExprs);
                break;
            }
            case Index: {
                if (!kindOfProcess.equals("INDEX")) {
                    Object[] params = new Object[]{this.currentProcess().getWord(), procDecl.getWord()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_INDEX_PROCESS_IN_PROC_CALL, params);
                    break;
                }
                exprs = term.getExpr();
                for (Expr expr : exprs) {
                    Type type = (Type)expr.accept((Visitor)this.exprChecker());
                    typeExprs.add(type);
                }
                errorAnn = this.checkCallProc(procDecl, paramsOrIndexes, typeExprs);
                break;
            }
            case Gen: {
                List<DeclName> genParams;
                if (!this.isGenericProcess(procDecl)) {
                    Object[] params = new Object[]{this.currentProcess().getWord(), procDecl.getWord()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_GEN_PROCESS_IN_PROC_CALL, params);
                    break;
                }
                exprs = term.getGenExpr();
                for (Expr expr : exprs) {
                    Type type = (Type)expr.accept((Visitor)this.exprChecker());
                    if (!(type instanceof PowerType)) {
                        Object[] params = new Object[]{this.currentProcess().getWord(), procDecl.getWord()};
                        errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_POWER_TYPE_IN_GEN_PROCESS, params);
                        break;
                    }
                    typeExprs.add(type);
                }
                if ((genParams = this.getGenParamsProcess(procDecl)).size() == typeExprs.size()) break;
                Object[] params = new Object[]{this.currentProcess().getWord(), procDecl.getWord(), genParams.size(), typeExprs.size()};
                errorAnn = this.errorAnn((TermA)term, ErrorMessage.GEN_PROCESS_INSTANTIATION_ERROR, params);
                break;
            }
            case GenParam: {
                Object[] params;
                if (!this.isGenericProcess(procDecl)) {
                    Object[] params2 = new Object[]{this.currentProcess().getWord(), procDecl.getWord()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_GEN_PROCESS_IN_PROC_CALL, params2);
                    break;
                }
                ListTerm genExprs = term.getGenExpr();
                ArrayList<Type> typeGenExprs = new ArrayList<Type>();
                for (Expr genExpr : genExprs) {
                    Type type = (Type)genExpr.accept((Visitor)this.exprChecker());
                    typeGenExprs.add(type);
                }
                List<DeclName> genParams = this.getGenParamsProcess(procDecl);
                if (genParams.size() != typeGenExprs.size()) {
                    params = new Object[]{this.currentProcess().getWord(), procDecl.getWord(), genParams.size(), typeGenExprs.size()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.GEN_PROCESS_INSTANTIATION_ERROR, params);
                }
                if (!kindOfProcess.equals("PARAM")) {
                    params = new Object[]{this.currentProcess().getWord(), procDecl.getWord()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_PARAM_PROCESS_IN_PROC_CALL, params);
                    break;
                }
                exprs = term.getExpr();
                for (Expr expr : exprs) {
                    Type type = (Type)expr.accept((Visitor)this.exprChecker());
                    typeExprs.add(type);
                }
                errorAnn = this.checkCallProc(procDecl, paramsOrIndexes, typeExprs);
                break;
            }
            case GenIndex: {
                Object[] params;
                if (!this.isGenericProcess(procDecl)) {
                    Object[] params3 = new Object[]{this.currentProcess().getWord(), procDecl.getWord()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_GEN_PROCESS_IN_PROC_CALL, params3);
                    break;
                }
                ListTerm genExprs = term.getGenExpr();
                ArrayList<Type> typeGenExprs = new ArrayList<Type>();
                for (Expr genExpr : genExprs) {
                    Type type = (Type)genExpr.accept((Visitor)this.exprChecker());
                    typeGenExprs.add(type);
                }
                List<DeclName> genParams = this.getGenParamsProcess(procDecl);
                if (genParams.size() != typeGenExprs.size()) {
                    params = new Object[]{this.currentProcess().getWord(), procDecl.getWord(), genParams.size(), typeGenExprs.size()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.GEN_PROCESS_INSTANTIATION_ERROR, params);
                }
                if (!kindOfProcess.equals("INDEX")) {
                    params = new Object[]{this.currentProcess().getWord(), procDecl.getWord()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_INDEX_PROCESS_IN_PROC_CALL, params);
                    break;
                }
                exprs = term.getExpr();
                for (Expr expr : exprs) {
                    Type type = (Type)expr.accept((Visitor)this.exprChecker());
                    typeExprs.add(type);
                }
                errorAnn = this.checkCallProc(procDecl, paramsOrIndexes, typeExprs);
                break;
            }
            case Normal: {
                if (kindOfProcess.equals("NORMAL")) break;
                Object[] params = new Object[]{this.currentProcess().getWord(), procDecl.getWord()};
                errorAnn = this.errorAnn((TermA)term, ErrorMessage.PROC_CALL_NEEDS_PARAMS, params);
            }
        }
        return errorAnn;
    }

    private ErrorAnn checkCallAction(CallAction term, List<NameTypePair> params, ErrorAnn errorAnn) {
        DeclName actionDecl = this.factory().createDeclName(term.getRefName());
        block0 : switch (term.getCallType()) {
            case Param: {
                if (!this.localCircTypeEnv().isParamAction(actionDecl)) {
                    Object[] paramsError = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionDecl.getWord()};
                    errorAnn = this.errorAnn((TermA)term, ErrorMessage.IS_NOT_PARAM_ACTION_IN_ACTION_CALL, paramsError);
                    break;
                }
                ArrayList<Type> typeExprs = new ArrayList<Type>();
                ListTerm exprs = null;
                exprs = term.getExpr();
                for (Expr expr : exprs) {
                    Type type = (Type)expr.accept((Visitor)this.exprChecker());
                    typeExprs.add(type);
                }
                int i = 0;
                if (params.size() == typeExprs.size()) {
                    for (NameTypePair pair : params) {
                        Type2 expectedU = GlobalDefs.unwrapType(pair.getType());
                        Type2 foundU = GlobalDefs.unwrapType((Type)typeExprs.get(i));
                        if (foundU instanceof UnknownType) {
                            Object[] paramsError = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionDecl.getWord(), i + 1};
                            errorAnn = this.errorAnn((TermA)actionDecl, ErrorMessage.PARAM_ACTION_CALL_UNDECLARED_VAR, paramsError);
                            break block0;
                        }
                        if (this.unify(foundU, expectedU) != GlobalDefs.SUCC) {
                            Object[] paramsError = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionDecl.getWord(), expectedU, foundU, i + 1};
                            errorAnn = this.errorAnn((TermA)actionDecl, ErrorMessage.PARAM_ACTION_CALL_NOT_UNIFY, paramsError);
                            break block0;
                        }
                        ++i;
                    }
                    break;
                }
                Object[] paramsError = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), params.size(), typeExprs.size(), actionDecl.getWord()};
                errorAnn = this.errorAnn((TermA)actionDecl, ErrorMessage.ACTION_CALL_DIFF_NUMBER_EXPRS, paramsError);
                break;
            }
            case Normal: {
                if (!this.localCircTypeEnv().isParamAction(actionDecl)) break;
                Object[] paramsError = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), actionDecl.getWord()};
                errorAnn = this.errorAnn((TermA)term, ErrorMessage.PARAM_ACTION_CALL_WITHOUT_EXPRS, paramsError);
            }
        }
        return errorAnn;
    }
}

