/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.ChannelDecl;
import net.sourceforge.czt.circus.ast.QualifiedDecl;
import net.sourceforge.czt.circus.visitor.ChannelDeclVisitor;
import net.sourceforge.czt.circus.visitor.QualifiedDeclVisitor;
import net.sourceforge.czt.typecheck.circus.Checker;
import net.sourceforge.czt.typecheck.circus.ErrorMessage;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.GivenType;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.visitor.DeclVisitor;

public class DeclChecker
extends Checker
implements ChannelDeclVisitor,
DeclVisitor,
QualifiedDeclVisitor {
    protected net.sourceforge.czt.typecheck.z.DeclChecker zDeclChecker_;

    public DeclChecker(TypeChecker typeChecker) {
        super(typeChecker);
        this.zDeclChecker_ = new net.sourceforge.czt.typecheck.z.DeclChecker(typeChecker);
    }

    public Object visitDecl(Decl decl) {
        return decl.accept((Visitor)this.zDeclChecker_);
    }

    public Object visitChannelDecl(ChannelDecl term) {
        ArrayList<NameTypePair> pairs = new ArrayList<NameTypePair>();
        ArrayList<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        VarDecl declChan = (VarDecl)term.getDecl();
        ListTerm genericParams = term.getDeclName();
        this.typeEnv().enterScope();
        this.addGenParamTypes((List<DeclName>)genericParams);
        if (declChan.getExpr() != null) {
            pairs.addAll((List)declChan.accept((Visitor)this.declChecker()));
        } else {
            DeclName name = this.factory().createDeclName("Synch", null, null);
            GivenType type = this.factory().createGivenType(name);
            ListTerm declNames = declChan.getDeclName();
            for (DeclName declName : declNames) {
                NameTypePair pair = this.factory().createNameTypePair(declName, (Type)type);
                pairs.add(pair);
            }
        }
        this.typeEnv().exitScope();
        this.setCurrentGenParams((List)genericParams);
        for (NameTypePair pair : pairs) {
            if (!genericParams.isEmpty()) {
                Object[] params;
                Type2 chanType = (Type2)pair.getType();
                boolean isGeneric = (Boolean)chanType.accept((Visitor)this.channelDeclChecker());
                if (isGeneric) {
                    if (!this.addGenChannel(pair.getName(), pair.getType(), (List<DeclName>)genericParams)) {
                        params = new Object[]{pair.getName()};
                        this.error((TermA)term, ErrorMessage.REDECLARED_CHANNEL_NAME, params);
                    }
                } else if (!this.addChannel(pair.getName(), pair.getType())) {
                    params = new Object[]{pair.getName()};
                    this.error((TermA)term, ErrorMessage.REDECLARED_CHANNEL_NAME, params);
                }
            } else if (!this.addChannel(pair.getName(), pair.getType())) {
                Object[] params = new Object[]{pair.getName()};
                this.error((TermA)term, ErrorMessage.REDECLARED_CHANNEL_NAME, params);
            }
            allPairs.add(pair);
        }
        return allPairs;
    }

    public Object visitQualifiedDecl(QualifiedDecl term) {
        List pairs = new ArrayList();
        ArrayList allPairs = new ArrayList();
        ListTerm decls = term.getDeclarations();
        for (Decl decl : decls) {
            pairs = (List)decl.accept((Visitor)this.declChecker());
            allPairs.addAll(pairs);
        }
        return allPairs;
    }
}

