/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.circus;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.circus.ast.AssignmentCommand;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusCommand;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.IfGuardedCommand;
import net.sourceforge.czt.circus.ast.ParamCommand;
import net.sourceforge.czt.circus.ast.QualifiedDecl;
import net.sourceforge.czt.circus.ast.SpecStmtCommand;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.circus.visitor.AssignmentCommandVisitor;
import net.sourceforge.czt.circus.visitor.CircusCommandVisitor;
import net.sourceforge.czt.circus.visitor.IfGuardedCommandVisitor;
import net.sourceforge.czt.circus.visitor.ParamCommandVisitor;
import net.sourceforge.czt.circus.visitor.SpecStmtCommandVisitor;
import net.sourceforge.czt.circus.visitor.VarDeclCommandVisitor;
import net.sourceforge.czt.circustools.ast.ActionSignature;
import net.sourceforge.czt.typecheck.circus.Checker;
import net.sourceforge.czt.typecheck.circus.ErrorMessage;
import net.sourceforge.czt.typecheck.circus.TypeChecker;
import net.sourceforge.czt.typecheck.z.DeclChecker;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.VarDecl;

public class CommandChecker
extends Checker
implements CircusCommandVisitor,
AssignmentCommandVisitor,
SpecStmtCommandVisitor,
IfGuardedCommandVisitor,
VarDeclCommandVisitor,
ParamCommandVisitor {
    protected DeclChecker zDeclChecker_;

    public CommandChecker(TypeChecker typeChecker) {
        super(typeChecker);
        this.zDeclChecker_ = new DeclChecker(typeChecker);
    }

    public Object visitCircusCommand(CircusCommand term) {
        return this.factory().createActionSignature();
    }

    public Object visitAssignmentCommand(AssignmentCommand term) {
        ListTerm vars = term.getLeftVars();
        ListTerm exprs = term.getExprs();
        if (vars.size() != exprs.size()) {
            Object[] params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord()};
            this.error((TermA)term, ErrorMessage.DIFF_NUM_ASSIG_COMMAND_ERROR, params);
        } else {
            ArrayList<String> leftVars = new ArrayList<String>();
            int i = 0;
            for (RefName leftVar : vars) {
                Object[] params;
                Expr rigthExpr = (Expr)exprs.get(i);
                if (!leftVars.contains(leftVar.getWord())) {
                    leftVars.add(leftVar.getWord());
                    if (!this.isLocalVar(leftVar)) {
                        params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), leftVar.getWord()};
                        this.error((TermA)term, ErrorMessage.IS_NOT_LOCAL_VAR_NAME_IN_ASSIG_COMMAND, params);
                        break;
                    }
                    Type varType = this.typeEnv().getType(leftVar);
                    Type exprType = (Type)rigthExpr.accept((Visitor)this.exprChecker());
                    if (this.unify(GlobalDefs.unwrapType(varType), GlobalDefs.unwrapType(exprType)) != GlobalDefs.SUCC) {
                        Object[] params2 = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), varType, exprType, i + 1};
                        this.error((TermA)term, ErrorMessage.ASSIG_COMMAND_ERROR, params2);
                        break;
                    }
                } else {
                    params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), leftVar.getWord()};
                    this.error((TermA)term, ErrorMessage.DUPLICATE_VAR_NAME_IN_ASSIG_COMMAND, params);
                    break;
                }
                ++i;
            }
        }
        ActionSignature actionSignature = this.factory().createActionSignature();
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitSpecStmtCommand(SpecStmtCommand term) {
        ListTerm frameVars = term.getFrame();
        Pred pre = term.getPre();
        Pred post = term.getPost();
        ArrayList<String> frame = new ArrayList<String>();
        for (RefName frameVar : frameVars) {
            if (!frame.contains(frameVar.getWord())) {
                frame.add(frameVar.getWord());
                if (this.isLocalVar(frameVar)) continue;
                Object[] params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), frameVar.getWord()};
                this.error((TermA)term, ErrorMessage.IS_NOT_LOCAL_VAR_NAME_IN_SPEC_COMMAND, params);
                break;
            }
            Object[] params = new Object[]{this.currentAction().getWord(), this.currentProcess().getWord(), frameVar.getWord()};
            this.error((TermA)term, ErrorMessage.DUPLICATE_VAR_NAME_IN_FRAME_OF_SPEC_COMMAND, params);
            break;
        }
        pre.accept((Visitor)this.predChecker());
        post.accept((Visitor)this.predChecker());
        ActionSignature actionSignature = this.factory().createActionSignature();
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitIfGuardedCommand(IfGuardedCommand term) {
        ActionSignature actionSignature = this.factory().createActionSignature();
        ListTerm gActions = term.getGuardedAction();
        for (GuardedAction gAction : gActions) {
            Pred pred = gAction.getPred();
            CircusAction action = gAction.getCircusAction();
            pred.accept((Visitor)this.predChecker());
            ActionSignature sig = (ActionSignature)action.accept((Visitor)this.actionChecker());
            ActionSignature sigTemp = this.cloneActionSignature(sig);
            actionSignature = this.joinActionSignature(actionSignature, sigTemp);
        }
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitVarDeclCommand(VarDeclCommand term) {
        List<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        ListTerm decls = term.getDeclarations();
        CircusAction action = term.getCircusAction();
        this.localCircTypeEnv().enterScopeLocalVars();
        this.typeEnv().enterScope();
        ArrayList<String> paramsError = new ArrayList<String>();
        paramsError.add(this.currentAction().getWord());
        paramsError.add(this.currentProcess().getWord());
        for (Decl d : decls) {
            if (!(d instanceof VarDecl)) {
                throw new UnsupportedOperationException("Variable declaration command accepts only VarDecl!");
            }
            VarDecl decl = (VarDecl)d;
            List pairs = (List)decl.accept((Visitor)this.declChecker());
            allPairs = this.checkDecls(allPairs, pairs, (TermA)term, ErrorMessage.REDECLARED_PARAM_IN_PROCESS, paramsError);
        }
        this.addVars(allPairs);
        this.localCircTypeEnv().addLocalVars(allPairs);
        ActionSignature actionSig = (ActionSignature)action.accept((Visitor)this.actionChecker());
        this.typeEnv().exitScope();
        this.localCircTypeEnv().exitScopeLocalVars();
        ActionSignature actionSignature = this.cloneActionSignature(actionSig);
        actionSignature.setLocalVarsSignature(this.factory().createSignature(allPairs));
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }

    public Object visitParamCommand(ParamCommand term) {
        List<NameTypePair> allPairs = new ArrayList<NameTypePair>();
        ListTerm decls = term.getQualifiedDecl();
        CircusCommand command = term.getCircusCommand();
        this.typeEnv().enterScope();
        this.localCircTypeEnv().enterScopeLocalVars();
        ArrayList<String> paramsError = new ArrayList<String>();
        paramsError.add(this.currentAction().getWord());
        paramsError.add(this.currentProcess().getWord());
        for (QualifiedDecl qDecl : decls) {
            List pairs = (List)qDecl.accept((Visitor)this.declChecker());
            allPairs = this.checkDecls(allPairs, pairs, (TermA)term, ErrorMessage.REDECLARED_PARAM_IN_PARCOMMAND, paramsError);
        }
        this.addVars(allPairs);
        this.localCircTypeEnv().addLocalVars(allPairs);
        ActionSignature actionSig = (ActionSignature)command.accept((Visitor)this.commandChecker());
        this.localCircTypeEnv().exitScopeLocalVars();
        this.typeEnv().exitScope();
        ActionSignature actTemp = this.cloneActionSignature(actionSig);
        actTemp.setLocalVarsSignature(this.factory().createSignature(allPairs));
        ActionSignature actionSignature = this.factory().createActionSignature();
        actionSignature = this.joinActionSignature(actionSig, actTemp);
        this.addActionAnn((CircusAction)term, actionSignature);
        return actionSignature;
    }
}

