/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.zpatt;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.czt.java_cup.runtime.Scanner;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.parser.util.DebugUtils;
import net.sourceforge.czt.parser.util.TokenStack;
import net.sourceforge.czt.parser.zpatt.Sym;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SmartScanner
implements Scanner {
    private boolean debug_ = false;
    private boolean inBoxName = false;
    private TokenStack dumb_;

    SmartScanner(Scanner dumbscanner) {
        this.dumb_ = new TokenStack(dumbscanner);
    }

    public Symbol next_token() throws Exception {
        Symbol result = this.dumb_.pop();
        if (result.sym == 104 && this.inBoxName) {
            this.inBoxName = false;
        } else if (result.sym == 104 && !this.inBoxName) {
            if (this.isColonDecl()) {
                this.debug("converting " + this.get_info(result) + " to DECLWORD");
                result.sym = 105;
            }
        } else if (result.sym == 64 || result.sym == 65) {
            this.inBoxName = true;
        }
        return result;
    }

    private boolean isColonDecl() throws Exception {
        boolean isColonDecl = false;
        boolean doLookahead = true;
        LinkedList<Symbol> tokens = new LinkedList<Symbol>();
        Symbol currsym = this.dumb_.pop();
        this.debug("popping: " + this.get_info(currsym));
        tokens.addLast(currsym);
        while (currsym.sym == 35 && doLookahead) {
            currsym = this.dumb_.pop();
            this.debug("popping: " + this.get_info(currsym));
            tokens.addLast(currsym);
            doLookahead = false;
            while (currsym.sym == 104 || currsym.sym == 58 || currsym.sym == 57 || currsym.sym == 105) {
                currsym = this.dumb_.pop();
                this.debug("popping: " + currsym.value);
                tokens.addLast(currsym);
                doLookahead = true;
            }
        }
        if (currsym.sym == 33 && doLookahead) {
            isColonDecl = true;
        }
        this.pushList(tokens, isColonDecl);
        return isColonDecl;
    }

    private void pushList(List<Symbol> tokens, boolean isColonDecl) {
        for (int i = tokens.size() - 1; i >= 0; --i) {
            Symbol symbol = tokens.get(i);
            if (symbol.sym == 104 && isColonDecl) {
                this.debug("converting result: " + symbol.value + " to DECLWORD");
                symbol.sym = 105;
            } else {
                this.debug("pushing back " + this.get_info(symbol));
            }
            this.dumb_.push(symbol);
        }
    }

    private void debug(String msg) {
        if (this.debug_) {
            System.err.println(msg);
        }
    }

    private Object get_info(Symbol symbol) {
        String result = null;
        Map symbolMap = DebugUtils.getFieldMap(Sym.class);
        Object sym = symbolMap.get(new Integer(symbol.sym));
        result = symbol.value != null ? sym.toString() + "(" + symbol.value + ")" : sym.toString();
        return result;
    }
}

