/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.zpatt;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import net.sourceforge.czt.java_cup.runtime.Scanner;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.parser.util.Decorword;
import net.sourceforge.czt.parser.zpatt.ContextFreeScanner;
import net.sourceforge.czt.parser.zpatt.SeparateDelimiter;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.CztLogger;
import net.sourceforge.czt.z.ast.InStroke;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.NumStroke;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.util.ZString;
import net.sourceforge.czt.zpatt.util.ZPattString;

public class KeywordScanner
implements Scanner {
    private SeparateDelimiter scanner_;
    private Map keywords_ = this.createKeywordMap();
    private Stack<Symbol> tokens_ = new Stack();

    public KeywordScanner(ContextFreeScanner scanner, Properties properties) {
        this.scanner_ = new SeparateDelimiter(scanner, properties);
    }

    private Map createKeywordMap() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("else", new Integer(50));
        result.put("false", new Integer(46));
        result.put("function", new Integer(53));
        result.put("generic", new Integer(54));
        result.put("if", new Integer(48));
        result.put("leftassoc", new Integer(55));
        result.put("let", new Integer(47));
        result.put(ZString.POWER, new Integer(29));
        result.put("parents", new Integer(44));
        result.put("pre", new Integer(51));
        result.put("relation", new Integer(52));
        result.put("rightassoc", new Integer(56));
        result.put("section", new Integer(43));
        result.put("then", new Integer(49));
        result.put("true", new Integer(45));
        result.put(ZString.COLON, new Integer(33));
        result.put("==", new Integer(60));
        result.put(ZString.COMMA, new Integer(35));
        result.put("::=", new Integer(59));
        result.put("|", new Integer(18));
        result.put(ZString.ANDALSO, new Integer(19));
        result.put(ZString.ZHIDE, new Integer(38));
        result.put("/", new Integer(30));
        result.put(ZString.DOT, new Integer(36));
        result.put(ZString.SEMICOLON, new Integer(34));
        result.put(ZString.ARG, new Integer(58));
        result.put(",,", new Integer(57));
        result.put(ZString.EQUALS, new Integer(31));
        result.put(ZString.CONJECTURE, new Integer(20));
        result.put(ZString.ALL, new Integer(26));
        result.put(ZString.SPOT, new Integer(37));
        result.put(ZString.EXI, new Integer(27));
        result.put(ZString.EXIONE, new Integer(61));
        result.put(ZString.IFF, new Integer(24));
        result.put(ZString.IMP, new Integer(23));
        result.put(ZString.OR, new Integer(22));
        result.put(ZString.AND, new Integer(21));
        result.put(ZString.NOT, new Integer(25));
        result.put(ZString.MEM, new Integer(32));
        result.put(ZString.ZPROJ, new Integer(39));
        result.put(ZString.CROSS, new Integer(28));
        result.put(ZString.LAMBDA, new Integer(4));
        result.put(ZString.MU, new Integer(3));
        result.put(ZString.THETA, new Integer(2));
        result.put(ZString.ZCOMP, new Integer(40));
        result.put(ZString.ZPIPE, new Integer(41));
        result.put(ZString.VDASH, new Integer(71));
        result.put(ZPattString.PROVISO, new Integer(72));
        return result;
    }

    private Symbol toToken(Stroke stroke, int left, int right) {
        if (stroke instanceof InStroke) {
            return new Symbol(7, left, right);
        }
        if (stroke instanceof OutStroke) {
            return new Symbol(6, left, right);
        }
        if (stroke instanceof NextStroke) {
            return new Symbol(5, left, right);
        }
        if (stroke instanceof NumStroke) {
            NumStroke numStroke = (NumStroke)stroke;
            return new Symbol(103, left, right, (Object)numStroke.getNumber());
        }
        throw new CztException("Unexpected stroke");
    }

    public Symbol next_token() throws IOException {
        if (!this.tokens_.empty()) {
            return this.tokens_.pop();
        }
        Symbol symbol = this.scanner_.next_token();
        String logMessage = "Received token (" + symbol.sym + ", " + symbol.value + ")";
        CztLogger.getLogger(KeywordScanner.class).finer(logMessage);
        if (symbol.sym == 104) {
            Decorword decorword = (Decorword)symbol.value;
            if ("".equals(decorword.getWord())) {
                Stroke[] strokes = decorword.getStrokes();
                assert (strokes.length > 0);
                for (int i = strokes.length - 1; i > 0; --i) {
                    this.tokens_.push(this.toToken(strokes[i], symbol.left, symbol.right));
                }
                return this.toToken(strokes[0], symbol.left, symbol.right);
            }
            String value = decorword.getName();
            Integer token = (Integer)this.keywords_.get(value);
            if (token != null) {
                logMessage = "Returning " + token + " instead.";
                CztLogger.getLogger(KeywordScanner.class).finer(logMessage);
                return new Symbol(token.intValue(), symbol.left, symbol.right);
            }
        }
        return symbol;
    }
}

