/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.parser.util.Decorword;
import net.sourceforge.czt.parser.util.OperatorTokenType;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.z.ast.Assoc;
import net.sourceforge.czt.z.ast.Cat;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.z.ast.Oper;
import net.sourceforge.czt.z.ast.Operand;
import net.sourceforge.czt.z.ast.Operator;
import net.sourceforge.czt.z.ast.OptempPara;
import net.sourceforge.czt.z.util.OperatorName;
import net.sourceforge.czt.z.util.ZString;

public class OpTable {
    private String section_;
    private SortedMap ops_ = new TreeMap();
    private Map<String, OptempPara> optempPara_ = new HashMap<String, OptempPara>();
    private Map opTokens_ = new HashMap();
    private Map precedence_ = new HashMap();
    private Map assoc_ = new HashMap();

    public OpTable(String section, Collection parents) throws OperatorException {
        this.section_ = section;
        if (parents != null) {
            for (OpTable table : parents) {
                this.addParentOpTable(table);
            }
        }
    }

    private void addParentOpTable(OpTable parentTable) throws OperatorException {
        this.ops_.putAll(parentTable.ops_);
        this.addOpTokens(parentTable);
        this.addPrecedences(parentTable);
        this.addAssociativities(parentTable);
        this.optempPara_.putAll(parentTable.optempPara_);
    }

    public static String getWord(String decorword) {
        Decorword dw = new Decorword(decorword);
        return dw.getWord();
    }

    public static String getOpNameWithoutStrokes(List oper) {
        StringBuffer result = new StringBuffer();
        for (Oper o : oper) {
            if (o instanceof Operand) {
                Operand operand = (Operand)o;
                if (Boolean.TRUE.equals(operand.getList())) {
                    result.append(ZString.LISTARG_TOK);
                    continue;
                }
                result.append(ZString.ARG_TOK);
                continue;
            }
            if (o instanceof Operator) {
                Operator operator = (Operator)o;
                String name = operator.getWord();
                assert (name.equals(OpTable.getWord(name)));
                result.append(name);
                continue;
            }
            throw new CztException("Unexpected Oper");
        }
        return result.toString();
    }

    public String getSection() {
        return this.section_;
    }

    public OpInfo lookup(String opname) {
        throw new UnsupportedOperationException();
    }

    public OpInfo lookup(List list) {
        StringBuffer opname = new StringBuffer();
        for (String s : list) {
            if (ZString.ARG_TOK.equals(s) || ZString.LISTARG_TOK.equals(s)) {
                opname.append(s);
                continue;
            }
            opname.append(OpTable.getWord(s));
        }
        OpInfo result = (OpInfo)this.ops_.get(opname.toString());
        return result;
    }

    public OpInfo lookup(OperatorName operatorName) {
        return (OpInfo)this.ops_.get(operatorName.getWord());
    }

    public OperatorTokenType getTokenType(Decorword decorword) {
        return (OperatorTokenType)this.opTokens_.get(decorword.getWord());
    }

    public Integer getPrec(String opWord) {
        return (Integer)this.precedence_.get(OpTable.getWord(opWord));
    }

    public Assoc getAssoc(String opWord) {
        Integer prec = (Integer)this.precedence_.get(OpTable.getWord(opWord));
        if (prec == null) {
            return null;
        }
        return (Assoc)this.assoc_.get(prec);
    }

    public String toString() {
        return "OpTable for " + this.section_ + "\n" + this.opTokens_;
    }

    public void add(OptempPara opPara) throws OperatorException {
        ListTerm oper = opPara.getOper();
        if (oper.size() < 2) {
            throw new OperatorException("Error: operator template with less than 2 arguments");
        }
        OpInfo info = new OpInfo(this.section_, opPara);
        String name = OpTable.getOpNameWithoutStrokes((List)opPara.getOper());
        this.addOperator(name, info);
        Oper first = (Oper)oper.get(0);
        Oper last = (Oper)oper.get(oper.size() - 1);
        if (first instanceof Operand) {
            if (last instanceof Operand) {
                this.addInfix(opPara);
                return;
            }
            this.addPostfix(opPara);
            return;
        }
        if (last instanceof Operand) {
            this.addPrefix(opPara);
            return;
        }
        this.addNofix(opPara);
    }

    private void addOperator(String name, OpInfo info) throws OperatorException {
        if (this.ops_.get(name) != null) {
            String message = "Operator " + name + " defined more than once";
            throw new OperatorException(message);
        }
        this.ops_.put(name, info);
    }

    private void addOperators(OpTable parentTable) throws OperatorException {
        SortedMap parentOps = parentTable.ops_;
        for (String name : parentOps.keySet()) {
            OpInfo info = (OpInfo)parentOps.get(name);
            assert (info != null);
            OpInfo existingInfo = (OpInfo)this.ops_.get(name);
            if (existingInfo != null && !existingInfo.equals(info)) {
                String message = "Operator " + name + " defined more than once" + " in parents " + info.getSection() + " and " + existingInfo.getSection();
                throw new OperatorException(message);
            }
            this.ops_.put(name, info);
        }
    }

    private void addPrefix(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        boolean start = true;
        int finish = words.size() - 4;
        if (words.size() == 2) {
            this.addPreOrPrep(opPara);
        } else {
            this.addLOrLp(opPara);
            this.addEsOrSsList(opPara, 1, finish);
            this.addEreOrSreOrErepOrSRep(opPara);
        }
    }

    private void addPostfix(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        int start = 2;
        int finish = words.size() - 3;
        if (words.size() == 2) {
            this.addPostOrPostp(opPara);
        } else {
            this.addElOrElp(opPara);
            this.addEsOrSsList(opPara, 2, finish);
            this.addErOrSrOrErpOrSrp(opPara);
        }
    }

    private void addInfix(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        int start = 2;
        int finish = words.size() - 4;
        if (words.size() == 3) {
            this.addIOrIp(opPara);
        } else {
            this.addElOrElp(opPara);
            this.addEsOrSsList(opPara, 2, finish);
            this.addEreOrSreOrErepOrSRep(opPara);
        }
    }

    private void addNofix(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        boolean start = true;
        int finish = words.size() - 2;
        this.addLOrLp(opPara);
        this.addEsOrSsList(opPara, 1, finish);
        this.addErOrSrOrErpOrSrp(opPara);
    }

    private void addPreOrPrep(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        boolean namePosition = false;
        OperatorTokenType type = opPara.getCat().equals((Object)Cat.Relation) ? OperatorTokenType.PREP : OperatorTokenType.PRE;
        this.addOp((List)words, 0, type, opPara);
    }

    private void addLOrLp(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        boolean namePosition = false;
        OperatorTokenType type = opPara.getCat().equals((Object)Cat.Relation) ? OperatorTokenType.LP : OperatorTokenType.L;
        this.addOp((List)words, 0, type, opPara);
    }

    private void addPostOrPostp(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        boolean namePosition = true;
        OperatorTokenType type = opPara.getCat().equals((Object)Cat.Relation) ? OperatorTokenType.POSTP : OperatorTokenType.POST;
        this.addOp((List)words, 1, type, opPara);
    }

    private void addElOrElp(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        boolean namePosition = true;
        OperatorTokenType type = opPara.getCat().equals((Object)Cat.Relation) ? OperatorTokenType.ELP : OperatorTokenType.EL;
        this.addOp((List)words, 1, type, opPara);
    }

    private void addEsOrSsList(OptempPara opPara, int start, int finish) throws OperatorException {
        ListTerm words = opPara.getOper();
        for (int i = start; i < finish; i += 2) {
            OperatorTokenType type = this.isSeq((List)words, i) ? OperatorTokenType.SS : OperatorTokenType.ES;
            int namePosition = i + 1;
            this.addOp((List)words, namePosition, type, opPara);
        }
    }

    private void addErOrSrOrErpOrSrp(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        OperatorTokenType type = null;
        int opPosition = words.size() - 2;
        int namePosition = words.size() - 1;
        type = opPara.getCat().equals((Object)Cat.Relation) ? (this.isSeq((List)words, opPosition) ? OperatorTokenType.SRP : OperatorTokenType.ERP) : (this.isSeq((List)words, opPosition) ? OperatorTokenType.SR : OperatorTokenType.ER);
        this.addOp((List)words, namePosition, type, opPara);
    }

    private void addEreOrSreOrErepOrSRep(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        OperatorTokenType type = null;
        int opPosition = words.size() - 3;
        int namePosition = words.size() - 2;
        type = opPara.getCat().equals((Object)Cat.Relation) ? (this.isSeq((List)words, opPosition) ? OperatorTokenType.SREP : OperatorTokenType.EREP) : (this.isSeq((List)words, opPosition) ? OperatorTokenType.SRE : OperatorTokenType.ERE);
        this.addOp((List)words, namePosition, type, opPara);
    }

    private void addIOrIp(OptempPara opPara) throws OperatorException {
        ListTerm words = opPara.getOper();
        boolean namePosition = true;
        OperatorTokenType type = opPara.getCat().equals((Object)Cat.Relation) ? OperatorTokenType.IP : OperatorTokenType.I;
        this.addOp((List)words, 1, type, opPara);
    }

    private boolean isSeq(List words, int i) {
        return ((Operand)words.get(i)).getList();
    }

    private String getName(Object o) throws OperatorException {
        Operator op;
        String result = null;
        if (o instanceof Operator) {
            op = (Operator)o;
            assert (op.getWord().equals(OpTable.getWord(op.getWord())));
        } else {
            throw new OperatorException("Attempt to add non-operator into operator table");
        }
        result = op.getWord();
        return result;
    }

    private void addOp(String name, OperatorTokenType type, OptempPara opPara) throws OperatorException {
        Integer precedence = opPara.getPrec();
        Assoc associativity = opPara.getAssoc();
        this.addOptempPara(name, opPara);
        this.addOpToken(name, type, opPara);
        this.addPrecedence(name, precedence);
        this.addAssociativity(precedence, associativity);
    }

    private void addOp(List words, int namePosition, OperatorTokenType type, OptempPara opPara) throws OperatorException {
        String name = this.getName(words.get(namePosition));
        this.addOp(name, type, opPara);
    }

    private void addOptempPara(String word, OptempPara optempPara) {
        this.optempPara_.put(word, optempPara);
    }

    private void addOpToken(String word, OperatorTokenType type, OptempPara opPara) throws OperatorException {
        OperatorTokenType existingType = (OperatorTokenType)this.opTokens_.get(word);
        if (existingType != null && !type.equals(existingType)) {
            OptempPara optempPara = this.optempPara_.get(word);
            LocAnn locAnn1 = (LocAnn)optempPara.getAnn(LocAnn.class);
            LocAnn locAnn2 = (LocAnn)opPara.getAnn(LocAnn.class);
            String message = "Operator word " + word + " defined as operator token " + existingType;
            if (locAnn1 != null) {
                message = message + " at line " + locAnn1.getLine() + " column " + locAnn1.getCol() + " in " + locAnn1.getLoc();
            }
            message = message + " and as operator token " + type;
            if (locAnn2 != null) {
                message = message + " at line " + locAnn2.getLine() + " column " + locAnn2.getCol() + " in " + locAnn2.getLoc();
            }
            message = message + "; but the association of operator words and operator tokens must be a function (see ISO Z Standard section 7.4.4).";
            throw new OperatorException(message);
        }
        this.opTokens_.put(word, type);
    }

    private void addOpTokens(OpTable parentTable) throws OperatorException {
        Map parentOpTokens = parentTable.opTokens_;
        for (String word : parentOpTokens.keySet()) {
            OperatorTokenType type = (OperatorTokenType)parentOpTokens.get(word);
            assert (type != null);
            this.addOpToken(word, type, parentTable.optempPara_.get(word));
        }
    }

    private void addPrecedence(String word, Integer precedence) throws OperatorException {
        if (precedence != null) {
            Integer existingPrec = (Integer)this.precedence_.get(word);
            if (existingPrec != null && !existingPrec.equals(precedence)) {
                String message = "Name " + word + " defined with precedence " + existingPrec + " and " + precedence;
                throw new OperatorException(message);
            }
            this.precedence_.put(word, precedence);
        }
    }

    private void addPrecedences(OpTable parentTable) throws OperatorException {
        Map parentPrecs = parentTable.precedence_;
        for (String word : parentPrecs.keySet()) {
            Integer prec = (Integer)parentPrecs.get(word);
            assert (prec != null);
            this.addPrecedence(word, prec);
        }
    }

    private void addAssociativity(Integer precedence, Assoc assoc) throws OperatorException {
        if (precedence != null) {
            assert (assoc != null);
            Assoc existingAssoc = (Assoc)this.assoc_.get(precedence);
            if (existingAssoc != null && !existingAssoc.equals((Object)assoc)) {
                String message = "Precedence " + precedence + " is associated with " + existingAssoc + " and " + assoc;
                throw new OperatorException(message);
            }
            this.assoc_.put(precedence, assoc);
        }
    }

    private void addAssociativities(OpTable parentTable) throws OperatorException {
        Map parentAssoc = parentTable.assoc_;
        for (Integer precedence : parentAssoc.keySet()) {
            Assoc assoc = (Assoc)parentAssoc.get(precedence);
            assert (assoc != null);
            this.addAssociativity(precedence, assoc);
        }
    }

    public static class OperatorException
    extends CommandException {
        public OperatorException(String message) {
            super(message);
        }
    }

    public static class OpInfo {
        private String section_;
        private Cat cat_;
        private Assoc assoc_;
        private Integer prec_;

        public OpInfo(String section, OptempPara opPara) {
            this.section_ = section;
            this.cat_ = opPara.getCat();
            this.assoc_ = opPara.getAssoc();
            this.prec_ = opPara.getPrec();
        }

        public String getSection() {
            return this.section_;
        }

        public Cat getCat() {
            return this.cat_;
        }

        public Assoc getAssoc() {
            return this.assoc_;
        }

        public Integer getPrec() {
            return this.prec_;
        }
    }
}

