/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sourceforge.czt.z.ast.InStroke;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.NumStroke;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.Stroke;
import net.sourceforge.czt.z.util.Factory;
import net.sourceforge.czt.z.util.ZChar;

public class Decorword {
    private Factory factory_ = new Factory();
    private String name_;
    private String word_;
    private List<Stroke> strokes_ = new ArrayList<Stroke>();

    public Decorword(String word, List strokes) {
        this.word_ = word;
        this.strokes_.addAll(strokes);
        StringBuffer buffer = new StringBuffer();
        buffer.append(word);
        for (Stroke stroke : strokes) {
            if (stroke instanceof InStroke) {
                buffer.append(ZChar.INSTROKE);
                continue;
            }
            if (stroke instanceof OutStroke) {
                buffer.append(ZChar.OUTSTROKE);
                continue;
            }
            if (stroke instanceof NextStroke) {
                buffer.append(ZChar.PRIME);
                continue;
            }
            if (stroke instanceof NumStroke) {
                NumStroke numStroke = (NumStroke)stroke;
                buffer.append(ZChar.SE);
                buffer.append(numStroke.getNumber());
                buffer.append(ZChar.NW);
                continue;
            }
            throw new IllegalArgumentException("Unexpected stroke");
        }
        this.name_ = buffer.toString();
    }

    public Decorword(String decorword) {
        int i;
        this.name_ = decorword;
        ZChar[] zchars = ZChar.toZChars((String)decorword);
        for (i = zchars.length - 1; i >= 0; --i) {
            ZChar zchar = zchars[i];
            if (ZChar.INSTROKE.equals((Object)zchar)) {
                this.strokes_.add(0, (Stroke)this.factory_.createInStroke());
                continue;
            }
            if (ZChar.OUTSTROKE.equals((Object)zchar)) {
                this.strokes_.add(0, (Stroke)this.factory_.createOutStroke());
                continue;
            }
            if (ZChar.PRIME.equals((Object)zchar)) {
                this.strokes_.add(0, (Stroke)this.factory_.createNextStroke());
                continue;
            }
            if (i < 2 || !ZChar.NW.equals((Object)zchar) || !ZChar.isDigit((ZChar)zchars[i - 1]) || !ZChar.SE.equals((Object)zchars[i - 2])) break;
            NumStroke numStroke = this.factory_.createNumStroke(new Integer(zchars[i - 1].toString()));
            this.strokes_.add((Stroke)numStroke);
            i -= 2;
        }
        StringBuffer result = new StringBuffer();
        for (int j = 0; j <= i; ++j) {
            result.append(zchars[j].toString());
        }
        this.word_ = result.toString();
    }

    public String getName() {
        return this.name_;
    }

    public String getWord() {
        return this.word_;
    }

    public Stroke[] getStrokes() {
        return this.strokes_.toArray(new Stroke[0]);
    }

    public ZChar check() {
        Stack<ZChar> stack = new Stack<ZChar>();
        ZChar[] zchars = ZChar.toZChars((String)this.word_);
        for (int i = 0; i < zchars.length; ++i) {
            boolean sup;
            if (zchars[i].equals((Object)ZChar.NE) || zchars[i].equals((Object)ZChar.SE)) {
                stack.push(zchars[i]);
                continue;
            }
            if (!zchars[i].equals((Object)ZChar.NW) && !zchars[i].equals((Object)ZChar.SW) || stack.empty()) continue;
            ZChar zchar = (ZChar)stack.pop();
            boolean sub = zchars[i].equals((Object)ZChar.NW) && zchar.equals((Object)ZChar.SE);
            boolean bl = sup = zchars[i].equals((Object)ZChar.SW) && zchar.equals((Object)ZChar.NE);
            if (sub || sup) continue;
            return zchars[i];
        }
        if (!stack.empty()) {
            return (ZChar)stack.pop();
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getWord());
        for (int i = 0; i < this.getStrokes().length; ++i) {
            Stroke stroke = this.getStrokes()[i];
            result.append(stroke.toString());
        }
        return result.toString();
    }
}

