/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.parser.oz;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Properties;
import java.util.logging.Logger;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.java_cup.runtime.Symbol;
import net.sourceforge.czt.oz.jaxb.JaxbValidator;
import net.sourceforge.czt.oz.jaxb.JaxbXmlWriter;
import net.sourceforge.czt.parser.oz.LatexScanner;
import net.sourceforge.czt.parser.oz.Parser;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.CztLogger;
import net.sourceforge.czt.z.ast.ZFactory;
import net.sourceforge.czt.z.impl.ZFactoryImpl;

public class LatexParser {
    ZFactory factory_ = new ZFactoryImpl();
    LatexScanner scanner_;
    Parser parser_;

    public LatexParser(Reader in, SectionInfo sectInfo, Properties properties) {
        this.scanner_ = new LatexScanner(in, sectInfo, properties);
        this.parser_ = new Parser(this.scanner_, sectInfo);
    }

    public LatexParser(Reader in, String filename, SectionInfo sectInfo, Properties properties) {
        this.scanner_ = new LatexScanner(in, sectInfo, properties);
        this.scanner_.setSource(filename);
        this.parser_ = new Parser(this.scanner_, filename, sectInfo);
    }

    public static void main(String[] args) {
        String usage = "Usage: net.sourceforge.czt.parser.oz.LatexParser [ -in <inputfile>] [ -out <outputfile>]";
        try {
            String filename = null;
            Logger logger = CztLogger.getLogger(LatexParser.class);
            InputStreamReader in = new InputStreamReader(System.in);
            OutputStream out = System.out;
            for (int i = 0; i < args.length; ++i) {
                if ("-in".equals(args[i])) {
                    if (i < args.length) {
                        filename = args[++i];
                        in = new InputStreamReader(new FileInputStream(filename));
                        continue;
                    }
                    System.err.println(usage);
                    return;
                }
                if ("-out".equals(args[i])) {
                    if (i < args.length) {
                        out = new FileOutputStream(args[++i]);
                        continue;
                    }
                    System.err.println(usage);
                    return;
                }
                System.err.println(usage);
                return;
            }
            LatexParser parser = new LatexParser(in, filename, new SectionManager(), new Properties());
            Term term = parser.parse();
            if (term != null) {
                JaxbValidator validator = new JaxbValidator();
                if (!validator.validate(term)) {
                    String message = "AST is not valid.";
                    logger.warning(message);
                }
                JaxbXmlWriter xmlWriter = new JaxbXmlWriter();
                xmlWriter.write(term, out);
            } else {
                System.err.println("Parse error");
            }
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Term parse() throws ParseException {
        try {
            Symbol parseTree = this.parser_.parse();
            Term term = (Term)parseTree.value;
            return term;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CztException("This should never happen", (Throwable)e);
        }
    }
}

