/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z.impl;

import java.util.List;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.impl.ListTermImpl;
import net.sourceforge.czt.typecheck.z.impl.UnknownTypeVisitor;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.NameNamePair;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.impl.Type2Impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnknownType
extends Type2Impl {
    protected RefName refName_;
    protected List<Type2> types_;
    protected List<NameNamePair> pairs_;
    protected boolean isMem_;

    protected UnknownType(RefName refName, boolean isMem, List<Type2> types, List<NameNamePair> pairs) {
        this.refName_ = refName;
        this.isMem_ = isMem;
        this.types_ = types;
        this.pairs_ = pairs;
    }

    protected UnknownType(RefName refName, boolean isMem, List<Type2> types) {
        this(refName, isMem, types, (List<NameNamePair>)new ListTermImpl(NameNamePair.class));
    }

    protected UnknownType(RefName refName, boolean isMem) {
        this(refName, isMem, (List<Type2>)new ListTermImpl(Type2.class));
    }

    protected UnknownType(RefName refName) {
        this(refName, false);
    }

    protected UnknownType() {
        this(null);
    }

    public List<Type2> getType() {
        List<Type2> result = this.types_;
        for (int i = 0; i < result.size(); ++i) {
            VariableType vType;
            Type2 type = result.get(i);
            if (!(type instanceof VariableType) || (vType = (VariableType)type).getValue() == vType) continue;
            result.set(i, vType.getValue());
        }
        return result;
    }

    public List<NameNamePair> getPairs() {
        return this.pairs_;
    }

    public RefName getRefName() {
        return this.refName_;
    }

    public void setRefName(RefName refName) {
        this.refName_ = refName;
    }

    public void setIsMem(boolean isMem) {
        this.isMem_ = isMem;
    }

    public boolean getIsMem() {
        return this.isMem_;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof UnknownType) {
            UnknownType unknownType = (UnknownType)((Object)obj);
            if (this.refName_ == null && unknownType.getRefName() == null) {
                result = true;
            } else if (this.refName_ != null && this.refName_.equals(unknownType.getRefName())) {
                result = true;
            }
            if (result && this.isMem_ == unknownType.getIsMem()) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        int constant = 31;
        int hashCode = super.hashCode();
        hashCode += "UnknownType".hashCode();
        if (this.refName_ != null) {
            hashCode += 31 * this.refName_.hashCode();
        }
        return hashCode;
    }

    public Object[] getChildren() {
        Object[] children = new Object[]{this.getRefName(), this.getType(), new Boolean(this.getIsMem())};
        return children;
    }

    public Object accept(Visitor v) {
        if (v instanceof UnknownTypeVisitor) {
            UnknownTypeVisitor visitor = (UnknownTypeVisitor)v;
            return visitor.visitUnknownType(this);
        }
        return super.accept(v);
    }

    public Term create(Object[] args) {
        UnknownType zedObject = null;
        try {
            zedObject = new UnknownType();
            RefName refName = (RefName)args[0];
            List types = (List)args[1];
            Boolean isMem = (Boolean)args[2];
            zedObject.setRefName(refName);
            zedObject.setIsMem(isMem);
            zedObject.getType().addAll(types);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException();
        }
        return zedObject;
    }

    public String toString() {
        String result = "unknown";
        if (this.refName_ != null) {
            int i;
            result = result + "(";
            if (this.getIsMem()) {
                result = result + "member(";
            }
            result = result + this.refName_;
            if (this.getIsMem()) {
                result = result + ")";
            }
            if (this.types_.size() > 0) {
                result = result + "[";
                result = result + this.types_.get(0).toString();
                for (i = 1; i < this.types_.size(); ++i) {
                    result = result + ", ";
                    result = result + this.types_.get(i).toString();
                }
                result = result + "]";
            }
            if (this.pairs_.size() > 0) {
                result = result + "[";
                result = result + this.pairs_.get(0).getNewName().toString() + "/";
                result = result + this.pairs_.get(0).getOldName().toString();
                for (i = 1; i < this.pairs_.size(); ++i) {
                    result = result + ", ";
                    result = result + this.pairs_.get(i).getNewName().toString() + "/";
                    result = result + this.pairs_.get(i).getOldName().toString();
                }
                result = result + "]";
            }
            result = result + ")";
        }
        return result;
    }
}

