/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z;

import java.util.List;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.Key;
import net.sourceforge.czt.typecheck.z.Checker;
import net.sourceforge.czt.typecheck.z.ErrorAnn;
import net.sourceforge.czt.typecheck.z.ErrorMessage;
import net.sourceforge.czt.typecheck.z.TypeChecker;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.NameSectTypeTriple;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Parent;
import net.sourceforge.czt.z.ast.Sect;
import net.sourceforge.czt.z.ast.SectTypeEnvAnn;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.visitor.ParentVisitor;
import net.sourceforge.czt.z.visitor.SectVisitor;
import net.sourceforge.czt.z.visitor.SpecVisitor;
import net.sourceforge.czt.z.visitor.ZSectVisitor;

public class SpecChecker
extends Checker
implements SpecVisitor,
ZSectVisitor,
ParentVisitor,
SectVisitor {
    public SpecChecker(TypeChecker typeChecker) {
        super(typeChecker);
    }

    public Object visitSpec(Spec spec) {
        ListTerm sects = spec.getSect();
        for (Sect sect : sects) {
            sect.accept((Visitor)this.specChecker());
        }
        Boolean result = this.getResult();
        return result;
    }

    public Object visitSect(Sect sect) {
        return Boolean.TRUE;
    }

    public Object visitZSect(ZSect zSect) {
        this.sectName(zSect.getName());
        if (this.sectTypeEnv().isChecked(this.sectName())) {
            Object[] params = new Object[]{zSect.getName()};
            this.error((TermA)zSect, ErrorMessage.REDECLARED_SECTION, params);
        }
        this.sectTypeEnv().setSection(this.sectName());
        ListTerm parents = zSect.getParent();
        List<String> names = GlobalDefs.list();
        for (Parent parent : parents) {
            Object[] params;
            parent.accept((Visitor)this.specChecker());
            if (names.contains(parent.getWord())) {
                params = new Object[]{parent.getWord(), this.sectName()};
                this.error((TermA)parent, ErrorMessage.REDECLARED_PARENT, params);
                continue;
            }
            if (parent.getWord().equals(this.sectName())) {
                params = new Object[]{parent.getWord()};
                this.error((TermA)parent, ErrorMessage.SELF_PARENT, params);
                continue;
            }
            names.add(parent.getWord());
        }
        ListTerm paras = zSect.getPara();
        for (Para para : paras) {
            Signature signature = (Signature)para.accept((Visitor)this.paraChecker());
            ListTerm pairs = signature.getNameTypePair();
            for (NameTypePair pair : pairs) {
                if (this.sectTypeEnv().add(pair.getName(), pair.getType())) continue;
                Object[] params = new Object[]{pair.getName()};
                this.error((TermA)pair.getName(), ErrorMessage.REDECLARED_GLOBAL_NAME, params);
            }
            this.postCheck();
        }
        if (this.useBeforeDecl() && !this.sectTypeEnv().getSecondTime()) {
            this.errors().clear();
            this.removeErrorAndTypeAnns((Term)zSect);
            this.sectTypeEnv().setSecondTime(true);
            zSect.accept((Visitor)this.specChecker());
        }
        GlobalDefs.addAnn((TermA)zSect, this.sectTypeEnv().getSectTypeEnvAnn());
        Boolean result = this.getResult();
        if (result == Boolean.FALSE) {
            this.removeTypeAnns((Term)zSect);
        }
        return result;
    }

    public Object visitParent(Parent parent) {
        this.sectTypeEnv().addParent(parent.getWord());
        TermA termA = null;
        try {
            termA = (TermA)this.sectInfo().get(new Key(parent.getWord(), ZSect.class));
        }
        catch (CommandException e) {
            // empty catch block
        }
        String section = this.sectTypeEnv().getSection();
        if (termA != null) {
            SectTypeEnvAnn ann = (SectTypeEnvAnn)termA.getAnn(SectTypeEnvAnn.class);
            if (ann == null) {
                List errors = this.specChecker().typecheck(termA, this.sectInfo());
                this.errors().addAll(errors);
                ann = (SectTypeEnvAnn)termA.getAnn(SectTypeEnvAnn.class);
            }
            ListTerm triples = ann.getNameSectTypeTriple();
            for (NameSectTypeTriple triple : triples) {
                this.sectTypeEnv().addParent(triple.getSect());
                this.sectTypeEnv().add(triple);
            }
            this.sectTypeEnv().setSection(section);
        }
        return null;
    }

    protected Boolean getResult() {
        Boolean result = Boolean.TRUE;
        if (this.errors().size() > 0) {
            result = Boolean.FALSE;
        }
        return result;
    }

    protected void postCheck() {
        List<ErrorAnn> paraErrors = GlobalDefs.list();
        for (Object next : this.paraErrors()) {
            if (next instanceof Expr) {
                Expr expr = (Expr)next;
                ErrorAnn errorAnn = (ErrorAnn)expr.accept((Visitor)this.postChecker());
                if (errorAnn == null) continue;
                paraErrors.add(errorAnn);
                continue;
            }
            if (!(next instanceof ErrorAnn)) continue;
            ErrorAnn errorAnn = (ErrorAnn)next;
            paraErrors.add(errorAnn);
        }
        this.paraErrors().clear();
        this.errors().addAll(paraErrors);
    }
}

