/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.czt.typecheck.z;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.base.ast.TermA;
import net.sourceforge.czt.base.visitor.TermVisitor;
import net.sourceforge.czt.print.z.PrintUtils;
import net.sourceforge.czt.session.Markup;
import net.sourceforge.czt.session.SectionInfo;
import net.sourceforge.czt.typecheck.z.ErrorAnn;
import net.sourceforge.czt.typecheck.z.ErrorMessage;
import net.sourceforge.czt.typecheck.z.TypeCheckUtils;
import net.sourceforge.czt.typecheck.z.TypeChecker;
import net.sourceforge.czt.typecheck.z.impl.Factory;
import net.sourceforge.czt.typecheck.z.impl.UnknownType;
import net.sourceforge.czt.typecheck.z.impl.VariableSignature;
import net.sourceforge.czt.typecheck.z.impl.VariableType;
import net.sourceforge.czt.typecheck.z.util.CarrierSet;
import net.sourceforge.czt.typecheck.z.util.GlobalDefs;
import net.sourceforge.czt.typecheck.z.util.ParameterAnn;
import net.sourceforge.czt.typecheck.z.util.SectTypeEnv;
import net.sourceforge.czt.typecheck.z.util.TypeEnv;
import net.sourceforge.czt.typecheck.z.util.UResult;
import net.sourceforge.czt.typecheck.z.util.UndeclaredAnn;
import net.sourceforge.czt.typecheck.z.util.UnificationEnv;
import net.sourceforge.czt.util.CztException;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.ast.AndPred;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.GenParamType;
import net.sourceforge.czt.z.ast.GenericType;
import net.sourceforge.czt.z.ast.GivenType;
import net.sourceforge.czt.z.ast.InStroke;
import net.sourceforge.czt.z.ast.LocAnn;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NameNamePair;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.NextStroke;
import net.sourceforge.czt.z.ast.Op;
import net.sourceforge.czt.z.ast.OutStroke;
import net.sourceforge.czt.z.ast.PowerExpr;
import net.sourceforge.czt.z.ast.PowerType;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.ProdExpr;
import net.sourceforge.czt.z.ast.ProdType;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchemaType;
import net.sourceforge.czt.z.ast.SetExpr;
import net.sourceforge.czt.z.ast.Signature;
import net.sourceforge.czt.z.ast.SignatureAnn;
import net.sourceforge.czt.z.ast.TupleExpr;
import net.sourceforge.czt.z.ast.Type;
import net.sourceforge.czt.z.ast.Type2;
import net.sourceforge.czt.z.ast.TypeAnn;
import net.sourceforge.czt.z.util.ZString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Checker
implements TermVisitor {
    protected TypeChecker typeChecker_;

    public Checker(TypeChecker typeChecker) {
        this.typeChecker_ = typeChecker;
    }

    public Object visitTerm(Term term) {
        this.logger().warning(this.getClass().getName() + " being asked to visit " + term.getClass().getName());
        return null;
    }

    protected void addTypeAnn(TermA termA, Type type) {
        assert (type != null);
        TypeAnn typeAnn = (TypeAnn)termA.getAnn(TypeAnn.class);
        if (typeAnn == null) {
            typeAnn = this.factory().createTypeAnn(type);
            termA.getAnns().add((Object)typeAnn);
        } else {
            typeAnn.setType(type);
        }
    }

    protected void addSignatureAnn(TermA termA, Signature signature) {
        assert (signature != null);
        SignatureAnn signatureAnn = (SignatureAnn)termA.getAnn(SignatureAnn.class);
        if (signatureAnn == null) {
            signatureAnn = this.factory().createSignatureAnn(signature);
            termA.getAnns().add((Object)signatureAnn);
        } else {
            Signature oldSignature = signatureAnn.getSignature();
            if (oldSignature instanceof VariableSignature && GlobalDefs.variableSignature(oldSignature).getValue() == oldSignature) {
                GlobalDefs.variableSignature(oldSignature).setValue(signature);
            } else {
                signatureAnn.setSignature(signature);
            }
        }
    }

    protected TypeAnn getTypeAnn(TermA termA) {
        TypeAnn typeAnn = (TypeAnn)termA.getAnn(TypeAnn.class);
        if (typeAnn == null) {
            typeAnn = this.factory().createTypeAnn();
            GlobalDefs.addAnn(termA, typeAnn);
        }
        return typeAnn;
    }

    protected Type2 getType2FromAnns(TermA termA) {
        Type annType = this.getTypeFromAnns(termA);
        Type2 result = GlobalDefs.unwrapType(annType);
        return result;
    }

    protected Type getTypeFromAnns(TermA termA) {
        UnknownType result = this.factory().createUnknownType();
        TypeAnn typeAnn = (TypeAnn)termA.getAnn(TypeAnn.class);
        if (typeAnn != null) {
            result = typeAnn.getType();
        }
        return result;
    }

    protected void error(ErrorAnn errorAnn) {
        this.paraErrors().add(errorAnn);
    }

    protected boolean addErrorAnn(TermA termA, ErrorAnn errorAnn) {
        for (Object ann : termA.getAnns()) {
            if (!(ann instanceof ErrorAnn)) continue;
            ErrorAnn existingAnn = (ErrorAnn)ann;
            if (!errorAnn.getErrorMessage().equals(existingAnn.getErrorMessage())) continue;
            return false;
        }
        termA.getAnns().add((Object)errorAnn);
        return true;
    }

    protected void error(TermA termA, ErrorAnn errorAnn) {
        boolean added = this.addErrorAnn(termA, errorAnn);
        if (added) {
            this.error(errorAnn);
        }
    }

    protected void error(TermA termA, ErrorMessage error, Object[] params) {
        ErrorAnn errorAnn = this.errorAnn(termA, error, params);
        this.error(termA, errorAnn);
    }

    protected void error(TermA termA, String error, Object[] params) {
        ErrorAnn errorAnn = this.errorAnn(termA, error, params);
        this.error(termA, errorAnn);
    }

    protected ErrorAnn errorAnn(TermA termA, ErrorMessage error, Object[] params) {
        ErrorAnn errorAnn = this.exprChecker().errorAnn(termA, error.toString(), params);
        return errorAnn;
    }

    protected ErrorAnn errorAnn(TermA termA, String error, Object[] params) {
        ErrorAnn errorAnn = new ErrorAnn(error, params, this.sectInfo(), this.sectName(), this.nearestLocAnn(termA), termA, this.markup());
        return errorAnn;
    }

    protected void removeError(TermA termA) {
        ListTerm anns = termA.getAnns();
        Iterator iter = anns.iterator();
        while (iter.hasNext()) {
            Object ann = iter.next();
            if (!(ann instanceof ErrorAnn)) continue;
            iter.remove();
            this.paraErrors().remove(ann);
        }
    }

    protected String format(Term term) {
        try {
            Term newTerm = (Term)term.accept((Visitor)this.exprChecker().getCarrierSet());
            StringWriter writer = new StringWriter();
            this.print(newTerm, writer, this.sectInfo(), this.sectName(), this.markup());
            return writer.toString();
        }
        catch (Exception e) {
            String message = "Cannot be printed";
            e.printStackTrace();
            return message;
        }
    }

    protected CarrierSet getCarrierSet() {
        return new CarrierSet();
    }

    protected void print(Term term, Writer writer, SectionInfo sectInfo, String sectName, Markup markup) {
        PrintUtils.print((Term)term, (Writer)writer, (SectionInfo)sectInfo, (String)sectName, (Markup)this.markup());
    }

    protected String position(TermA termA) {
        String result = "Unknown location: ";
        LocAnn locAnn = this.nearestLocAnn(termA);
        if (locAnn != null) {
            result = "\"" + locAnn.getLoc() + "\", ";
            result = result + "line " + locAnn.getLine() + ": ";
        } else {
            result = "No location information";
        }
        return result;
    }

    protected LocAnn nearestLocAnn(TermA termA) {
        LocAnn result = (LocAnn)termA.getAnn(LocAnn.class);
        if (result == null) {
            for (int i = 0; i < termA.getChildren().length; ++i) {
                Object next = termA.getChildren()[i];
                if (!(next instanceof TermA)) continue;
                LocAnn nextLocAnn = this.nearestLocAnn((TermA)next);
                return nextLocAnn;
            }
        }
        return result;
    }

    protected UResult unify(Type2 typeA, Type2 typeB) {
        return this.unificationEnv().unify(typeA, typeB);
    }

    protected UResult unify(Signature sigA, Signature sigB) {
        return this.unificationEnv().unify(sigA, sigB);
    }

    protected CarrierSet carrierSet() {
        return this.typeChecker_.carrierSet_;
    }

    protected Factory factory() {
        return this.typeChecker_.zFactory_;
    }

    protected SectTypeEnv sectTypeEnv() {
        return this.typeChecker_.sectTypeEnv_;
    }

    protected TypeEnv typeEnv() {
        return this.typeChecker_.typeEnv_;
    }

    protected TypeEnv pending() {
        return this.typeChecker_.pending_;
    }

    protected boolean isPending() {
        return this.typeChecker_.isPending_;
    }

    protected void setIsPending(boolean isPending) {
        this.typeChecker_.isPending_ = isPending;
    }

    protected UnificationEnv unificationEnv() {
        return this.typeChecker_.unificationEnv_;
    }

    protected SectionInfo sectInfo() {
        return this.typeChecker_.sectInfo_;
    }

    protected Markup markup() {
        return this.typeChecker_.markup_;
    }

    protected String sectName() {
        return this.typeChecker_.sectName_.toString();
    }

    protected void sectName(String sectName) {
        this.typeChecker_.sectName_.replace(0, this.typeChecker_.sectName_.length(), sectName);
    }

    protected List<ErrorAnn> errors() {
        return this.typeChecker_.errors_;
    }

    protected List<Object> paraErrors() {
        return this.typeChecker_.paraErrors_;
    }

    protected boolean useBeforeDecl() {
        return this.typeChecker_.useBeforeDecl_;
    }

    protected Logger logger() {
        return this.typeChecker_.logger_;
    }

    protected List typecheck(TermA termA, SectionInfo sectInfo) {
        return TypeCheckUtils.typecheck((Term)termA, sectInfo, this.markup());
    }

    protected Checker specChecker() {
        return this.typeChecker_.specChecker_;
    }

    protected Checker paraChecker() {
        return this.typeChecker_.paraChecker_;
    }

    protected Checker declChecker() {
        return this.typeChecker_.declChecker_;
    }

    protected Checker exprChecker() {
        return this.typeChecker_.exprChecker_;
    }

    protected Checker predChecker() {
        return this.typeChecker_.predChecker_;
    }

    protected Checker postChecker() {
        return this.typeChecker_.postChecker_;
    }

    protected void checkForDuplicates(List<NameTypePair> pairs, TermA termA) {
        this.checkForDuplicates(pairs, termA, ErrorMessage.TYPE_MISMATCH_IN_SIGNATURE.toString());
    }

    protected void checkForDuplicates(List<NameTypePair> pairs, TermA termA, String errorMessage) {
        for (int i = 0; i < pairs.size(); ++i) {
            NameTypePair first = pairs.get(i);
            for (int j = i + 1; j < pairs.size(); ++j) {
                Type2 secondType;
                NameTypePair second = pairs.get(j);
                if (!first.getName().equals(second.getName())) continue;
                Type2 firstType = GlobalDefs.unwrapType(first.getType());
                UResult unified = this.unify(firstType, secondType = GlobalDefs.unwrapType(second.getType()));
                if (unified == GlobalDefs.FAIL) {
                    Object[] params = null;
                    if (termA != null) {
                        params = new Object[]{second.getName(), termA, firstType, secondType};
                        this.error(termA, errorMessage, params);
                        continue;
                    }
                    params = new Object[]{second.getName(), firstType, secondType};
                    this.error((TermA)second.getName(), errorMessage, params);
                    continue;
                }
                pairs.remove(j--);
            }
        }
    }

    protected Signature createCompSig(Signature lSig, Signature rSig, TermA termA, String errorMessage) {
        List b3Pairs = GlobalDefs.list(lSig.getNameTypePair());
        List b4Pairs = GlobalDefs.list(rSig.getNameTypePair());
        ListTerm rPairs = rSig.getNameTypePair();
        for (NameTypePair rPair : rPairs) {
            Type2 rType;
            DeclName rName = rPair.getName();
            List<NextStroke> strokes = GlobalDefs.list(rName.getStroke());
            int size = strokes.size();
            strokes.add(this.factory().createNextStroke());
            DeclName sName = this.factory().createDeclName(rName.getWord(), strokes, null);
            NameTypePair foundPair = this.findNameTypePair(sName, lSig);
            if (foundPair == null) continue;
            Type2 fType = GlobalDefs.unwrapType(foundPair.getType());
            UResult unified = this.unify(fType, rType = GlobalDefs.unwrapType(rPair.getType()));
            if (unified == GlobalDefs.FAIL) {
                Object[] params = new Object[]{termA, sName, fType, rName, rType};
                this.error(termA, errorMessage, params);
            }
            b3Pairs.remove(foundPair);
            b4Pairs.remove(rPair);
        }
        b3Pairs.addAll(b4Pairs);
        Signature result = this.factory().createSignature(b3Pairs);
        return result;
    }

    protected Signature createPipeSig(Signature lSig, Signature rSig, TermA termA, String errorMessage) {
        List b3Pairs = GlobalDefs.list(lSig.getNameTypePair());
        List b4Pairs = GlobalDefs.list(rSig.getNameTypePair());
        ListTerm rPairs = rSig.getNameTypePair();
        for (NameTypePair rPair : rPairs) {
            Type2 rType;
            DeclName rName = rPair.getName();
            List<OutStroke> strokes = GlobalDefs.list(rName.getStroke());
            int size = strokes.size();
            if (size <= 0 || !(strokes.get(size - 1) instanceof InStroke)) continue;
            OutStroke out = this.factory().createOutStroke();
            strokes.set(size - 1, out);
            DeclName sName = this.factory().createDeclName(rName.getWord(), strokes, null);
            NameTypePair foundPair = this.findNameTypePair(sName, lSig);
            if (foundPair == null) continue;
            Type2 fType = GlobalDefs.unwrapType(foundPair.getType());
            UResult unified = this.unify(fType, rType = GlobalDefs.unwrapType(rPair.getType()));
            if (unified == GlobalDefs.FAIL) {
                Object[] params = new Object[]{termA, sName, fType, rName, rType};
                this.error(termA, errorMessage, params);
            }
            b3Pairs.remove(foundPair);
            b4Pairs.remove(rPair);
        }
        b3Pairs.addAll(b4Pairs);
        Signature result = this.factory().createSignature(b3Pairs);
        return result;
    }

    protected Signature createHideSig(Signature signature, List<RefName> refNames, TermA termA) {
        ListTerm pairs = signature.getNameTypePair();
        List newPairs = GlobalDefs.list(pairs);
        for (RefName refName : refNames) {
            DeclName declName = this.factory().createDeclName(refName);
            NameTypePair rPair = this.findNameTypePair(declName, signature);
            if (rPair == null) {
                Object[] params = new Object[]{termA, declName};
                this.error(termA, ErrorMessage.NON_EXISTENT_NAME_IN_HIDEEXPR, params);
                continue;
            }
            Iterator pIter = newPairs.iterator();
            while (pIter.hasNext()) {
                NameTypePair nPair = (NameTypePair)pIter.next();
                if (nPair != rPair) continue;
                pIter.remove();
            }
        }
        Signature result = this.factory().createSignature(newPairs);
        return result;
    }

    protected void checkForDuplicateRenames(List<NameNamePair> namePairs, TermA termA, String errorMessage) {
        List<RefName> oldNames = GlobalDefs.list();
        for (NameNamePair namePair : namePairs) {
            RefName oldName = namePair.getOldName();
            if (oldNames.contains(oldName)) {
                Object[] params = new Object[]{termA, oldName};
                this.error(termA, errorMessage, params);
            }
            oldNames.add(oldName);
        }
    }

    protected void renameUnknownTypes(Term term, Term topTerm, List<NameNamePair> pairs) {
        if (term instanceof UnknownType) {
            UnknownType uType = (UnknownType)term;
            uType.getPairs().addAll(pairs);
        } else {
            Object[] children = term.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] != null & children[i] instanceof Term) || children[i] == topTerm) continue;
                this.renameUnknownTypes((Term)children[i], topTerm, pairs);
            }
        }
    }

    protected Signature rename(Signature signature, List<NameNamePair> namePairs) {
        List<NameTypePair> newPairs = GlobalDefs.list();
        ListTerm pairs = signature.getNameTypePair();
        for (NameTypePair pair : pairs) {
            NameNamePair namePair = this.findNameNamePair(pair.getName(), namePairs);
            this.renameUnknownTypes((Term)pair.getType(), (Term)pair.getType(), namePairs);
            if (namePair != null) {
                DeclName newName = namePair.getNewName();
                NameTypePair newPair = this.factory().createNameTypePair(newName, pair.getType());
                newPairs.add(newPair);
                continue;
            }
            newPairs.add(pair);
        }
        Signature result = this.factory().createSignature(newPairs);
        return result;
    }

    protected Signature createRenameSig(Signature signature, List<NameNamePair> namePairs, TermA termA, String errorMessage) {
        this.checkForDuplicateRenames(namePairs, termA, errorMessage);
        Signature result = this.rename(signature, namePairs);
        return result;
    }

    protected UResult checkChainRelOp(AndPred andPred) {
        UResult result = GlobalDefs.SUCC;
        if (Op.Chain.equals((Object)andPred.getOp())) {
            Pred rightPred;
            Type2 lhsRight;
            Pred leftPred = andPred.getLeftPred();
            Type2 rhsLeft = this.getRightType(leftPred);
            UResult unified = this.unify(rhsLeft, lhsRight = this.getLeftType(rightPred = andPred.getRightPred()));
            if (unified == GlobalDefs.FAIL) {
                Object[] params = new Object[]{andPred, rhsLeft, lhsRight};
                this.error((TermA)andPred, ErrorMessage.TYPE_MISMATCH_IN_CHAIN_REL, params);
                result = GlobalDefs.FAIL;
            } else if (unified == GlobalDefs.PARTIAL) {
                result = GlobalDefs.PARTIAL;
            }
        }
        return result;
    }

    protected Type2 getLeftType(Pred pred) {
        MemPred memPred = (MemPred)pred;
        List<Type2> types = this.getLeftRightType(memPred);
        Type2 result = types.get(0);
        return result;
    }

    protected Type2 getRightType(Pred pred) {
        Type2 result = null;
        if (pred instanceof MemPred) {
            MemPred memPred = (MemPred)pred;
            List<Type2> types = this.getLeftRightType(memPred);
            result = types.get(1);
        } else if (pred instanceof AndPred) {
            AndPred andPred = (AndPred)pred;
            MemPred memPred = (MemPred)andPred.getRightPred();
            result = this.getRightType((Pred)memPred);
        }
        return result;
    }

    protected List<Type2> getLeftRightType(MemPred memPred) {
        List<Type2> result = GlobalDefs.list();
        Expr leftExpr = memPred.getLeftExpr();
        Expr rightExpr = memPred.getRightExpr();
        boolean mixfix = memPred.getMixfix();
        if (mixfix && rightExpr instanceof SetExpr) {
            result.add(this.getType2FromAnns((TermA)leftExpr));
            result.add(this.getBaseType(this.getType2FromAnns((TermA)rightExpr)));
        } else if (!mixfix) {
            result.add(this.getType2FromAnns((TermA)leftExpr));
            result.add(this.getType2FromAnns((TermA)rightExpr));
        } else if (leftExpr instanceof TupleExpr) {
            TupleExpr tupleExpr = (TupleExpr)leftExpr;
            result.add(this.getType2FromAnns((TermA)((Expr)tupleExpr.getExpr().get(0))));
            result.add(this.getType2FromAnns((TermA)((Expr)tupleExpr.getExpr().get(1))));
        } else {
            result.add(this.getType2FromAnns((TermA)leftExpr));
        }
        return result;
    }

    public Type2 getBaseType(Type2 type2) {
        UnknownType result = this.factory().createUnknownType();
        if (type2 instanceof PowerType) {
            PowerType powerType = (PowerType)type2;
            result = powerType.getType();
        } else if (type2 instanceof UnknownType) {
            result = type2;
        }
        return result;
    }

    protected Type instantiate(Type type) {
        UnknownType result = this.factory().createUnknownType();
        if (type instanceof GenericType) {
            GenericType gType = (GenericType)type;
            ListTerm declNames = gType.getName();
            Type2 firstType = gType.getType();
            Type2 optionalType = gType.getOptionalType();
            optionalType = optionalType == null ? this.exprChecker().instantiate(gType.getType(), GlobalDefs.list(gType.getType())) : this.exprChecker().instantiate(optionalType, GlobalDefs.list(optionalType));
            result = this.factory().createGenericType((List)declNames, firstType, optionalType);
        } else {
            Type2 type2 = (Type2)type;
            result = this.exprChecker().instantiate(type2, GlobalDefs.list(type2));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Type2 instantiate(Type2 type, List<Type2> preTypes) {
        void var3_17;
        UnknownType unknownType = this.factory().createUnknownType();
        if (type instanceof GenParamType) {
            GenParamType genParamType = (GenParamType)type;
            DeclName genName = genParamType.getName();
            Type2 unificationEnvType = this.unificationEnv().getType(genName);
            if (GlobalDefs.containsObject(this.typeEnv().getParameters(), genName) && this.isPending()) {
                Type2 type2 = type;
                return var3_17;
            } else if (unificationEnvType instanceof UnknownType && GlobalDefs.unknownType(unificationEnvType).getRefName() == null) {
                VariableType vType;
                VariableType variableType = vType = this.factory().createVariableType();
                this.unificationEnv().addGenName(genName, variableType);
                return var3_17;
            } else {
                if (!(unificationEnvType instanceof Type2)) throw new CztException("Cannot instantiate " + type);
                Type2 type2 = unificationEnvType;
            }
            return var3_17;
        } else if (type instanceof VariableType) {
            VariableType vType = (VariableType)type;
            if (vType.getValue() != vType) {
                Type2 type2 = this.exprChecker().instantiate(vType.getValue(), preTypes);
                return var3_17;
            } else {
                VariableType variableType = vType;
            }
            return var3_17;
        } else if (type instanceof PowerType) {
            PowerType powerType = (PowerType)type;
            if (GlobalDefs.containsObject(preTypes, powerType.getType())) {
                return powerType;
            }
            Type2 replaced = this.exprChecker().instantiate(powerType.getType(), preTypes);
            PowerType powerType2 = this.factory().createPowerType(replaced);
            return var3_17;
        } else if (type instanceof GivenType) {
            GivenType givenType = (GivenType)type;
            GivenType givenType2 = this.factory().createGivenType(givenType.getName());
            return var3_17;
        } else if (type instanceof SchemaType) {
            SchemaType schemaType = (SchemaType)type;
            Signature signature = this.exprChecker().instantiate(schemaType.getSignature(), preTypes);
            SchemaType schemaType2 = this.factory().createSchemaType(signature);
            return var3_17;
        } else if (type instanceof ProdType) {
            ProdType prodType = (ProdType)type;
            List<Type2> newTypes = this.exprChecker().instantiateTypes((List<Type2>)prodType.getType(), preTypes);
            ProdType prodType2 = this.factory().createProdType(newTypes);
            return var3_17;
        } else {
            if (!(type instanceof UnknownType)) return var3_17;
            UnknownType uType = (UnknownType)type;
            RefName refName = uType.getRefName();
            if (refName != null) {
                ParameterAnn pAnn = (ParameterAnn)refName.getAnn(ParameterAnn.class);
                List<Type2> types = uType.getType();
                if (pAnn != null && types.size() == 0) {
                    types.addAll(pAnn.getParameters());
                }
                boolean isMem = uType.getIsMem();
                List<Type2> newTypes = this.exprChecker().instantiateTypes(types, preTypes);
                UnknownType unknownType2 = this.factory().createUnknownType(refName, isMem, newTypes);
                return var3_17;
            } else {
                UnknownType unknownType3 = uType;
            }
        }
        return var3_17;
    }

    protected Signature instantiate(Signature signature, List<Type2> preTypes) {
        ListTerm pairs = signature.getNameTypePair();
        List<NameTypePair> newPairs = this.exprChecker().instantiatePairs((List<NameTypePair>)pairs, preTypes);
        Signature result = this.factory().createSignature(newPairs);
        return result;
    }

    protected List<NameTypePair> instantiatePairs(List<NameTypePair> pairs, List<Type2> preTypes) {
        List<NameTypePair> newPairs = GlobalDefs.list();
        for (NameTypePair pair : pairs) {
            if (GlobalDefs.containsObject(preTypes, pair.getType()) || pair.getType() instanceof GenericType) {
                newPairs.add(pair);
                continue;
            }
            Type2 replaced = this.exprChecker().instantiate(GlobalDefs.unwrapType(pair.getType()), preTypes);
            NameTypePair newPair = this.factory().createNameTypePair(pair.getName(), (Type)replaced);
            newPairs.add(newPair);
        }
        return newPairs;
    }

    protected List<Type2> instantiateTypes(List<Type2> types, List<Type2> preTypes) {
        List<Type2> newTypes = GlobalDefs.list();
        for (Type2 type : types) {
            if (GlobalDefs.containsObject(preTypes, type)) {
                newTypes.add(type);
                continue;
            }
            Type2 replaced = this.exprChecker().instantiate(type, preTypes);
            newTypes.add(replaced);
        }
        return newTypes;
    }

    protected Type addGenerics(Type2 type) {
        Object result = null;
        List<DeclName> params = this.typeEnv().getParameters();
        result = params.size() > 0 ? this.factory().createGenericType(params, type, null) : type;
        return result;
    }

    public void addGenParamTypes(List<DeclName> declNames) {
        this.typeEnv().addParameters(declNames);
        List<String> names = GlobalDefs.list();
        for (DeclName declName : declNames) {
            GenParamType genParamType = this.factory().createGenParamType(declName);
            PowerType powerType = this.factory().createPowerType((Type2)genParamType);
            if (names.contains(declName.getWord())) {
                Object[] params = new Object[]{declName};
                this.error((TermA)declName, ErrorMessage.REDECLARED_GEN, params);
            } else {
                names.add(declName.getWord());
            }
            this.typeEnv().add(declName, (Type)powerType);
        }
    }

    protected Type getType(RefName name) {
        this.setIsPending(false);
        Type type = this.typeEnv().getType(name);
        if (type instanceof UnknownType && (!((type = this.pending().getType(name)) instanceof UnknownType) || type instanceof UnknownType && GlobalDefs.unknownType(type).getRefName() != null)) {
            this.setIsPending(true);
        }
        if (type instanceof UnknownType) {
            Type sectTypeEnvType = this.sectTypeEnv().getType(name);
            if (!GlobalDefs.instanceOf(sectTypeEnvType, UnknownType.class)) {
                type = sectTypeEnvType;
            } else {
                UnknownType uType = (UnknownType)sectTypeEnvType;
                RefName refName = uType.getRefName();
                if (refName != null && !name.equals(refName)) {
                    type = this.exprChecker().resolveUnknownType((Type2)uType);
                }
            }
        }
        if (type instanceof UnknownType && GlobalDefs.unknownType(type).getRefName() == null) {
            UndeclaredAnn ann = new UndeclaredAnn();
            name.getAnns().add((Object)ann);
        } else {
            GlobalDefs.removeAnn((TermA)name, UndeclaredAnn.class);
        }
        return type;
    }

    protected Type2 resolveUnknownType(Type2 type) {
        Type2 result = type;
        if (this.sectTypeEnv().getSecondTime() && type instanceof UnknownType) {
            UnknownType uType = (UnknownType)type;
            RefName refName = uType.getRefName();
            if (refName != null) {
                Type refType = this.getType(refName);
                if (refType instanceof GenericType) {
                    ListTerm names = GlobalDefs.genericType(refType).getName();
                    List<Type2> types = uType.getType();
                    if (names.size() == types.size()) {
                        Type newType;
                        this.unificationEnv().enterScope();
                        for (int i = 0; i < names.size(); ++i) {
                            this.unificationEnv().addGenName((DeclName)names.get(i), types.get(i));
                        }
                        refType = newType = this.exprChecker().instantiate(refType);
                        this.unificationEnv().exitScope();
                    } else {
                        refType = type;
                    }
                }
                if (uType.getIsMem() && GlobalDefs.unwrapType(refType) instanceof PowerType) {
                    result = GlobalDefs.powerType(GlobalDefs.unwrapType(refType)).getType();
                } else if (!uType.getIsMem()) {
                    result = GlobalDefs.unwrapType(refType);
                }
            }
            if (uType.getPairs().size() > 0 && result instanceof SchemaType) {
                Signature signature = GlobalDefs.schemaType(result).getSignature();
                List<NameNamePair> pairs = uType.getPairs();
                Signature newSig = this.createRenameSig(signature, uType.getPairs(), null, null);
                result = this.factory().createSchemaType(newSig);
            }
        } else if (this.sectTypeEnv().getSecondTime() && type instanceof PowerType && GlobalDefs.powerType(type).getType() instanceof UnknownType) {
            Type2 resolved = this.exprChecker().resolveUnknownType(GlobalDefs.powerType(type).getType());
            result = this.factory().createPowerType(resolved);
        }
        return result;
    }

    protected NameTypePair findNameTypePair(DeclName declName, Signature signature) {
        ListTerm pairs = signature.getNameTypePair();
        NameTypePair result = this.findNameTypePair(declName, (List<NameTypePair>)pairs);
        return result;
    }

    protected NameTypePair findNameTypePair(RefName refName, Signature signature) {
        DeclName declName = this.factory().createDeclName(refName);
        return this.findNameTypePair(declName, signature);
    }

    protected NameNamePair findNameNamePair(DeclName declName, List<NameNamePair> pairs) {
        RefName refName = this.factory().createRefName(declName);
        return this.findNameNamePair(refName, pairs);
    }

    protected NameNamePair findNameNamePair(RefName refName, List<NameNamePair> pairs) {
        NameNamePair result = null;
        for (NameNamePair pair : pairs) {
            if (!pair.getOldName().equals(refName)) continue;
            result = pair;
            break;
        }
        return result;
    }

    protected NameTypePair findNameTypePair(DeclName declName, List<NameTypePair> pairs) {
        NameTypePair result = null;
        for (NameTypePair pair : pairs) {
            if (!pair.getName().equals(declName)) continue;
            result = pair;
            break;
        }
        return result;
    }

    protected NameTypePair findNameTypePair(RefName refName, List<NameTypePair> pairs) {
        DeclName declName = this.factory().createDeclName(refName);
        return this.findNameTypePair(declName, pairs);
    }

    protected void removeTypeAnns(Term term) {
        TermA termA;
        Object ann;
        if (term instanceof TermA && (ann = (termA = (TermA)term).getAnn(TypeAnn.class)) != null) {
            GlobalDefs.removeAnn(termA, ann);
        }
        Object[] children = term.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Object next = children[i];
            if (next == null || !(next instanceof Term)) continue;
            this.removeTypeAnns((Term)next);
        }
    }

    protected void removeErrorAnns(Term term) {
        if (term instanceof TermA) {
            TermA termA = (TermA)term;
            Object ann = termA.getAnn(ErrorAnn.class);
            while (ann != null) {
                GlobalDefs.removeAnn(termA, ann);
                ann = termA.getAnn(ErrorAnn.class);
            }
        }
    }

    protected void removeErrorAndTypeAnns(Term term) {
        if (term instanceof TermA) {
            TermA termA = (TermA)term;
            Object ann = termA.getAnn(TypeAnn.class);
            if (ann != null) {
                GlobalDefs.removeAnn(termA, ann);
            }
            if ((ann = termA.getAnn(SignatureAnn.class)) != null) {
                GlobalDefs.removeAnn(termA, ann);
            }
            ann = termA.getAnn(ErrorAnn.class);
            while (ann != null) {
                GlobalDefs.removeAnn(termA, ann);
                ann = termA.getAnn(ErrorAnn.class);
            }
        }
        Object[] children = term.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Object next = children[i];
            if (next == null || !(next instanceof Term)) continue;
            this.removeErrorAndTypeAnns((Term)next);
        }
    }

    public String toString(Type type) {
        return type.toString();
    }

    protected boolean debug() {
        return TypeChecker.debug_;
    }

    protected void setDebug(boolean b) {
        TypeChecker.debug_ = b;
    }

    protected void debug(String message) {
        if (this.debug()) {
            System.err.println(message);
        }
    }

    protected boolean isFinity(Expr expr) {
        boolean result;
        block5: {
            block4: {
                result = true;
                if (!(expr instanceof RefExpr)) break block4;
                RefExpr refE = (RefExpr)expr;
                if (!refE.getRefName().getWord().equals(ZString.NAT) && !refE.getRefName().getWord().equals(ZString.ARITHMOS)) break block5;
                result = false;
                break block5;
            }
            if (expr instanceof PowerExpr) {
                result = this.isFinity(((PowerExpr)expr).getExpr());
            } else if (expr instanceof ProdExpr) {
                Expr e;
                ListTerm exprs = ((ProdExpr)expr).getExpr();
                Iterator i$ = exprs.iterator();
                while (i$.hasNext() && (result = this.isFinity(e = (Expr)i$.next()))) {
                }
            }
        }
        return result;
    }
}

