/*
 * Decompiled with CFR 0.152.
 */
package circparser.formw.expression;

import circparser.formw.TermAImpl;
import circparser.formw.expression.ApplicationExpression;
import circparser.formw.expression.Expression;
import circparser.formw.expression.arithmetic.NegationArithExpression;
import circparser.formw.expression.set.PowerSet;
import circparser.formw.toolkit.FiniteSet;
import circparser.formw.toolkit.NonEmptyFiniteSet;
import circparser.formw.toolkit.NonEmptyPowerSet;
import circparser.formw.toolkit.NonEmptySequence;
import circparser.formw.toolkit.Sequence;
import circparser.formw.toolkit.prefix.Cardinality;
import circparser.formw.toolkit.prefix.Disjointness;
import circparser.formw.toolkit.prefix.DistributedConcatenation;
import circparser.formw.toolkit.prefix.Domain;
import circparser.formw.toolkit.prefix.First;
import circparser.formw.toolkit.prefix.Front;
import circparser.formw.toolkit.prefix.GeneralizedSetIntersection;
import circparser.formw.toolkit.prefix.GeneralizedSetUnion;
import circparser.formw.toolkit.prefix.Head;
import circparser.formw.toolkit.prefix.Identity;
import circparser.formw.toolkit.prefix.InjectiveSequence;
import circparser.formw.toolkit.prefix.Items;
import circparser.formw.toolkit.prefix.Iteration;
import circparser.formw.toolkit.prefix.Last;
import circparser.formw.toolkit.prefix.Maximum;
import circparser.formw.toolkit.prefix.Minimum;
import circparser.formw.toolkit.prefix.Range;
import circparser.formw.toolkit.prefix.Reverse;
import circparser.formw.toolkit.prefix.Second;
import circparser.formw.toolkit.prefix.Squash;
import circparser.formw.toolkit.prefix.Successor;
import circparser.formw.toolkit.prefix.Tail;

public class PrefixExpressionMounter {
    public static Expression mountExpression(Expression exp, String op) {
        TermAImpl result = null;
        if (op.equals("\\power")) {
            result = new PowerSet(exp);
        } else if (op.equals("first")) {
            result = new First(exp);
        } else if (op.equals("second")) {
            result = new Second(exp);
        } else if (op.equals("\\dom")) {
            result = new Domain(exp);
        } else if (op.equals("\\ran")) {
            result = new Range(exp);
        } else if (op.equals("\\finset")) {
            result = new FiniteSet(exp);
        } else if (op.equals("\\id")) {
            result = new Identity(exp);
        } else if (op.equals("\\negate")) {
            result = new NegationArithExpression(exp);
        } else if (op.equals("items")) {
            result = new Items(exp);
        } else if (op.equals("\\seq")) {
            result = new Sequence(exp);
        } else if (op.equals("\\iseq")) {
            result = new InjectiveSequence(exp);
        } else if (op.equals("rev")) {
            result = new Reverse(exp);
        } else if (op.equals("head")) {
            result = new Head(exp);
        } else if (op.equals("tail")) {
            result = new Tail(exp);
        } else if (op.equals("last")) {
            result = new Last(exp);
        } else if (op.equals("front")) {
            result = new Front(exp);
        } else if (op.equals("squash")) {
            result = new Squash(exp);
        } else if (op.equals("\\dcat")) {
            result = new DistributedConcatenation(exp);
        } else if (op.equals("\\disjoint")) {
            result = new Disjointness(exp);
        } else if (op.equals("\\#")) {
            result = new Cardinality(exp);
        } else if (op.equals("\\power_1")) {
            result = new NonEmptyPowerSet(exp);
        } else if (op.equals("\\finset_1")) {
            result = new NonEmptyFiniteSet(exp);
        } else if (op.equals("min")) {
            result = new Minimum(exp);
        } else if (op.equals("max")) {
            result = new Maximum(exp);
        } else if (op.equals("\\seq_1")) {
            result = new NonEmptySequence(exp);
        } else if (op.equals("succ")) {
            result = new Successor(exp);
        } else if (op.equals("\\bigcap")) {
            result = new GeneralizedSetIntersection(exp);
        } else if (op.equals("\\bigcup")) {
            result = new GeneralizedSetUnion(exp);
        } else if (op.equals("iter") && exp instanceof ApplicationExpression) {
            result = new Iteration(exp);
        }
        if (result == null) {
            System.out.println("ERRO: PrefixExpressionMounter - operador: " + op + " nao reconhecido!");
        }
        return result;
    }
}

