package Parser.mdl;
import java.io.IOException;

%%

%class Lexer
%unicode
%type int
%public
%implements Token
%line
%column

%{
	StringBuffer string = new StringBuffer();
	String token;
	int code;
	int nextToken() {
		try {
			code = yylex();
			//System.out.println("Getting token "+token+" ("+code+")\n");
		} catch (IOException e) {
			e.printStackTrace();
		}
		return code;
	}
	int getToken() {
		return code;
	}
	String getSemantic() {
		return token;
	}
	 public static void main(String[] args) {
		String filename = args[0];
        Lexer scanner = null;
        try {
          scanner = new Lexer( new java.io.FileReader(filename) );
          while (scanner.nextToken()!=ENDINPUT) {
            System.out.print(scanner.getToken()+"\t\t");
            System.out.println(scanner.getSemantic());
          } 

        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+filename+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+filename+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
%}

%eofval{
	return ENDINPUT;
%eofval}

LineTerminator = \r|\n|\r\n

WhiteSpace = {LineTerminator} | [ \t\f]

Identifier = [:jletter:] ([:jletterdigit:]|\.)*

Integer = (\+|-)?(0 | [1-9][0-9]*)

NaN = NaN

Real = (\+|-)?([0-9]+\.[0-9]+)

Comment = # .*

%state YYSTRING
%state YYARRAY

%%

<YYINITIAL> {
{NaN}				{ token = yytext(); return NAN; }
{Identifier}		{ token = yytext(); return IDENTIFIER; }
{Integer}			{ token = yytext(); return INTEGER; }
{Real}				{ token = yytext(); return REAL; }
\"					{ string.setLength(0); yybegin(YYSTRING); }
\{					{ token = yytext(); return OPENBLOCK; }
\}					{ token = yytext(); return CLOSEBLOCK; }
"["					{ token = yytext(); yybegin(YYARRAY); }
{Comment}			{ token = yytext(); return COMMENT; }
{WhiteSpace}		{}
{LineTerminator}	{}
}

<YYSTRING> {
\"					{ yybegin(YYINITIAL); token = string.toString(); return STRING; }
\\\\				{ string.append("\\\\"); }
\\\"				{ string.append("\\\""); }
[^\"]				{ string.append( yytext() ); }
}

<YYARRAY> {
{Integer}				{ token += yytext(); }
{Real}				{ token += yytext(); }
{NaN}				{ token += yytext(); }
";"					{ token += yytext(); }
","					{ token += yytext(); }
" "					{ token += yytext(); }
"]"					{ token += yytext(); yybegin(YYINITIAL); return ARRAY; }
.|\n    			{ System.err.println("Error: unexpected character '"+yytext()+"' on line "+yyline+", column "+yycolumn); return -1; }
}

\b     { System.err.println("Error: backspace doesn't work"); return -1; }

/* error fallback */
.|\n    { System.err.println("Error: unexpected character '"+yytext()+"' on line "+yyline+", column "+yycolumn); return -1;}