package Parser.stateflow;
import java.io.IOException;

%%

%class Lexer
%int
%public
%implements Token

%{
	int code;
	String token;
	int nextToken() {
		try {
			code = yylex();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return code;
	}
	int getToken() {
		return code;
	}
	String getSemantic() {
		return token;
	}
%}

%eofval{
	return ENDINPUT;
%eofval}
ELLIPSIS = "..." //(\\n | \\r | \\r\\n)
WHITESPACES = [ \t]+

ENTRY = "entry" | "en"
DURING = "during" | "du"
EXIT = "exit" | "ex"
BIND = "bind"
ON = "on"

SEND = "send"

ASSIGNMENT = "=" | ":="
ASSIGN_AND = "&="
ASSIGN_DIV = "/="
ASSIGN_MINUS = "-="
ASSIGN_MULT = "*="
ASSIGN_OR = "|="
ASSIGN_PLUS = "+="
ASSIGN_XOR = "^="
INC = "++"
DEC = "--"

AFTER = "after"
BEFORE = "before"
AT = "at"
EVERY = "every"
TEMPORALCOUNT = "temporalCount"
SEND = "send"

EQ = "=="
GEQ = ">="
MOD = "%%"
LAND = "&&"
LEQ = "<="
LOR = "||"
LSHIFT = "<<"
NEQ = "<>" | "!=" | "~="
NL  = "\\n" | "\\r" | "\\r\\n"
RNL = \n | \r | \r\n
RSHIFT = ">>"

INTEGER = [0-9]+
IDENTIFIER = [:jletter:] [:jletterdigit:]* ("." [:jletter:] [:jletterdigit:]*)*
FLOAT = [0-9]+("." [0-9]+)
STRING = \"([^\"]|\\\")*\"

%%
"&" | "|" | "^" | "~" | "!" | "," | ";" | "+" | "-" | "*" | "/" | "<" | ">" | "(" | ")" | ":" | "[" | "]" | "{" | "}" { return (int) yycharat(0); }

{ELLIPSIS} { }
{WHITESPACES} { }
{NL} {}
{RNL} {}

/* action types */
{ENTRY} { return ENTRY; }
{DURING} { return DURING; }
{EXIT} { return EXIT; }
{BIND} { return BIND; }
{ON} { return ON; }

{SEND} { return SEND; }

/* actions */
{ASSIGNMENT} { return ASSIGNMENT; }
{ASSIGN_AND} { return ASSIGN_AND; }
{ASSIGN_DIV} { return ASSIGN_DIV; }
{ASSIGN_MINUS} { return ASSIGN_MINUS; }
{ASSIGN_MULT} { return ASSIGN_MULT; }
{ASSIGN_OR} { return ASSIGN_OR; }
{ASSIGN_PLUS} { return ASSIGN_PLUS; }
{ASSIGN_XOR} { return ASSIGN_XOR; }
{INC} { return INC; }
{DEC} { return DEC; }
{SEND} { return SEND; }

/* temporal expressions */
{AFTER}				{ return AFTER; }
{BEFORE}			{ return BEFORE; }
{AT}				{ return AT; }
{EVERY}				{ return EVERY; }
{TEMPORALCOUNT}		{ return TEMPORALCOUNT; }

/* expressions */
{EQ} { return EQ; }
{GEQ} { return GEQ; }
{LAND} { return LAND; }
{LEQ} { return LEQ; }
{LOR} { return LOR; }
{NEQ} { return NEQ; }
{MOD} { return MOD; }
{LSHIFT} { return LSHIFT; }
{RSHIFT}  { return RSHIFT; }

{FLOAT} { token = yytext(); return FLOAT; }
{IDENTIFIER} { token = yytext().replaceAll("_", "\\\\_"); return IDENTIFIER; }
{INTEGER}  { token = yytext(); return INTEGER; }
{STRING} { return STRING; }

\b     { System.err.println("Sorry, backspace doesn't work"); }

/* error fallback */
[^]    { System.err.println("Error: unexpected character '"+yytext()+"'"); return -1; }
