/*
 * Decompiled with CFR 0.152.
 */
package ui.text;

import Parser.mdl.ParsingException;
import circussyntax.CircustoLatex;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import translator.NameGeneratorLatex;
import translator.translator;
import ui.LogOutput;
import ui.Output;
import ui.TextOutput;

public class TextInterface {
    public static void inputerror() {
        System.out.println("\nInput format: s2c [input] [-o output] [-l libraries]\n\nIf no parameters are supplied, the graphical interface will be used.\nIf no output is supplied, the output will be written to the file input.tex.\n");
    }

    public static void rungui() {
        System.out.println("Opening GUI.");
    }

    public static String getinput(String[] args) {
        if (args.length == 0) {
            return null;
        }
        if (args[0].equals("-o") || args[0].equals("-l")) {
            TextInterface.inputerror();
            return null;
        }
        int l = args[0].lastIndexOf(".mdl");
        if (l < 0) {
            return String.valueOf(args[0]) + ".mdl";
        }
        return args[0];
    }

    public static String getoutput(String[] args) {
        int j = -1;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-o")) {
                j = i;
            }
            ++i;
        }
        if (j >= 0) {
            if (args[j + 1].equals("-l") || j + 1 >= args.length) {
                TextInterface.inputerror();
                return null;
            }
            return args[j + 1];
        }
        String input = TextInterface.getinput(args);
        if (input == null) {
            return null;
        }
        String output = input.substring(0, input.lastIndexOf(".mdl"));
        output = String.valueOf(output) + ".tex";
        return output;
    }

    public static List<String> getlibraries(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-l")) break;
            ++i;
        }
        if (i == args.length) {
            return new LinkedList<String>();
        }
        int j = i + 1;
        while (j < args.length) {
            if (args[j].equals("-o")) break;
            ++j;
        }
        if (i == j - 1) {
            TextInterface.inputerror();
            return null;
        }
        LinkedList<String> libs = new LinkedList<String>();
        int aux = i + 1;
        while (aux < j) {
            libs.add(args[aux].replaceAll("_", "\\\\_"));
            ++aux;
        }
        return libs;
    }

    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            String file = "C:\\Users\\Alvaro\\workspace\\Stateflow2Circus\\examples\\functionstest.mdl";
            try {
                NameGeneratorLatex _n = new NameGeneratorLatex();
                CircustoLatex _c = new CircustoLatex(_n);
                TextOutput _o = new TextOutput();
                translator t2 = new translator(_c, _n, _o);
                String spec = t2.translate(file, new LinkedList<String>());
                System.out.println(spec);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else {
            String input = TextInterface.getinput(args);
            String output = TextInterface.getoutput(args);
            List<String> libraries = TextInterface.getlibraries(args);
            if (input == null || output == null || libraries == null) {
                return;
            }
            Writer writer = null;
            Output _o = null;
            try {
                try {
                    NameGeneratorLatex _n = new NameGeneratorLatex();
                    CircustoLatex _c = new CircustoLatex(_n);
                    _o = new LogOutput(String.valueOf(output.substring(0, input.lastIndexOf(".mdl"))) + ".log");
                    translator t3 = new translator(_c, _n, _o);
                    String spec = t3.translate(input, libraries);
                    File file = new File(output);
                    writer = new BufferedWriter(new FileWriter(file));
                    writer.write(spec);
                }
                catch (FileNotFoundException e3) {
                    e3.printStackTrace();
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        if (_o != null) {
                            _o.close();
                        }
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        if (_o != null) {
                            _o.close();
                        }
                    }
                    catch (IOException e6) {
                        e6.printStackTrace();
                    }
                }
                catch (ParsingException e7) {
                    e7.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        if (_o != null) {
                            _o.close();
                        }
                    }
                    catch (IOException e8) {
                        e8.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (_o != null) {
                        _o.close();
                    }
                }
                catch (IOException e9) {
                    e9.printStackTrace();
                }
            }
        }
    }
}

