/*
 * Decompiled with CFR 0.152.
 */
package circussyntax;

import circussyntax.CircusSyntax;
import java.util.List;
import translator.NameGenerator;
import zsyntax.Pair;
import zsyntax.ZtoLatex;

public class CircustoLatex
extends ZtoLatex
implements CircusSyntax {
    private String par(String s) {
        return "(" + s + ")";
    }

    private String block(String s) {
        return "\\circblockbegin " + s + " \\circblockend ";
    }

    public CircustoLatex(NameGenerator names) {
        super(names);
    }

    @Override
    public String csname(String n) {
        return n;
    }

    @Override
    public String cs(List<String> ns) {
        String r = "\\lchanset ";
        if (ns.size() > 0) {
            r = String.valueOf(r) + ns.get(0);
        }
        int i = 1;
        while (i < ns.size()) {
            r = String.valueOf(r) + ", " + ns.get(i);
            ++i;
        }
        r = String.valueOf(r) + " \\rchanset";
        return r;
    }

    @Override
    public String csunion(String cs1, String cs2) {
        return String.valueOf(cs1) + " \\cup " + cs2;
    }

    @Override
    public String csinter(String cs1, String cs2) {
        return String.valueOf(cs1) + " \\cap " + cs2;
    }

    @Override
    public String csminus(String cs1, String cs2) {
        return String.valueOf(cs1) + " \\setminus " + cs2;
    }

    @Override
    public String program(List<String> pars) {
        String r = "";
        if (pars.size() > 0) {
            r = pars.get(0);
            int i = 1;
            while (i < pars.size()) {
                r = String.valueOf(r) + "\n\n" + pars.get(i);
                ++i;
            }
        }
        return r;
    }

    @Override
    public String zparagraphdeclaration(String par) {
        return par;
    }

    @Override
    public String channeldeclaration(String cdecl) {
        String r = "\\begin{circus}\n";
        r = String.valueOf(r) + "\\circchannel " + cdecl + "\n";
        r = String.valueOf(r) + "\\end{circus}";
        return r;
    }

    @Override
    public String channelsetdeclaration(String name, String csexp) {
        String r = "\\begin{circus}\n";
        r = String.valueOf(r) + "\\circchannelset " + name + " == csexp\n\\end{circus}";
        return r;
    }

    @Override
    public String processdeclaration(String procdecl) {
        return "\\begin{circus}\n" + procdecl + "\n\\end{circus}";
    }

    @Override
    public String cdecl(List<String> ds) {
        if (ds.size() < 1) {
            throw new RuntimeException("A channel declaration paragraph must contain at least one channel declaration.\n");
        }
        String r = ds.get(0);
        int i = 1;
        while (i < ds.size()) {
            r = String.valueOf(r) + "\\\\\n" + ds.get(i);
            ++i;
        }
        return r;
    }

    @Override
    public String simplecdecl(List<String> ns) {
        if (ns.size() < 1) {
            throw new RuntimeException("A channel declaration must contain at least one channel name.\n");
        }
        String r = ns.get(0);
        int i = 1;
        while (i < ns.size()) {
            r = String.valueOf(r) + ", " + ns.get(i);
            ++i;
        }
        return r;
    }

    @Override
    public String typedsimplecdecl(List<String> ns, String e2) {
        return String.valueOf(this.simplecdecl(ns)) + ": " + e2;
    }

    @Override
    public String genericcdecl(List<String> formals, List<String> ns, String e2) {
        if (formals.size() < 1) {
            throw new RuntimeException("A generic channel declaratoin must contain at least one parameter.\n");
        }
        String r = "\\circchannel [" + formals.get(0);
        int i = 1;
        while (i < formals.size()) {
            r = String.valueOf(r) + ", " + formals.get(i);
            ++i;
        }
        r = String.valueOf(r) + "] " + this.typedsimplecdecl(ns, e2);
        return r;
    }

    @Override
    public String simpleprocessdeclaration(String n, String procdef) {
        String r = "\\circprocess " + n + " \\circdef " + procdef;
        return r;
    }

    @Override
    public String genericprocessdeclaration(String n, List<String> formals, String procdef) {
        if (formals.size() < 1) {
            throw new RuntimeException("A generic process delcaration must declare at least one parameter.\n");
        }
        String r = "\\circprocess " + n + "[" + formals.get(0);
        int i = 1;
        while (i < formals.size()) {
            r = String.valueOf(r) + ", " + formals.get(i);
            ++i;
        }
        r = String.valueOf(r) + "] \\circdef " + procdef;
        return r;
    }

    @Override
    public String processdefinition(String proc) {
        return proc;
    }

    @Override
    public String parameterisedprocessdefinition(String declpart, String proc) {
        return String.valueOf(declpart) + " \\circspot " + proc;
    }

    @Override
    public String indexedprocessdefinition(String declpart, String proc) {
        return String.valueOf(declpart) + " \\circindex " + proc;
    }

    @Override
    public String proc(List<String> ppar1, String e2, List<String> ppar2, String action2) {
        String r = "\\circbegin\\\\\n\\end{circus}\n\n";
        for (String s : ppar1) {
            r = String.valueOf(r) + s + "\n\n";
        }
        r = String.valueOf(r) + "\\begin{circusaction}\n\\circstate " + e2 + "\n\\end{circusaction}\n\n";
        for (String s : ppar2) {
            r = String.valueOf(r) + s + "\n\n";
        }
        r = String.valueOf(r) + "\\begin{circusaction}\n\\circspot " + action2 + "\\\\\n\\end{circusaction}\n\n\\begin{circus}\n\\circend";
        return r;
    }

    @Override
    public String processsequentialcomposition(String p1, String p2) {
        return String.valueOf(p1) + " \\circseq " + p2;
    }

    @Override
    public String processexternalchoice(String p1, String p2) {
        return String.valueOf(p1) + " \\extchoice " + p2;
    }

    @Override
    public String processinternalchoice(String p1, String p2) {
        return String.valueOf(p1) + " \\intchoice " + p2;
    }

    @Override
    public String processparallelcomposition(String p1, String csexp, String p2) {
        return String.valueOf(p1) + " \\lpar " + csexp + " \\rpar " + p2;
    }

    @Override
    public String processinterleave(String p1, String p2) {
        return String.valueOf(p1) + " \\interleave " + p2;
    }

    @Override
    public String processhiding(String p, String csexp) {
        return String.valueOf(p) + "\\circhide " + csexp;
    }

    @Override
    public String processinstantiation(String declpart, String procdef, List<String> es) {
        if (es.size() < 1) {
            throw new RuntimeException("A process instantiation must contain at least one instantiating expression.\n");
        }
        String r = "(" + declpart + " \\circspot " + procdef + ")(" + es.get(0);
        int i = 1;
        while (i < es.size()) {
            r = String.valueOf(r) + ", " + es.get(i);
            ++i;
        }
        r = String.valueOf(r) + ")";
        return r;
    }

    @Override
    public String processcallinstantiation(String n, List<String> es) {
        if (es.size() < 1) {
            throw new RuntimeException("A process instantiation must contain at least one instantiating expression.\n");
        }
        String r = String.valueOf(n) + "(" + es.get(0);
        int i = 1;
        while (i < es.size()) {
            r = String.valueOf(r) + ", " + es.get(i);
            ++i;
        }
        r = String.valueOf(r) + ")";
        return r;
    }

    @Override
    public String processcall(String n) {
        return n;
    }

    @Override
    public String indexedprocessinstantiation(String declpart, String procdef, List<String> es) {
        if (es.size() < 1) {
            throw new RuntimeException("A process instantiation must contain at least one instantiating expression.\n");
        }
        String r = "(" + declpart + " \\circindex " + procdef + ")(" + es.get(0);
        int i = 1;
        while (i < es.size()) {
            r = String.valueOf(r) + ", " + es.get(i);
            ++i;
        }
        r = String.valueOf(r) + ")";
        return r;
    }

    @Override
    public String indexedprocesscallinstantiation(String n, List<String> es) {
        if (es.size() < 1) {
            throw new RuntimeException("A process instantiation must contain at least one instantiating expression.\n");
        }
        String r = String.valueOf(n) + "(" + es.get(0);
        int i = 1;
        while (i < es.size()) {
            r = String.valueOf(r) + ", " + es.get(i);
            ++i;
        }
        r = String.valueOf(r) + ")";
        return r;
    }

    @Override
    public String processrenaming(String proc, List<String> ns1, List<String> ns2) {
        if (ns1.size() != ns2.size() || ns1.size() < 1) {
            throw new RuntimeException("The number of old names and new names must be the same, and there must be at least one such pair.\n");
        }
        String oldnames = ns1.get(0);
        String newnames = ns2.get(0);
        int i = 1;
        while (i < ns1.size()) {
            oldnames = String.valueOf(oldnames) + ", " + ns1.get(i);
            newnames = String.valueOf(newnames) + ", " + ns2.get(i);
            ++i;
        }
        String r = String.valueOf(proc) + "[" + oldnames + " := " + newnames + "]";
        return r;
    }

    @Override
    public String genericprocessinstantiation(String n, List<String> es) {
        if (es.size() < 1) {
            throw new RuntimeException("A generic process must be instantiatied by at least one parameter.\n");
        }
        String r = String.valueOf(n) + "[" + es.get(0);
        int i = 1;
        while (i < es.size()) {
            r = String.valueOf(r) + ", " + es.get(i);
            ++i;
        }
        r = String.valueOf(r) + "]";
        return r;
    }

    @Override
    public String iteratedprocesssequentialcomposition(String declpart, String proc) {
        return "\\Semi " + declpart + " \\circspot " + proc;
    }

    @Override
    public String iteratedprocessexternalchoice(String declpart, String proc) {
        return "\\Extchoice " + declpart + " \\circspot " + proc;
    }

    @Override
    public String iteratedprocessinternalchoice(String declpart, String proc) {
        return "\\Intchoice " + declpart + " \\circspot " + proc;
    }

    @Override
    public String iteratedprocessparallelcomposition(String csexp, String declpart, String proc) {
        return "\\Parallel " + declpart + " \\lpar " + csexp + " \\rpar \\circspot " + proc;
    }

    @Override
    public String iteratedprocessinterleave(String declpart, String proc) {
        return "\\Interleave " + declpart + " \\circspot " + proc;
    }

    @Override
    public String zparagraph(String par) {
        return par;
    }

    @Override
    public String actionparagraph(String n, String action2) {
        return "\\begin{circusaction}\n" + n + " \\circdef " + action2 + "\n\\end{circusaction}";
    }

    @Override
    public String namesetparagraph(String n, String nsexp) {
        return "\\begin{circus}\n\\circnameset" + n + " == " + nsexp + "\n\\end{circus}";
    }

    @Override
    public String paraction(String action2) {
        return action2;
    }

    @Override
    public String parameterisedparaction(String declpart, String action2) {
        return String.valueOf(declpart) + " \\circspot " + this.par(action2);
    }

    @Override
    public String schemaaction(String exp) {
        return "\\lschexpract " + exp + " \\rschexpract";
    }

    @Override
    public String commandaction(String command) {
        return command;
    }

    @Override
    public String namedaction(String n) {
        return n;
    }

    @Override
    public String cspaction(String action2) {
        return action2;
    }

    @Override
    public String renamingaction(String action2, List<Pair<String, String>> pairs) {
        if (pairs.size() < 1) {
            throw new RuntimeException("There must be at least one such pair.\n");
        }
        String r = String.valueOf(action2) + "[" + (String)pairs.get((int)0).first + "/" + (String)pairs.get((int)0).second;
        int i = 1;
        while (i < pairs.size()) {
            r = String.valueOf(r) + ", " + (String)pairs.get((int)i).first + "/" + (String)pairs.get((int)i).second;
            ++i;
        }
        r = String.valueOf(r) + "]";
        return this.par(r);
    }

    @Override
    public String inputparameter(String n) {
        return "?" + n;
    }

    @Override
    public String guardedinputparameter(String n, String predicate) {
        return "?" + n + "\\prefixcolon" + this.par(predicate);
    }

    @Override
    public String outputparameter(String e2) {
        return "!" + this.par(e2);
    }

    @Override
    public String simpleparameter(String e2) {
        return "." + this.par(e2);
    }

    @Override
    public String communication(String n, List<String> ps) {
        String r = n;
        for (String s : ps) {
            r = String.valueOf(r) + s;
        }
        return r;
    }

    @Override
    public String genericcommunication(String n, List<String> es, List<String> ps) {
        if (es.size() < 1) {
            throw new RuntimeException("Generic communications must be instantiated by at least one expression,\n");
        }
        String r = String.valueOf(n) + "[" + es.get(0);
        int i = 1;
        while (i < es.size()) {
            r = String.valueOf(r) + ", " + es.get(i);
            ++i;
        }
        r = String.valueOf(r) + "]";
        for (String s : ps) {
            r = String.valueOf(r) + s;
        }
        return r;
    }

    @Override
    public String assignment(List<Pair<String, String>> pairs) {
        if (pairs.size() < 1) {
            throw new RuntimeException("There must be at least one such pair.\n");
        }
        String left = (String)pairs.get((int)0).first;
        String right = (String)pairs.get((int)0).second;
        int i = 1;
        while (i < pairs.size()) {
            left = String.valueOf(left) + ", " + (String)pairs.get((int)i).first;
            right = String.valueOf(right) + ", " + (String)pairs.get((int)i).second;
            ++i;
        }
        String r = String.valueOf(left) + " := " + right;
        return r;
    }

    @Override
    public String ifcommand(String gaction) {
        return this.block("\\circif " + gaction + "\n\\circfi");
    }

    @Override
    public String variableblock(String declpart, String action2) {
        return this.par("\\circvar " + declpart + " \\circspot " + action2);
    }

    @Override
    public String actionspecification(List<String> ns, String p1, String p2) {
        String r = "";
        if (ns.size() > 0) {
            r = String.valueOf(r) + ns.get(0);
        }
        int i = 1;
        while (i < ns.size()) {
            r = String.valueOf(r) + ", " + ns.get(i);
            ++i;
        }
        r = String.valueOf(r) + "\\prefixcolon [~ " + p1 + ", " + p2 + " ~]";
        return r;
    }

    @Override
    public String assumption(String p) {
        return "\\{~ " + p + " ~\\}";
    }

    @Override
    public String coercion(String p) {
        return "[~ " + p + " ~]";
    }

    @Override
    public String substitutionbyvalue(String declpart, String action2) {
        return this.par("\\circval " + declpart + " \\circspot " + action2);
    }

    @Override
    public String substitutionbyresult(String declpart, String action2) {
        return this.par("\\circres " + declpart + " \\circspot " + action2);
    }

    @Override
    public String substitutionbyvalueresult(String declpart, String action2) {
        return this.par("\\circvres " + declpart + " \\circspot " + action2);
    }

    @Override
    public String gactions(List<Pair<String, String>> pairs) {
        if (pairs.size() < 1) {
            throw new RuntimeException("There must be at least one such pair.\n");
        }
        String r = String.valueOf((String)pairs.get((int)0).first) + " \\circthen " + (String)pairs.get((int)0).second;
        int i = 1;
        while (i < pairs.size()) {
            r = String.valueOf(r) + "\n\\\\\\circelse " + (String)pairs.get((int)i).first + " \\circthen " + this.par((String)pairs.get((int)i).second);
            ++i;
        }
        return String.valueOf(r) + "\\\\\n";
    }

    @Override
    public String skip() {
        return "\\Skip";
    }

    @Override
    public String stop() {
        return "\\Stop";
    }

    @Override
    public String chaos() {
        return "\\Chaos";
    }

    @Override
    public String prefixedaction(String comm, String action2) {
        return this.par(String.valueOf(comm) + " \\then " + action2);
    }

    @Override
    public String guardedaction(String p, String action2) {
        return this.par("\\lcircguard " + p + " \\rcircguard \\circguard " + action2);
    }

    @Override
    public String actionsequentialcomposition(String a1, String a2) {
        return this.par(String.valueOf(a1) + " \\circseq " + a2);
    }

    @Override
    public String actionexternalchoice(String a1, String a2) {
        return this.par(String.valueOf(a1) + " \\extchoice " + a2);
    }

    @Override
    public String actioninternalchoice(String a1, String a2) {
        return this.par(String.valueOf(a1) + " \\intchoice " + a2);
    }

    @Override
    public String actionparallelcomposition(String a1, String ns1, String csexp, String ns2, String a2) {
        return this.par(String.valueOf(a1) + " \\lpar " + ns1 + " | " + csexp + " | " + ns2 + " \\rpar " + a2);
    }

    @Override
    public String actioninterleave(String a1, String ns1, String ns2, String a2) {
        return this.par(String.valueOf(a1) + " \\linter " + ns1 + " | " + ns2 + " \\rinter " + a2);
    }

    @Override
    public String actionhiding(String a, String csexp) {
        return this.par(String.valueOf(a) + "\\circhide " + csexp);
    }

    @Override
    public String paractioninstantiation(String paraction, List<String> es) {
        if (es.size() < 1) {
            throw new RuntimeException("An action instantiation must contain at least one instantiating expression.\n");
        }
        String r = String.valueOf(paraction) + "(" + es.get(0);
        int i = 1;
        while (i < es.size()) {
            r = String.valueOf(r) + ", " + es.get(i);
            ++i;
        }
        r = String.valueOf(r) + ")";
        return r;
    }

    @Override
    public String recursiveaction(String n, String action2) {
        return this.par("\\circmu " + n + " \\circspot " + action2);
    }

    @Override
    public String iteratedactionsequentialcomposition(String declpart, String action2) {
        return this.par("\\Semi " + declpart + " \\circspot " + action2);
    }

    @Override
    public String iteratedactionexternalchoice(String declpart, String action2) {
        return this.par("\\Extchoice " + declpart + " \\circspot " + action2);
    }

    @Override
    public String iteratedactioninternalchoice(String declpart, String action2) {
        return this.par("\\Intchoice " + declpart + " \\circspot " + action2);
    }

    @Override
    public String iteratedactionparallelcomposition(String csexp, String declpart, String nsexp, String action2) {
        throw new RuntimeException("Function \"iteratedactionparallelcomposition\" was not implemented.\n");
    }

    @Override
    public String iteratedactioninterleave(String declpart, String nsexp, String action2) {
        throw new RuntimeException("Function \"iteratedactioninterleave\" was not implemented.\n");
    }

    @Override
    public String sequence(List<String> ss) {
        String seq = "\\langle ";
        if (ss.size() > 0) {
            seq = String.valueOf(seq) + ss.get(0);
            int i = 1;
            while (i < ss.size()) {
                seq = String.valueOf(seq) + ", " + ss.get(i);
                ++i;
            }
        }
        return String.valueOf(seq) + " \\rangle";
    }

    @Override
    public String boolean_type() {
        return "\\true";
    }

    @Override
    public String value_false() {
        return "\\false";
    }

    @Override
    public String value_true() {
        return "\\boolean";
    }

    @Override
    public String ns(List<String> ns) {
        String r = "\\{ ";
        if (ns.size() > 0) {
            r = String.valueOf(r) + ns.get(0);
        }
        int i = 1;
        while (i < ns.size()) {
            r = String.valueOf(r) + ", " + ns.get(i);
            ++i;
        }
        r = String.valueOf(r) + " \\}";
        return r;
    }

    @Override
    public String nsinter(String nsexp1, String nsexp2) {
        return null;
    }

    @Override
    public String nsminus(String nsexp1, String nsexp2) {
        return null;
    }

    @Override
    public String nsunion(String nsexp1, String nsexp2) {
        return null;
    }

    @Override
    public String externalchoiceextension(List<String> actions) {
        String action2 = this.cspaction(this.skip());
        if (actions.size() > 0) {
            action2 = actions.get(0);
            int i = 1;
            while (i < actions.size()) {
                action2 = String.valueOf(action2) + "\\\\\n\\extchoice\\\\\n" + actions.get(i);
                ++i;
            }
        }
        return this.block(action2);
    }

    @Override
    public String sequentialcompositionextension(List<String> actions) {
        String action2 = this.cspaction(this.skip());
        if (actions.size() > 0) {
            action2 = actions.get(0);
            int i = 1;
            while (i < actions.size()) {
                action2 = String.valueOf(action2) + "\\circseq\\\\\n" + actions.get(i);
                ++i;
            }
        }
        return this.block(action2);
    }

    @Override
    public String circussection(String name, List<String> parents, String prog) {
        String header = "\\begin{zsection}\\\\\n\\SECTION " + name;
        if (parents.size() > 0) {
            header = String.valueOf(header) + " \\parents " + parents.get(0);
            int i = 1;
            while (i < parents.size()) {
                header = String.valueOf(header) + ", " + parents.get(i);
                ++i;
            }
        }
        header = String.valueOf(header) + "\\\\\n\\end{zsection}\\\\\n";
        return String.valueOf(header) + prog;
    }
}

