/*
 * Decompiled with CFR 0.152.
 */
package MDLSyntax;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Group {
    String name;
    HashMap<String, String> pairs;
    HashSet<Group> groups;

    public Group(String name) {
        this.name = name;
        this.pairs = new HashMap();
        this.groups = new HashSet();
    }

    public Group() {
        this.pairs = new HashMap();
        this.groups = new HashSet();
    }

    public void addPair(String first, String second) {
        this.pairs.put(first, second);
    }

    public void addGroup(Group g) {
        this.groups.add(g);
    }

    public Set<Group> getGroups(String name) {
        HashSet<Group> g = new HashSet<Group>();
        for (Group aux : this.groups) {
            if (aux.name.equals(name)) {
                g.add(aux);
            }
            g.addAll(aux.getGroups(name));
        }
        return g;
    }

    public Group getGroup(String name) {
        for (Group aux : this.groups) {
            if (!aux.name.equals(name)) continue;
            return aux;
        }
        return null;
    }

    public String get(String name) {
        return this.pairs.get(name);
    }

    public static String tabs(int n) {
        String s = "";
        int i = 0;
        while (i < n) {
            s = String.valueOf(s) + "\t";
            ++i;
        }
        return s;
    }

    public String print(int n) {
        String s = "";
        s = String.valueOf(s) + Group.tabs(n) + this.name + " {\n";
        for (String id : this.pairs.keySet()) {
            String value2 = this.pairs.get(id);
            s = String.valueOf(s) + Group.tabs(n + 1) + id + " -> " + value2 + "\n";
        }
        for (Group g : this.groups) {
            s = String.valueOf(s) + g.print(n + 1);
        }
        s = String.valueOf(s) + Group.tabs(n) + "}\n";
        return s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

