/*
 * Decompiled with CFR 0.152.
 */
package s2cgui;

import Parser.mdl.ParsingException;
import circussyntax.CircusSyntax;
import circussyntax.CircustoLatex;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import s2cgui.S2CGUIAboutBox;
import s2cgui.S2CGUIApp;
import translator.NameGenerator;
import translator.NameGeneratorLatex;
import translator.translator;
import ui.LogOutput;
import ui.Output;

public class S2CGUIView
extends FrameView {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public S2CGUIView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                S2CGUIView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                S2CGUIView.this.busyIconIndex = (S2CGUIView.this.busyIconIndex + 1) % S2CGUIView.this.busyIcons.length;
                S2CGUIView.this.statusAnimationLabel.setIcon(S2CGUIView.this.busyIcons[S2CGUIView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!S2CGUIView.this.busyIconTimer.isRunning()) {
                        S2CGUIView.this.statusAnimationLabel.setIcon(S2CGUIView.this.busyIcons[0]);
                        S2CGUIView.this.busyIconIndex = 0;
                        S2CGUIView.this.busyIconTimer.start();
                    }
                    S2CGUIView.this.progressBar.setVisible(true);
                    S2CGUIView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    S2CGUIView.this.busyIconTimer.stop();
                    S2CGUIView.this.statusAnimationLabel.setIcon(S2CGUIView.this.idleIcon);
                    S2CGUIView.this.progressBar.setVisible(false);
                    S2CGUIView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    S2CGUIView.this.statusMessageLabel.setText(text == null ? "" : text);
                    S2CGUIView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    S2CGUIView.this.progressBar.setVisible(true);
                    S2CGUIView.this.progressBar.setIndeterminate(false);
                    S2CGUIView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = S2CGUIApp.getApplication().getMainFrame();
            this.aboutBox = new S2CGUIAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        S2CGUIApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(S2CGUIApp.class).getContext().getResourceMap(S2CGUIView.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        ApplicationActionMap actionMap = Application.getInstance(S2CGUIApp.class).getContext().getActionMap(S2CGUIView.class, this);
        this.jButton1.setAction(actionMap.get("output"));
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jButton2.setAction(actionMap.get("input"));
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setName("jButton2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jTextField1.setText(resourceMap.getString("jTextField1.text", new Object[0]));
        this.jTextField1.setName("jTextField1");
        this.jTextField2.setText(resourceMap.getString("jTextField2.text", new Object[0]));
        this.jTextField2.setName("jTextField2");
        this.jScrollPane1.setName("jScrollPane1");
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setName("jList1");
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton3.setAction(actionMap.get("addLibrary"));
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setName("jButton3");
        this.jButton4.setAction(actionMap.get("remove"));
        this.jButton4.setText(resourceMap.getString("jButton4.text", new Object[0]));
        this.jButton4.setName("jButton4");
        this.jButton5.setAction(actionMap.get("translate"));
        this.jButton5.setText(resourceMap.getString("jButton5.text", new Object[0]));
        this.jButton5.setName("jButton5");
        this.jButton6.setAction(actionMap.get("quit"));
        this.jButton6.setText(resourceMap.getString("jButton6.text", new Object[0]));
        this.jButton6.setName("jButton6");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jTextField1, -1, 257, Short.MAX_VALUE)).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 257, Short.MAX_VALUE).addComponent(this.jTextField2, -1, 257, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.jButton5, -1, 122, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton6, -2, 125, -2))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton4)).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton5).addComponent(this.jButton6)).addContainerGap(-1, Short.MAX_VALUE)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 417, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 247, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    @Action
    public void addLibrary() {
        String lib = JOptionPane.showInputDialog("Input the name of the library.");
        if (lib != null && !lib.equals("")) {
            ((DefaultListModel)this.jList1.getModel()).addElement(lib);
        }
    }

    @Action
    public void remove() {
        int i = this.jList1.getSelectedIndex();
        if (i >= 0) {
            DefaultListModel model = (DefaultListModel)this.jList1.getModel();
            model.remove(i);
        }
    }

    @Action
    public void input() {
        JFileChooser fc = new JFileChooser(".");
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".mdl") || file.isDirectory();
            }

            public String getDescription() {
                return "Simulink file (*.mdl)";
            }
        });
        fc.showOpenDialog(this.getFrame());
        File file = fc.getSelectedFile();
        if (file != null) {
            this.jTextField1.setText(file.getAbsolutePath());
        }
    }

    @Action
    public void output() {
        JFileChooser fc = new JFileChooser(".");
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".tex") || file.isDirectory();
            }

            public String getDescription() {
                return "LaTeX file (*.tex)";
            }
        });
        fc.showSaveDialog(this.getFrame());
        File file = fc.getSelectedFile();
        if (file != null) {
            this.jTextField2.setText(file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void translate() {
        if (this.jTextField1.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.getFrame(), "Please choose an input file.", "Input warning", 2);
        } else {
            String input = this.jTextField1.getText();
            String output = this.jTextField2.getText();
            LinkedList<String> libraries = new LinkedList<String>();
            if (input.isEmpty()) {
                JOptionPane.showMessageDialog(this.getFrame(), "Warning", "No input file selected.", 2);
            }
            for (int i = 0; i < this.jList1.getModel().getSize(); ++i) {
                libraries.add(((String)this.jList1.getModel().getElementAt(i)).replaceAll("_", "\\\\_"));
            }
            if (output.isEmpty()) {
                output = input.substring(0, input.lastIndexOf(".mdl"));
                output = output + ".tex";
            }
            String spec = null;
            LogOutput _o = null;
            try {
                NameGeneratorLatex _n = new NameGeneratorLatex();
                CircustoLatex _c = new CircustoLatex((NameGenerator)_n);
                if (!output.endsWith(".tex")) {
                    output = output + ".tex";
                }
                _o = new LogOutput(output.substring(0, output.lastIndexOf(".tex")) + ".log");
                translator t = new translator((CircusSyntax)_c, (NameGenerator)_n, (Output)_o);
                spec = t.translate(input, libraries);
            }
            catch (ParsingException e) {
                JOptionPane.showMessageDialog(this.getFrame(), e.toString(), "Error", 0);
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(this.getFrame(), e.toString(), "Error", 0);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getFrame(), e.toString(), "Error", 0);
            }
            if (spec != null) {
                Writer writer = null;
                try {
                    File file = new File(output);
                    writer = new BufferedWriter(new FileWriter(file));
                    writer.write(spec);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this.getFrame(), e.toString(), "Error", 0);
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                            JOptionPane.showMessageDialog(this.getFrame(), "Translation successfull.", "Success", 1);
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(this.getFrame(), e.toString(), "Error", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.getFrame(), "Error", "Error", 0);
            }
            try {
                if (_o != null) {
                    _o.close();
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getFrame(), e.toString(), "Error", 0);
            }
        }
    }
}

