/*
 * Decompiled with CFR 0.152.
 */
package zsyntax;

import java.util.List;
import translator.NameGenerator;
import zsyntax.Pair;
import zsyntax.ZSyntax;

public class ZtoLatex
implements ZSyntax {
    NameGenerator names;

    public ZtoLatex(NameGenerator names) {
        this.names = names;
    }

    @Override
    public String primestroke() {
        return "'";
    }

    @Override
    public String outputstroke() {
        return "!";
    }

    @Override
    public String inputstroke() {
        return "?";
    }

    @Override
    public String character(String c) {
        return c;
    }

    @Override
    public String decimal(String d) {
        return d;
    }

    @Override
    public String schematext_horizontal(List<String> declpart, List<String> predicate) {
        String decl = declpart.size() > 0 ? declpart.get(0) : "";
        String pred = predicate.size() > 0 ? predicate.get(0) : "";
        return String.valueOf(decl) + " | " + pred;
    }

    @Override
    public String schematext_vertical(List<String> declpart, List<String> predicate) {
        String decl = declpart.size() > 0 ? declpart.get(0) : "";
        String pred = predicate.size() > 0 ? "\n \\where \n" + predicate.get(0) : "";
        return String.valueOf(decl) + pred;
    }

    @Override
    public String declpart_horizontal(List<String> declarations) {
        String r = "";
        int n = declarations.size();
        if (n > 0) {
            r = declarations.get(0);
        }
        int i = 1;
        while (i < n) {
            r = String.valueOf(r) + "; " + declarations.get(i);
            ++i;
        }
        return r;
    }

    @Override
    public String declpart_vertical(List<String> declarations) {
        String r = "";
        int n = declarations.size();
        if (n > 0) {
            r = declarations.get(0);
        }
        int i = 1;
        while (i < n) {
            r = String.valueOf(r) + "\\\\\n " + declarations.get(i);
            ++i;
        }
        return r;
    }

    @Override
    public String variable(List<String> declnames, String expression) {
        String r = "";
        int n = declnames.size();
        if (n <= 0) {
            throw new RuntimeException("The sequence of names in a variable declaration must be non-empty.\n");
        }
        r = declnames.get(0);
        int i = 1;
        while (i < n) {
            r = String.valueOf(r) + ", " + declnames.get(i);
            ++i;
        }
        r = String.valueOf(r) + ": " + expression;
        return r;
    }

    @Override
    public String constant(String declname, String expression) {
        return String.valueOf(declname) + " == " + expression;
    }

    @Override
    public String expression(String expression) {
        return expression;
    }

    @Override
    public String newline(String predicate1, String predicate2) {
        return String.valueOf(predicate1) + "\\\\\n" + predicate2;
    }

    @Override
    public String semicolon(String predicate1, String predicate2) {
        return "(" + predicate1 + ");(" + predicate2 + ")";
    }

    @Override
    public String forall(String schematext, String predicate) {
        return "\\forall " + schematext + " @ (" + predicate + ")";
    }

    @Override
    public String exists(String schematext, String predicate) {
        return "\\exists " + schematext + " @ (" + predicate + ")";
    }

    @Override
    public String unique(String schematext, String predicate) {
        return "\\exists_1 " + schematext + " @ (" + predicate + ")";
    }

    @Override
    public String equivalence(String predicate1, String predicate2) {
        return "(" + predicate1 + ") \\iff (" + predicate2 + ")";
    }

    @Override
    public String implication(String predicate1, String predicate2) {
        return "(" + predicate1 + ") \\implies (" + predicate2 + ")";
    }

    @Override
    public String disjunction(String predicate1, String predicate2) {
        return "(" + predicate1 + ") \\lor (" + predicate2 + ")";
    }

    @Override
    public String conjunction(String predicate1, String predicate2) {
        return "(" + predicate1 + ") \\land (" + predicate2 + ")";
    }

    @Override
    public String negation(String predicate) {
        return "\\lnot (" + predicate + ")";
    }

    @Override
    public String relationapplication(String relation) {
        return relation;
    }

    @Override
    public String relation(String rel) {
        return rel;
    }

    @Override
    public String schemapredicate(String expression) {
        return expression;
    }

    @Override
    public String TRUE() {
        return "true";
    }

    @Override
    public String FALSE() {
        return "false";
    }

    @Override
    public String parenthesizedpredicate(String predicate) {
        return "(" + predicate + ")";
    }

    @Override
    public String sequence(List<String> es) {
        String s = "\\langle ";
        if (es.size() == 1) {
            s = String.valueOf(s) + es.get(0);
        }
        int i = 1;
        while (i < es.size()) {
            s = String.valueOf(s) + ", " + es.get(i);
            ++i;
        }
        s = String.valueOf(s) + " \\rangle";
        return s;
    }

    @Override
    public String application(String app) {
        return app;
    }

    @Override
    public String rel(String name, List<String> es) {
        if (name.equals(this.names.EQUAL())) {
            return String.valueOf(es.get(0)) + " " + this.names.EQUAL() + " " + es.get(1);
        }
        if (name.equals(this.names.NEQ())) {
            return String.valueOf(es.get(0)) + " " + this.names.NEQ() + " " + es.get(1);
        }
        if (name.equals(this.names.IN())) {
            return String.valueOf(es.get(0)) + " " + this.names.IN() + " " + es.get(1);
        }
        String s = name;
        if (es.size() >= 1) {
            s = String.valueOf(s) + "(" + es.get(0);
        }
        int i = 1;
        while (i < es.size()) {
            s = String.valueOf(s) + ", " + es.get(i);
            ++i;
        }
        if (es.size() >= 1) {
            s = String.valueOf(s) + ")";
        }
        return s;
    }

    @Override
    public String app(String name, List<String> es) {
        return this.rel(name, es);
    }

    @Override
    public String schemaforall(String schematext, String expression) {
        return this.forall(schematext, expression);
    }

    @Override
    public String schemaexists(String schematext, String expression) {
        return this.exists(schematext, expression);
    }

    @Override
    public String schemaunique(String schematext, String expression) {
        return this.unique(schematext, expression);
    }

    @Override
    public String functionconstruction(String schematext, String expression) {
        return "\\lambda " + schematext + " @ " + expression;
    }

    @Override
    public String definitedescription(String schematext, String expression) {
        return "\\mu " + schematext + " @ " + expression;
    }

    @Override
    public String substitution(List<Pair<String, String>> pairs, String expression) {
        String r = "\\LET ";
        if (pairs.size() <= 0) {
            throw new RuntimeException("A let expression must contain at least one definition pair.\n");
        }
        r = String.valueOf(r) + (String)pairs.get((int)0).first + " == " + (String)pairs.get((int)0).second;
        int i = 1;
        while (i < pairs.size()) {
            r = String.valueOf(r) + ";\\\\\n " + (String)pairs.get((int)i).first + " == " + (String)pairs.get((int)i).second;
            ++i;
        }
        r = String.valueOf(r) + "\\\\\n @ " + expression;
        return r;
    }

    @Override
    public String schemaequivalence(String expression1, String expression2) {
        return this.equivalence(expression1, expression2);
    }

    @Override
    public String schemaimplication(String expression1, String expression2) {
        return this.implication(expression1, expression2);
    }

    @Override
    public String schemadisjunction(String expression1, String expression2) {
        return this.disjunction(expression1, expression2);
    }

    @Override
    public String schemaconjunction(String expression1, String expression2) {
        return this.conjunction(expression1, expression2);
    }

    @Override
    public String schemanegation(String expression) {
        return this.negation(expression);
    }

    @Override
    public String conditional(String predicate, String expression1, String expression2) {
        return "\\circblockbegin\n\\IF " + predicate + "\\\\\n \\THEN " + expression1 + "\\\\\n \\ELSE " + expression2 + "\n\\circblockend";
    }

    @Override
    public String composition(String expression1, String expression2) {
        return String.valueOf(expression1) + " \\semi " + expression2;
    }

    @Override
    public String piping(String expression1, String expression2) {
        return String.valueOf(expression1) + " \\pipe " + expression2;
    }

    @Override
    public String hiding(String expression, List<String> declnames) {
        String r = expression;
        if (declnames.size() == 0) {
            throw new RuntimeException("The hiding operator must be applied to at least one name.\n");
        }
        r = String.valueOf(r) + "(" + declnames.get(0);
        int i = 1;
        while (i < declnames.size()) {
            r = String.valueOf(r) + ", " + declnames.get(i);
            ++i;
        }
        r = String.valueOf(r) + ")";
        return r;
    }

    @Override
    public String projection(String expression1, String expression2) {
        return String.valueOf(expression1) + " \\project " + expression2;
    }

    @Override
    public String precondition(String expression) {
        return "\\pre " + expression;
    }

    @Override
    public String product(String expression1, String expression2) {
        return String.valueOf(expression1) + " \\cross " + expression2;
    }

    @Override
    public String powerset(String expression) {
        return "\\power " + expression;
    }

    @Override
    public String functionapplication(String application) {
        return application;
    }

    @Override
    public String applicationexpression(String expression1, String expression2) {
        return String.valueOf(expression1) + " ~ " + expression2;
    }

    @Override
    public String decoration(String expression, String stroke) {
        return String.valueOf(expression) + stroke;
    }

    @Override
    public String schemarenaming(String expression, List<Pair<String, String>> pairs) {
        if (pairs.size() == 0) {
            throw new RuntimeException("The renaming operator must be applied to at least a pair of names.\n");
        }
        String r = String.valueOf(expression) + "[";
        r = String.valueOf(r) + (String)pairs.get((int)0).first + "/" + (String)pairs.get((int)0).second;
        int i = 1;
        while (i < pairs.size()) {
            r = String.valueOf(r) + ", " + (String)pairs.get((int)i).first + "/" + (String)pairs.get((int)i).second;
            ++i;
        }
        r = String.valueOf(r) + "]";
        return r;
    }

    @Override
    public String bindingselection(String expression, String refname) {
        return String.valueOf(expression) + "." + refname;
    }

    @Override
    public String tupleselection(String expression, Integer n) {
        return String.valueOf(expression) + "." + n;
    }

    @Override
    public String bindingconstruction(String expression, List<String> strokes) {
        String r = "\\theta " + expression;
        for (String s : strokes) {
            r = String.valueOf(r) + s;
        }
        return r;
    }

    @Override
    public String reference(String refname) {
        return refname;
    }

    @Override
    public String genericinstantiation(String refname, List<String> expressions) {
        if (expressions.size() == 0) {
            throw new RuntimeException("At least one expression should be provided to a generic instantiation.\n");
        }
        String r = String.valueOf(refname) + "[" + expressions.get(0);
        int i = 1;
        while (i < expressions.size()) {
            r = String.valueOf(r) + ", " + expressions.get(i);
            ++i;
        }
        r = String.valueOf(r) + "]";
        return r;
    }

    @Override
    public String numberliteral(String n) {
        return n.toString();
    }

    @Override
    public String setextension(List<String> expressions) {
        String r = "\\{";
        if (expressions.size() > 0) {
            r = String.valueOf(r) + expressions.get(0);
        }
        int i = 1;
        while (i < expressions.size()) {
            r = String.valueOf(r) + ", " + expressions.get(i);
            ++i;
        }
        return String.valueOf(r) + "\\}";
    }

    @Override
    public String setcomprehension(String schematext, String expression) {
        return "\\{" + schematext + " @ " + expression + "\\}";
    }

    @Override
    public String characteristicsetcomprehension(String schematext) {
        return "\\{" + schematext + "\\}";
    }

    @Override
    public String schemaconstruction(String schematext) {
        return "[" + schematext + "]";
    }

    @Override
    public String bindingextension(List<Pair<String, String>> pairs) {
        String r = "\\circblockbegin\\lblot ";
        if (pairs.size() > 0) {
            r = String.valueOf(r) + (String)pairs.get((int)0).first + " == " + (String)pairs.get((int)0).second;
        }
        int i = 1;
        while (i < pairs.size()) {
            r = String.valueOf(r) + ",\n\\\\ " + (String)pairs.get((int)i).first + " == " + (String)pairs.get((int)i).second;
            ++i;
        }
        r = String.valueOf(r) + " \\rblot\\circblockend";
        return r;
    }

    @Override
    public String tupleextension(List<String> expressions) {
        if (expressions.size() < 2) {
            throw new RuntimeException("A tuple extension should have at least two expressions.\n");
        }
        String r = "(" + expressions.get(0);
        int i = 1;
        while (i < expressions.size()) {
            r = String.valueOf(r) + ", " + expressions.get(i);
            ++i;
        }
        r = String.valueOf(r) + ")";
        return r;
    }

    @Override
    public String characteristicdefinitedescription(String schematext) {
        return "( \\mu" + schematext + ")";
    }

    @Override
    public String parenthesizedexpression(String expression) {
        return "(" + expression + ")";
    }

    @Override
    public String decl(String declname) {
        return declname;
    }

    @Override
    public String ref(String refname) {
        return refname;
    }

    @Override
    public String branch(String declname, List<String> expressions) {
        if (expressions.size() > 1) {
            throw new RuntimeException("A branch contain at most one expressin per name.\n");
        }
        String r = "";
        r = expressions.size() == 0 ? declname : String.valueOf(declname) + " \\ldata " + expressions.get(0) + " \\rdata";
        return r;
    }

    @Override
    public String freetype(String name, List<String> branches) {
        if (branches.size() < 1) {
            throw new RuntimeException("A freetype must contain at least one branch.\n");
        }
        String r = String.valueOf(name) + " ::= " + branches.get(0);
        int i = 1;
        while (i < branches.size()) {
            r = String.valueOf(r) + " | " + branches.get(i);
            ++i;
        }
        return r;
    }

    @Override
    public String giventypes(List<String> names) {
        if (names.size() < 1) {
            throw new RuntimeException("A given type declaration must declare at least one given type.\n");
        }
        String r = "[" + names.get(0);
        int i = 1;
        while (i < names.size()) {
            r = String.valueOf(r) + ", " + names.get(i);
            ++i;
        }
        r = String.valueOf(r) + "]";
        return r;
    }

    @Override
    public String axiomaticdescription(String schematext) {
        String r = "\\begin{axdef}\n";
        r = String.valueOf(r) + schematext + "\n";
        r = String.valueOf(r) + "\\end{axdef}";
        return r;
    }

    @Override
    public String schemadefinition(String name, String schematext) {
        String r = "\\begin{schema}{" + name + "}\n";
        r = String.valueOf(r) + schematext + "\n";
        r = String.valueOf(r) + "\\end{schema}";
        return r;
    }

    @Override
    public String genericaxiomaticdescription(List<String> formals, String schematext) {
        if (formals.size() < 1) {
            throw new RuntimeException("A generic axiomatic description must declare at least one parameter.\n");
        }
        String r = "\\begin{gendef}[";
        r = String.valueOf(r) + formals.get(0);
        int i = 1;
        while (i < formals.size()) {
            r = String.valueOf(r) + ", " + formals.get(i);
            ++i;
        }
        r = String.valueOf(r) + "]\n";
        r = String.valueOf(r) + schematext + "\n";
        r = String.valueOf(r) + "\\end{gendef}";
        return r;
    }

    @Override
    public String genericschemadefinition(String name, List<String> formals, String schematext) {
        if (formals.size() < 1) {
            throw new RuntimeException("A generic schema definition must declare at least one parameter.\n");
        }
        String r = "\\begin{schema}{" + name + "}[";
        r = String.valueOf(r) + formals.get(0);
        int i = 1;
        while (i < formals.size()) {
            r = String.valueOf(r) + ", " + formals.get(i);
            ++i;
        }
        r = String.valueOf(r) + "]\n";
        r = String.valueOf(r) + schematext + "\n";
        r = String.valueOf(r) + "\\end{schema}";
        return r;
    }

    @Override
    public String horizontaldefinition(String declname, String expression) {
        String r = "\\begin{zed}\n";
        r = String.valueOf(r) + declname + " == " + expression + "\n";
        r = String.valueOf(r) + "\\end{zed}";
        return r;
    }

    @Override
    public String generichorizontaldefinition(String name, List<String> formals, String expression) {
        if (formals.size() < 1) {
            throw new RuntimeException("A generic horizontal definition must declare at least one parameter.\n");
        }
        String r = "\\begin{zed}\n";
        r = String.valueOf(r) + name + "[" + formals.get(0);
        int i = 1;
        while (i < formals.size()) {
            r = String.valueOf(r) + ", " + formals.get(i);
            ++i;
        }
        r = String.valueOf(r) + "] == " + expression + "\n";
        r = String.valueOf(r) + "\\end{zed}";
        return r;
    }

    @Override
    public String genericoperatordefinition(String gename, String expression) {
        throw new RuntimeException("Function \"genericoperatordefinition\" was not implemented.\n");
    }

    @Override
    public String freetypes(List<String> freetypes) {
        if (freetypes.size() < 1) {
            throw new RuntimeException("A free type declaration must declare at least one free type.\n");
        }
        String r = "\\begin{zed}\n";
        r = String.valueOf(r) + freetypes.get(0);
        int i = 1;
        while (i < freetypes.size()) {
            r = String.valueOf(r) + "\n &" + freetypes.get(i);
            ++i;
        }
        r = String.valueOf(r) + "\n\\end{zed}";
        return r;
    }

    @Override
    public String conjecture(String predicate) {
        String r = "\\begin{zed}\n";
        r = String.valueOf(r) + "\\vdash ?" + predicate + "\n";
        r = String.valueOf(r) + "\\end{zed}";
        return r;
    }

    @Override
    public String genericconjecture(List<String> formals, String predicate) {
        String r = "\\begin{zed}\n";
        r = String.valueOf(r) + "[" + formals.get(0);
        int i = 1;
        while (i < formals.size()) {
            r = String.valueOf(r) + ", " + formals.get(i);
            ++i;
        }
        r = String.valueOf(r) + "] \\vdash ?" + predicate + "\n";
        r = String.valueOf(r) + "\\end{zed}";
        return r;
    }

    @Override
    public String operatortemplate(String operatortemplate) {
        throw new RuntimeException("Function \"operatortemplate\" was not implemented.\n");
    }
}

