/*
 * Decompiled with CFR 0.152.
 */
package Parser;

import MDLSyntax.Group;
import MDLSyntax.Spec;
import Parser.stateflow.StateParser;
import Parser.stateflow.TransitionParser;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import stateflowabstractsyntax.action.ACTION;
import stateflowabstractsyntax.action.assign;
import stateflowabstractsyntax.action.bcast;
import stateflowabstractsyntax.action.expr;
import stateflowabstractsyntax.action.massign;
import stateflowabstractsyntax.daction.DACTION;
import stateflowabstractsyntax.daction.ONACTION;
import stateflowabstractsyntax.daction.action;
import stateflowabstractsyntax.datatype.scalar;
import stateflowabstractsyntax.expr.EXPR;
import stateflowabstractsyntax.expr.time;
import stateflowabstractsyntax.expr.variable;
import stateflowabstractsyntax.objects.Chart;
import stateflowabstractsyntax.objects.DATASCOPE;
import stateflowabstractsyntax.objects.DECOMP;
import stateflowabstractsyntax.objects.Data;
import stateflowabstractsyntax.objects.EVENTSCOPE;
import stateflowabstractsyntax.objects.EVENTTRIGGER;
import stateflowabstractsyntax.objects.Event;
import stateflowabstractsyntax.objects.Function;
import stateflowabstractsyntax.objects.Junction;
import stateflowabstractsyntax.objects.SCALAR;
import stateflowabstractsyntax.objects.STYPE;
import stateflowabstractsyntax.objects.State;
import stateflowabstractsyntax.objects.Transition;
import ui.Output;

public class Builder {
    Map<Integer, Chart> charts;
    Map<Integer, Function> functions;
    Map<Integer, Chart> truthtables;
    Output output;

    public Builder(Spec sp, Output output) {
        this.output = output;
        this.charts = new HashMap<Integer, Chart>();
        this.functions = new HashMap<Integer, Function>();
        this.truthtables = new HashMap<Integer, Chart>();
        Group stateflow = sp.getGroup("Stateflow");
        this.getCharts(stateflow);
        this.getStates(stateflow);
        this.getJunctions(stateflow);
        this.getTransitions(stateflow);
        this.getData(stateflow);
        this.getEvents(stateflow);
        for (Chart c : this.charts.values()) {
            this.cleanup(c, this.functions);
        }
        this.updateChart(stateflow);
        Iterator<Chart> it = this.charts.values().iterator();
        while (it.hasNext()) {
            Chart c = it.next();
            if (!c.isTruthtable) continue;
            it.remove();
            this.truthtables.put(c.identifier, c);
        }
    }

    public Map<Integer, Chart> getCharts() {
        return this.charts;
    }

    public void getCharts(Group stateflow) {
        Set<Group> gs = stateflow.getGroups("chart");
        for (Group g : gs) {
            Chart c = new Chart();
            c.identifier = new Integer(g.get("id"));
            c.name = g.get("name").replaceAll("_", "\\\\_");
            c.name = c.name.replaceAll(" ", "\\\\_");
            System.out.println(c.name);
            c.decomp = g.get("decomposition").equals("CLUSTER_CHART") ? DECOMP.SEQ : DECOMP.PAR;
            this.charts.put(c.identifier, c);
            if (g.get("type") == null || !g.get("type").equals("TRUTHTABLE_CHART")) continue;
            c.isTruthtable = true;
        }
    }

    public void updateChart(Group stateflow) {
        for (Chart c : this.charts.values()) {
            Object defg;
            Set<Group> ss = stateflow.getGroups("state");
            Set<Group> ts = stateflow.getGroups("transition");
            for (Transition t2 : c.transitions.values()) {
                int order;
                if (t2.source.size() != 0 || t2.parent != c.identifier || (order = new Integer(((Group)(defg = this.getGroup("id", String.valueOf(t2.identifier), ts))).get("executionOrder")).intValue()) != 1) continue;
                c.def.add(t2.identifier);
                break;
            }
            HashSet<Group> substates = new HashSet<Group>();
            defg = c.states.values().iterator();
            while (defg.hasNext()) {
                State s1 = defg.next();
                if (s1.parent != c.identifier) continue;
                Group gs1 = this.getGroup("id", String.valueOf(s1.identifier), ss);
                substates.add(gs1);
            }
            if (c.decomp == DECOMP.PAR) {
                int i = 0;
                while (i < substates.size()) {
                    Group gs1 = this.getGroup("executionOrder", String.valueOf(i + 1), substates);
                    c.substates.add(new Integer(gs1.get("id")));
                    ++i;
                }
            } else {
                for (Group gs1 : substates) {
                    c.substates.add(new Integer(gs1.get("id")));
                }
            }
            this.updateStates(stateflow, c);
            this.updateTransitions(stateflow, c);
            this.updateJunctions(stateflow, c);
        }
    }

    public void getStates(Group stateflow) {
        Set<Group> gs = stateflow.getGroups("state");
        for (Group g : gs) {
            String label = g.get("labelString");
            if (g.get("type").equals("FUNC_STATE")) {
                this.output.print("This chart contains functions, which are not yet treated by this tool; they will be ignored.");
                Group simulink = g.getGroup("simulink");
                if (simulink != null && simulink.get("isSimulinkFcn").equals("1")) {
                    this.output.print("Not processing simulink function " + label);
                    this.functions.put(new Integer(g.get("id")), new Function());
                    continue;
                }
                this.output.print("Not processing Stateflow function " + label);
                this.functions.put(new Integer(g.get("id")), new Function());
                continue;
            }
            if (g.get("type").equals("GROUP_STATE")) {
                this.output.print("This state is a comment state, and will be ignored.");
                continue;
            }
            this.output.print("Starting to process state " + label);
            StateParser p = new StateParser(new StringReader(label));
            p.parse();
            State s = p.getState();
            s.identifier = new Integer(g.get("id"));
            Integer cid = new Integer(g.get("chart"));
            Chart c = this.charts.get(cid);
            c.states.put(s.identifier, s);
            String parent = g.get("treeNode");
            int i = parent.indexOf(91);
            int j = parent.lastIndexOf(93);
            parent = parent.substring(i + 1, j);
            s.parent = new Integer(parent.split("\\s")[0]);
            if (g.get("type").equals("AND_STATE")) {
                s.type = STYPE.PAR;
            } else if (g.get("type").equals("OR_STATE")) {
                s.type = STYPE.SEQ;
            }
            s.decomp = g.get("decomposition").equals("CLUSTER_STATE") ? DECOMP.SEQ : DECOMP.PAR;
            this.output.print("Done processing state " + label);
        }
    }

    public Group getGroup(String key, String value2, Set<Group> gs) {
        for (Group g : gs) {
            if (!g.get(key).equals(value2)) continue;
            return g;
        }
        throw new RuntimeException("Group not found.\n");
    }

    public boolean isDescendant(int id1, int id2, Chart c) {
        if (id1 == id2) {
            return false;
        }
        if (c.junctions.keySet().contains(id2)) {
            return false;
        }
        if (!c.states.keySet().contains(id2)) {
            throw new RuntimeException(String.valueOf(id2) + " does not corresnpond to either a junction or a state.\n");
        }
        if (c.junctions.keySet().contains(id1)) {
            Junction j1 = c.junctions.get(id1);
            State s2 = c.states.get(id2);
            if (j1.parent == c.identifier) {
                return false;
            }
            if (j1.parent == s2.identifier) {
                return true;
            }
            State parent = c.states.get(j1.parent);
            return this.isDescendant(parent.identifier, id2, c);
        }
        if (c.states.keySet().contains(id1)) {
            State s1 = c.states.get(id1);
            State s2 = c.states.get(id2);
            if (s1.parent == c.identifier) {
                return false;
            }
            if (s1.parent == s2.identifier) {
                return true;
            }
            State parent = c.states.get(s1.parent);
            return this.isDescendant(parent.identifier, id2, c);
        }
        throw new RuntimeException(String.valueOf(id1) + " does not corresnpond to either a junction or a state.\n");
    }

    public boolean isInner(int tid, Chart c) {
        Transition t2 = c.transitions.get(tid);
        if (t2 == null) {
            throw new RuntimeException("Transitions " + tid + " does not exist.\n");
        }
        if (t2.source.size() == 0) {
            throw new RuntimeException("This is a default transition.\n");
        }
        return this.isDescendant(t2.destination, t2.source.get(0), c);
    }

    public void updateStates(Group stateflow, Chart c) {
        Set<Group> ss = stateflow.getGroups("state");
        Set<Group> ts = stateflow.getGroups("transition");
        for (State s : c.states.values()) {
            Object gs1;
            int order;
            this.updateAction(c, s.entry);
            this.updateAction(c, s.exit);
            this.updateDAction(c, s.during);
            Group gs = this.getGroup("id", String.valueOf(s.identifier), ss);
            for (Transition t2 : c.transitions.values()) {
                Group defg;
                if (t2.source.size() != 0 || t2.parent != s.identifier || (order = new Integer((defg = this.getGroup("id", String.valueOf(t2.identifier), ts)).get("executionOrder")).intValue()) != 1) continue;
                s.def.add(t2.identifier);
                break;
            }
            for (Transition t2 : c.transitions.values()) {
                Group innerg;
                if (t2.source.size() <= 0 || !t2.source.get(0).equals(s.identifier) || !this.isInner(t2.identifier, c) || (order = new Integer((innerg = this.getGroup("id", String.valueOf(t2.identifier), ts)).get("executionOrder")).intValue()) != 1) continue;
                s.inner.add(t2.identifier);
                break;
            }
            for (Transition t2 : c.transitions.values()) {
                Group outerg;
                if (t2.source.size() <= 0 || !t2.source.get(0).equals(s.identifier) || (order = new Integer((outerg = this.getGroup("id", String.valueOf(t2.identifier), ts)).get("executionOrder")).intValue()) != 1) continue;
                s.outer.add(t2.identifier);
                break;
            }
            if (s.type == STYPE.PAR) {
                int order1;
                for (State s1 : c.states.values()) {
                    if (s1.parent != s.parent) continue;
                    gs1 = this.getGroup("id", String.valueOf(s1.identifier), ss);
                    order = new Integer(gs.get("executionOrder"));
                    order1 = new Integer(((Group)gs1).get("executionOrder"));
                    if (order1 == order + 1) {
                        s1.left.add(s.identifier);
                        break;
                    }
                    if (order != order1 + 1) continue;
                    s.left.add(s1.identifier);
                    break;
                }
                for (State s1 : c.states.values()) {
                    if (s1.parent != s.parent) continue;
                    gs1 = this.getGroup("id", String.valueOf(s1.identifier), ss);
                    order = new Integer(gs.get("executionOrder"));
                    order1 = new Integer(((Group)gs1).get("executionOrder"));
                    if (order1 == order + 1) {
                        s.right.add(s1.identifier);
                        break;
                    }
                    if (order != order1 + 1) continue;
                    s1.right.add(s.identifier);
                    break;
                }
            }
            HashSet<Group> substates = new HashSet<Group>();
            for (State s1 : c.states.values()) {
                if (s1.parent != s.identifier) continue;
                Group gs12 = this.getGroup("id", String.valueOf(s1.identifier), ss);
                substates.add(gs12);
            }
            if (s.decomp == DECOMP.PAR) {
                int i = 0;
                while (i < substates.size()) {
                    gs1 = this.getGroup("executionOrder", String.valueOf(i + 1), substates);
                    s.substates.add(new Integer(((Group)gs1).get("id")));
                    ++i;
                }
                continue;
            }
            for (Group gs13 : substates) {
                s.substates.add(new Integer(gs13.get("id")));
            }
        }
    }

    public void getJunctions(Group stateflow) {
        Set<Group> gs = stateflow.getGroups("junction");
        for (Group g : gs) {
            Junction j = new Junction();
            j.identifier = new Integer(g.get("id"));
            String parent = g.get("linkNode");
            int x = parent.indexOf(91);
            int y = parent.lastIndexOf(93);
            parent = parent.substring(x + 1, y);
            j.parent = new Integer(parent.split("\\s")[0]);
            j.history = !g.get("type").equals("CONNECTIVE_JUNCTION");
            Integer cid = new Integer(g.get("chart"));
            Chart c = this.charts.get(cid);
            c.junctions.put(j.identifier, j);
        }
    }

    public void updateJunctions(Group stateflow, Chart c) {
        Set<Group> ts = stateflow.getGroups("transition");
        block0: for (Junction j : c.junctions.values()) {
            for (Transition t2 : c.transitions.values()) {
                int order;
                Group gt2 = this.getGroup("id", String.valueOf(t2.identifier), ts);
                if (t2.source.size() <= 0 || !t2.source.get(0).equals(j.identifier) || (order = new Integer(gt2.get("executionOrder")).intValue()) != 1) continue;
                j.transition.add(t2.identifier);
                continue block0;
            }
        }
    }

    public void getTransitions(Group stateflow) {
        Set<Group> gs = stateflow.getGroups("transition");
        for (Group g : gs) {
            Transition t2;
            String label = g.get("labelString");
            this.output.print("Starting to process transition " + label);
            if (label != null) {
                TransitionParser p = new TransitionParser(new StringReader(label));
                p.parse();
                t2 = p.getTransition();
            } else {
                t2 = new Transition();
            }
            t2.identifier = new Integer(g.get("id"));
            String parent = g.get("linkNode");
            int i = parent.indexOf(91);
            int j = parent.lastIndexOf(93);
            parent = parent.substring(i + 1, j);
            t2.parent = new Integer(parent.split("\\s")[0]);
            t2.source = new LinkedList<Integer>();
            if (g.getGroup("src").get("id") != null) {
                t2.source.add(new Integer(g.getGroup("src").get("id")));
            }
            t2.destination = new Integer(g.getGroup("dst").get("id"));
            this.charts.get((Object)new Integer((String)g.get((String)"chart"))).transitions.put(t2.identifier, t2);
            this.output.print("Done processing transition " + label);
        }
    }

    public void updateTransitions(Group stateflow, Chart c) {
        Set<Group> ts = stateflow.getGroups("transition");
        block0: for (Group tg1 : ts) {
            Integer tid1 = new Integer(tg1.get("id"));
            if (!c.transitions.keySet().contains(tid1)) continue;
            Transition t1 = c.transitions.get(tid1);
            this.updateAction(c, t1.condact);
            this.updateAction(c, t1.transact);
            for (ACTION a : t1.transact) {
                if (!(a instanceof bcast)) continue;
                ((bcast)a).transitionaction = true;
            }
            for (Group tg2 : ts) {
                int order2;
                int order1;
                Integer tid2 = new Integer(tg2.get("id"));
                if (!c.transitions.keySet().contains(tid2)) continue;
                Transition t2 = c.transitions.get(tid2);
                if (t1.source.size() == 0 && t2.source.size() == 0) {
                    if (t1.parent != t2.parent) continue;
                    order1 = new Integer(tg1.get("executionOrder"));
                    order2 = new Integer(tg2.get("executionOrder"));
                    if (order2 == order1 + 1) {
                        t1.next.add(tid2);
                        continue block0;
                    }
                    if (order1 != order2 + 1) continue;
                    t2.next.add(tid1);
                    continue block0;
                }
                if (t1.source.size() == 0 || t2.source.size() == 0 || !t1.source.get(0).equals(t2.source.get(0))) continue;
                order1 = new Integer(tg1.get("executionOrder"));
                order2 = new Integer(tg2.get("executionOrder"));
                if (order2 == order1 + 1) {
                    t1.next.add(tid2);
                    continue block0;
                }
                if (order1 != order2 + 1) continue;
                t2.next.add(tid1);
                continue block0;
            }
        }
    }

    public void getEvents(Group stateflow) {
        Set<Group> gs = stateflow.getGroups("event");
        for (Group g : gs) {
            Event e2 = new Event();
            e2.identifier = new Integer(g.get("id"));
            e2.ename = g.get("name").replaceAll("_", "\\\\_");
            String parent = g.get("linkNode");
            int i = parent.indexOf(91);
            int j = parent.lastIndexOf(93);
            parent = parent.substring(i + 1, j);
            e2.parent = new Integer(parent.split("\\s")[0]);
            String scope = g.get("scope");
            e2.scope = scope == "LOCAL_EVENT" ? EVENTSCOPE.LOCALEVENT : (scope == "INPUT_EVENT" ? EVENTSCOPE.INPUTEVENT : EVENTSCOPE.OUTPUTEVENT);
            String trigger = g.get("trigger");
            e2.trigger = trigger == "EITHER_EDGE_EVENT" ? EVENTTRIGGER.EITHEREDGE : (trigger == "FALLING_EDGE_EVENT" ? EVENTTRIGGER.FALLINGEDGE : (trigger == "FUNCTION_CALL_EVENT" ? EVENTTRIGGER.FUNCTIONCALL : EVENTTRIGGER.RISINGEDGE));
            if (this.functions.containsKey(e2.parent)) continue;
            if (this.charts.containsKey(e2.parent)) {
                this.charts.get((Object)Integer.valueOf((int)e2.parent)).events.put(e2.identifier, e2);
                continue;
            }
            State p = null;
            for (Chart c : this.charts.values()) {
                for (State s : c.states.values()) {
                    if (s.identifier != e2.parent) continue;
                    p = s;
                }
            }
            if (p == null) {
                throw new RuntimeException("Error: data must be parented by either a chart or state.\n");
            }
            this.charts.get((Object)Integer.valueOf((int)p.parent)).events.put(e2.identifier, e2);
        }
    }

    public void getData(Group stateflow) {
        Set<Group> gs = stateflow.getGroups("data");
        for (Group g : gs) {
            if (g.get("scope").startsWith("FUNCTION")) continue;
            Data d = new Data();
            d.identifier = new Integer(g.get("id"));
            d.dname = g.get("name").replaceAll("_", "\\\\_");
            String parent = g.get("linkNode");
            int i = parent.indexOf(91);
            int j = parent.lastIndexOf(93);
            parent = parent.substring(i + 1, j);
            d.parent = new Integer(parent.split("\\s")[0]);
            String scope = g.get("scope");
            d.scope = scope.equals("CONSTANT_DATA") ? DATASCOPE.CONSTANTDATA : (scope.equals("STORE_MEMORY_DATA") ? DATASCOPE.DATASTOREMEMORYDATA : (scope.equals("INPUT_DATA") ? DATASCOPE.INPUTDATA : (scope.equals("LOCAL_DATA") ? DATASCOPE.LOCALDATA : (scope.equals("OUTPUT_DATA") ? DATASCOPE.OUTPUTDATA : DATASCOPE.PARAMETERDATA))));
            d.type = new scalar(SCALAR.UNIVERSE);
            if (this.functions.containsKey(d.parent)) continue;
            this.output.print("Starting to process data " + d.dname);
            if (this.charts.containsKey(d.parent)) {
                this.charts.get((Object)Integer.valueOf((int)d.parent)).data.put(d.identifier, d);
            } else {
                State p = null;
                for (Chart c : this.charts.values()) {
                    for (State s : c.states.values()) {
                        if (s.identifier != d.parent) continue;
                        p = s;
                    }
                }
                if (p == null) {
                    throw new RuntimeException("Error: data must be parented by either a chart or state.\n");
                }
                this.charts.get((Object)Integer.valueOf((int)p.parent)).data.put(d.identifier, d);
            }
            this.output.print("Done processing data " + d.dname);
        }
    }

    public EXPR updateExpression(Chart c, EXPR e2) {
        if (e2 instanceof time) {
            System.out.println("updating variable expression");
            boolean datat = false;
            for (Data d : c.data.values()) {
                if (!d.dname.equals("t")) continue;
                datat = true;
            }
            if (datat) {
                return new variable("t");
            }
        }
        return e2;
    }

    public void updateExpression(Chart c, List<EXPR> es) {
        int i = 0;
        while (i < es.size()) {
            es.set(i, this.updateExpression(c, es.get(i)));
            ++i;
        }
    }

    public ACTION updateAction(Chart c, ACTION a) {
        if (a instanceof expr) {
            expr e2 = (expr)a;
            if (e2.e instanceof variable) {
                variable v = (variable)e2.e;
                boolean isbcast = false;
                for (Event ev : c.events.values()) {
                    if (!ev.ename.equals(v.dname)) continue;
                    isbcast = true;
                }
                if (isbcast) {
                    return new bcast(v.dname, c.name);
                }
            }
            return new expr(this.updateExpression(c, e2.e));
        }
        if (a instanceof bcast) {
            if (((bcast)a).destination == null) {
                ((bcast)a).destination = c.name;
            }
        } else {
            if (a instanceof assign) {
                assign aux = (assign)a;
                this.updateExpression(c, aux.es);
                return new assign(new variable(aux.dname, aux.es), this.updateExpression(c, aux.e));
            }
            if (a instanceof massign) {
                massign aux = (massign)a;
                return new massign(aux.a, this.updateExpression(c, aux.e));
            }
        }
        return a;
    }

    public DACTION updateDAction(Chart c, DACTION a) {
        if (a instanceof ONACTION) {
            return a;
        }
        List<ACTION> as = ((action)a).as;
        this.updateAction(c, as);
        return new action(as);
    }

    public void updateAction(Chart c, List<ACTION> as) {
        int i = 0;
        while (i < as.size()) {
            as.set(i, this.updateAction(c, as.get(i)));
            ++i;
        }
    }

    public void updateDAction(Chart c, List<DACTION> as) {
        int i = 0;
        while (i < as.size()) {
            as.set(i, this.updateDAction(c, as.get(i)));
            ++i;
        }
    }

    public void cleanup(Chart c, Map<Integer, Function> functions) {
        Iterator<Transition> tit = c.transitions.values().iterator();
        while (tit.hasNext()) {
            Transition t2 = tit.next();
            if (!functions.containsKey(t2.parent)) continue;
            tit.remove();
        }
        this.output.print("Done with transitions.");
        Iterator<Junction> jit = c.junctions.values().iterator();
        while (jit.hasNext()) {
            Junction j = jit.next();
            if (!functions.containsKey(j.parent)) continue;
            jit.remove();
        }
        this.output.print("Done with junctions.");
        Iterator<Event> eit = c.events.values().iterator();
        while (eit.hasNext()) {
            Event e2 = eit.next();
            if (!functions.containsKey(e2.parent)) continue;
            eit.remove();
        }
        this.output.print("Done with events.");
        Iterator<Data> dit = c.data.values().iterator();
        while (dit.hasNext()) {
            Data d = dit.next();
            if (!functions.containsKey(d.parent)) continue;
            System.out.println("Checking data with parent " + d.parent + " is in list ");
            for (Integer i : functions.keySet()) {
                System.out.print(i + " ");
            }
            dit.remove();
        }
        this.output.print("Done with data.");
        this.output.print("Done cleaning up.");
    }
}

