/*
 * Decompiled with CFR 0.152.
 */
package translator;

import MDLSyntax.Group;
import MDLSyntax.Spec;
import Parser.Builder;
import Parser.mdl.ParsingException;
import circussyntax.CircusSyntax;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import stateflowabstractsyntax.action.ACTION;
import stateflowabstractsyntax.action.assign;
import stateflowabstractsyntax.action.bcast;
import stateflowabstractsyntax.action.expr;
import stateflowabstractsyntax.action.massign;
import stateflowabstractsyntax.daction.DACTION;
import stateflowabstractsyntax.daction.ONACTION;
import stateflowabstractsyntax.daction.action;
import stateflowabstractsyntax.expr.EXPR;
import stateflowabstractsyntax.expr.after;
import stateflowabstractsyntax.expr.and;
import stateflowabstractsyntax.expr.at;
import stateflowabstractsyntax.expr.band;
import stateflowabstractsyntax.expr.before;
import stateflowabstractsyntax.expr.bnot;
import stateflowabstractsyntax.expr.bor;
import stateflowabstractsyntax.expr.bxor;
import stateflowabstractsyntax.expr.division;
import stateflowabstractsyntax.expr.eq;
import stateflowabstractsyntax.expr.every;
import stateflowabstractsyntax.expr.fun;
import stateflowabstractsyntax.expr.geq;
import stateflowabstractsyntax.expr.gt;
import stateflowabstractsyntax.expr.in;
import stateflowabstractsyntax.expr.leq;
import stateflowabstractsyntax.expr.lshift;
import stateflowabstractsyntax.expr.lt;
import stateflowabstractsyntax.expr.modulus;
import stateflowabstractsyntax.expr.mult;
import stateflowabstractsyntax.expr.neg;
import stateflowabstractsyntax.expr.neq;
import stateflowabstractsyntax.expr.not;
import stateflowabstractsyntax.expr.or;
import stateflowabstractsyntax.expr.rshift;
import stateflowabstractsyntax.expr.sub;
import stateflowabstractsyntax.expr.sum;
import stateflowabstractsyntax.expr.tempCount;
import stateflowabstractsyntax.expr.time;
import stateflowabstractsyntax.expr.value;
import stateflowabstractsyntax.expr.variable;
import stateflowabstractsyntax.objects.Chart;
import stateflowabstractsyntax.objects.DATASCOPE;
import stateflowabstractsyntax.objects.DECOMP;
import stateflowabstractsyntax.objects.Data;
import stateflowabstractsyntax.objects.EVENTSCOPE;
import stateflowabstractsyntax.objects.Event;
import stateflowabstractsyntax.objects.Junction;
import stateflowabstractsyntax.objects.STYPE;
import stateflowabstractsyntax.objects.State;
import stateflowabstractsyntax.objects.Transition;
import stateflowabstractsyntax.trigger.TRIGGER;
import stateflowabstractsyntax.trigger.e;
import stateflowabstractsyntax.trigger.t;
import translator.NameGenerator;
import translator.ObjectGetters;
import translator.Opt;
import ui.Output;
import zsyntax.Pair;
import zsyntax.Triple;

public class translator {
    CircusSyntax _c;
    NameGenerator _n;
    Output output;

    public translator(CircusSyntax _c, NameGenerator _n, Output output) {
        this._c = _c;
        this._n = _n;
        this.output = output;
    }

    public List<String> translate_exprs(Chart c, List<EXPR> es) {
        LinkedList<String> result = new LinkedList<String>();
        for (EXPR e2 : es) {
            result.add(this.translate_expr(c, e2));
        }
        return result;
    }

    public String translate_expr(Chart c, EXPR e2) {
        if (e2 instanceof variable) {
            String n = ((variable)e2).dname;
            List<EXPR> es = ((variable)e2).es;
            Data d = ObjectGetters.getdatabyname(c, n);
            if (es.size() == 0) {
                return this._c.reference(this._c.ref(this._n.dataname(c, d)));
            }
            return this._c.application(this._c.app(this._c.reference(this._c.ref(this._n.dataname(c, d))), this.translate_exprs(c, es)));
        }
        if (e2 instanceof value) {
            String s = ((value)e2).value;
            return this._c.numberliteral(s);
        }
        if (e2 instanceof not) {
            return "(\\anot " + this.translate_expr(c, ((not)e2).e) + ")";
        }
        if (e2 instanceof and) {
            return "(" + this.translate_expr(c, ((and)e2).e1) + " \\aand " + this.translate_expr(c, ((and)e2).e2) + ")";
        }
        if (e2 instanceof or) {
            return "(" + this.translate_expr(c, ((or)e2).e1) + " \\aor " + this.translate_expr(c, ((or)e2).e2) + ")";
        }
        if (e2 instanceof bnot) {
            return "(\\anot " + this.translate_expr(c, ((bnot)e2).e) + ")";
        }
        if (e2 instanceof band) {
            return "(" + this.translate_expr(c, ((band)e2).e1) + " \\aand " + this.translate_expr(c, ((band)e2).e2) + ")";
        }
        if (e2 instanceof bor) {
            return "(" + this.translate_expr(c, ((bor)e2).e1) + " \\aor " + this.translate_expr(c, ((bor)e2).e2) + ")";
        }
        if (e2 instanceof bxor) {
            return "exp(" + this.translate_expr(c, ((bxor)e2).e1) + ", " + this.translate_expr(c, ((bxor)e2).e2) + ")";
        }
        if (e2 instanceof neg) {
            return "(" + this._n.NEGATE() + "~" + this.translate_expr(c, ((neg)e2).e) + ")";
        }
        if (e2 instanceof sum) {
            return "(" + this.translate_expr(c, ((sum)e2).e1) + " + " + this.translate_expr(c, ((sum)e2).e2) + ")";
        }
        if (e2 instanceof sub) {
            return "(" + this.translate_expr(c, ((sub)e2).e1) + " - " + this.translate_expr(c, ((sub)e2).e2) + ")";
        }
        if (e2 instanceof mult) {
            return "(" + this.translate_expr(c, ((mult)e2).e1) + " * " + this.translate_expr(c, ((mult)e2).e2) + ")";
        }
        if (e2 instanceof division) {
            return "(" + this.translate_expr(c, ((division)e2).e1) + " \\div " + this.translate_expr(c, ((division)e2).e2) + ")";
        }
        if (e2 instanceof modulus) {
            return "(" + this.translate_expr(c, ((modulus)e2).e1) + " \\mod " + this.translate_expr(c, ((modulus)e2).e2) + ")";
        }
        if (e2 instanceof lshift) {
            return "(" + this.translate_expr(c, ((lshift)e2).e1) + " \\lshift " + this.translate_expr(c, ((lshift)e2).e2) + ")";
        }
        if (e2 instanceof rshift) {
            return "(" + this.translate_expr(c, ((rshift)e2).e1) + " \\rshift " + this.translate_expr(c, ((rshift)e2).e2) + ")";
        }
        if (e2 instanceof gt) {
            return "(" + this.translate_expr(c, ((gt)e2).e1) + " " + this._n.AGT() + " " + this.translate_expr(c, ((gt)e2).e2) + ")";
        }
        if (e2 instanceof lt) {
            return "(" + this.translate_expr(c, ((lt)e2).e1) + " " + this._n.ALT() + " " + this.translate_expr(c, ((lt)e2).e2) + ")";
        }
        if (e2 instanceof geq) {
            return "(" + this.translate_expr(c, ((geq)e2).e1) + " " + this._n.AGEQ() + " " + this.translate_expr(c, ((geq)e2).e2) + ")";
        }
        if (e2 instanceof leq) {
            return "(" + this.translate_expr(c, ((leq)e2).e1) + " " + this._n.ALEQ() + " " + this.translate_expr(c, ((leq)e2).e2) + ")";
        }
        if (e2 instanceof eq) {
            return "(" + this.translate_expr(c, ((eq)e2).e1) + " " + this._n.AEQ() + " " + this.translate_expr(c, ((eq)e2).e2) + ")";
        }
        if (e2 instanceof neq) {
            return "(" + this.translate_expr(c, ((neq)e2).e1) + " " + this._n.ANEQ() + " " + this.translate_expr(c, ((neq)e2).e2) + ")";
        }
        if (e2 instanceof in) {
            String exp = null;
            for (String n : ((in)e2).snames) {
                LinkedList<String> args = new LinkedList<String>();
                args.add(this._c.reference(this._c.ref(n)));
                exp = exp == null ? this._c.functionapplication(this._c.app(this._n.STATESTATUS(), args)) : String.valueOf(exp) + " \\lor " + this._c.functionapplication(this._c.app(this._n.STATESTATUS(), args));
            }
            return exp;
        }
        if (e2 instanceof fun) {
            return this._c.functionapplication(this._c.app(((fun)e2).name, this.translate_exprs(c, ((fun)e2).args)));
        }
        if (e2 instanceof after) {
            throw new RuntimeException("Translation of AFTER expressions not yet implemented.");
        }
        if (e2 instanceof before) {
            throw new RuntimeException("Translation of BEFORE expressions not yet implemented.");
        }
        if (e2 instanceof at) {
            throw new RuntimeException("Translation of AT expressions not yet implemented.");
        }
        if (e2 instanceof every) {
            throw new RuntimeException("Translation of EVERY expressions not yet implemented.");
        }
        if (e2 instanceof tempCount) {
            throw new RuntimeException("Translation of TEMPCOUNT expressions not yet implemented.");
        }
        if (e2 instanceof time) {
            return this._c.reference(this._c.ref(this._n.TIME()));
        }
        throw new RuntimeException("Unknown type of expression: " + e2.getClass().getName());
    }

    public String translate_acts(Chart c, List<ACTION> as) {
        String result;
        if (as.size() == 0) {
            result = this._c.cspaction(this._c.skip());
        } else {
            result = this.translate_act(c, as.get(as.size() - 1));
            if (as.size() > 1) {
                int i = as.size() - 2;
                while (i >= 0) {
                    result = this._c.cspaction(this._c.actionsequentialcomposition(this.translate_act(c, as.get(i)), result));
                    --i;
                }
            }
        }
        return result;
    }

    public String translate_act(Chart c, ACTION a) {
        if (a instanceof assign) {
            String n = ((assign)a).dname;
            List<EXPR> es = ((assign)a).es;
            EXPR e2 = ((assign)a).e;
            LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
            Pair<String, String> p = new Pair<String, String>();
            if (es.size() == 0) {
                p.setFirst(this._n.dataname(c, ObjectGetters.getdatabyname(c, n)));
                p.setSecond(this.translate_expr(c, e2));
                pairs.add(p);
                return this._c.commandaction(this._c.assignment(pairs));
            }
            if (es.size() == 1) {
                LinkedList<String> seq = new LinkedList<String>();
                seq.add(this.translate_expr(c, es.get(0)));
                seq.add(this.translate_expr(c, e2));
                String tuple = this._c.tupleextension(seq);
                seq = new LinkedList();
                seq.add(tuple);
                String set = this._c.setextension(seq);
                seq = new LinkedList();
                seq.add(this._c.reference(this._c.ref(this._n.dataname(c, ObjectGetters.getdatabyname(c, n)))));
                seq.add(set);
                tuple = this._c.tupleextension(seq);
                seq = new LinkedList();
                seq.add(tuple);
                String function = this._c.functionapplication(this._c.app(this._n.OVERRIDE(), seq));
                p.setFirst(this._n.dataname(c, ObjectGetters.getdatabyname(c, n)));
                p.setSecond(function);
                pairs.add(p);
                return this._c.commandaction(this._c.assignment(pairs));
            }
            LinkedList<String> seq = new LinkedList<String>();
            seq.add(this._c.tupleextension(this.translate_exprs(c, es)));
            seq.add(this.translate_expr(c, e2));
            String tuple = this._c.tupleextension(seq);
            seq = new LinkedList();
            seq.add(tuple);
            String set = this._c.setextension(seq);
            seq = new LinkedList();
            seq.add(this._c.reference(this._c.ref(this._n.dataname(c, ObjectGetters.getdatabyname(c, n)))));
            seq.add(set);
            tuple = this._c.tupleextension(seq);
            seq = new LinkedList();
            seq.add(tuple);
            String function = this._c.functionapplication(this._c.app(this._n.OVERRIDE(), seq));
            p.setFirst(this._n.dataname(c, ObjectGetters.getdatabyname(c, n)));
            p.setSecond(function);
            pairs.add(p);
            return this._c.commandaction(this._c.assignment(pairs));
        }
        if (a instanceof massign) {
            List<String> names = ((massign)a).a.names;
            EXPR e3 = ((massign)a).e;
            String type = this._c.reference(this._c.ref(this._n.UNIVERSE()));
            int i = 1;
            while (i < names.size()) {
                type = this._c.product(type, this._c.reference(this._c.ref(this._n.UNIVERSE())));
                ++i;
            }
            LinkedList<String> declnames = new LinkedList<String>();
            declnames.add(this._n.AUX());
            LinkedList<String> declarations = new LinkedList<String>();
            declarations.add(this._c.variable(declnames, type));
            String decl = this._c.declpart_vertical(declarations);
            LinkedList<String> assignments = new LinkedList<String>();
            LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
            pairs.add(new Pair<String, String>(this._c.reference(this._c.ref(this._n.AUX())), this.translate_expr(c, e3)));
            assignments.add(this._c.commandaction(this._c.assignment(pairs)));
            int i2 = 0;
            while (i2 < names.size()) {
                pairs = new LinkedList();
                pairs.add(new Pair<String, String>(this._c.reference(this._c.ref(this._n.dataname(c, ObjectGetters.getdatabyname(c, names.get(i2))))), this._c.tupleselection(this._c.reference(this._c.ref(this._n.AUX())), i2 + 1)));
                assignments.add(this._c.commandaction(this._c.assignment(pairs)));
                ++i2;
            }
            return this._c.commandaction(this._c.variableblock(decl, this._c.sequentialcompositionextension(assignments)));
        }
        if (a instanceof bcast) {
            String n = ((bcast)a).ename;
            boolean t2 = ((bcast)a).transitionaction;
            String d = ((bcast)a).destination;
            Event e4 = ObjectGetters.geteventbyname(c, n);
            LinkedList<String> parameters = new LinkedList<String>();
            parameters.add(this._c.outputparameter(this._c.reference(this._c.ref(this._n.eventname(c, e4)))));
            String comm = this._c.communication(this._n.OUTPUTCHANNEL(), parameters);
            String dest = null;
            if (c.name.equals(d)) {
                dest = this._n.chartid(c);
            } else {
                State s = ObjectGetters.getstatebyname(c, d);
                dest = this._n.stateid(c, s);
            }
            LinkedList<String> pars = new LinkedList<String>();
            pars.add(this._c.reference(this._c.ref(this._n.eventname(c, e4))));
            pars.add(this._c.reference(this._c.ref(this._n.O())));
            pars.add(this._c.reference(this._c.ref(dest)));
            if (e4.scope == EVENTSCOPE.OUTPUTEVENT) {
                return this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())));
            }
            if (e4.scope == EVENTSCOPE.LOCALEVENT) {
                if (!t2) {
                    return this._c.cspaction(this._c.paractioninstantiation(this._c.paraction(this._c.namedaction(this._n.BROADCAST())), pars));
                }
                return this._c.cspaction(this._c.paractioninstantiation(this._c.paraction(this._c.namedaction(this._n.BROADCASTTACTION())), pars));
            }
            throw new RuntimeException("WARNING: Input event " + n + "is being broadcasted.");
        }
        if (a instanceof expr) {
            return this._c.cspaction(this._c.skip());
        }
        throw new RuntimeException("Unknown type of action: " + a.getClass().getName());
    }

    public String translate_dacts(Chart c, List<DACTION> as) {
        String result;
        if (as.size() == 0) {
            result = this._c.cspaction(this._c.skip());
        } else {
            result = this.translate_dact(c, as.get(as.size() - 1));
            if (as.size() > 1) {
                int i = as.size() - 2;
                while (i >= 0) {
                    result = this._c.cspaction(this._c.actionsequentialcomposition(this.translate_dact(c, as.get(i)), result));
                    --i;
                }
            }
        }
        return result;
    }

    public String translate_dact(Chart c, DACTION a) {
        if (a instanceof action) {
            List<ACTION> as = ((action)a).as;
            return this.translate_acts(c, as);
        }
        if (a instanceof ONACTION) {
            ONACTION o = (ONACTION)a;
            return this.translate_onact(c, o);
        }
        throw new RuntimeException("Unknown type of on action: " + a.getClass().getName());
    }

    public String translate_onact(Chart c, ONACTION a) {
        String n = a.ename;
        List<ACTION> as = a.as;
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.inputparameter(this._n.E()));
        String comm = this._c.communication(this._n.CURRENTEVENT(), cparameters);
        LinkedList<String> seq = new LinkedList<String>();
        seq.add(this._c.reference(this._c.ref(this._n.E())));
        seq.add(this._c.reference(this._c.ref(this._n.eventname(c, ObjectGetters.geteventbyname(c, n)))));
        String rel = this._c.relationapplication(this._c.rel(this._n.EQUAL(), seq));
        LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(rel);
        p.setSecond(this.translate_acts(c, as));
        pairs.add(p);
        p = new Pair();
        p.setFirst(this._c.negation(rel));
        p.setSecond(this._c.cspaction(this._c.skip()));
        pairs.add(p);
        String act = this._c.commandaction(this._c.ifcommand(this._c.gactions(pairs)));
        return this._c.cspaction(this._c.prefixedaction(comm, act));
    }

    public String translate_trigger(Chart c, TRIGGER t2) {
        if (t2 instanceof e) {
            String n = ((e)t2).ename;
            LinkedList<String> seq = new LinkedList<String>();
            seq.add(this._c.reference(this._c.ref(this._n.E())));
            seq.add(this._c.reference(this._c.ref(this._n.eventname(c, ObjectGetters.geteventbyname(c, n)))));
            return this._c.relationapplication(this._c.rel(this._n.EQUAL(), seq));
        }
        if (t2 instanceof t) {
            return this.translate_pred(c, ((t)t2).t);
        }
        throw new RuntimeException("Unknown type of trigger: " + t2.getClass().getName());
    }

    public String translate_triggers(Chart c, List<TRIGGER> ts) {
        String result;
        if (ts.size() == 0) {
            result = this._c.TRUE();
        } else {
            result = this.translate_trigger(c, ts.get(ts.size() - 1));
            if (ts.size() > 1) {
                int i = ts.size() - 2;
                while (i >= 0) {
                    result = this._c.disjunction(this.translate_trigger(c, ts.get(i)), result);
                    --i;
                }
            }
        }
        return result;
    }

    public String truthvalue(String exp) {
        LinkedList<String> seq = new LinkedList<String>();
        seq.add(exp);
        seq.add(this._c.numberliteral("0"));
        return this._c.relationapplication(this._c.rel(this._n.NEQ(), seq));
    }

    public String translate_pred(Chart c, EXPR e2) {
        return "(" + this.truthvalue(this.translate_expr(c, e2)) + ")";
    }

    public Pair<String, String> chart_identifier(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.IDENTIFIER()));
        p.setSecond(this._c.reference(this._c.ref(this._n.chartid(c))));
        return p;
    }

    public Pair<String, String> chart_default(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.DEFAULT()));
        if (c.def.size() == 0) {
            p.setSecond(this._c.reference(this._c.ref(this._n.NULLTRANSITIONID())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.transitionid(c, ObjectGetters.gettransitionbyid(c, c.def.get(0))))));
        }
        return p;
    }

    public Pair<String, String> chart_inner(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.INNER()));
        p.setSecond(this._c.reference(this._c.ref(this._n.NULLTRANSITIONID())));
        return p;
    }

    public Pair<String, String> chart_outer(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.OUTER()));
        p.setSecond(this._c.reference(this._c.ref(this._n.NULLTRANSITIONID())));
        return p;
    }

    public Pair<String, String> chart_parent(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.PARENT()));
        p.setSecond(this._c.reference(this._c.ref(this._n.NULLSTATEID())));
        return p;
    }

    public Pair<String, String> chart_left(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.LEFT()));
        p.setSecond(this._c.reference(this._c.ref(this._n.NULLSTATEID())));
        return p;
    }

    public Pair<String, String> chart_right(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.RIGHT()));
        p.setSecond(this._c.reference(this._c.ref(this._n.NULLSTATEID())));
        return p;
    }

    public Pair<String, String> chart_substates(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.SUBSTATES()));
        LinkedList<String> ss = new LinkedList<String>();
        for (Integer i : c.substates) {
            ss.add(this._c.reference(this._c.ref(this._n.stateid(c, ObjectGetters.getstatebyid(c, i)))));
        }
        p.setSecond(this._c.sequence(ss));
        return p;
    }

    public Pair<String, String> chart_decomposition(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.DECOMPOSITION()));
        if (c.decomp == DECOMP.SEQ) {
            p.setSecond(this._c.reference(this._c.ref(this._n.CLUSTER())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.SET())));
        }
        return p;
    }

    public Pair<String, String> chart_type(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.TYPE()));
        p.setSecond(this._c.reference(this._c.ref(this._n.CHART())));
        return p;
    }

    public Pair<String, String> chart_history(Chart c) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.HISTORY()));
        p.setSecond(this._c.reference(this._c.ref(this._n.F())));
        return p;
    }

    public String ChartAsStateDeclaration(Chart c) {
        LinkedList<String> name = new LinkedList<String>();
        name.add(this._c.decl(this._n.chartname(c)));
        String type = this._c.reference(this._c.ref(this._n.TYPESTATE()));
        LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
        pairs.add(this.chart_identifier(c));
        pairs.add(this.chart_default(c));
        pairs.add(this.chart_inner(c));
        pairs.add(this.chart_outer(c));
        pairs.add(this.chart_parent(c));
        pairs.add(this.chart_left(c));
        pairs.add(this.chart_right(c));
        pairs.add(this.chart_substates(c));
        pairs.add(this.chart_decomposition(c));
        pairs.add(this.chart_type(c));
        pairs.add(this.chart_history(c));
        String binding = this._c.bindingextension(pairs);
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.variable(name, type));
        LinkedList<String> decl = new LinkedList<String>();
        decl.add(this._c.declpart_vertical(declarations));
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.chartname(c))));
        operands.add(binding);
        LinkedList<String> pred = new LinkedList<String>();
        pred.add(this._c.relationapplication(this._c.rel(this._n.EQUAL(), operands)));
        return this._c.axiomaticdescription(this._c.schematext_vertical(decl, pred));
    }

    public String ChartDeclaration(Chart c) {
        LinkedList<String> tuple;
        LinkedList<String> states = new LinkedList<String>();
        for (State s : c.states.values()) {
            tuple = new LinkedList<String>();
            tuple.add(this._c.reference(this._c.ref(this._n.stateid(c, s))));
            tuple.add(this._c.reference(this._c.ref(this._n.statename(c, s))));
            states.add(this._c.tupleextension(tuple));
        }
        LinkedList<String> transitions = new LinkedList<String>();
        for (Transition t2 : c.transitions.values()) {
            tuple = new LinkedList();
            tuple.add(this._c.reference(this._c.ref(this._n.transitionid(c, t2))));
            tuple.add(this._c.reference(this._c.ref(this._n.transitionname(c, t2))));
            transitions.add(this._c.tupleextension(tuple));
        }
        LinkedList<String> junctions = new LinkedList<String>();
        for (Junction j : c.junctions.values()) {
            tuple = new LinkedList();
            tuple.add(this._c.reference(this._c.ref(this._n.junctionid(c, j))));
            tuple.add(this._c.reference(this._c.ref(this._n.junctionname(c, j))));
            junctions.add(this._c.tupleextension(tuple));
        }
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.expression(this._c.reference(this._c.ref(this._n.STATEFLOWCHART()))));
        String decl = this._c.declpart_vertical(declarations);
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.IDENTIFIER())));
        operands.add(this._c.reference(this._c.ref(this._n.chartid(c))));
        String pred = this._c.relationapplication(this._c.rel(this._n.EQUAL(), operands));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.STATES())));
        operands.add(this._c.setextension(states));
        pred = this._c.newline(pred, this._c.relationapplication(this._c.rel(this._n.EQUAL(), operands)));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.TRANSITIONS())));
        operands.add(this._c.setextension(transitions));
        pred = this._c.newline(pred, this._c.relationapplication(this._c.rel(this._n.EQUAL(), operands)));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.JUNCTIONS())));
        operands.add(this._c.setextension(junctions));
        pred = this._c.newline(pred, this._c.relationapplication(this._c.rel(this._n.EQUAL(), operands)));
        return this._c.schemadefinition(this._n.processstatename(c), this._c.schematext_vertical(new Opt<String>(decl), new Opt<String>(pred)));
    }

    public String StateIdentifierDeclaration(Chart c) {
        LinkedList<String> snames = new LinkedList<String>();
        for (State s : c.states.values()) {
            snames.add(this._c.decl(this._n.stateid(c, s)));
        }
        snames.add(this._c.decl(this._n.chartid(c)));
        String type = this._c.reference(this._c.ref(this._n.STATEID()));
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.variable(snames, type));
        String decl = this._c.declpart_vertical(declarations);
        LinkedList<String> declpart = new LinkedList<String>();
        declpart.add(decl);
        LinkedList<String> predicate = new LinkedList<String>();
        return this._c.axiomaticdescription(this._c.schematext_vertical(declpart, predicate));
    }

    public Pair<String, String> state_identifier(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.IDENTIFIER()));
        p.setSecond(this._c.reference(this._c.ref(this._n.stateid(c, s))));
        return p;
    }

    public Pair<String, String> state_default(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.DEFAULT()));
        if (s.def.size() == 0) {
            p.setSecond(this._c.reference(this._c.ref(this._n.NULLTRANSITIONID())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.transitionid(c, ObjectGetters.gettransitionbyid(c, s.def.get(0))))));
        }
        return p;
    }

    public Pair<String, String> state_inner(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.INNER()));
        if (s.inner.size() == 0) {
            p.setSecond(this._c.reference(this._c.ref(this._n.NULLTRANSITIONID())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.transitionid(c, ObjectGetters.gettransitionbyid(c, s.inner.get(0))))));
        }
        return p;
    }

    public Pair<String, String> state_outer(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.OUTER()));
        if (s.outer.size() == 0) {
            p.setSecond(this._c.reference(this._c.ref(this._n.NULLTRANSITIONID())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.transitionid(c, ObjectGetters.gettransitionbyid(c, s.outer.get(0))))));
        }
        return p;
    }

    public Pair<String, String> state_parent(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.PARENT()));
        if (c.states.keySet().contains(s.parent)) {
            p.setSecond(this._c.reference(this._c.ref(this._n.stateid(c, ObjectGetters.getstatebyid(c, s.parent)))));
        } else if (c.identifier == s.parent) {
            p.setSecond(this._c.reference(this._c.ref(this._n.chartid(c))));
        } else {
            throw new RuntimeException("Parent of the state is a chart other than the one to which the state belongs.\n");
        }
        return p;
    }

    public Pair<String, String> state_left(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.LEFT()));
        if (s.left.size() == 0) {
            p.setSecond(this._c.reference(this._c.ref(this._n.NULLSTATEID())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.stateid(c, ObjectGetters.getstatebyid(c, s.left.get(0))))));
        }
        return p;
    }

    public Pair<String, String> state_right(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.RIGHT()));
        if (s.right.size() == 0) {
            p.setSecond(this._c.reference(this._c.ref(this._n.NULLSTATEID())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.stateid(c, ObjectGetters.getstatebyid(c, s.right.get(0))))));
        }
        return p;
    }

    public Pair<String, String> state_substates(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.SUBSTATES()));
        LinkedList<String> ss = new LinkedList<String>();
        for (Integer i : s.substates) {
            ss.add(this._c.reference(this._c.ref(this._n.stateid(c, ObjectGetters.getstatebyid(c, i)))));
        }
        p.setSecond(this._c.sequence(ss));
        return p;
    }

    public Pair<String, String> state_decomposition(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.DECOMPOSITION()));
        if (s.decomp == DECOMP.SEQ) {
            p.setSecond(this._c.reference(this._c.ref(this._n.CLUSTER())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.SET())));
        }
        return p;
    }

    public Pair<String, String> state_type(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.TYPE()));
        if (s.type == STYPE.PAR) {
            p.setSecond(this._c.reference(this._c.ref(this._n.AND())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.OR())));
        }
        return p;
    }

    public Pair<String, String> state_history(Chart c, State s) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.HISTORY()));
        if (s.history) {
            p.setSecond(this._c.reference(this._c.ref(this._n.T())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.F())));
        }
        return p;
    }

    public String StateDeclaration(Chart c, State s) {
        LinkedList<String> name = new LinkedList<String>();
        name.add(this._c.decl(this._n.statename(c, s)));
        String type = this._c.reference(this._c.ref(this._n.TYPESTATE()));
        LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
        pairs.add(this.state_identifier(c, s));
        pairs.add(this.state_default(c, s));
        pairs.add(this.state_inner(c, s));
        pairs.add(this.state_outer(c, s));
        pairs.add(this.state_parent(c, s));
        pairs.add(this.state_left(c, s));
        pairs.add(this.state_right(c, s));
        pairs.add(this.state_substates(c, s));
        pairs.add(this.state_decomposition(c, s));
        pairs.add(this.state_type(c, s));
        pairs.add(this.state_history(c, s));
        String binding = this._c.bindingextension(pairs);
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.variable(name, type));
        LinkedList<String> decl = new LinkedList<String>();
        decl.add(this._c.declpart_vertical(declarations));
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.statename(c, s))));
        operands.add(binding);
        LinkedList<String> pred = new LinkedList<String>();
        pred.add(this._c.relationapplication(this._c.rel(this._n.EQUAL(), operands)));
        return this._c.axiomaticdescription(this._c.schematext_vertical(decl, pred));
    }

    public String EntryActionDeclaration(Chart c, State s) {
        this.output.print("Starting to translate entry action of state " + s.name);
        String name = this._n.entryactionname(c, s);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.stateid(c, s)))));
        cparameters.add(this._c.inputparameter(this._n.O()));
        String comm = this._c.communication(this._n.EXECUTEENTRYACTION(), cparameters);
        if (s.entry.size() > 0) {
            return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this.translate_acts(c, s.entry)))));
        }
        return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String EntryActionsDeclaration(Chart c) {
        LinkedList<String> actions = new LinkedList<String>();
        for (State s : c.states.values()) {
            actions.add(this._c.namedaction(this._n.entryactionname(c, s)));
        }
        return this._c.actionparagraph(this._n.ENTRYACTIONS(), this._c.paraction(this._c.externalchoiceextension(actions)));
    }

    public String DuringActionDeclaration(Chart c, State s) {
        String name = this._n.duringactionname(c, s);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.stateid(c, s)))));
        cparameters.add(this._c.inputparameter(this._n.O()));
        String comm = this._c.communication(this._n.EXECUTEDURINGACTION(), cparameters);
        if (s.during.size() > 0) {
            return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this.translate_dacts(c, s.during)))));
        }
        return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String DuringActionsDeclaration(Chart c) {
        LinkedList<String> actions = new LinkedList<String>();
        for (State s : c.states.values()) {
            actions.add(this._c.namedaction(this._n.duringactionname(c, s)));
        }
        return this._c.actionparagraph(this._n.DURINGACTIONS(), this._c.paraction(this._c.externalchoiceextension(actions)));
    }

    public String ExitActionDeclaration(Chart c, State s) {
        String name = this._n.exitactionname(c, s);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.stateid(c, s)))));
        cparameters.add(this._c.inputparameter(this._n.O()));
        String comm = this._c.communication(this._n.EXECUTEEXITACTION(), cparameters);
        if (s.exit.size() > 0) {
            return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this.translate_acts(c, s.exit)))));
        }
        return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String ExitActionsDeclaration(Chart c) {
        LinkedList<String> actions = new LinkedList<String>();
        for (State s : c.states.values()) {
            actions.add(this._c.namedaction(this._n.exitactionname(c, s)));
        }
        return this._c.actionparagraph(this._n.EXITACTIONS(), this._c.paraction(this._c.externalchoiceextension(actions)));
    }

    public String JunctionIdentifierDeclaration(Chart c) {
        LinkedList<String> jnames = new LinkedList<String>();
        for (Junction j : c.junctions.values()) {
            jnames.add(this._c.decl(this._n.junctionid(c, j)));
        }
        if (jnames.size() == 0) {
            return null;
        }
        String type = this._c.reference(this._c.ref(this._n.JUNCTIONID()));
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.variable(jnames, type));
        String decl = this._c.declpart_vertical(declarations);
        LinkedList<String> declpart = new LinkedList<String>();
        declpart.add(decl);
        LinkedList<String> predicate = new LinkedList<String>();
        return this._c.axiomaticdescription(this._c.schematext_vertical(declpart, predicate));
    }

    public Pair<String, String> junction_identifier(Chart c, Junction j) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.IDENTIFIER()));
        p.setSecond(this._c.reference(this._c.ref(this._n.junctionid(c, j))));
        return p;
    }

    public Pair<String, String> junction_transition(Chart c, Junction j) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.TRANS()));
        if (j.transition.size() == 0) {
            p.setSecond(this._c.reference(this._c.ref(this._n.NULLTRANSITIONID())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.transitionid(c, ObjectGetters.gettransitionbyid(c, j.transition.get(0))))));
        }
        return p;
    }

    public Pair<String, String> junction_parent(Chart c, Junction j) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.PARENT()));
        if (c.states.keySet().contains(j.parent)) {
            p.setSecond(this._c.reference(this._c.ref(this._n.stateid(c, ObjectGetters.getstatebyid(c, j.parent)))));
        } else if (c.identifier == j.parent) {
            p.setSecond(this._c.reference(this._c.ref(this._n.chartid(c))));
        } else {
            throw new RuntimeException("Parent of the state is a chart other than the one to which the state belongs.\n");
        }
        return p;
    }

    public Pair<String, String> junction_history(Chart c, Junction j) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.HISTORY()));
        if (j.history) {
            p.setSecond(this._c.reference(this._c.ref(this._n.T())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.F())));
        }
        return p;
    }

    public String JunctionDeclaration(Chart c, Junction j) {
        LinkedList<String> name = new LinkedList<String>();
        name.add(this._c.decl(this._n.junctionname(c, j)));
        String type = this._c.reference(this._c.ref(this._n.TYPEJUNCTION()));
        LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
        pairs.add(this.junction_identifier(c, j));
        pairs.add(this.junction_transition(c, j));
        pairs.add(this.junction_parent(c, j));
        pairs.add(this.junction_history(c, j));
        String binding = this._c.bindingextension(pairs);
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.variable(name, type));
        LinkedList<String> decl = new LinkedList<String>();
        decl.add(this._c.declpart_vertical(declarations));
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.junctionname(c, j))));
        operands.add(binding);
        LinkedList<String> pred = new LinkedList<String>();
        pred.add(this._c.relationapplication(this._c.rel(this._n.EQUAL(), operands)));
        return this._c.axiomaticdescription(this._c.schematext_vertical(decl, pred));
    }

    public String TransitionIdentifierDeclaration(Chart c) {
        LinkedList<String> tnames = new LinkedList<String>();
        for (Transition t2 : c.transitions.values()) {
            tnames.add(this._c.decl(this._n.transitionid(c, t2)));
        }
        if (tnames.size() == 0) {
            return null;
        }
        String type = this._c.reference(this._c.ref(this._n.TRANSITIONID()));
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.variable(tnames, type));
        String decl = this._c.declpart_vertical(declarations);
        LinkedList<String> declpart = new LinkedList<String>();
        declpart.add(decl);
        LinkedList<String> predicate = new LinkedList<String>();
        return this._c.axiomaticdescription(this._c.schematext_vertical(declpart, predicate));
    }

    public Pair<String, String> transition_identifier(Chart c, Transition t2) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.IDENTIFIER()));
        p.setSecond(this._c.reference(this._c.ref(this._n.transitionid(c, t2))));
        return p;
    }

    public Pair<String, String> transition_source(Chart c, Transition t2) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.SOURCE()));
        if (t2.source.size() == 0) {
            LinkedList<String> expressions = new LinkedList<String>();
            expressions.add(this._c.reference(this._c.ref(this._n.NULLSTATEID())));
            p.setSecond(this._c.functionapplication(this._c.app(this._n.SDEST(), expressions)));
        } else if (c.states.keySet().contains(t2.source.get(0))) {
            LinkedList<String> expressions = new LinkedList<String>();
            expressions.add(this._c.reference(this._c.ref(this._n.stateid(c, ObjectGetters.getstatebyid(c, t2.source.get(0))))));
            p.setSecond(this._c.functionapplication(this._c.app(this._n.SDEST(), expressions)));
        } else {
            LinkedList<String> expressions = new LinkedList<String>();
            expressions.add(this._c.reference(this._c.ref(this._n.junctionid(c, ObjectGetters.getjunctionbyid(c, t2.source.get(0))))));
            p.setSecond(this._c.functionapplication(this._c.app(this._n.JDEST(), expressions)));
        }
        return p;
    }

    public Pair<String, String> transition_destination(Chart c, Transition t2) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.DESTINATION()));
        if (c.states.keySet().contains(t2.destination)) {
            LinkedList<String> expressions = new LinkedList<String>();
            expressions.add(this._c.reference(this._c.ref(this._n.stateid(c, ObjectGetters.getstatebyid(c, t2.destination)))));
            p.setSecond(this._c.functionapplication(this._c.app(this._n.SDEST(), expressions)));
        } else {
            LinkedList<String> expressions = new LinkedList<String>();
            expressions.add(this._c.reference(this._c.ref(this._n.junctionid(c, ObjectGetters.getjunctionbyid(c, t2.destination)))));
            p.setSecond(this._c.functionapplication(this._c.app(this._n.JDEST(), expressions)));
        }
        return p;
    }

    public Pair<String, String> transition_next(Chart c, Transition t2) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.NEXT()));
        if (t2.next.size() == 0) {
            p.setSecond(this._c.reference(this._c.ref(this._n.NULLTRANSITIONID())));
        } else {
            p.setSecond(this._c.reference(this._c.ref(this._n.transitionid(c, ObjectGetters.gettransitionbyid(c, t2.next.get(0))))));
        }
        return p;
    }

    public Pair<String, String> transition_parent(Chart c, Transition t2) {
        Pair<String, String> p = new Pair<String, String>();
        p.setFirst(this._c.decl(this._n.PARENT()));
        if (c.states.keySet().contains(t2.parent)) {
            p.setSecond(this._c.reference(this._c.ref(this._n.stateid(c, ObjectGetters.getstatebyid(c, t2.parent)))));
        } else if (c.identifier == t2.parent) {
            p.setSecond(this._c.reference(this._c.ref(this._n.chartid(c))));
        } else {
            throw new RuntimeException("Parent of the transition is a chart other than the one to which the state belongs.\n");
        }
        return p;
    }

    public String TransitionDeclaration(Chart c, Transition t2) {
        LinkedList<String> name = new LinkedList<String>();
        name.add(this._c.decl(this._n.transitionname(c, t2)));
        String type = this._c.reference(this._c.ref(this._n.TYPETRANSITION()));
        LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
        pairs.add(this.transition_identifier(c, t2));
        pairs.add(this.transition_source(c, t2));
        pairs.add(this.transition_destination(c, t2));
        pairs.add(this.transition_next(c, t2));
        pairs.add(this.transition_parent(c, t2));
        String binding = this._c.bindingextension(pairs);
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.variable(name, type));
        LinkedList<String> decl = new LinkedList<String>();
        decl.add(this._c.declpart_vertical(declarations));
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.transitionname(c, t2))));
        operands.add(binding);
        LinkedList<String> pred = new LinkedList<String>();
        pred.add(this._c.relationapplication(this._c.rel(this._n.EQUAL(), operands)));
        return this._c.axiomaticdescription(this._c.schematext_vertical(decl, pred));
    }

    public String ConditionActionDeclaration(Chart c, Transition t2) {
        String name = this._n.conditionactionname(c, t2);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.transitionid(c, t2)))));
        cparameters.add(this._c.inputparameter(this._n.O()));
        String comm = this._c.communication(this._n.EXECUTECONDITIONACTION(), cparameters);
        if (t2.condact.size() > 0) {
            return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this.translate_acts(c, t2.condact)))));
        }
        return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String ConditionActionsDeclaration(Chart c) {
        LinkedList<String> actions = new LinkedList<String>();
        for (Transition t2 : c.transitions.values()) {
            actions.add(this._c.namedaction(this._n.conditionactionname(c, t2)));
        }
        return this._c.actionparagraph(this._n.CONDITIONACTIONS(), this._c.paraction(this._c.externalchoiceextension(actions)));
    }

    public String TransitionActionDeclaration(Chart c, Transition t2) {
        String name = this._n.transitionactionname(c, t2);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.transitionid(c, t2)))));
        cparameters.add(this._c.inputparameter(this._n.O()));
        String comm = this._c.communication(this._n.EXECUTETRANSITIONACTION(), cparameters);
        if (t2.transact.size() > 0) {
            return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this.translate_acts(c, t2.transact)))));
        }
        return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String TransitionActionsDeclaration(Chart c) {
        LinkedList<String> actions = new LinkedList<String>();
        for (Transition t2 : c.transitions.values()) {
            actions.add(this._c.namedaction(this._n.transitionactionname(c, t2)));
        }
        return this._c.actionparagraph(this._n.TRANSITIONACTIONS(), this._c.paraction(this._c.externalchoiceextension(actions)));
    }

    public String ConditionDeclaration(Chart c, Transition t2) {
        String name = this._n.conditionname(c, t2);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.transitionid(c, t2)))));
        cparameters.add(this._c.outputparameter(this._c.reference(this._c.ref(this._n.T()))));
        String truecomm = this._c.communication(this._n.EVALUATECONDITION(), cparameters);
        cparameters = new LinkedList();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.transitionid(c, t2)))));
        cparameters.add(this._c.outputparameter(this._c.reference(this._c.ref(this._n.F()))));
        String falsecomm = this._c.communication(this._n.EVALUATECONDITION(), cparameters);
        if (t2.condition.size() > 0) {
            LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
            pairs.add(new Pair<String, String>(this.translate_pred(c, t2.condition.get(0)), this._c.cspaction(this._c.prefixedaction(truecomm, this._c.cspaction(this._c.skip())))));
            pairs.add(new Pair<String, String>(this._c.negation(this.translate_pred(c, t2.condition.get(0))), this._c.cspaction(this._c.prefixedaction(falsecomm, this._c.cspaction(this._c.skip())))));
            return this._c.actionparagraph(name, this._c.paraction(this._c.commandaction(this._c.ifcommand(this._c.gactions(pairs)))));
        }
        return this._c.actionparagraph(name, this._c.paraction(this._c.prefixedaction(truecomm, this._c.cspaction(this._c.skip()))));
    }

    public String ConditionsDeclaration(Chart c) {
        LinkedList<String> conditions = new LinkedList<String>();
        for (Transition t2 : c.transitions.values()) {
            conditions.add(this._c.namedaction(this._n.conditionname(c, t2)));
        }
        return this._c.actionparagraph(this._n.CONDITIONS(), this._c.paraction(this._c.externalchoiceextension(conditions)));
    }

    public String TriggerDeclaration(Chart c, Transition t2) {
        String name = this._n.triggername(c, t2);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.transitionid(c, t2)))));
        cparameters.add(this._c.inputparameter(this._n.E()));
        String comm = this._c.communication(this._n.CHECKTRIGGER(), cparameters);
        String trueguard = this.translate_triggers(c, t2.trigger);
        cparameters = new LinkedList();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.transitionid(c, t2)))));
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.E()))));
        cparameters.add(this._c.outputparameter(this._c.reference(this._c.ref(this._n.T()))));
        String truecomm = this._c.communication(this._n.RESULT(), cparameters);
        cparameters = new LinkedList();
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.transitionid(c, t2)))));
        cparameters.add(this._c.simpleparameter(this._c.reference(this._c.ref(this._n.E()))));
        cparameters.add(this._c.outputparameter(this._c.reference(this._c.ref(this._n.F()))));
        String falsecomm = this._c.communication(this._n.RESULT(), cparameters);
        if (t2.trigger.size() > 0) {
            LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
            pairs.add(new Pair<String, String>(trueguard, this._c.cspaction(this._c.prefixedaction(truecomm, this._c.cspaction(this._c.skip())))));
            pairs.add(new Pair<String, String>(this._c.negation(trueguard), this._c.cspaction(this._c.prefixedaction(falsecomm, this._c.cspaction(this._c.skip())))));
            return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.commandaction(this._c.ifcommand(this._c.gactions(pairs)))))));
        }
        return this._c.actionparagraph(name, this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.prefixedaction(truecomm, this._c.cspaction(this._c.skip())))))));
    }

    public String TriggersDeclaration(Chart c) {
        LinkedList<String> triggers = new LinkedList<String>();
        for (Transition t2 : c.transitions.values()) {
            triggers.add(this._c.namedaction(this._n.triggername(c, t2)));
        }
        return this._c.actionparagraph(this._n.TRIGGERSACTION(), this._c.paraction(this._c.externalchoiceextension(triggers)));
    }

    public String DataDeclaration(Chart c, Data d) {
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.decl(this._n.dataname(c, d)));
        return this._c.variable(declarations, this._c.reference(this._c.ref(this._n.UNIVERSE())));
    }

    public String ChannelsDeclaration(Chart c) {
        LinkedList<String> cnames = new LinkedList<String>();
        for (Data d : c.data.values()) {
            if (d.scope != DATASCOPE.INPUTDATA && d.scope != DATASCOPE.OUTPUTDATA) continue;
            cnames.add(this._n.datachannelname(c, d));
        }
        if (cnames.size() == 0) {
            return null;
        }
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.typedsimplecdecl(cnames, this._c.reference(this._c.ref(this._n.UNIVERSE()))));
        return this._c.channeldeclaration(this._c.cdecl(declarations));
    }

    public String EventsDeclaration(Chart c) {
        LinkedList<String> names = new LinkedList<String>();
        for (Event e2 : c.events.values()) {
            names.add(this._c.decl(this._n.eventname(c, e2)));
        }
        if (names.size() == 0) {
            return null;
        }
        String type = this._c.reference(this._c.ref(this._n.TYPEEVENT()));
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(this._c.variable(names, type));
        LinkedList<String> decl = new LinkedList<String>();
        decl.add(this._c.declpart_vertical(declarations));
        LinkedList<String> pred = new LinkedList<String>();
        return this._c.axiomaticdescription(this._c.schematext_vertical(decl, pred));
    }

    public String SimulationInstanceDeclaration(Chart c) {
        String chart = this._c.expression(this._c.reference(this._c.ref(this._n.processstatename(c))));
        String simulationdata = this._c.expression(this._c.reference(this._c.ref(this._n.SIMULATIONDATA())));
        LinkedList<String> variables = new LinkedList<String>();
        variables.add(chart);
        variables.add(simulationdata);
        for (Integer i : c.data.keySet()) {
            variables.add(this.DataDeclaration(c, c.data.get(i)));
        }
        String decl = this._c.declpart_vertical(variables);
        return this._c.schemadefinition(this._n.SIMULATIONINSTANCE(), this._c.schematext_vertical(new Opt<String>(decl), new LinkedList<String>()));
    }

    public String newline_conjunction(List<String> preds) {
        String pred = "";
        if (preds.size() == 0) {
            throw new RuntimeException("This list should have at least one element.\n");
        }
        pred = preds.get(preds.size() - 1);
        if (preds.size() > 1) {
            int i = preds.size() - 2;
            while (i >= 0) {
                pred = this._c.newline(preds.get(i), pred);
                --i;
            }
        }
        return pred;
    }

    public String InitSimulationInstanceDeclaration(Chart c) {
        String initsimulationdata = this._c.expression(this._c.reference(this._c.ref(this._n.INITISIMULATIONDATA())));
        String simulationinstance = this._c.expression(this._c.reference(this._c.ref(this._n.SIMULATIONINSTANCE())));
        LinkedList<String> initialisations = new LinkedList<String>();
        for (Data d : c.data.values()) {
            LinkedList<String> operands = new LinkedList<String>();
            operands.add(this._c.reference(this._c.ref(this._n.dataname(c, d))));
            operands.add(this._c.numberliteral("0"));
            initialisations.add(this._c.relationapplication(this._c.rel(this._n.EQUAL(), operands)));
        }
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(initsimulationdata);
        declarations.add(simulationinstance);
        String decl = this._c.declpart_vertical(declarations);
        Opt<String> pred = initialisations.size() == 0 ? new Opt<String>() : new Opt<String>(this.newline_conjunction(initialisations));
        return this._c.schemadefinition(this._n.INITSIMULATIONINSTANCE(), this._c.schematext_vertical(new Opt<String>(decl), pred));
    }

    public String GetStateDeclaration() {
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.STATES())));
        String functionapplication = this._c.functionapplication(this._c.app(this._n.DOM(), operands));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        operands.add(functionapplication);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.guardedinputparameter(this._n.X(), this._c.relationapplication(this._c.rel(this._n.IN(), operands))));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        cparameters.add(this._c.outputparameter(this._c.functionapplication(this._c.app(this._n.STATES(), operands))));
        String comm = this._c.communication(this._n.STATECHANNEL(), cparameters);
        return this._c.actionparagraph(this._n.GETSTATE(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String GetJunctionDeclaration() {
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.JUNCTIONS())));
        String functionapplication = this._c.functionapplication(this._c.app(this._n.DOM(), operands));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        operands.add(functionapplication);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.guardedinputparameter(this._n.X(), this._c.relationapplication(this._c.rel(this._n.IN(), operands))));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        cparameters.add(this._c.outputparameter(this._c.functionapplication(this._c.app(this._n.JUNCTIONS(), operands))));
        String comm = this._c.communication(this._n.JUNCTIONCHANNEL(), cparameters);
        return this._c.actionparagraph(this._n.GETJUNCTION(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String GetTransitionDeclaration() {
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.TRANSITIONS())));
        String functionapplication = this._c.functionapplication(this._c.app(this._n.DOM(), operands));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        operands.add(functionapplication);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.guardedinputparameter(this._n.X(), this._c.relationapplication(this._c.rel(this._n.IN(), operands))));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        cparameters.add(this._c.outputparameter(this._c.functionapplication(this._c.app(this._n.TRANSITIONS(), operands))));
        String comm = this._c.communication(this._n.TRANSITIONCHANNEL(), cparameters);
        return this._c.actionparagraph(this._n.GETTRANSITION(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String GetChartDeclaration() {
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.IDENTIFIER())));
        String functionapplication = this._c.functionapplication(this._c.app(this._n.STATES(), operands));
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.outputparameter(functionapplication));
        String comm = this._c.communication(this._n.CHARTCHANNEL(), cparameters);
        return this._c.actionparagraph(this._n.GETCHART(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String StatusDeclaration() {
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.STATESTATUS())));
        String functionapplication = this._c.functionapplication(this._c.app(this._n.DOM(), operands));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        operands.add(functionapplication);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.guardedinputparameter(this._n.X(), this._c.relationapplication(this._c.rel(this._n.IN(), operands))));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        cparameters.add(this._c.outputparameter(this._c.functionapplication(this._c.app(this._n.STATESTATUS(), operands))));
        String comm = this._c.communication(this._n.STATUSCHANNEL(), cparameters);
        return this._c.actionparagraph(this._n.STATUSACTION(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String HistoryDeclaration() {
        LinkedList<String> operands = new LinkedList<String>();
        operands.add(this._c.reference(this._c.ref(this._n.STATEHISTORY())));
        String functionapplication = this._c.functionapplication(this._c.app(this._n.DOM(), operands));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        operands.add(functionapplication);
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.guardedinputparameter(this._n.X(), this._c.relationapplication(this._c.rel(this._n.IN(), operands))));
        operands = new LinkedList();
        operands.add(this._c.reference(this._c.ref(this._n.X())));
        cparameters.add(this._c.outputparameter(this._c.functionapplication(this._c.app(this._n.STATEHISTORY(), operands))));
        String comm = this._c.communication(this._n.HISTORYCHANNEL(), cparameters);
        return this._c.actionparagraph(this._n.HISTORYACTION(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, this._c.cspaction(this._c.skip())))));
    }

    public String ActivationDeclaration() {
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.inputparameter(this._n.X()));
        String comm = this._c.communication(this._n.ACTIVATECHANNEL(), cparameters);
        String activate = this._c.schemaaction(this._c.reference(this._c.ref(this._n.ACTIVATESCHEMA())));
        return this._c.actionparagraph(this._n.ACTIVATIONACTION(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, activate))));
    }

    public String DeactivationDeclaration() {
        LinkedList<String> cparameters = new LinkedList<String>();
        cparameters.add(this._c.inputparameter(this._n.X()));
        String comm = this._c.communication(this._n.DEACTIVATECHANNEL(), cparameters);
        String deactivate = this._c.schemaaction(this._c.reference(this._c.ref(this._n.DEACTIVATESCHEMA())));
        return this._c.actionparagraph(this._n.DEACTIVATIONACTION(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(comm, deactivate))));
    }

    public String BroadcastDeclaration() {
        LinkedList<String> vars = new LinkedList<String>();
        vars.add(this._c.decl(this._n.E()));
        String p1 = this._c.variable(vars, this._c.reference(this._c.ref(this._n.EVENT())));
        vars = new LinkedList();
        vars.add(this._c.decl(this._n.ORIGIN()));
        vars.add(this._c.decl(this._n.DEST()));
        String p2 = this._c.variable(vars, this._c.reference(this._c.ref(this._n.STATEID())));
        LinkedList<String> args = new LinkedList<String>();
        args.add(this._c.reference(this._c.ref(this._n.DEST())));
        String f_states = this._c.functionapplication(this._c.app(this._n.STATES(), args));
        args = new LinkedList();
        args.add(this._c.reference(this._c.ref(this._n.ORIGIN())));
        String f_statestatus = this._c.functionapplication(this._c.app(this._n.STATESTATUS(), args));
        String a_allactions_x = this._c.cspaction(this._c.actionsequentialcomposition(this._c.namedaction(this._n.ALLACTIONS()), this._c.namedaction(this._n.X())));
        String ele = this._c.cspaction(this._c.prefixedaction(this._c.communication(this._n.ENDLOCALEXECUTION(), new LinkedList<String>()), this._c.cspaction(this._c.skip())));
        String interrupt = this._c.cspaction(this._c.prefixedaction(this._c.communication(this._n.INTERRUPTSIMULATOR(), new LinkedList<String>()), this._c.cspaction(this._c.skip())));
        LinkedList<String> declarations = new LinkedList<String>();
        declarations.add(p1);
        declarations.add(p2);
        String decl = this._c.declpart_horizontal(declarations);
        args = new LinkedList();
        args.add(this._c.reference(this._c.ref(this._n.E())));
        args.add(f_states);
        String cpar = this._c.outputparameter(this._c.tupleextension(args));
        String rec = this._c.recursiveaction(this._n.X(), this._c.cspaction(this._c.actionexternalchoice(a_allactions_x, ele)));
        args = new LinkedList();
        args.add(f_statestatus);
        args.add(this._c.reference(this._c.ref(this._n.T())));
        String pred1 = this._c.relationapplication(this._c.rel(this._n.EQUAL(), args));
        args = new LinkedList();
        args.add(f_statestatus);
        args.add(this._c.reference(this._c.ref(this._n.F())));
        String pred2 = this._c.relationapplication(this._c.rel(this._n.EQUAL(), args));
        args = new LinkedList();
        args.add(cpar);
        String comm = this._c.communication(this._n.LOCALCHANNEL(), args);
        LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
        pairs.add(new Pair<String, String>(pred1, this._c.cspaction(this._c.skip())));
        pairs.add(new Pair<String, String>(pred2, interrupt));
        String check = this._c.ifcommand(this._c.gactions(pairs));
        String seqcomp = this._c.actionsequentialcomposition(this._c.cspaction(rec), this._c.commandaction(check));
        String action2 = this._c.prefixedaction(comm, this._c.cspaction(seqcomp));
        return this._c.actionparagraph(this._n.BROADCAST(), this._c.parameterisedparaction(decl, this._c.paraction(this._c.cspaction(action2))));
    }

    public String BroadcastTactionDeclaration() {
        LinkedList<String> vars = new LinkedList<String>();
        vars.add(this._c.decl(this._n.E()));
        String p1 = this._c.variable(vars, this._c.reference(this._c.ref(this._n.EVENT())));
        vars = new LinkedList();
        vars.add(this._c.decl(this._n.ORIGIN()));
        vars.add(this._c.decl(this._n.DEST()));
        String p2 = this._c.variable(vars, this._c.reference(this._c.ref(this._n.STATEID())));
        LinkedList<String> pars = new LinkedList<String>();
        pars.add(this._c.reference(this._c.ref(this._n.E())));
        pars.add(this._c.reference(this._c.ref(this._n.ORIGIN())));
        pars.add(this._c.reference(this._c.ref(this._n.DEST())));
        LinkedList<String> args = new LinkedList<String>();
        args.add(this._c.reference(this._c.ref(this._n.DEST())));
        String f_states = this._c.functionapplication(this._c.app(this._n.STATES(), args));
        String interrupt = this._c.cspaction(this._c.prefixedaction(this._c.communication(this._n.INTERRUPTSIMULATOR(), new LinkedList<String>()), this._c.cspaction(this._c.skip())));
        LinkedList<String> declarations = new LinkedList<String>();
        vars = new LinkedList();
        vars.add(this._c.decl(this._n.S()));
        declarations.add(this._c.variable(vars, this._c.reference(this._c.ref(this._n.STATE()))));
        vars = new LinkedList();
        vars.add(this._c.decl(this._n.B()));
        declarations.add(this._c.variable(vars, this._c.reference(this._c.ref(this._n.BOOL()))));
        String broadcast = this._c.cspaction(this._c.paractioninstantiation(this._c.paraction(this._c.namedaction(this._n.BROADCAST())), pars));
        LinkedList<String> declarations1 = new LinkedList<String>();
        declarations1.add(p1);
        declarations1.add(p2);
        String decl = this._c.declpart_horizontal(declarations1);
        args = new LinkedList();
        args.add(this._c.reference(this._c.ref(this._n.B())));
        args.add(this._c.reference(this._c.ref(this._n.T())));
        String pred = this._c.relationapplication(this._c.rel(this._n.EQUAL(), args));
        LinkedList<Pair<String, String>> pairs = new LinkedList<Pair<String, String>>();
        pairs.add(new Pair<String, String>(this._n.S(), f_states));
        String assign2 = this._c.commandaction(this._c.assignment(pairs));
        String has = this._c.schemaaction(this._c.reference(this._c.ref(this._n.HASACTIVESUBSTATE())));
        pairs = new LinkedList();
        pairs.add(new Pair<String, String>(pred, interrupt));
        pairs.add(new Pair<String, String>(this._c.negation(pred), this._c.cspaction(this._c.skip())));
        String check = this._c.gactions(pairs);
        String middle = this._c.cspaction(this._c.actionsequentialcomposition(assign2, has));
        String seqcomp = this._c.actionsequentialcomposition(this._c.cspaction(this._c.actionsequentialcomposition(broadcast, middle)), this._c.commandaction(this._c.ifcommand(check)));
        return this._c.actionparagraph(this._n.BROADCASTTACTION(), this._c.parameterisedparaction(decl, this._c.paraction(this._c.commandaction(this._c.variableblock(this._c.declpart_horizontal(declarations), this._c.cspaction(seqcomp))))));
    }

    public String ChartActionsDeclaration() {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(this._c.namedaction(this._n.ENTRYACTIONS()));
        actions.add(this._c.namedaction(this._n.DURINGACTIONS()));
        actions.add(this._c.namedaction(this._n.EXITACTIONS()));
        actions.add(this._c.namedaction(this._n.CONDITIONACTIONS()));
        actions.add(this._c.namedaction(this._n.TRANSITIONACTIONS()));
        return this._c.actionparagraph(this._n.CHARTACTIONS(), this._c.paraction(this._c.externalchoiceextension(actions)));
    }

    public String InterfaceActionsDeclaration() {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(this._c.namedaction(this._n.GETCHART()));
        actions.add(this._c.namedaction(this._n.GETSTATE()));
        actions.add(this._c.namedaction(this._n.GETJUNCTION()));
        actions.add(this._c.namedaction(this._n.GETTRANSITION()));
        actions.add(this._c.namedaction(this._n.STATUSACTION()));
        actions.add(this._c.namedaction(this._n.HISTORYACTION()));
        actions.add(this._c.namedaction(this._n.ACTIVATIONACTION()));
        actions.add(this._c.namedaction(this._n.DEACTIVATIONACTION()));
        return this._c.actionparagraph(this._n.INTERFACEACTIONS(), this._c.paraction(this._c.externalchoiceextension(actions)));
    }

    public String interleaveextension(List<Pair<String, List<String>>> as) {
        String action2 = this._c.cspaction(this._c.skip());
        if (as.size() > 0) {
            action2 = (String)as.get((int)0).first;
            int i = 1;
            while (i < as.size()) {
                LinkedList<String> ns1 = new LinkedList<String>();
                LinkedList<String> ns2 = new LinkedList<String>();
                int j = 0;
                while (j < i) {
                    ns1.addAll((Collection)as.get((int)j).second);
                    ++j;
                }
                ns2.addAll((Collection)as.get((int)i).second);
                action2 = this._c.cspaction(this._c.actioninterleave(action2, this._c.ns(ns1), this._c.ns(ns2), (String)as.get((int)i).first));
                ++i;
            }
        }
        return action2;
    }

    public String InputsDeclaration(Chart c) {
        LinkedList<Pair<String, String>> channels = new LinkedList<Pair<String, String>>();
        for (Data d : c.data.values()) {
            if (d.scope != DATASCOPE.INPUTDATA) continue;
            channels.add(new Pair<String, String>(this._n.datachannelname(c, d), this._n.dataname(c, d)));
        }
        LinkedList commassign = new LinkedList();
        for (Pair pair : channels) {
            LinkedList<String> cparameters = new LinkedList<String>();
            cparameters.add(this._c.inputparameter(this._n.X()));
            String first = this._c.communication((String)pair.first, cparameters);
            LinkedList<Pair<String, String>> assignment = new LinkedList<Pair<String, String>>();
            assignment.add(new Pair<String, String>((String)pair.second, this._c.reference(this._c.ref(this._n.X()))));
            String second = this._c.assignment(assignment);
            LinkedList<String> third = new LinkedList<String>();
            third.add((String)pair.second);
            commassign.add(new Triple(first, second, third));
        }
        LinkedList<Pair<String, List<String>>> linkedList = new LinkedList<Pair<String, List<String>>>();
        for (Triple triple : commassign) {
            linkedList.add(new Pair<String, List>(this._c.paraction(this._c.cspaction(this._c.prefixedaction((String)triple.first, this._c.commandaction((String)triple.second)))), (List)triple.third));
        }
        return this._c.actionparagraph(this._n.INPUTSACTION(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(this._c.communication(this._n.READINPUTSCHANNEL(), new LinkedList<String>()), this.interleaveextension(linkedList)))));
    }

    public String OutputsDeclaration(Chart c) {
        LinkedList<Pair<String, String>> channels = new LinkedList<Pair<String, String>>();
        for (Data d : c.data.values()) {
            if (d.scope != DATASCOPE.OUTPUTDATA) continue;
            channels.add(new Pair<String, String>(this._n.datachannelname(c, d), this._n.dataname(c, d)));
        }
        LinkedList comm = new LinkedList();
        for (Pair pair : channels) {
            LinkedList<String> cparameters = new LinkedList<String>();
            cparameters.add(this._c.outputparameter(this._c.reference(this._c.ref((String)pair.second))));
            String first = this._c.communication((String)pair.first, cparameters);
            LinkedList<String> second = new LinkedList<String>();
            second.add((String)pair.second);
            comm.add(new Pair(first, second));
        }
        LinkedList<Pair<String, List<String>>> linkedList = new LinkedList<Pair<String, List<String>>>();
        for (Pair pair : comm) {
            linkedList.add(new Pair<String, List>(this._c.cspaction(this._c.prefixedaction((String)pair.first, this._c.cspaction(this._c.skip()))), (List)pair.second));
        }
        return this._c.actionparagraph(this._n.OUTPUTSACTION(), this._c.paraction(this._c.cspaction(this._c.prefixedaction(this._c.communication(this._n.WRITEOUTPUTSCHANNEL(), new LinkedList<String>()), this.interleaveextension(linkedList)))));
    }

    public String AllActionsDeclaration() {
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(this._c.namedaction(this._n.CONDITIONACTIONS()));
        actions.add(this._c.namedaction(this._n.TRIGGERSACTION()));
        actions.add(this._c.namedaction(this._n.INPUTSACTION()));
        actions.add(this._c.namedaction(this._n.OUTPUTSACTION()));
        actions.add(this._c.namedaction(this._n.CHARTACTIONS()));
        actions.add(this._c.namedaction(this._n.INTERFACEACTIONS()));
        return this._c.actionparagraph(this._n.ALLACTIONS(), this._c.paraction(this._c.externalchoiceextension(actions)));
    }

    public String MainActionDeclaration() {
        String first = this._c.schemaaction(this._c.reference(this._c.ref(this._n.INITSIMULATIONINSTANCE())));
        return this._c.cspaction(this._c.actionsequentialcomposition(first, this._c.cspaction(this._c.recursiveaction(this._n.X(), this._c.cspaction(this._c.actionsequentialcomposition(this._c.namedaction(this._n.ALLACTIONS()), this._c.namedaction(this._n.X())))))));
    }

    public String ProcessDeclaration(Chart c) {
        LinkedList<String> stateparagraphs = new LinkedList<String>();
        stateparagraphs.add(this._c.zparagraph(this.ChartDeclaration(c)));
        stateparagraphs.add(this._c.zparagraph(this.SimulationInstanceDeclaration(c)));
        stateparagraphs.add(this._c.zparagraph(this.InitSimulationInstanceDeclaration(c)));
        String state = this._c.schemaconjunction(this._c.reference(this._c.ref(this._n.SIMULATIONINSTANCE())), this._c.reference(this._c.ref(this._n.SIMULATIONDATA())));
        LinkedList<String> entryactions = new LinkedList<String>();
        for (State s : c.states.values()) {
            entryactions.add(this.EntryActionDeclaration(c, s));
        }
        entryactions.add(this.EntryActionsDeclaration(c));
        LinkedList<String> duringactions = new LinkedList<String>();
        for (State s : c.states.values()) {
            duringactions.add(this.DuringActionDeclaration(c, s));
        }
        duringactions.add(this.DuringActionsDeclaration(c));
        LinkedList<String> exitactions = new LinkedList<String>();
        for (State s : c.states.values()) {
            exitactions.add(this.ExitActionDeclaration(c, s));
        }
        exitactions.add(this.ExitActionsDeclaration(c));
        LinkedList<String> conditionactions = new LinkedList<String>();
        for (Transition t2 : c.transitions.values()) {
            conditionactions.add(this.ConditionActionDeclaration(c, t2));
        }
        conditionactions.add(this.ConditionActionsDeclaration(c));
        LinkedList<String> transitionactions = new LinkedList<String>();
        for (Transition t3 : c.transitions.values()) {
            transitionactions.add(this.TransitionActionDeclaration(c, t3));
        }
        transitionactions.add(this.TransitionActionsDeclaration(c));
        LinkedList<String> conditions = new LinkedList<String>();
        for (Transition t4 : c.transitions.values()) {
            conditions.add(this.ConditionDeclaration(c, t4));
        }
        conditions.add(this.ConditionsDeclaration(c));
        LinkedList<String> triggers = new LinkedList<String>();
        for (Transition t5 : c.transitions.values()) {
            triggers.add(this.TriggerDeclaration(c, t5));
        }
        triggers.add(this.TriggersDeclaration(c));
        LinkedList<String> getters = new LinkedList<String>();
        getters.add(this.GetStateDeclaration());
        getters.add(this.GetJunctionDeclaration());
        getters.add(this.GetTransitionDeclaration());
        getters.add(this.GetChartDeclaration());
        LinkedList<String> broadcasters = new LinkedList<String>();
        broadcasters.add(this.BroadcastDeclaration());
        broadcasters.add(this.BroadcastTactionDeclaration());
        LinkedList<String> others = new LinkedList<String>();
        others.add(this.StatusDeclaration());
        others.add(this.HistoryDeclaration());
        others.add(this.ActivationDeclaration());
        others.add(this.DeactivationDeclaration());
        LinkedList<String> collections = new LinkedList<String>();
        collections.add(this.ChartActionsDeclaration());
        collections.add(this.InterfaceActionsDeclaration());
        collections.add(this.InputsDeclaration(c));
        collections.add(this.OutputsDeclaration(c));
        collections.add(this.AllActionsDeclaration());
        LinkedList<String> actions = new LinkedList<String>();
        actions.addAll(entryactions);
        actions.addAll(duringactions);
        actions.addAll(exitactions);
        actions.addAll(conditionactions);
        actions.addAll(transitionactions);
        actions.addAll(conditions);
        actions.addAll(triggers);
        actions.addAll(getters);
        actions.addAll(broadcasters);
        actions.addAll(others);
        actions.addAll(collections);
        return this._c.simpleprocessdeclaration(this._n.processname(c), this._c.processdefinition(this._c.proc(stateparagraphs, state, actions, this.MainActionDeclaration())));
    }

    public String translate(Chart c) {
        this.output.print("Starting translation of chart " + c.name);
        LinkedList<String> identifiers = new LinkedList<String>();
        String aux = this._c.zparagraphdeclaration(this.StateIdentifierDeclaration(c));
        if (aux != null) {
            identifiers.add(aux);
        }
        if ((aux = this._c.zparagraph(this.JunctionIdentifierDeclaration(c))) != null) {
            identifiers.add(aux);
        }
        if ((aux = this._c.zparagraph(this.TransitionIdentifierDeclaration(c))) != null) {
            identifiers.add(aux);
        }
        LinkedList<String> states = new LinkedList<String>();
        for (State s : c.states.values()) {
            states.add(this._c.zparagraph(this.StateDeclaration(c, s)));
        }
        LinkedList<String> junctions = new LinkedList<String>();
        for (Junction j : c.junctions.values()) {
            junctions.add(this._c.zparagraph(this.JunctionDeclaration(c, j)));
        }
        LinkedList<String> transitions = new LinkedList<String>();
        for (Transition t2 : c.transitions.values()) {
            transitions.add(this._c.zparagraph(this.TransitionDeclaration(c, t2)));
        }
        LinkedList<String> events = new LinkedList<String>();
        aux = this._c.zparagraph(this.EventsDeclaration(c));
        if (aux != null) {
            events.add(aux);
        }
        LinkedList<String> channels = new LinkedList<String>();
        aux = this._c.zparagraph(this.ChannelsDeclaration(c));
        if (aux != null) {
            channels.add(aux);
        }
        LinkedList<String> proc = new LinkedList<String>();
        proc.add(this._c.processdeclaration(this.ProcessDeclaration(c)));
        LinkedList<String> circuspars = new LinkedList<String>();
        circuspars.addAll(identifiers);
        circuspars.addAll(states);
        circuspars.addAll(junctions);
        circuspars.addAll(transitions);
        circuspars.addAll(events);
        circuspars.addAll(channels);
        circuspars.addAll(proc);
        this.output.print("Done translating chart " + c.name);
        return String.valueOf(this._c.program(circuspars)) + "\n";
    }

    public String translate(String input, List<String> libraries) throws ParsingException, FileNotFoundException {
        Spec s = new Spec(input);
        if (s.top == null) {
            throw new ParsingException("Unable to parse the file.");
        }
        if (s.containsChart()) {
            Map<Integer, Chart> charts = new Builder(s, this.output).getCharts();
            Group model = s.top;
            String modelname = model.get("Name");
            modelname = modelname.replaceAll("_", "\\\\_");
            LinkedList<String> parents = new LinkedList<String>();
            parents.add("stateflow\\_toolkit");
            parents.addAll(libraries);
            String sectionedspecification = "";
            for (Chart c : charts.values()) {
                String sectionname = String.valueOf(modelname) + "\\_" + c.name;
                sectionedspecification = String.valueOf(sectionedspecification) + this._c.circussection(sectionname, parents, this.translate(c)) + "\n\n";
            }
            return sectionedspecification;
        }
        return "The file does not contain Stateflow charts.\n";
    }

    public String translate(String input) throws ParsingException, FileNotFoundException {
        return this.translate(input, new LinkedList<String>());
    }
}

