/*
 * Decompiled with CFR 0.152.
 */
package vm;

import devices.CR16C.KT4585.CR16CRealtimeClock;
import icecaptools.IcecapCompileMe;
import javax.realtime.AbsoluteTime;
import vm.Architecture;

public abstract class RealtimeClock {
    private static RealtimeClock instance;

    protected RealtimeClock() {
    }

    @IcecapCompileMe
    public static RealtimeClock getRealtimeClock() {
        if (instance != null) {
            return instance;
        }
        switch (Architecture.architecture) {
            case 3: {
                instance = new CR16CRealtimeClock();
                break;
            }
            default: {
                instance = new DefaultRealtimeClock();
            }
        }
        return RealtimeClock.getRealtimeClock();
    }

    public abstract int getGranularity();

    public abstract void getCurrentTime(AbsoluteTime var1);

    private static native int getNativeResolution();

    private static native int getNativeTime(AbsoluteTime var0);

    public static native void delayNativeUntil(AbsoluteTime var0);

    public static native void awaitNextTick();

    private static class DefaultRealtimeClock
    extends RealtimeClock {
        private DefaultRealtimeClock() {
        }

        @Override
        public int getGranularity() {
            return RealtimeClock.getNativeResolution();
        }

        @Override
        public void getCurrentTime(AbsoluteTime now) {
            RealtimeClock.getNativeTime(now);
        }
    }
}

