/*
 * Decompiled with CFR 0.152.
 */
package minicdj.util;

import java.io.Serializable;
import minicdj.util.Arrays;

public class BitSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7997698588986878753L;
    private static final int LONG_MASK = 63;
    private long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException();
        }
        int length = nbits >>> 6;
        if ((nbits & 0x3F) != 0) {
            ++length;
        }
        this.bits = new long[length];
    }

    public void and(BitSet bs) {
        int max = Math.min(this.bits.length, bs.bits.length);
        int i = 0;
        while (i < max) {
            int n = i;
            this.bits[n] = this.bits[n] & bs.bits[i];
            ++i;
        }
        while (i < this.bits.length) {
            this.bits[i++] = 0L;
        }
    }

    public void andNot(BitSet bs) {
        int i = Math.min(this.bits.length, bs.bits.length);
        while (--i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] & (bs.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int cardinality() {
        int card = 0;
        int i = this.bits.length - 1;
        while (i >= 0) {
            long a = this.bits[i];
            if (a != 0L) {
                if (a == -1L) {
                    card += 64;
                } else {
                    a = (a >> 1 & 0x5555555555555555L) + (a & 0x5555555555555555L);
                    a = (a >> 2 & 0x3333333333333333L) + (a & 0x3333333333333333L);
                    int b = (int)((a >>> 32) + a);
                    b = (b >> 4 & 0xF0F0F0F) + (b & 0xF0F0F0F);
                    b = (b >> 8 & 0xFF00FF) + (b & 0xFF00FF);
                    card += (b >> 16 & 0xFFFF) + (b & 0xFFFF);
                }
            }
            --i;
        }
        return card;
    }

    public void clear() {
        Arrays.fill(this.bits, 0L);
    }

    public void clear(int pos) {
        int offset = pos >> 6;
        this.ensure(offset);
        int n = offset;
        this.bits[n] = this.bits[n] & (1L << pos ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int from, int to) {
        if (from < 0 || from > to) {
            throw new IndexOutOfBoundsException();
        }
        if (from == to) {
            return;
        }
        int lo_offset = from >>> 6;
        int hi_offset = to >>> 6;
        this.ensure(hi_offset);
        if (lo_offset == hi_offset) {
            int n = hi_offset;
            this.bits[n] = this.bits[n] & ((1L << from) - 1L | -1L << to);
            return;
        }
        int n = lo_offset;
        this.bits[n] = this.bits[n] & (1L << from) - 1L;
        int n2 = hi_offset;
        this.bits[n2] = this.bits[n2] & -1L << to;
        int i = lo_offset + 1;
        while (i < hi_offset) {
            this.bits[i] = 0L;
            ++i;
        }
    }

    public Object clone() {
        try {
            BitSet bs = (BitSet)super.clone();
            bs.bits = (long[])this.bits.clone();
            return bs;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BitSet)) {
            return false;
        }
        BitSet bs = (BitSet)obj;
        int max = Math.min(this.bits.length, bs.bits.length);
        int i = 0;
        while (i < max) {
            if (this.bits[i] != bs.bits[i]) {
                return false;
            }
            ++i;
        }
        int j = i;
        while (j < this.bits.length) {
            if (this.bits[j] != 0L) {
                return false;
            }
            ++j;
        }
        j = i;
        while (j < bs.bits.length) {
            if (bs.bits[j] != 0L) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void flip(int index) {
        int offset = index >> 6;
        this.ensure(offset);
        int n = offset;
        this.bits[n] = this.bits[n] ^ 1L << index;
    }

    public void flip(int from, int to) {
        if (from < 0 || from > to) {
            throw new IndexOutOfBoundsException();
        }
        if (from == to) {
            return;
        }
        int lo_offset = from >>> 6;
        int hi_offset = to >>> 6;
        this.ensure(hi_offset);
        if (lo_offset == hi_offset) {
            int n = hi_offset;
            this.bits[n] = this.bits[n] ^ -1L << from & (1L << to) - 1L;
            return;
        }
        int n = lo_offset;
        this.bits[n] = this.bits[n] ^ -1L << from;
        int n2 = hi_offset;
        this.bits[n2] = this.bits[n2] ^ (1L << to) - 1L;
        int i = lo_offset + 1;
        while (i < hi_offset) {
            int n3 = i++;
            this.bits[n3] = this.bits[n3] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public boolean get(int pos) {
        int offset = pos >> 6;
        if (offset >= this.bits.length) {
            return false;
        }
        return (this.bits[offset] & 1L << pos) != 0L;
    }

    public BitSet get(int from, int to) {
        if (from < 0 || from > to) {
            throw new IndexOutOfBoundsException();
        }
        BitSet bs = new BitSet(to - from);
        int lo_offset = from >>> 6;
        if (lo_offset >= this.bits.length) {
            return bs;
        }
        int lo_bit = from & 0x3F;
        int hi_offset = to >>> 6;
        if (lo_bit == 0) {
            int len = Math.min(hi_offset - lo_offset + 1, this.bits.length - lo_offset);
            System.arraycopy(this.bits, lo_offset, bs.bits, 0, len);
            if (hi_offset < this.bits.length) {
                int n = hi_offset - lo_offset;
                bs.bits[n] = bs.bits[n] & (1L << to) - 1L;
            }
            return bs;
        }
        int len = Math.min(hi_offset, this.bits.length - 1);
        int reverse = 64 - lo_bit;
        int i = 0;
        while (lo_offset < len) {
            bs.bits[i] = this.bits[lo_offset] >>> lo_bit | this.bits[lo_offset + 1] << reverse;
            ++lo_offset;
            ++i;
        }
        if ((to & 0x3F) > lo_bit) {
            bs.bits[i++] = this.bits[lo_offset] >>> lo_bit;
        }
        if (hi_offset < this.bits.length) {
            int n = i - 1;
            bs.bits[n] = bs.bits[n] & (1L << to - from) - 1L;
        }
        return bs;
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.bits.length;
        while (i > 0) {
            h ^= (long)i * this.bits[--i];
        }
        return (int)(h >> 32 ^ h);
    }

    public boolean intersects(BitSet set) {
        int i = Math.min(this.bits.length, set.bits.length);
        while (--i >= 0) {
            if ((this.bits[i] & set.bits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        int i = this.bits.length - 1;
        while (i >= 0) {
            if (this.bits[i] != 0L) {
                return false;
            }
            --i;
        }
        return true;
    }

    public int length() {
        int i = this.bits.length - 1;
        while (i >= 0 && this.bits[i] == 0L) {
            --i;
        }
        if (i < 0) {
            return 0;
        }
        long b = this.bits[i];
        int len = (i + 1) * 64;
        while (b >= 0L) {
            --len;
            b <<= 1;
        }
        return len;
    }

    public int nextClearBit(int from) {
        int offset = from >> 6;
        long mask = 1L << from;
        while (offset < this.bits.length) {
            long h = this.bits[offset];
            do {
                if ((h & mask) == 0L) {
                    return from;
                }
                ++from;
            } while ((mask <<= 1) != 0L);
            mask = 1L;
            ++offset;
        }
        return from;
    }

    public int nextSetBit(int from) {
        int offset = from >> 6;
        long mask = 1L << from;
        while (offset < this.bits.length) {
            long h = this.bits[offset];
            do {
                if ((h & mask) != 0L) {
                    return from;
                }
                ++from;
            } while ((mask <<= 1) != 0L);
            mask = 1L;
            ++offset;
        }
        return -1;
    }

    public void or(BitSet bs) {
        this.ensure(bs.bits.length - 1);
        int i = bs.bits.length - 1;
        while (i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] | bs.bits[i];
            --i;
        }
    }

    public void set(int pos) {
        int offset = pos >> 6;
        this.ensure(offset);
        int n = offset;
        this.bits[n] = this.bits[n] | 1L << pos;
    }

    public void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public void set(int from, int to) {
        if (from < 0 || from > to) {
            throw new IndexOutOfBoundsException();
        }
        if (from == to) {
            return;
        }
        int lo_offset = from >>> 6;
        int hi_offset = to >>> 6;
        this.ensure(hi_offset);
        if (lo_offset == hi_offset) {
            int n = hi_offset;
            this.bits[n] = this.bits[n] | -1L << from & (1L << to) - 1L;
            return;
        }
        int n = lo_offset;
        this.bits[n] = this.bits[n] | -1L << from;
        int n2 = hi_offset;
        this.bits[n2] = this.bits[n2] | (1L << to) - 1L;
        int i = lo_offset + 1;
        while (i < hi_offset) {
            this.bits[i] = -1L;
            ++i;
        }
    }

    public void set(int from, int to, boolean value) {
        if (value) {
            this.set(from, to);
        } else {
            this.clear(from, to);
        }
    }

    public int size() {
        return this.bits.length * 64;
    }

    public String toString() {
        StringBuffer r = new StringBuffer("{");
        boolean first = true;
        int i = 0;
        while (i < this.bits.length) {
            long bit = 1L;
            long word = this.bits[i];
            if (word != 0L) {
                int j = 0;
                while (j < 64) {
                    if ((word & bit) != 0L) {
                        if (!first) {
                            r.append(", ");
                        }
                        r.append(64 * i + j);
                        first = false;
                    }
                    bit <<= 1;
                    ++j;
                }
            }
            ++i;
        }
        return r.append("}").toString();
    }

    public void xor(BitSet bs) {
        this.ensure(bs.bits.length - 1);
        int i = bs.bits.length - 1;
        while (i >= 0) {
            int n = i;
            this.bits[n] = this.bits[n] ^ bs.bits[i];
            --i;
        }
    }

    private void ensure(int lastElt) {
        if (lastElt >= this.bits.length) {
            long[] nd = new long[lastElt + 1];
            System.arraycopy(this.bits, 0, nd, 0, this.bits.length);
            this.bits = nd;
        }
    }
}

