/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import devices.Console;
import icecaptools.IcecapCompileMe;
import javax.realtime.Clock;
import javax.realtime.Monitor;
import javax.realtime.PriorityFrame;
import javax.realtime.PrioritySchedulerImpl;
import javax.realtime.RelativeTime;
import javax.realtime.RtProcess;
import javax.realtime.Scheduler;
import javax.safetycritical.AperiodicEventHandler;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ManagedThread;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import javax.scj.util.Const;
import vm.ClockInterruptHandler;
import vm.Process;

@SCJAllowed(value=Level.LEVEL_1)
public class PriorityScheduler
extends Scheduler {
    protected PriorityFrame pFrame;
    PrioritySchedulerImpl prioritySchedulerImpl;
    Clock rtClock;
    RelativeTime timeGrain;
    protected static PriorityScheduler scheduler;
    protected Mission currMission;
    protected RtProcess outerMostSeqProcess = null;
    private Process mainProcess;

    protected static PriorityScheduler instance() {
        if (scheduler == null) {
            scheduler = new PriorityScheduler();
        }
        return scheduler;
    }

    protected PriorityScheduler() {
        int[] schedulerStack = new int[Const.PRIORITY_SCHEDULER_STACK_SIZE];
        this.pFrame = new PriorityFrame(Const.DEFAULT_PRIORITY_QUEUE_SIZE);
        this.prioritySchedulerImpl = new PrioritySchedulerImpl(this);
        ClockInterruptHandler.initialize(this.prioritySchedulerImpl, schedulerStack);
        this.rtClock = Clock.getRealtimeClock();
        this.timeGrain = new RelativeTime(0L, 0, this.rtClock);
        this.rtClock.getResolution(this.timeGrain);
        scheduler = this;
    }

    private void processStart() {
        ClockInterruptHandler clockHandler = ClockInterruptHandler.instance;
        this.mainProcess = new Process(null, null);
        clockHandler.register();
        clockHandler.enable();
        clockHandler.startClockHandler(this.mainProcess);
        clockHandler.yield();
    }

    @IcecapCompileMe
    protected void stop(Process current) {
        current.transferTo(this.mainProcess);
    }

    protected void start() {
        this.current = this.pFrame.queue.extractMin();
        this.processStart();
    }

    @IcecapCompileMe
    protected RtProcess move() {
        this.currMission = this.current.target.getMission();
        if (this.current == RtProcess.idleProcess) {
            this.rtClock.getTime(this.current.next);
            this.current.next.add(this.timeGrain, this.current.next);
            this.pFrame.queue.insert(this.current);
        } else if (this.current.target instanceof MissionSequencer) {
            if (this.current.state == 5) {
                if (this.current.index == -2) {
                    this.current.target.cleanUp();
                } else {
                    this.removeSO(this.currMission, this.current.target);
                }
                this.current.state = 6;
            } else {
                this.current.state = 1;
                this.rtClock.getTime(this.current.next);
                this.current.next.add(this.timeGrain, this.current.next);
                this.pFrame.queue.insert(this.current);
            }
        } else if (this.current.target instanceof PeriodicEventHandler) {
            if (this.current.state == 5) {
                if (this.currMission.terminationPending()) {
                    this.removeSO(this.currMission, this.current.target);
                    this.current.state = 6;
                } else {
                    this.current.state = 4;
                    this.current.start();
                    this.pFrame.queue.insert(this.current);
                }
            } else {
                this.current.state = 1;
                this.pFrame.queue.insert(this.current);
            }
        } else if (this.current.target instanceof AperiodicEventHandler) {
            if (this.current.state == 5) {
                if (this.currMission.terminationPending()) {
                    this.removeSO(this.currMission, this.current.target);
                    this.removeAperiodicHandlers(this.currMission);
                    this.current.state = 6;
                } else {
                    this.current.state = 3;
                }
            } else {
                this.current.state = 1;
                this.pFrame.queue.insert(this.current);
            }
        } else if (this.current.target instanceof OneShotEventHandler) {
            if (this.current.state == 5) {
                this.removeSO(this.currMission, this.current.target);
                this.current.state = 6;
            } else {
                this.current.state = 1;
                this.pFrame.queue.insert(this.current);
            }
        } else if (this.current.target instanceof ManagedThread) {
            if (this.current.state == 5) {
                this.removeSO(this.currMission, this.current.target);
                this.current.state = 6;
            } else {
                this.current.state = 1;
                this.pFrame.queue.insert(this.current);
            }
        } else {
            Console.println(" current name: " + this.current.target.getName() + " index: " + this.current.index);
            throw new IllegalArgumentException("PriorityScheduler.move: UPS: another handler??");
        }
        RtProcess nextProcess = this.pFrame.queue.extractMin();
        nextProcess.state = 2;
        this.current = nextProcess;
        if (this.current == RtProcess.idleProcess && this.pFrame.queue.heapSize == 0) {
            this.current.target.cleanUp();
            return null;
        }
        return nextProcess;
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public int getMaxPriority() {
        return 100;
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public int getMinPriority() {
        return 1;
    }

    protected void insertReleaseQueue(RtProcess process) {
        this.pFrame.queue.insert(process);
    }

    protected void removeReleaseQueue(RtProcess process) {
        this.pFrame.queue.remove(process);
    }

    protected void addProcess(RtProcess process) {
        this.pFrame.addProcess(process);
    }

    protected void removeSO(Mission m, ManagedSchedulable ms) {
    }

    protected void removeAperiodicHandlers(Mission m) {
    }

    protected RtProcess getProcess(int missionIndex, int scjProcessIndex) {
        return null;
    }

    protected void waitForMS(Monitor monitor) {
        this.prioritySchedulerImpl.waitForMS(monitor);
    }

    protected void notifyForMS(Monitor monitor) {
        this.prioritySchedulerImpl.notifyForMS(monitor);
    }

    protected void moveToNext() {
        RtProcess nextProcess = this.pFrame.queue.extractMin();
        nextProcess.state = 2;
        this.current = nextProcess;
    }

    protected void addProcessToLockQueue(Object target, RtProcess process) {
        this.pFrame.lockQueue.addProcess(target, process);
    }

    protected RtProcess getProcessFromLockQueue(Object target) {
        return this.pFrame.lockQueue.getNextProcess(target);
    }

    public void printQueues() {
        ClockInterruptHandler.instance.disable();
        Console.println("");
        Console.println("PS current process: " + this.current.target.getName());
        Console.println("----------- release queue ----------");
        this.pFrame.queue.print();
        Console.println("----------- lock queue ----------");
        this.pFrame.lockQueue.print();
        Console.println("----------- wait queue ----------");
        this.pFrame.waitQueue.print();
        Console.println("");
        ClockInterruptHandler.instance.enable();
    }
}

