/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import devices.Console;
import javax.realtime.PriorityScheduler;
import javax.realtime.RtProcess;

class PriorityQueue {
    int[] queue;
    int tail;

    PriorityQueue(int size) {
        this.queue = new int[size];
        this.tail = -1;
        this.makeEmptyQueue(this.queue);
    }

    private void makeEmptyQueue(int[] set) {
        int i = 0;
        while (i < set.length) {
            set[i] = -999;
            ++i;
        }
    }

    protected synchronized void addProcess(Object target, RtProcess process) {
        if (this.tail < this.queue.length - 1) {
            ++this.tail;
            int index = this.tail;
            int i = 0;
            while (i < this.tail) {
                RtProcess temp = this.getScjProcess(this.queue[i]);
                if (temp == null) {
                    throw new IllegalArgumentException("1");
                }
                if (process.target.getPriorityParameter().getPriority() > temp.target.getPriorityParameter().getPriority()) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != this.tail) {
                i = this.tail;
                while (i > index) {
                    this.queue[i] = this.queue[i - 1];
                    --i;
                }
            }
        } else {
            throw new IndexOutOfBoundsException("set: too small");
        }
        process.lockRequired = target;
        this.queue[index] = process.index;
    }

    protected synchronized RtProcess getNextProcess(Object target) {
        int i = 0;
        while (i <= this.tail) {
            RtProcess process = this.getScjProcess(this.queue[i]);
            if (process.lockRequired == target) {
                process.lockRequired = null;
                this.reorderSet(i);
                return process;
            }
            ++i;
        }
        return null;
    }

    public synchronized void removeProcess(RtProcess process) {
        int i = 0;
        while (i <= this.tail) {
            if (this.queue[i] == process.index) {
                this.reorderSet(i);
                process.lockRequired = null;
            }
            ++i;
        }
    }

    private void reorderSet(int index) {
        int i = index;
        while (i <= this.tail - 1) {
            this.queue[i] = this.queue[i + 1];
            ++i;
        }
        this.queue[this.tail] = -999;
        --this.tail;
    }

    private RtProcess getScjProcess(int processIdx) {
        if (processIdx == -999) {
            return null;
        }
        if (processIdx == -2) {
            return PriorityScheduler.instance().outerMostSeqProcess;
        }
        if (processIdx == -1) {
            return RtProcess.idleProcess;
        }
        int missionIndex = processIdx / 20;
        int scjProcessIndex = processIdx % 20;
        return PriorityScheduler.instance().getProcess(missionIndex, scjProcessIndex);
    }

    public void print() {
        Console.println("Set size = " + (this.tail + 1));
        int i = 0;
        while (i <= this.tail) {
            RtProcess temp = this.getScjProcess(this.queue[i]);
            if (temp != null) {
                Console.println(temp.print());
            }
            ++i;
        }
        i = 0;
        while (i < this.queue.length) {
            Console.print("[ " + this.queue[i] + " ] ");
            ++i;
        }
        Console.println("");
    }
}

