/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;

public class CircularBuffer {
    private byte[] buffer;
    private short rdPtr;
    private short wrPtr;
    private boolean full;
    private static Exception exp = null;

    public CircularBuffer(short length) {
        this.buffer = new byte[length];
        this.rdPtr = 0;
        this.wrPtr = 0;
        this.full = false;
    }

    public synchronized byte read() throws IOException {
        if (!this.isEmpty()) {
            short s = this.rdPtr;
            this.rdPtr = (short)(s + 1);
            byte val = this.buffer[s];
            this.full = false;
            if (this.rdPtr == this.buffer.length) {
                this.rdPtr = 0;
            }
            return val;
        }
        this.initializeException("Read from empty buffer");
        throw (IOException)exp;
    }

    private void initializeException(String string) {
        if (exp == null) {
            exp = new CircularBufferException();
        }
        ((CircularBufferException)exp).setMessage(string);
    }

    public synchronized boolean write(byte b) throws IOException {
        if (!this.full) {
            short s = this.wrPtr;
            this.wrPtr = (short)(s + 1);
            this.buffer[s] = b;
            if (this.wrPtr == this.buffer.length) {
                this.wrPtr = 0;
            }
            if (this.wrPtr == this.rdPtr) {
                this.full = true;
            }
            return this.full;
        }
        this.initializeException("Write to full buffer");
        throw (IOException)exp;
    }

    public synchronized boolean isFull() {
        return this.full;
    }

    public synchronized boolean isEmpty() {
        if (this.full) {
            return false;
        }
        return this.rdPtr == this.wrPtr;
    }

    public synchronized boolean write(char c) throws IOException {
        return this.write((byte)c);
    }

    public synchronized int capacity() {
        return this.buffer.length;
    }

    private static class CircularBufferException
    extends IOException {
        private String message;

        private CircularBufferException() {
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

