/*
 * Decompiled with CFR 0.152.
 */
package minicdj.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import minicdj.util.AbstractCollection;
import minicdj.util.AbstractMap;
import minicdj.util.AbstractSet;
import minicdj.util.Arrays;
import minicdj.util.Collection;
import minicdj.util.ConcurrentModificationException;
import minicdj.util.Iterator;
import minicdj.util.Map;
import minicdj.util.NoSuchElementException;
import minicdj.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    static final int DEFAULT_CAPACITY = 11;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 362498820763181265L;
    private int threshold;
    final float loadFactor;
    transient HashEntry[] buckets;
    transient int modCount;
    transient int size;
    private transient Set entries;

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(Map m) {
        this(Math.max(m.size() * 2, 11), 0.75f);
        this.putAll(m);
    }

    public HashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.buckets = new HashEntry[initialCapacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object get(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (HashMap.equals(key, e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (HashMap.equals(key, e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public Object put(Object key, Object value) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (HashMap.equals(key, e.key)) {
                e.access();
                Object r = e.value;
                e.value = value;
                return r;
            }
            e = e.next;
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            idx = this.hash(key);
        }
        this.addEntry(key, value, idx, true);
        return null;
    }

    @Override
    public void putAll(Map m) {
        Iterator itr = m.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = (Map.Entry)itr.next();
            if (e instanceof AbstractMap.BasicMapEntry) {
                AbstractMap.BasicMapEntry entry = (AbstractMap.BasicMapEntry)e;
                this.put(entry.key, entry.value);
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        HashEntry last = null;
        while (e != null) {
            if (HashMap.equals(key, e.key)) {
                ++this.modCount;
                if (last == null) {
                    this.buckets[idx] = e.next;
                } else {
                    last.next = e.next;
                }
                --this.size;
                return e.cleanup();
            }
            last = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        int i = this.buckets.length - 1;
        while (i >= 0) {
            HashEntry e = this.buckets[i];
            while (e != null) {
                if (HashMap.equals(value, e.value)) {
                    return true;
                }
                e = e.next;
            }
            --i;
        }
        return false;
    }

    @Override
    public Object clone() {
        HashMap copy = null;
        try {
            copy = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.buckets = new HashEntry[this.buckets.length];
        copy.putAllInternal(this);
        copy.entries = null;
        return copy;
    }

    @Override
    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                @Override
                public int size() {
                    return HashMap.this.size;
                }

                @Override
                public Iterator iterator() {
                    return HashMap.this.iterator(0);
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    return HashMap.this.containsKey(o);
                }

                @Override
                public boolean remove(Object o) {
                    int oldsize = HashMap.this.size;
                    HashMap.this.remove(o);
                    return oldsize != HashMap.this.size;
                }
            };
        }
        return this.keys;
    }

    @Override
    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public int size() {
                    return HashMap.this.size;
                }

                @Override
                public Iterator iterator() {
                    return HashMap.this.iterator(1);
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                @Override
                public int size() {
                    return HashMap.this.size;
                }

                @Override
                public Iterator iterator() {
                    return HashMap.this.iterator(2);
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    return HashMap.this.getEntry(o) != null;
                }

                @Override
                public boolean remove(Object o) {
                    HashEntry e = HashMap.this.getEntry(o);
                    if (e != null) {
                        HashMap.this.remove(e.key);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    void addEntry(Object key, Object value, int idx, boolean callRemove) {
        HashEntry e = new HashEntry(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
    }

    final HashEntry getEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry me = (Map.Entry)o;
        Object key = me.getKey();
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (HashMap.equals(e.key, key)) {
                return HashMap.equals(e.value, me.getValue()) ? e : null;
            }
            e = e.next;
        }
        return null;
    }

    final int hash(Object key) {
        return key == null ? 0 : Math.abs(key.hashCode() % this.buckets.length);
    }

    Iterator iterator(int type) {
        return new HashIterator(type);
    }

    void putAllInternal(Map m) {
        Iterator itr = m.entrySet().iterator();
        this.size = 0;
        while (itr.hasNext()) {
            ++this.size;
            Map.Entry e = (Map.Entry)itr.next();
            Object key = e.getKey();
            int idx = this.hash(key);
            this.addEntry(key, e.getValue(), idx, false);
        }
    }

    private void rehash() {
        HashEntry[] oldBuckets = this.buckets;
        int newcapacity = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newcapacity * this.loadFactor);
        this.buckets = new HashEntry[newcapacity];
        int i = oldBuckets.length - 1;
        while (i >= 0) {
            HashEntry e = oldBuckets[i];
            while (e != null) {
                int idx = this.hash(e.key);
                HashEntry next = e.next;
                e.next = this.buckets[idx];
                this.buckets[idx] = e;
                e = next;
            }
            --i;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.buckets.length);
        s.writeInt(this.size);
        Iterator it = this.iterator(2);
        while (it.hasNext()) {
            HashEntry entry = (HashEntry)it.next();
            s.writeObject(entry.key);
            s.writeObject(entry.value);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int len;
        s.defaultReadObject();
        this.buckets = new HashEntry[s.readInt()];
        this.size = len = s.readInt();
        while (len-- > 0) {
            Object key = s.readObject();
            this.addEntry(key, s.readObject(), this.hash(key), false);
        }
    }

    static class HashEntry
    extends AbstractMap.BasicMapEntry {
        HashEntry next;

        HashEntry(Object key, Object value) {
            super(key, value);
        }

        void access() {
        }

        Object cleanup() {
            return this.value;
        }
    }

    private final class HashIterator
    implements Iterator {
        private final int type;
        private int knownMod;
        private int count;
        private int idx;
        private HashEntry last;
        private HashEntry next;

        HashIterator(int type) {
            this.knownMod = HashMap.this.modCount;
            this.count = HashMap.this.size;
            this.idx = HashMap.this.buckets.length;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            if (this.knownMod != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.count > 0;
        }

        @Override
        public Object next() {
            if (this.knownMod != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                e = HashMap.this.buckets[--this.idx];
            }
            this.next = e.next;
            this.last = e;
            if (this.type == 1) {
                return e.value;
            }
            if (this.type == 0) {
                return e.key;
            }
            return e;
        }

        @Override
        public void remove() {
            if (this.knownMod != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            HashMap.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }
}

