/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx;

import minicdj.cdx.Vector2d;
import minicdj.collision.Vector3d;

final class VectorConstants {
    public static final int NO_QUADRANT = 0;
    public static final int NE_QUADRANT = 1;
    public static final int NW_QUADRANT = 2;
    public static final int SE_QUADRANT = 4;
    public static final int SW_QUADRANT = 3;

    VectorConstants() {
    }

    public static void west(Vector3d dest) {
        dest.x = -1.0f;
        dest.y = 0.0f;
        dest.z = 0.0f;
    }

    public static void east(Vector3d dest) {
        dest.x = 1.0f;
        dest.y = 0.0f;
        dest.z = 0.0f;
    }

    public static void north(Vector3d dest) {
        dest.x = 0.0f;
        dest.y = 1.0f;
        dest.z = 0.0f;
    }

    public static void south(Vector3d dest) {
        dest.x = 0.0f;
        dest.y = -1.0f;
        dest.z = 0.0f;
    }

    public static void up(Vector3d dest) {
        dest.x = 0.0f;
        dest.y = 0.0f;
        dest.z = 1.0f;
    }

    public static void down(Vector3d dest) {
        dest.x = 0.0f;
        dest.y = 0.0f;
        dest.z = -1.0f;
    }

    public static void direction(float deg, Vector3d dest) {
        double radians = Math.PI * (double)deg / 180.0;
        dest.x = (float)Math.cos(radians);
        dest.y = (float)Math.sin(radians);
        dest.z = 0.0f;
    }

    public static void west(Vector2d dest) {
        dest.x = -1.0f;
        dest.y = 0.0f;
    }

    public static void east(Vector2d dest) {
        dest.x = 1.0f;
        dest.y = 0.0f;
    }

    public static void north(Vector2d dest) {
        dest.x = 0.0f;
        dest.y = 1.0f;
    }

    public static void south(Vector2d dest) {
        dest.x = 0.0f;
        dest.y = -1.0f;
    }

    public static void direction(float deg, Vector2d dest) {
        double radians = Math.PI * (double)deg / 180.0;
        dest.x = (float)Math.cos(radians);
        dest.y = (float)Math.sin(radians);
    }
}

